<?php
/**
 * SVG icons used in Botiga
 *
 * @package Botiga
 */

if ( ! class_exists( 'Botiga_SVG_Icons' ) ) {
	/**
	 * Get a svg icon
	 */
	class Botiga_SVG_Icons {

		public static function get_svg_icon( $icon ) {
			$icons = self::$svg_icons;

			$svg_code = $icons[ $icon ];

			return $svg_code;
		}

		public static $svg_icons = array(
			'icon-phone'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M497.39 361.8l-112-48a24 24 0 0 0-28 6.9l-49.6 60.6A370.66 370.66 0 0 1 130.6 204.11l60.6-49.6a23.94 23.94 0 0 0 6.9-28l-48-112A24.16 24.16 0 0 0 122.6.61l-104 24A24 24 0 0 0 0 48c0 256.5 207.9 464 464 464a24 24 0 0 0 23.4-18.6l24-104a24.29 24.29 0 0 0-14.01-27.6z"/></svg>',
			'icon-phone2'       => '<svg viewBox="0 0 15 15" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.125 9.52734L10.4453 8.37891C9.84375 8.10547 9.16016 8.29688 8.75 8.78906L8.01172 9.69141C6.78125 8.98047 5.76953 7.96875 5.05859 6.76562L5.98828 6.02734C6.45312 5.61719 6.64453 4.93359 6.39844 4.35938L5.22266 1.625C4.94922 0.996094 4.26562 0.640625 3.58203 0.804688L1.09375 1.37891C0.4375 1.51562 0 2.08984 0 2.77344C0 9.39062 5.35938 14.75 11.9766 14.75C12.6602 14.75 13.2344 14.3125 13.3438 13.6562L13.918 11.168C14.1094 10.4844 13.7539 9.80078 13.125 9.52734ZM12.6602 10.8672L12.0859 13.3555C12.0859 13.3828 12.0312 13.4375 11.9766 13.4375C6.09766 13.4375 1.28516 8.65234 1.28516 2.77344C1.28516 2.71875 1.33984 2.66406 1.39453 2.66406L3.88281 2.08984L3.91016 2.0625C3.96484 2.0625 3.99219 2.11719 4.01953 2.14453L5.16797 4.82422C5.19531 4.87891 5.19531 4.93359 5.14062 4.96094L3.80078 6.05469C3.58203 6.24609 3.5 6.57422 3.63672 6.84766C4.53906 8.67969 6.04297 10.1836 7.875 11.0859C8.14844 11.2227 8.50391 11.168 8.69531 10.9219L9.78906 9.58203C9.81641 9.55469 9.87109 9.52734 9.92578 9.55469L12.6055 10.7031C12.6602 10.7578 12.6875 10.8125 12.6602 10.8672Z" fill="white"/>
			</svg>',
			'icon-mail'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"/></svg>',

			'icon-wishlist'     => '<svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path class="cls-1" d="M16,28.72a3,3,0,0,1-2.13-.88L3.57,17.54a8.72,8.72,0,0,1-2.52-6.25,8.06,8.06,0,0,1,8.14-8A8.06,8.06,0,0,1,15,5.68l1,1,.82-.82h0a8.39,8.39,0,0,1,11-.89,8.25,8.25,0,0,1,.81,12.36L18.13,27.84A3,3,0,0,1,16,28.72ZM9.15,5.28A6.12,6.12,0,0,0,4.89,7a6,6,0,0,0-1.84,4.33A6.72,6.72,0,0,0,5,16.13l10.3,10.3a1,1,0,0,0,1.42,0L27.23,15.91A6.25,6.25,0,0,0,29,11.11a6.18,6.18,0,0,0-2.43-4.55,6.37,6.37,0,0,0-8.37.71L16.71,8.8a1,1,0,0,1-1.42,0l-1.7-1.7a6.28,6.28,0,0,0-4.4-1.82Z"/></svg>',
			'icon-wishlist2'     => '<svg class="stroke-based" width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.5 3C12.8905 3 11.0082 4.70299 10 5.8C8.99175 4.70299 7.1095 3 5.5 3C2.651 3 1 5.07403 1 7.71371C1 12.1 10 17 10 17C10 17 19 12.1 19 7.9C19 5.26032 17.349 3 14.5 3Z" stroke-width="1.5"/><path d="M14 9.5L11.5 12" stroke-width="1.5" stroke-linecap="round"/></svg>',
			
			'icon-user'			=> '<svg width="24" height="24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M12 3.75a5.25 5.25 0 100 10.5 5.25 5.25 0 000-10.5zM5.25 9a6.75 6.75 0 1113.5 0 6.75 6.75 0 01-13.5 0z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12 15.75a9.754 9.754 0 00-8.445 4.874.75.75 0 11-1.3-.75 11.254 11.254 0 0119.49 0 .75.75 0 01-1.3.75A9.754 9.754 0 0012 15.75z"/></svg>',
			'icon-user2'			=> '<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M23.0769 12C23.0769 5.8923 18.1082 0.923096 12 0.923096C5.89185 0.923096 0.923096 5.8923 0.923096 12C0.923096 15.1233 2.2276 17.9434 4.31415 19.959C4.363 20.0226 4.42086 20.0742 4.48858 20.1176C6.46511 21.9479 9.09997 23.0769 12 23.0769C14.9001 23.0769 17.5349 21.9479 19.5115 20.1176C19.5792 20.0742 19.637 20.0226 19.6859 19.959C21.7724 17.9434 23.0769 15.1233 23.0769 12ZM12 2.30771C17.3447 2.30771 21.6923 6.65582 21.6923 12C21.6923 14.2661 20.9047 16.3485 19.5967 18.0008C18.9962 16.0643 17.282 14.5484 14.9553 13.8508C16.2233 12.9332 17.0526 11.4466 17.0526 9.7667C17.0526 6.98439 14.7864 4.72087 12 4.72087C9.21366 4.72087 6.94743 6.98439 6.94743 9.7667C6.94743 11.4466 7.77676 12.9332 9.0447 13.8508C6.71807 14.5484 5.00381 16.0643 4.40334 18.0008C3.09535 16.3485 2.30771 14.2661 2.30771 12C2.30771 6.65582 6.65537 2.30771 12 2.30771ZM8.33205 9.7667C8.33205 7.74792 9.97718 6.10549 12 6.10549C14.0229 6.10549 15.668 7.74792 15.668 9.7667C15.668 11.7855 14.0229 13.4279 12 13.4279C9.97718 13.4279 8.33205 11.7855 8.33205 9.7667ZM5.56688 19.2295C5.775 16.6911 8.46682 14.8125 12 14.8125C15.5332 14.8125 18.225 16.6911 18.4332 19.2295C16.7198 20.7559 14.4699 21.6923 12 21.6923C9.53012 21.6923 7.28024 20.7559 5.56688 19.2295Z"/></svg>',
			'icon-user3'			=> '<svg width="28" height="28" viewBox="0 2 28 28" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18 12.75H6C5.00544 12.75 4.05161 13.1451 3.34835 13.8483C2.64509 14.5516 2.25 15.5054 2.25 16.5V21.75H3.75V16.5C3.75 15.9033 3.98705 15.331 4.40901 14.909C4.83097 14.4871 5.40326 14.25 6 14.25H18C18.5967 14.25 19.169 14.4871 19.591 14.909C20.0129 15.331 20.25 15.9033 20.25 16.5V21.75H21.75V16.5C21.75 15.5054 21.3549 14.5516 20.6517 13.8483C19.9484 13.1451 18.9946 12.75 18 12.75V12.75Z"/>
			<path d="M12 11.25C12.89 11.25 13.76 10.9861 14.5001 10.4916C15.2401 9.99715 15.8169 9.29435 16.1575 8.47208C16.4981 7.64981 16.5872 6.74501 16.4135 5.8721C16.2399 4.99918 15.8113 4.19736 15.182 3.56802C14.5526 2.93869 13.7508 2.5101 12.8779 2.33647C12.005 2.16283 11.1002 2.25195 10.2779 2.59254C9.45566 2.93314 8.75285 3.50992 8.25839 4.24994C7.76392 4.98996 7.5 5.85999 7.5 6.75C7.5 7.94348 7.97411 9.08807 8.81802 9.93198C9.66193 10.7759 10.8065 11.25 12 11.25ZM12 3.75C12.5933 3.75 13.1734 3.92595 13.6667 4.25559C14.1601 4.58524 14.5446 5.05377 14.7716 5.60195C14.9987 6.15013 15.0581 6.75333 14.9424 7.33527C14.8266 7.91722 14.5409 8.45177 14.1213 8.87132C13.7018 9.29088 13.1672 9.5766 12.5853 9.69236C12.0033 9.80811 11.4001 9.7487 10.8519 9.52164C10.3038 9.29458 9.83524 8.91006 9.50559 8.41671C9.17595 7.92337 9 7.34335 9 6.75C9 5.95435 9.31607 5.19129 9.87868 4.62868C10.4413 4.06607 11.2044 3.75 12 3.75V3.75Z"/></svg>',

			'icon-check'        => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 512 512"><path d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z" /></svg>',
			'icon-check-circle' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"></path></svg>',
			
			'icon-bars'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M16 132h416c8.837 0 16-7.163 16-16V76c0-8.837-7.163-16-16-16H16C7.163 60 0 67.163 0 76v40c0 8.837 7.163 16 16 16zm0 160h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16zm0 160h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16z"/></svg>',
			'icon-cart'			=> '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.5 21.75a1.5 1.5 0 100-3 1.5 1.5 0 000 3zM17.25 21.75a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M0 3a.75.75 0 01.75-.75h1.577A1.5 1.5 0 013.77 3.338L4.53 6h16.256a.75.75 0 01.72.956l-2.474 8.662a2.25 2.25 0 01-2.163 1.632H7.88a2.25 2.25 0 01-2.163-1.632l-2.47-8.645a.738.738 0 01-.01-.033l-.91-3.19H.75A.75.75 0 010 3zm4.959 4.5l2.201 7.706a.75.75 0 00.721.544h8.988a.75.75 0 00.72-.544L19.792 7.5H4.96z"/></svg>',
			'icon-cart2'		=> '<svg width="22" height="22" viewBox="0 0 23 24" class="stroke-based" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1.06845 23.5L3.38424 5.5H19.6158L21.9316 23.5H1.06845Z" stroke-width="1.4"/><path d="M7 5C7 2.51472 9.01472 0.5 11.5 0.5C13.9853 0.5 16 2.51472 16 5V5.5H7V5Z" stroke-width="1.4" /></svg>',
			'icon-cart3'		=> '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.25 5.25C2.25 4.42157 2.92157 3.75 3.75 3.75H20.25C21.0784 3.75 21.75 4.42157 21.75 5.25V18.75C21.75 19.5784 21.0784 20.25 20.25 20.25H3.75C2.92157 20.25 2.25 19.5784 2.25 18.75V5.25ZM20.25 5.25H3.75V18.75H20.25V5.25Z"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M8.25 7.5C8.66421 7.5 9 7.83579 9 8.25C9 9.04565 9.31607 9.80871 9.87868 10.3713C10.4413 10.9339 11.2044 11.25 12 11.25C12.7956 11.25 13.5587 10.9339 14.1213 10.3713C14.6839 9.80871 15 9.04565 15 8.25C15 7.83579 15.3358 7.5 15.75 7.5C16.1642 7.5 16.5 7.83579 16.5 8.25C16.5 9.44347 16.0259 10.5881 15.182 11.432C14.3381 12.2759 13.1935 12.75 12 12.75C10.8065 12.75 9.66193 12.2759 8.81802 11.432C7.97411 10.5881 7.5 9.44347 7.5 8.25C7.5 7.83579 7.83579 7.5 8.25 7.5Z"/></svg>',
			'icon-cart4'		=> '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.6875 7.57895V19.4211H19.3125V7.57895H4.6875ZM3 7.46053C3 6.69439 3.63994 6 4.52344 6H19.4766C20.3601 6 21 6.69439 21 7.46053V19.5395C21 20.3056 20.3601 21 19.4766 21H4.52344C3.63994 21 3 20.3056 3 19.5395V7.46053Z"/>
			<path fill-rule="evenodd" clip-rule="evenodd" d="M15.75 8.125C15.3358 8.125 15 7.78921 15 7.375C15 6.57935 14.6839 5.81629 14.1213 5.25368C13.5587 4.69107 12.7956 4.375 12 4.375C11.2043 4.375 10.4413 4.69107 9.87868 5.25368C9.31607 5.81629 9 6.57935 9 7.375C9 7.78921 8.66421 8.125 8.25 8.125C7.83578 8.125 7.5 7.78921 7.5 7.375C7.5 6.18153 7.9741 5.03693 8.81802 4.19302C9.66193 3.34911 10.8065 2.875 12 2.875C13.1935 2.875 14.3381 3.34911 15.182 4.19302C16.0259 5.03693 16.5 6.18153 16.5 7.375C16.5 7.78921 16.1642 8.125 15.75 8.125Z"/></svg>',
			'icon-cart5'		=> '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.9387 6.58686C20.9153 6.22177 20.6133 5.93782 20.2473 5.93782H16.5829V4.85519C16.5829 2.68722 14.5267 0.923096 12 0.923096C9.47324 0.923096 7.41706 2.68722 7.41706 4.85519V5.93782H3.75269C3.38671 5.93782 3.08472 6.22177 3.06129 6.58686L2.07781 22.3414C2.06609 22.5325 2.1337 22.7191 2.26441 22.8588C2.39512 22.9976 2.57811 23.0769 2.76922 23.0769H21.2308C21.4219 23.0769 21.6049 22.9976 21.7356 22.8588C21.8663 22.7191 21.9339 22.5325 21.9222 22.3414L20.9387 6.58686ZM8.80167 4.85519C8.80167 3.45074 10.2368 2.30771 12 2.30771C13.7632 2.30771 15.1983 3.45074 15.1983 4.85519V5.93782H8.80167V4.85519ZM7.41706 7.32243V8.82604C7.41706 9.20825 7.72715 9.51835 8.10936 9.51835C8.49157 9.51835 8.80167 9.20825 8.80167 8.82604V7.32243H15.1983V8.82604C15.1983 9.20825 15.5084 9.51835 15.8906 9.51835C16.2728 9.51835 16.5829 9.20825 16.5829 8.82604V7.32243H19.5964L20.1963 16.9228H3.80368L4.40353 7.32243H7.41706ZM3.5057 21.6923L3.74604 17.8459H20.2539L20.4943 21.6923H3.5057Z"/></svg>',
			'icon-facebook'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"/></svg>',
			'icon-tiktok'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z" /></svg>',
			'icon-twitter'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"/></svg>',
			'icon-discord'      => '<svg viewBox="0 0 22 26" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.575 12.375C14.575 13.1375 14.0125 13.7625 13.3 13.7625C12.6 13.7625 12.025 13.1375 12.025 12.375C12.025 11.6125 12.5875 10.9875 13.3 10.9875C14.0125 10.9875 14.575 11.6125 14.575 12.375ZM8.7375 10.9875C8.025 10.9875 7.4625 11.6125 7.4625 12.375C7.4625 13.1375 8.0375 13.7625 8.7375 13.7625C9.45 13.7625 10.0125 13.1375 10.0125 12.375C10.025 11.6125 9.45 10.9875 8.7375 10.9875ZM21.9375 3.075V25.5C18.7884 22.7171 19.7955 23.6383 16.1375 20.2375L16.8 22.55H2.625C1.2125 22.55 0.0625 21.4 0.0625 19.975V3.075C0.0625 1.65 1.2125 0.5 2.625 0.5H19.375C20.7875 0.5 21.9375 1.65 21.9375 3.075ZM18.375 14.925C18.375 10.9 16.575 7.6375 16.575 7.6375C14.775 6.2875 13.0625 6.325 13.0625 6.325L12.8875 6.525C15.0125 7.175 16 8.1125 16 8.1125C13.0307 6.48511 9.54277 6.48481 6.6625 7.75C6.2 7.9625 5.925 8.1125 5.925 8.1125C5.925 8.1125 6.9625 7.125 9.2125 6.475L9.0875 6.325C9.0875 6.325 7.375 6.2875 5.575 7.6375C5.575 7.6375 3.775 10.9 3.775 14.925C3.775 14.925 4.825 16.7375 7.5875 16.825C7.5875 16.825 8.05 16.2625 8.425 15.7875C6.8375 15.3125 6.2375 14.3125 6.2375 14.3125C6.42139 14.4412 6.72461 14.6081 6.75 14.625C8.85986 15.8065 11.8568 16.1937 14.55 15.0625C14.9875 14.9 15.475 14.6625 15.9875 14.325C15.9875 14.325 15.3625 15.35 13.725 15.8125C14.1 16.2875 14.55 16.825 14.55 16.825C17.3125 16.7375 18.375 14.925 18.375 14.925Z" fill="black"/>
			</svg>',
			'icon-github'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"/></svg>',
			'icon-linkedin'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"/></svg>',
			'icon-youtube'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>',
			'icon-xing'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5H9.8c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3l-43.9-75.6c-4.3-7.8.3-14.1 8.5-14.1H100c7.3 0 13.3 4.1 18 12.2l44.7 77.5zM382.6 46.1l-144 253v.3L330.2 466c3.9 7.1.2 14.1-8.5 14.1h-65.2c-7.6 0-13.6-4-18-12.2l-92.4-168.5c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2h65.7c8 0 12.3 6.7 8.5 14.1z"/></svg>',
			'icon-instagram'	=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>',
			'icon-flickr'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM144.5 319c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5zm159 0c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5z"/></svg>',
			'icon-dribbble'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"/></svg>',
			'icon-vk'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M545 117.7c3.7-12.5 0-21.7-17.8-21.7h-58.9c-15 0-21.9 7.9-25.6 16.7 0 0-30 73.1-72.4 120.5-13.7 13.7-20 18.1-27.5 18.1-3.7 0-9.4-4.4-9.4-16.9V117.7c0-15-4.2-21.7-16.6-21.7h-92.6c-9.4 0-15 7-15 13.5 0 14.2 21.2 17.5 23.4 57.5v86.8c0 19-3.4 22.5-10.9 22.5-20 0-68.6-73.4-97.4-157.4-5.8-16.3-11.5-22.9-26.6-22.9H38.8c-16.8 0-20.2 7.9-20.2 16.7 0 15.6 20 93.1 93.1 195.5C160.4 378.1 229 416 291.4 416c37.5 0 42.1-8.4 42.1-22.9 0-66.8-3.4-73.1 15.4-73.1 8.7 0 23.7 4.4 58.7 38.1 40 40 46.6 57.9 69 57.9h58.9c16.8 0 25.3-8.4 20.4-25-11.2-34.9-86.9-106.7-90.3-111.5-8.7-11.2-6.2-16.2 0-26.2.1-.1 72-101.3 79.4-135.6z"/></svg>',
			'icon-weibo'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7C108.5 446.7 0 395.3 0 310.4c0-44.3 28-95.4 76.3-143.7C176 67 279.5 65.8 249.9 161c-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zm143.7-146.3c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8.3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4.6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z"/></svg>',
			'icon-vimeo'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M403.2 32H44.8C20.1 32 0 52.1 0 76.8v358.4C0 459.9 20.1 480 44.8 480h358.4c24.7 0 44.8-20.1 44.8-44.8V76.8c0-24.7-20.1-44.8-44.8-44.8zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2l-15.2-19.6c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3.9 49 22.5 47.1 64.7z"/></svg',
			'icon-mix'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 64v348.9c0 56.2 88 58.1 88 0V174.3c7.9-52.9 88-50.4 88 6.5v175.3c0 57.9 96 58 96 0V240c5.3-54.7 88-52.5 88 4.3v23.8c0 59.9 88 56.6 88 0V64H0z"/></svg>',
			'icon-behance'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"/></svg>',
			'icon-spotify'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm100.7 364.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z"/></svg>',
			'icon-soundcloud'	=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M111.4 256.3l5.8 65-5.8 68.3c-.3 2.5-2.2 4.4-4.4 4.4s-4.2-1.9-4.2-4.4l-5.6-68.3 5.6-65c0-2.2 1.9-4.2 4.2-4.2 2.2 0 4.1 2 4.4 4.2zm21.4-45.6c-2.8 0-4.7 2.2-5 5l-5 105.6 5 68.3c.3 2.8 2.2 5 5 5 2.5 0 4.7-2.2 4.7-5l5.8-68.3-5.8-105.6c0-2.8-2.2-5-4.7-5zm25.5-24.1c-3.1 0-5.3 2.2-5.6 5.3l-4.4 130 4.4 67.8c.3 3.1 2.5 5.3 5.6 5.3 2.8 0 5.3-2.2 5.3-5.3l5.3-67.8-5.3-130c0-3.1-2.5-5.3-5.3-5.3zM7.2 283.2c-1.4 0-2.2 1.1-2.5 2.5L0 321.3l4.7 35c.3 1.4 1.1 2.5 2.5 2.5s2.2-1.1 2.5-2.5l5.6-35-5.6-35.6c-.3-1.4-1.1-2.5-2.5-2.5zm23.6-21.9c-1.4 0-2.5 1.1-2.5 2.5l-6.4 57.5 6.4 56.1c0 1.7 1.1 2.8 2.5 2.8s2.5-1.1 2.8-2.5l7.2-56.4-7.2-57.5c-.3-1.4-1.4-2.5-2.8-2.5zm25.3-11.4c-1.7 0-3.1 1.4-3.3 3.3L47 321.3l5.8 65.8c.3 1.7 1.7 3.1 3.3 3.1 1.7 0 3.1-1.4 3.1-3.1l6.9-65.8-6.9-68.1c0-1.9-1.4-3.3-3.1-3.3zm25.3-2.2c-1.9 0-3.6 1.4-3.6 3.6l-5.8 70 5.8 67.8c0 2.2 1.7 3.6 3.6 3.6s3.6-1.4 3.9-3.6l6.4-67.8-6.4-70c-.3-2.2-2-3.6-3.9-3.6zm241.4-110.9c-1.1-.8-2.8-1.4-4.2-1.4-2.2 0-4.2.8-5.6 1.9-1.9 1.7-3.1 4.2-3.3 6.7v.8l-3.3 176.7 1.7 32.5 1.7 31.7c.3 4.7 4.2 8.6 8.9 8.6s8.6-3.9 8.6-8.6l3.9-64.2-3.9-177.5c-.4-3-2-5.8-4.5-7.2zm-26.7 15.3c-1.4-.8-2.8-1.4-4.4-1.4s-3.1.6-4.4 1.4c-2.2 1.4-3.6 3.9-3.6 6.7l-.3 1.7-2.8 160.8s0 .3 3.1 65.6v.3c0 1.7.6 3.3 1.7 4.7 1.7 1.9 3.9 3.1 6.4 3.1 2.2 0 4.2-1.1 5.6-2.5 1.7-1.4 2.5-3.3 2.5-5.6l.3-6.7 3.1-58.6-3.3-162.8c-.3-2.8-1.7-5.3-3.9-6.7zm-111.4 22.5c-3.1 0-5.8 2.8-5.8 6.1l-4.4 140.6 4.4 67.2c.3 3.3 2.8 5.8 5.8 5.8 3.3 0 5.8-2.5 6.1-5.8l5-67.2-5-140.6c-.2-3.3-2.7-6.1-6.1-6.1zm376.7 62.8c-10.8 0-21.1 2.2-30.6 6.1-6.4-70.8-65.8-126.4-138.3-126.4-17.8 0-35 3.3-50.3 9.4-6.1 2.2-7.8 4.4-7.8 9.2v249.7c0 5 3.9 8.6 8.6 9.2h218.3c43.3 0 78.6-35 78.6-78.3.1-43.6-35.2-78.9-78.5-78.9zm-296.7-60.3c-4.2 0-7.5 3.3-7.8 7.8l-3.3 136.7 3.3 65.6c.3 4.2 3.6 7.5 7.8 7.5 4.2 0 7.5-3.3 7.5-7.5l3.9-65.6-3.9-136.7c-.3-4.5-3.3-7.8-7.5-7.8zm-53.6-7.8c-3.3 0-6.4 3.1-6.4 6.7l-3.9 145.3 3.9 66.9c.3 3.6 3.1 6.4 6.4 6.4 3.6 0 6.4-2.8 6.7-6.4l4.4-66.9-4.4-145.3c-.3-3.6-3.1-6.7-6.7-6.7zm26.7 3.4c-3.9 0-6.9 3.1-6.9 6.9L227 321.3l3.9 66.4c.3 3.9 3.1 6.9 6.9 6.9s6.9-3.1 6.9-6.9l4.2-66.4-4.2-141.7c0-3.9-3-6.9-6.9-6.9z"/></svg>',
			'icon-twitch'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M391.17,103.47H352.54v109.7h38.63ZM285,103H246.37V212.75H285ZM120.83,0,24.31,91.42V420.58H140.14V512l96.53-91.42h77.25L487.69,256V0ZM449.07,237.75l-77.22,73.12H294.61l-67.6,64v-64H140.14V36.58H449.07Z"/></svg>',
			'icon-bandcamp'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256,8C119,8,8,119,8,256S119,504,256,504,504,393,504,256,393,8,256,8Zm48.2,326.1h-181L207.9,178h181Z"/></svg>',
			'icon-etsy'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M384 348c-1.75 10.75-13.75 110-15.5 132-117.879-4.299-219.895-4.743-368.5 0v-25.5c45.457-8.948 60.627-8.019 61-35.25 1.793-72.322 3.524-244.143 0-322-1.029-28.46-12.13-26.765-61-36v-25.5c73.886 2.358 255.933 8.551 362.999-3.75-3.5 38.25-7.75 126.5-7.75 126.5H332C320.947 115.665 313.241 68 277.25 68h-137c-10.25 0-10.75 3.5-10.75 9.75V241.5c58 .5 88.5-2.5 88.5-2.5 29.77-.951 27.56-8.502 40.75-65.251h25.75c-4.407 101.351-3.91 61.829-1.75 160.25H257c-9.155-40.086-9.065-61.045-39.501-61.5 0 0-21.5-2-88-2v139c0 26 14.25 38.25 44.25 38.25H263c63.636 0 66.564-24.996 98.751-99.75H384z"/></svg>',
			'icon-pinterest'	=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3.8-3.4 5-20.3 6.9-28.1.6-2.5.3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z"/></svg>',
			'icon-whatsapp'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
			'icon-wa.me'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
			'icon-telegram'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248,8C111.033,8,0,119.033,0,256S111.033,504,248,504,496,392.967,496,256,384.967,8,248,8ZM362.952,176.66c-3.732,39.215-19.881,134.378-28.1,178.3-3.476,18.584-10.322,24.816-16.948,25.425-14.4,1.326-25.338-9.517-39.287-18.661-21.827-14.308-34.158-23.215-55.346-37.177-24.485-16.135-8.612-25,5.342-39.5,3.652-3.793,67.107-61.51,68.335-66.746.153-.655.3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283.746-104.608,69.142-14.845,10.194-26.894,9.934c-8.855-.191-25.888-5.006-38.551-9.123-15.531-5.048-27.875-7.717-26.8-16.291q.84-6.7,18.45-13.7,108.446-47.248,144.628-62.3c68.872-28.647,83.183-33.623,92.511-33.789,2.052-.034,6.639.474,9.61,2.885a10.452,10.452,0,0,1,3.53,6.716A43.765,43.765,0,0,1,362.952,176.66Z"/></svg>',
			'icon-t.me'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248,8C111.033,8,0,119.033,0,256S111.033,504,248,504,496,392.967,496,256,384.967,8,248,8ZM362.952,176.66c-3.732,39.215-19.881,134.378-28.1,178.3-3.476,18.584-10.322,24.816-16.948,25.425-14.4,1.326-25.338-9.517-39.287-18.661-21.827-14.308-34.158-23.215-55.346-37.177-24.485-16.135-8.612-25,5.342-39.5,3.652-3.793,67.107-61.51,68.335-66.746.153-.655.3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283.746-104.608,69.142-14.845,10.194-26.894,9.934c-8.855-.191-25.888-5.006-38.551-9.123-15.531-5.048-27.875-7.717-26.8-16.291q.84-6.7,18.45-13.7,108.446-47.248,144.628-62.3c68.872-28.647,83.183-33.623,92.511-33.789,2.052-.034,6.639.474,9.61,2.885a10.452,10.452,0,0,1,3.53,6.716A43.765,43.765,0,0,1,362.952,176.66Z"/></svg>',
			'icon-reddit'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z"/></svg>',
			'icon-ok'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024"><path d="M1024 512c0 512 0 512-512 512S0 1024 0 512 0 0 512 0s512 0 512 512z"/><path d="M592.2 686.1c40.4-9.2 79.3-25.2 115.101-47.7 27.1-17.1 35.3-52.899 18.199-80.1-17.1-27.2-52.899-35.4-80.1-18.3-81.2 51.1-185.7 51-266.9 0-27.199-17.1-63-8.9-80.1 18.3-17.1 27.1-8.9 63 18.2 80.1 35.8 22.5 74.7 38.5 115.1 47.7L321 796.9c-22.699 22.699-22.699 59.399 0 82.1 11.4 11.3 26.2 17 41 17 14.9 0 29.7-5.7 41.101-17L512 770.1 620.9 879c22.7 22.7 59.4 22.7 82.1 0 22.7-22.7 22.7-59.5 0-82.1L592.2 686.1M512 244.2c45.301 0 82.101 36.8 82.101 82.1 0 45.2-36.8 82-82.101 82-45.199 0-82.1-36.8-82.1-82 0-45.3 36.901-82.1 82.1-82.1zm0 280.2c109.301 0 198.2-88.9 198.2-198.101C710.2 216.9 621.301 128 512 128c-109.3 0-198.199 88.9-198.199 198.2 0 109.3 88.899 198.2 198.199 198.2z" fill="#fff"/></svg>',
			'icon-up'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M240.971 130.524l194.343 194.343c9.373 9.373 9.373 24.569 0 33.941l-22.667 22.667c-9.357 9.357-24.522 9.375-33.901.04L224 227.495 69.255 381.516c-9.379 9.335-24.544 9.317-33.901-.04l-22.667-22.667c-9.373-9.373-9.373-24.569 0-33.941L207.03 130.525c9.372-9.373 24.568-9.373 33.941-.001z"/></svg>',
			'icon-cancel'		=> '<svg width="16" height="16" fill="none" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid meet"><path d="M2.219.781L.78 2.22 9.562 11l-8.78 8.781 1.437 1.438L11 12.437l8.781 8.782 1.438-1.438L12.437 11l8.782-8.781L19.78.78 11 9.562 2.219.783z"/></svg>',	
			'icon-expand'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 344v112a23.94 23.94 0 01-24 24H312c-21.39 0-32.09-25.9-17-41l36.2-36.2L224 295.6 116.77 402.9 153 439c15.09 15.1 4.39 41-17 41H24a23.94 23.94 0 01-24-24V344c0-21.4 25.89-32.1 41-17l36.19 36.2L184.46 256 77.18 148.7 41 185c-15.1 15.1-41 4.4-41-17V56a23.94 23.94 0 0124-24h112c21.39 0 32.09 25.9 17 41l-36.2 36.2L224 216.4l107.23-107.3L295 73c-15.09-15.1-4.39-41 17-41h112a23.94 23.94 0 0124 24v112c0 21.4-25.89 32.1-41 17l-36.19-36.2L263.54 256l107.28 107.3L407 327.1c15.1-15.2 41-4.5 41 16.9z"/></svg>',
			'icon-heart'		=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M458.4 64.3C400.6 15.7 311.3 23 256 79.3 200.7 23 111.4 15.6 53.6 64.3-21.6 127.6-10.6 230.8 43 285.5l175.4 178.7c10 10.2 23.4 15.9 37.6 15.9 14.3 0 27.6-5.6 37.6-15.8L469 285.6c53.5-54.7 64.7-157.9-10.6-221.3zm-23.6 187.5L259.4 430.5c-2.4 2.4-4.4 2.4-6.8 0L77.2 251.8c-36.5-37.2-43.9-107.6 7.3-150.7 38.9-32.7 98.9-27.8 136.5 10.5l35 35.7 35-35.7c37.8-38.5 97.8-43.2 136.5-10.6 51.1 43.1 43.5 113.9 7.3 150.8z"/></svg>',
			'icon-search'		=> '<svg width="24" height="24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.875 3.75a7.125 7.125 0 100 14.25 7.125 7.125 0 000-14.25zM2.25 10.875a8.625 8.625 0 1117.25 0 8.625 8.625 0 01-17.25 0z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M15.913 15.914a.75.75 0 011.06 0l4.557 4.556a.75.75 0 01-1.06 1.06l-4.557-4.556a.75.75 0 010-1.06z"/></svg>',	
			'icon-down'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.011 512.011"><path d="M505.755 123.592c-8.341-8.341-21.824-8.341-30.165 0L256.005 343.176 36.421 123.592c-8.341-8.341-21.824-8.341-30.165 0s-8.341 21.824 0 30.165l234.667 234.667a21.275 21.275 0 0015.083 6.251 21.275 21.275 0 0015.083-6.251l234.667-234.667c8.34-8.341 8.34-21.824-.001-30.165z"/></svg>',
			'icon-btt-icon1'	=> '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5 15L12 8L19 15" stroke-width="1.5" stroke-linejoin="round"/></svg>',
			'icon-btt-icon2'	=> '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5 15l7-7 7 7" stroke-width="3" stroke-linejoin="round"/></svg>',
			'icon-btt-icon3'	=> '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7 12l5.5-5.5m0 0L18 12m-5.5-5.5V19" stroke-width="1.5" stroke-linejoin="round"/></svg>',
			'icon-btt-icon4'	=> '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7 12l5.5-5.5m0 0L18 12m-5.5-5.5V19" stroke-width="3" stroke-linejoin="round"/></svg>',
			'icon-eye'			=> '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M572.52 241.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 000 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 000-29.19zM288 400a144 144 0 11144-144 143.93 143.93 0 01-144 144zm0-240a95.31 95.31 0 00-25.31 3.79 47.85 47.85 0 01-66.9 66.9A95.78 95.78 0 10288 160z"/></svg>',
			'icon-filters'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" ><path d="M496 384H160v-16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v16H16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h80v16c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-16h336c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16zm0-160h-80v-16c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v16H16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h336v16c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-16h80c8.8 0 16-7.2 16-16v-32c0-8.8-7.2-16-16-16zm0-160H288V48c0-8.8-7.2-16-16-16h-32c-8.8 0-16 7.2-16 16v16H16C7.2 64 0 71.2 0 80v32c0 8.8 7.2 16 16 16h208v16c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16v-16h208c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16z" /></svg>',
			'icon-edit'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M13.89 3.39l2.71 2.72c.46.46.42 1.24.03 1.64l-8.01 8.02-5.56 1.16 1.16-5.58s7.6-7.63 7.99-8.03c.39-.39 1.22-.39 1.68.07zm-2.73 2.79l-5.59 5.61 1.11 1.11 5.54-5.65zm-2.97 8.23l5.58-5.6-1.07-1.08-5.59 5.6z"></path></svg>',
			'mobile-icon1'		=> 	'<svg width="16" height="7" viewBox="0 0 16 7" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="16" height="1"/><rect y="6" width="16" height="1"/></svg>',
			'mobile-icon2'		=> 	'<svg width="16" height="11" viewBox="0 0 16 11" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="16" height="1"/><rect y="5" width="16" height="1"/><rect y="10" width="16" height="1"/></svg>',
			'mobile-icon3'		=> 	'<svg width="16" height="11" viewBox="0 0 16 11" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="16" height="1"/><rect y="5" width="10" height="1"/><rect y="10" width="16" height="1"/></svg>',
			'mobile-icon4'		=> 	'<svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg"><rect y="7" width="14" height="1"/><rect x="7.5" y="0.5" width="14" height="1" transform="rotate(90 7.5 0.5)"/></svg>',

			'icon-angle-left'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M31.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L127.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L201.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34z"/></svg>',
			'icon-angle-right'  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 512"><path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z"/></svg>',

			'icon-list'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="none"><path d="M16 96C16 69.49 37.49 48 64 48C90.51 48 112 69.49 112 96C112 122.5 90.51 144 64 144C37.49 144 16 122.5 16 96zM480 64C497.7 64 512 78.33 512 96C512 113.7 497.7 128 480 128H192C174.3 128 160 113.7 160 96C160 78.33 174.3 64 192 64H480zM480 224C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H192C174.3 288 160 273.7 160 256C160 238.3 174.3 224 192 224H480zM480 384C497.7 384 512 398.3 512 416C512 433.7 497.7 448 480 448H192C174.3 448 160 433.7 160 416C160 398.3 174.3 384 192 384H480zM16 416C16 389.5 37.49 368 64 368C90.51 368 112 389.5 112 416C112 442.5 90.51 464 64 464C37.49 464 16 442.5 16 416zM112 256C112 282.5 90.51 304 64 304C37.49 304 16 282.5 16 256C16 229.5 37.49 208 64 208C90.51 208 112 229.5 112 256z"></path></svg>',
			'icon-grid'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" fill="none"><path d="M0 72C0 49.91 17.91 32 40 32H88C110.1 32 128 49.91 128 72V120C128 142.1 110.1 160 88 160H40C17.91 160 0 142.1 0 120V72zM0 232C0 209.9 17.91 192 40 192H88C110.1 192 128 209.9 128 232V280C128 302.1 110.1 320 88 320H40C17.91 320 0 302.1 0 280V232zM128 440C128 462.1 110.1 480 88 480H40C17.91 480 0 462.1 0 440V392C0 369.9 17.91 352 40 352H88C110.1 352 128 369.9 128 392V440zM160 72C160 49.91 177.9 32 200 32H248C270.1 32 288 49.91 288 72V120C288 142.1 270.1 160 248 160H200C177.9 160 160 142.1 160 120V72zM288 280C288 302.1 270.1 320 248 320H200C177.9 320 160 302.1 160 280V232C160 209.9 177.9 192 200 192H248C270.1 192 288 209.9 288 232V280zM160 392C160 369.9 177.9 352 200 352H248C270.1 352 288 369.9 288 392V440C288 462.1 270.1 480 248 480H200C177.9 480 160 462.1 160 440V392zM448 120C448 142.1 430.1 160 408 160H360C337.9 160 320 142.1 320 120V72C320 49.91 337.9 32 360 32H408C430.1 32 448 49.91 448 72V120zM320 232C320 209.9 337.9 192 360 192H408C430.1 192 448 209.9 448 232V280C448 302.1 430.1 320 408 320H360C337.9 320 320 302.1 320 280V232zM448 440C448 462.1 430.1 480 408 480H360C337.9 480 320 462.1 320 440V392C320 369.9 337.9 352 360 352H408C430.1 352 448 369.9 448 392V440z"></path></svg>',
			'icon-size-chart' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" fill="none"><path d="m8.6 10.2-.4-3.4c-.1-1-.7-1.7-1.5-2.1.6-.5.9-1.2.9-2C7.7 1.2 6.5 0 5 0a2.69 2.69 0 0 0-1.8 4.7c-.7.4-1.3 1.2-1.4 2.1l-.4 3.4c0 .3.1.7.3.9.2.3.6.4.9.4h.2l.2 5.4c0 .6.5 1.1 1.2 1.1h1.7c.6 0 1.1-.5 1.1-1.1l.3-5.4h.2c.3 0 .6-.2.9-.4.2-.2.3-.6.2-.9zM5 .9c1 0 1.8.8 1.8 1.8S6 4.5 5 4.5s-1.8-.8-1.8-1.8S4 .9 5 .9zm2.7 9.6s-.1.1-.2.1h-.7c-.2 0-.4.2-.4.4l-.3 5.8c0 .2-.1.3-.3.3H4.2c-.2 0-.3-.1-.3-.3L3.6 11c0-.2-.2-.4-.4-.4h-.6c-.1 0-.2-.1-.2-.1s-.1-.1-.1-.3l.4-3.4c.1-.8.8-1.4 1.7-1.4h1.2c.9 0 1.6.7 1.7 1.5l.4 3.4c.1.1 0 .2 0 .2z" style="stroke:#000;stroke-width:.25;stroke-miterlimit:10"/><path d="M15.4 0h-4.8c-.4 0-.8.4-.8.8v16.3c0 .4.4.8.8.8h4.8c.4 0 .8-.4.8-.8V.8c0-.4-.4-.8-.8-.8zm0 17.2h-4.8v-.6h1.6v-.8h-1.6V15h1.6v-.8h-1.6v-.8H13v-.8h-2.4v-.8h1.6V11h-1.6v-.8h1.6v-.8h-1.6v-.8H13v-.8h-2.4V7h1.6v-.8h-1.6v-.8h1.6v-.8h-1.6v-.8H13V3h-2.4v-.8h1.6v-.8h-1.6V.8h4.8v16.4z"/></svg>',
			'icon-size-chart-2' => '<svg xmlns="http://www.w3.org/2000/svg" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd" viewBox="0 0 512 455.18"><path fill="#777" fill-rule="nonzero" d="M107.98 331.84h-.23l-.38-.01.31.35.3-.34zM382.62 19.95v415.28h81.71c7.61 0 14.54-3.13 19.56-8.16 5.04-5 8.16-11.92 8.16-19.55V47.67c0-7.61-3.12-14.55-8.15-19.57-5.02-5.03-11.95-8.15-19.57-8.15h-81.71zm-19.94 415.28V19.95H47.67c-7.62 0-14.56 3.12-19.58 8.14-5.02 5.02-8.14 11.96-8.14 19.58v359.85c0 7.6 3.12 14.53 8.15 19.56 5.02 5.03 11.96 8.15 19.57 8.15h315.01zm-44.8-60.66h6.76c7.04-21.8 8.85-22.65 6.67-39.09-5.3-40.07-41.02-60.53-38.67-85.5 2.7-28.66 15.4-37.48 21.79-61.77 3.33-12.67 12.19-49.01 4.98-60.3-4.54-7.12-14.6-8.67-22.25-12.16-25.22-11.46-32.99-23.37-30.75-45.16H232.7c2.24 21.79-5.52 33.7-30.74 45.16-7.67 3.49-17.72 5.04-22.27 12.16-7.2 11.29 1.66 47.63 5 60.3 6.39 24.29 19.07 33.11 21.78 61.77 2.35 24.97-33.36 45.43-38.67 85.5-2.18 16.44-.38 17.29 6.67 39.09h7.16v6.08c0 2.17 1.78 3.94 3.95 3.94h128.36c2.16 0 3.94-1.77 3.94-3.94v-6.08zM47.67 0h416.66c13.11 0 25.04 5.38 33.67 14 8.63 8.64 14 20.57 14 33.67v359.85c0 13.06-5.38 24.99-14.02 33.63-8.63 8.66-20.55 14.03-33.65 14.03H47.67c-13.1 0-25.03-5.37-33.67-14-8.62-8.63-14-20.56-14-33.66V47.67C0 34.56 5.37 22.63 14 14 22.63 5.37 34.56 0 47.67 0zm341.08 44.13h62.93V59.8h-62.93V44.13zm0 39.03h36.41v15.67h-36.41V83.16zm0 312.21h36.41v15.67h-36.41v-15.67zm0-39.02h62.93v15.68h-62.93v-15.68zm0-39.03h36.41v15.67h-36.41v-15.67zm0-39.03h62.93v15.68h-62.93v-15.68zm0-39.01h36.41v15.67h-36.41v-15.67zm0-39.04h62.93v15.67h-62.93v-15.67zm0-39.03h36.41v15.67h-36.41v-15.67zm0-39.03h62.93v15.67h-62.93v-15.67zM133.54 75.83c4.42 0 8 3.58 8 8 0 4.41-3.58 8-8 8H81.96c-4.41 0-7.99-3.59-7.99-8 0-4.42 3.58-8 7.99-8h51.58zm0 287.54c4.42 0 8 3.58 8 8 0 4.41-3.58 7.99-8 7.99H81.96c-4.41 0-7.99-3.58-7.99-7.99 0-4.42 3.58-8 7.99-8h51.58zm.78-233.15c2.88 3.33 2.51 8.37-.82 11.25-3.32 2.88-8.36 2.51-11.24-.81l-6.51-7.52v189.72l6.51-7.52c2.88-3.33 7.92-3.69 11.24-.81 3.33 2.88 3.7 7.91.82 11.25l-20.54 23.71c-2.88 3.33-7.92 3.69-11.25.81l-.73-.72-20.55-23.08c-2.93-3.29-2.64-8.34.65-11.27 3.29-2.94 8.34-2.64 11.28.65l6.58 7.39V132.71l-6.58 7.39c-2.94 3.3-7.99 3.59-11.28.66-3.29-2.93-3.58-7.98-.65-11.27l20.53-23.09.75-.71c3.33-2.88 8.37-2.52 11.25.81l20.54 23.72zm-25.63-5.24-1.01-1.17-1.06 1.2c.37-.05.74-.09 1.13-.09l.94.06z"/></svg>',
			'icon-size-chart-3' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82.27 122.88"><title>measurement-vertical</title><path fill="#777" d="M39.47,0h40.1a2.68,2.68,0,0,1,1.87.76l.08.08a2.67,2.67,0,0,1,.75,1.86V120.18a2.74,2.74,0,0,1-.76,1.87l-.13.12a2.72,2.72,0,0,1-1.81.71H39.47a2.72,2.72,0,0,1-1.87-.76l-.13-.13a2.72,2.72,0,0,1-.71-1.81V2.7A2.73,2.73,0,0,1,37.52.83l.07-.07A2.69,2.69,0,0,1,39.47,0ZM77.22,15.81H58.14V10.75H77.22V5.06H41.82V117.82h35.4v-5.69H66.7v-5.06H77.22v-5.65H58.14v-5H77.22V90.72H66.7v-5H77.22V80H58.14V75H77.22V69.32H66.7v-5H77.22V58.62H58.14V53.56H77.22V47.92H66.7V42.86H77.22V37.22H58.14V32.16H77.22V26.51H66.7V21.46H77.22V15.81ZM24,.23a3.22,3.22,0,0,1,0,6.43H3.22a3.22,3.22,0,1,1,0-6.43Zm0,115.66a3.22,3.22,0,0,1,0,6.44H3.22a3.22,3.22,0,1,1,0-6.44Zm.31-93.78a3.21,3.21,0,0,1-4.85,4.2l-2.62-3V99.6l2.62-3a3.21,3.21,0,0,1,4.85,4.2L16,110.31a3.21,3.21,0,0,1-4.53.33l-.29-.3-8.27-9.27a3.22,3.22,0,1,1,4.8-4.28l2.64,3V23.11l-2.65,3a3.22,3.22,0,0,1-4.8-4.28l8.26-9.28.3-.29a3.21,3.21,0,0,1,4.53.33l8.26,9.54Z"/></svg>',
			'icon-size-chart-4' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.88 89.03"><title>measuring-tape</title><path fill="#777" d="M118.29,48.22c-29.73,2.45-58.61,3.68-80.22.88C22.76,47.12,11,43.09,4.93,36V47.86c0,1.07,0,2.82-.06,4.54-.18,9.75-.33,18,8.57,24.74V72.49a2.3,2.3,0,1,1,4.59,0V80a37.46,37.46,0,0,0,7,2.56c.59.15,1.18.3,1.79.43V64a2.3,2.3,0,1,1,4.59,0v19.8a79.79,79.79,0,0,0,8.23.66V72.49a2.3,2.3,0,1,1,4.59,0v12h8.23V64a2.3,2.3,0,1,1,4.59,0V84.44h8.24V71.26a2.3,2.3,0,1,1,4.59,0V84.44h8.23V64a2.3,2.3,0,1,1,4.59,0V84.44H91V71.86a2.3,2.3,0,0,1,4.59,0V84.44h8.24s0-.09,0-.13V64a2.3,2.3,0,1,1,4.59,0V84.44h9.9V48.22ZM14.78,83.43a2.49,2.49,0,0,1-.28-.15,31.36,31.36,0,0,1-3.73-2.41C-.07,72.67.1,63.38.3,52.33c0-1.22,0-2.47,0-4.47V27A13.91,13.91,0,0,1,0,24C0,17.12,5.24,11,13.71,6.66,21.75,2.55,32.79,0,44.93,0S68.68,2.58,77.1,6.75,91,16.75,91.38,23.32c0,0,0-.08,0-.13.39,3.69,0,14.74,0,22.27,9.4-.48,19.12-1.18,28.91-2h.28a2.3,2.3,0,0,1,2.29,2.29v41a2.3,2.3,0,0,1-2.29,2.3H41.22a73.16,73.16,0,0,1-17.28-2.08,41.16,41.16,0,0,1-9.16-3.51ZM45.56,12.67c12.23,0,23.19,5.23,23.19,12s-11,11.73-23.19,11.73-22.15-5-22.15-11.73,9.92-12,22.15-12Zm29.09-1.9C66.94,7,56.31,4.6,44.93,4.6s-21.4,2.31-28.71,6.05C9.36,14.17,5.11,18.89,5.11,24s4.25,9.84,11.11,13.35c7.31,3.74,17.45,6,28.71,6s22-2.36,29.72-6.17C81.77,33.71,86.29,29,86.29,24s-4.52-9.71-11.64-13.23Z"/></svg>',
			'icon-size-chart-5' => '<svg enable-background="new 0 0 48 48" version="1.1" viewBox="0 0 48 48" width="48px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g id="Expanded"><g><g><path fill="#777" d="M43,48H29c-0.553,0-1-0.448-1-1V1c0-0.552,0.447-1,1-1h14c0.553,0,1,0.448,1,1v46C44,47.552,43.553,48,43,48z M30,46h12     V2H30V46z"/></g><g><rect fill="#777" height="2" width="5" x="29" y="8"/></g><g><rect fill="#777" height="2" width="5" x="29" y="14"/></g><g><rect fill="#777" height="2" width="5" x="29" y="20"/></g><g><rect fill="#777" height="2" width="5" x="29" y="26"/></g><g><rect fill="#777" height="2" width="5" x="29" y="32"/></g><g><rect fill="#777" height="2" width="5" x="29" y="38"/></g><g><path fill="#777" d="M15,46h-4c-2.757,0-5-2.243-5-5V12c0-0.197,0.059-0.391,0.168-0.555l6-9c0.371-0.557,1.293-0.557,1.664,0l6,9     C19.941,11.609,20,11.803,20,12v29C20,43.757,17.757,46,15,46z M8,12.303V41c0,1.654,1.346,3,3,3h4c1.654,0,3-1.346,3-3V12.303     l-5-7.5L8,12.303z"/></g><g><path fill="#777" d="M19,40H7c-0.553,0-1-0.448-1-1s0.447-1,1-1h12c0.553,0,1,0.448,1,1S19.553,40,19,40z"/></g><g><path fill="#777" d="M19,36H7c-0.553,0-1-0.448-1-1s0.447-1,1-1h12c0.553,0,1,0.448,1,1S19.553,36,19,36z"/></g><g><path fill="#777" d="M11,36c-0.553,0-1-0.448-1-1V16c0-0.552,0.447-1,1-1s1,0.448,1,1v19C12,35.552,11.553,36,11,36z"/></g><g><path fill="#777" d="M15,36c-0.553,0-1-0.448-1-1V16c0-0.552,0.447-1,1-1s1,0.448,1,1v19C16,35.552,15.553,36,15,36z"/></g><g><rect fill="#777" height="2" width="6" x="10" y="7"/></g><g><path fill="#777" d="M10,17c-2.206,0-4-1.794-4-4c0-0.552,0.447-1,1-1s1,0.448,1,1c0,1.103,0.897,2,2,2s2-0.897,2-2c0-0.552,0.447-1,1-1     s1,0.448,1,1C14,15.206,12.206,17,10,17z"/></g><g><path fill="#777" d="M16,17c-2.206,0-4-1.794-4-4c0-0.552,0.447-1,1-1s1,0.448,1,1c0,1.103,0.897,2,2,2s2-0.897,2-2c0-0.552,0.447-1,1-1     s1,0.448,1,1C20,15.206,18.206,17,16,17z"/></g></g></g></svg>',
			'icon-size-chart-6' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.88 122.88"><title>scale-ruler</title><path fill="#777" d="M91.87.85,122,31a2.94,2.94,0,0,1,.35.44,2.82,2.82,0,0,1,.49,1.6,2.85,2.85,0,0,1-.84,2l-87,87a3,3,0,0,1-.54.41,2.77,2.77,0,0,1-1.49.43,2.9,2.9,0,0,1-2-.84L.84,91.88a2.89,2.89,0,0,1,0-4.07l87-87a2.88,2.88,0,0,1,2-.84,2.82,2.82,0,0,1,2,.85ZM37.27,112.23l-7.91-7.91,3.8-3.8,7.91,7.91,4.25-4.25L31,89.84l3.8-3.8,14.34,14.34,4.25-4.24-7.91-7.92,3.8-3.8,7.91,7.91,4.25-4.24L47.07,73.74l3.8-3.8L65.22,84.29,69.47,80l-7.91-7.91,3.8-3.8,7.91,7.91L77.52,72,63.17,57.64l3.8-3.8L81.32,68.19l4.24-4.25L77.65,56l3.8-3.8,7.91,7.91,4.25-4.25L79.27,41.55l3.8-3.8L97.41,52.09,116.47,33,89.84,6.41,6.41,89.84,33,116.47l4.23-4.24ZM98,28.56a3.69,3.69,0,0,0-3.69-3.69,3.69,3.69,0,0,0-2.61,6.3l.08.09a3.71,3.71,0,0,0,5.14-.09l.08-.08a3.68,3.68,0,0,0,1-2.53Zm1.71-5.4a7.63,7.63,0,0,1,.12,10.68l-.12.13A7.64,7.64,0,0,1,89,34.08L88.91,34a7.64,7.64,0,0,1,10.81-10.8Z"/></svg>',

			'icon-duplicate'  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="none"><path d="M464 0H144c-26.51 0-48 21.49-48 48v48H48c-26.51 0-48 21.49-48 48v320c0 26.51 21.49 48 48 48h320c26.51 0 48-21.49 48-48v-48h48c26.51 0 48-21.49 48-48V48c0-26.51-21.49-48-48-48zM362 464H54a6 6 0 0 1-6-6V150a6 6 0 0 1 6-6h42v224c0 26.51 21.49 48 48 48h224v42a6 6 0 0 1-6 6zm96-96H150a6 6 0 0 1-6-6V54a6 6 0 0 1 6-6h308a6 6 0 0 1 6 6v308a6 6 0 0 1-6 6z"/></svg>',

			'icon-location' => '<svg viewBox="0 0 12 15" xmlns="http://www.w3.org/2000/svg">
			<path d="M6 0.75C3.07422 0.75 0.75 3.10156 0.75 6C0.75 8.13281 1.46094 8.73438 5.45312 14.4766C5.58984 14.668 5.78125 14.75 6 14.75C6.19141 14.75 6.38281 14.668 6.51953 14.4766C10.5117 8.70703 11.25 8.13281 11.25 6C11.25 3.10156 8.89844 0.75 6 0.75ZM6 12.9453C5.50781 12.2617 5.07031 11.6328 4.6875 11.1133C2.30859 7.72266 2.0625 7.28516 2.0625 6C2.0625 3.83984 3.8125 2.0625 6 2.0625C8.16016 2.0625 9.9375 3.83984 9.9375 6C9.9375 7.28516 9.66406 7.72266 7.28516 11.1133C6.90234 11.6328 6.46484 12.2617 6 12.9453ZM6 3.8125C4.76953 3.8125 3.8125 4.76953 3.8125 6C3.8125 7.20312 4.76953 8.1875 6 8.1875C7.20312 8.1875 8.1875 7.20312 8.1875 6C8.1875 4.76953 7.20312 3.8125 6 3.8125ZM6 6.875C5.50781 6.875 5.125 6.49219 5.125 6C5.125 5.53516 5.50781 5.125 6 5.125C6.46484 5.125 6.875 5.53516 6.875 6C6.875 6.49219 6.46484 6.875 6 6.875Z" fill="white"/>
			</svg>'

		);
	}
}

