<?php
 
 if(!class_exists('listingproIcons')){
	class listingproIcons {
		private $icon_code = array();
		 
		public function __construct() {

			$this->icon_code['todayTime'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAADCElEQVR4nO1awY0qMQxNCZRACZRAB0sHTAfQAXTC3iI/H1LC0gF0AB0wHfx/CSvwJCwzsWGQ8qRckLCdF9uxM3auoqKioqKiosIQIYQJM38x8wbADxGdAPy7XfG3H2beMPNXCGHybruLEEKYENESwEFutsc6ENHyo8jw3k/jSV8KNi7XhZk33vvpu/f3EAYb7xABYPXufXbgvZ8+4ep7ItoS0QLATMoAMCOiBRFtAez/Co3ReEPcUO7Uz8y8HmJsDKU1gHPOG4hoYbCl5wGgyRjXAmiU9bQZXWp6hhjVMYiIvi2ydrxVvkdBQnT7IkPkf3v8L0f8a8IhJjwZ8y0zz/vIGUqAc84x8zwREpeXJMZUtu+7+ShnMAHO/ZLQuR36yumFeEWpxF8pAVFGJxyYeT1E1p9IuT4RfQ+Vp0GAc84lEuPFpHROnH5bokiLgBDCROYDItoOlfdIiUx8TYlMLQKiLBkKul6QUHBWkKlGQJQnK8amVOat8LvMr5FotAmIZbP+jRDd/85YjftWm4CYpO9kqoRBwv33xUKdPgHOOUdER5EMy6tDmf21MqwRAfq2QvTmWjW3EQGyR9lrCD0JoZ3HjCGwIADATBzWSUOouqEpuc+ul9tbCagEVAJkiamSBC0gkyAUSnaza9ACVtegSSFkARNbTVg1AkTTpuKtVs2QNsyaIee6TYbZu1sBZDtMREc14RAdoUqJqYxEyd6oCU+9u6kqKIQ8IBS+VyaReBS1eX3tidR7pclNFZOM9IKduqKeALAzP/0rND+MaCDh+vYJWt4IUencVGnajs4HWtXMn0MmFC6vJCEzlNG+rD7R+Dw+FCm3f0uPkjMEwM5qQCKR8N6bhx6QcCGipZaeOG+Ym0NqtPQMNW6RyAm/FSOA1dAhKQCr1FTpNeZH05p776ep20Gsw3UMFpkxuZtx2ocjd0R0HGNDdm1IctNcGqsdYyN2hzjNtVUmoiWi7RhK76cRs3bzRGg8dHUAzUdtPIXoFbdjsKnpzzNuxmk/ftMVFRUVFRUVo8d/fHG1F7o+XcIAAAAASUVORK5CYII=";
			
			$this->icon_code['cool'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAADWklEQVRoge1ZX0hTURi/r0vKFVSDoC6U9x7EUEJQQWThJP80NpDwIR/uo8qEVWRCGEOI8GkIJSwfRAgkCJYmDEwbzkx3R1wIIlYPgx4iENvDIMiiXw+7Xba7P95zd+9uwT74ntw55/c73+/7PN93GaZmNatZzRiGYSCxdsQ5LxJ8ECKJQuQliHxadgkJPgyRLEAkAiTWbjVehmFyQCtgCTR7lpBgHfgd4swCpwBd1HmpqkQgsXb59ioEXoTIDmHNBS82tEAkKePBKyTSEBtaTAJPBGqd63fBYPANLVUEL7tBkYDE2s2VTRk5GZET5iSsZhJSZeDjnNc68BXmQ1Y6RtT5yqWkj4BIBOvBy77L++kJWKr9CqMgy6fKZfMQp6lI6uTNxBoxP9OJYaEXbVc8JX10pAerobaSIFZDbZr2mJ/pRCbWqF9GyD57lcXzM51lD1X7hL8b42Mu9A0OoG9wAONjLkzdvky1x9JsRz6BBB/WTkCl/9GRHqrDjXCXx62OYJQiAvnl0zvUTw0gPNeOvY0m7G00ITzXTr1+WOjVn8hQPR2CgS7K27taoP9r1/uo9ggGuiohkF+BMrFGqigUHk53Cd6h/sIkFgl0SwgiQXK5WbN23z69VHD4l7WLmtdvLrYWq2IpGglFi5XB5HJz2TLo8rjLltHNxdZDdZ9cbi71z0z7w06eLJQEsjTbgQl/N1weN1weN7xD/ZiedJY5PP8SpiediiRdHjcm/N1Ymu0oKpscX6CJwL/zDvrrcRLQTiDbxFgPOtdpmxszn9LJkAOfn5yhWKOjsTFLRvsrLCI+G6J3jpojHxWJFA2433GCgy2u7G8SD04g4rPh02OH1ttP6x5F0raUEZ8NEZ8NmbXzRf/+4dFpRHw2rN+qw683vLZ99TQz+VHQngvvH55CxGfD66l67K+w+LnN4WCLw7cXLN4FTyoEvz47q1n7FQ+CaZqbHzEO4v3jClC1r/mPYO/5Oe3SMWw2tEOcNFJKhhyI3T2GlzfqsH6zDtv36vEx5MD3Vxe0g49zXkPA6yWh3/k0zJpWmz9iNOHmC0iYNi+qwng9j8gu74chM1M+jV3eb9lnpywRPRHhJUuBqw0Sa5ejsoBsP5HKScqU8qEvTgKmfcSoWc1q9v/ZHwEdYUWl/1cUAAAAAElFTkSuQmCC";
			$this->icon_code['smily'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAC0klEQVRoge1ZMWgaURi+9cBBXIKTN2juYSk4FUtLTPYMDo4ODhlPEIouDga6uJXSQCAh2MGOQchQoYMHLuop3BoIwaVQKoQblOvWr8Odh5pE7z3feSncD9/i8Xvf9/7vPd7/nyAEEUQQQQiCIECXwhjsZzGUP0EjKjRZhyYbNnQM5RY00oBGCtClsN98BUFYIO2QJXANS1DBP/I9cmgRpyD9JGR9p0KgS2F79bYk/oSQHpG8Ja8lUtDImD95R4QBLZHyiDwpUPucHQXO5BOpHZK3wakS0KWwt7ZZYycee8KbDetahL4d+cF+1j/yW+4Hyzo8zvntrcQmQCMF/8nb6MslegG+en/LKtj22fGxuQE0J5KbzWt2k7j++Ab1k/eo5Q/QrKbx8OPVRiKseVQ2gnXtXUvipvEF5myK64szFI+PUDw+QiWXWUuGNQ8aAYZyy72ADf5vVtMwZ1MAwMPvXw6R4vERmtU09zwbKkUF1h+ftfwBri/OYM6m+P7t6xKRSi7DPY96I2PD1aGWP1h6OY0AljwGAetPoGY1/SyRyw9vuefNwc1CZjf57Cr+vHnNPc/GmMZC6qbVMLtJNKtpVHIZVHIZfFbeuT5GWfKoLnb2ZMHFn+4UDZoKvJx70BwDcupegNXE+E96EbTNzcu4Ss/B0Niw2ujv4Plnd5dR3F1GvbXPiogx7cvaiog/avzR76YaR1sR0SmHaFffYB5F0raUo3oEbUXE/dXjVb6/iqKtiBjVI3QCWJqZ5Sq43wuTVgxtRXREmGocphp3yLcVEZNWjMr7Ww+CaZub2/M9h+wqbs/36KzDbTbUI4c0ZZ+0YhjVI+iUQ+iUQxjVI7Qrb2Cwn+VCnlUEO2QDXk2rvR8xerDyj0R4Ni/awXh9SUhfLoHLzFQ20JdLvn12soSwVETWfSW+GtClsF2VBqx+YrywKcfOh74BOfXsI0YQQQTx/8U/NbsBR2GfRk4AAAAASUVORK5CYII=";
			$this->icon_code['sleeping'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAACk0lEQVRoge1ZMWvbQBjV6mBcuVBCaFyrEPlu9E/oT/BP8A8wxEsypItDaOjWLpkyeCihLZQ6SzFkiBIXbOtMuaFDhgymhJQWDxqdQOB1kOo6tmPrpJPOBX3wJnPovfved77vO01LIokkktA0TQM3dNiFEnrkDRi1wAgHI44Hjh5pgNE6GC2DG7pqvpqmjZEekaXwDVdQWR35Dn3hEhcgPROExyoE3NC93QtJfIaQDjWiJc/MIhjtyyc/EuGAmcWIyNOysM+DoyyZvFmMkbwHSZkAN/RobTPHTjJqIpqC9S2ChyNvF0rqyIesB9c6Ms758FYKJoDRsnryHrqkKi5AqfdDZsGzT8zH5gKInEhLUrzBbQT32que9Dh6pOFfwBz///6cx7fXj3HbMqd+u22Z+PkxJ3XdGCyBDDx8fLZrj9CspNDayeD6fQ7DMxPDMxPXH3Jo7WTQrKTw491Taev+QaCQMefqcHNuwt7LollJzYS9l8XN+fQuB10XUMDiE+jqaB29/SxOt9I43Uqjt5/F1dH6Qi8HXQdGIcVCCtEXsZC1BIQnLeT/YudNFpaA9D3URTKwPPegv7Bpzb8At4lRT3ocos3NchVygMZG1Ea/Pj3D15cZXB6uYXBsYGht4K5NcNcmGFobGBwbuDxcA3uVjdY+EyL6fj/y/e2TB/+kJuF8eS6y+07gUaTorXTQyOPiYBWdXR3Wdhonmys42VyBtZ1GZ1fHxcEqBo282O4HaWbuZ0FlLRAeehCsrrmROKVzB7kxk7cLJSnk4xdBHEQ1rY5+xBjBzk+JiGxeFMN4/Z6QLqlCysyUOOiSqrJnJ1dIkIwQrpT4ZIAbupeVOtx+oj9WlP3RQ59Na5E9YiSRRBL/X/wB39ErAGSgONsAAAAASUVORK5CYII=";
			$this->icon_code['crying'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAACw0lEQVRoge1ZMWvbQBjVagip3bUx1SLfjSbQLUOh0NmdA8V7PXjJ0EwGg+nWoT/AxCW0hZKM3uLEg2OdMEegkEChJqQ2KR2MTUscKLwOUiw7km2dpLNa0AdvsXzSe/red9z3SVHiiCOOOBRFUcDVJPRMDgZ5C0YbYISDkYEFDoMcgtEqGM2Dq8mo+SqKMkV6QpbCM0xB+ejIn9KnJnEB0q4gfKVCwNWk9fYCEncRckpVueSZlgWj3fDJT0QMwLSsJPI0L+xz/8iHTF7LrpC8hZAyAa4m5dpmgZ3CqAk5BetZBA9GXs/koiMfsB5M64Sxzwe3kj8BjOajJ2+hTYriAiL1fsAsWPZZ8ba5BCI70j9SvP5tBPPYGz3paRjk0LsAD/6/2t+AUUnhaGcNRztrMCopXO1vLCXidx0YbQhkYP72OT7RoJdTqBcSrtDLKYxPtNDW2RAoZCw4OrRKD1AvJNDcXUfvYxo3xxpujjX0PqTR3F1HvZDA5ftHoa3zKWD+DvTj4DE6bx7itul8W7dNDf1P6VDXTSOYhTpPgOs94OxZVIXcFbFQw3GDnwcAAHx7HZEAgYOdNVmwF19WMInrPblE7zLtvFYVycDsOWik2wL+jOQK+PrKfM5In/1dpyXvAswmxl48/m4L+H0uV0Dvnf2sabuKNjczhXz+0hQx0uXXgGu2fTQ2DhsJYFij+PKC4uw5RWeL4mKb4tdnj+vdsi1in3siuqLk+2UKtknRok70yx7u4cg2GfgeRYqeSoe1+eTvMKwJZtRPMzObBe9t5cX2YvItav7HuwDCAw+CRZqbztZyAWzTM/nwpnTmIFfizuNGXs/kQiG/ehFkAFnTavkjRglv3iFC2rxoBeP1GSFtUkQoM1MyQJsUI/vsZArxkxHCIyV+P8DVpJWVKsx+ojtVlN3Jhz6dlqR9xIgjjjj+v/gLAT87Freiw9YAAAAASUVORK5CYII=";
			$this->icon_code['angry'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAADbElEQVRoge1Zz0tUURh9iJWTqYONwpQ4zxln7lv6D5QtpI2LDBfhRmbRwsVE9gMCxR9UGC1KUCQIU1xpm8ZAHE1kUjRnnsGryKAQZuPGwiZFF0FxWtyZNz5n3sz7Oc9gPjibmXfvO+d+57vc+z2GKUQhClEIhmEYCKwdUV8L1skgeC4MngjgSTwBAeskCJ4bB8/5IbB2q/kyDHOItEiWg2JQQX7ryK9xlyhxFaQzggh5FQKBtSdWTyfxDELWONZc8ry3ATwXM568KCIO3ttgEnnOr9rn2uE3mLy3IY/kEzAoExBYu7m2yWInI2rCnIJVLELQRz7qa7GOvM56oNYxYp/XbyVtAnjObz35BCKkU70AS72vMwsJ++R528wBNTuSbPHOecwnOuvWbyPQY2/6JFdOADfKgBmZl+RCVOb3JS8w76FzXzuV+Zl1ElQuQM7/3ZXABUbEzkAVdlZ8mld7P8Lh2+h5ujDJebsr5Z4Pq8iAzPY555EI6B1yojXoxuNQPb6+9SomvjXvwdiCF+2v3WifYrHdXJyad7JWZpyKQka2o8PtCvFlHRO1aA260Rp0487zGpr+Z+dkPMwBE/SZsZ6z4rj2KRb7TUV0zuulWYSrEpBlB1ryiQI+t5WgY6IWvUNOhDvKUquYycc3y8X/95uKMPywSjquMdvqU+i3UBIvXRIrSdBWQkVmGuc/nXnMRQYYqMplvZgaC4Vzenm6Drh6MkXichFw3yFPPokRZ2pcIwM0F1Nr5awdFQe7RGdB8+5iEsbVZOD4nIOSiHL9ygXQS4z1pA9D7eXmeBylk9BwsTHKRn8jBJsvnFjpqcBSVzk+DTqwN6/yTKXGPkdExJS+5OdMHf68I5LfvgddWO4qRyhgk2DhVil255Sep0hccytS6ZVya7IGoYAN7x9VYjfkxt4bD76MVIuEIw/s+DHtwsFiPT4+dSAUsGG1r0KZAC2XGWkWctfCwWI9wvfK0lY6FLBhc9SZ9vyHJw5sv3Ip8r7uRrDSy83vZS82hqux2leBxbtnsDFcjV+zdXoK17guHW3kmr3THCEf9bUYQj7/IkgcZnWrzW8xmrDyaSJM6xflob0uERIhnTCkZ0riiJBOyz47USFaMkIES4kfDQisPZGVcdD7ROxQUcbED31Rrt+0jxiFKEQh/r/4B2YxCCnP/4ErAAAAAElFTkSuQmCC";
			

			$this->icon_code['whiteMapMarker'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAACw0lEQVRoge2aS7XCQAyGkYCESkBCJSABCUioAyQgAQmVUAmVUAnfXTChYaDzoAllcXMOG0jz/JPMpOx2//RKwB5ogQ7ogQGYwmcAbsAFaLe29S0FBy7B4Bq6AM3W9i85MISMtMAh8OyBBjiG34bYoa2duCljeuBQ8fwBuEYB2HvavGTEGAwY12A+kjXVBGMVhUwINHoLjAeZvXLGNzMRnMyhoJwZLOW+U9QpOJlHLcp2Zy1fK5Hu1LoouetpFMQaDwWSjZu58Fdd0s2uHsKls2S7SsjeOdTTEJ69lcIlPA8wrTY8EnwsLULugzAeeJqGEmiqwJ0sfBChAqsuw9eqOuqZp7tMde1gW6jTDl7MLfeY4NEd58JCVwu/ZWETggDQr7VfCxUDmwTPWWUi2ZqZ50WX4LGvE4XXJsGTzZrilZpb7IBejgjuFyNd4mytkVJMH5i8KFCgtdh6rR3h3iTA8riiYHNK8FwroJUtZK9il05zTvB0pYpVYLoEjzQP0/abnSMBLmOFgWOm5kSn3e2Rucsko63gAGqCMy8l9I0yCUEqumCNI3tlQJPh1Te+dzQVOFGsr5pUhBbrJOKXlZCsg/rwXfYeo+Bnf9IGTm7CX3VVBa1W+KP3l0R1pR4ZwI2XEsH+yUXB7inzfvd2pWR01DF4B0sUSVbs2uIsW9r86AlfUSaDyjz1FBzvLZW59HjmYeq/oFNK5exl1oq/mg2lVGdl9a5W1cb3sqGUP7aOK+X4bxcLDFg9Vyg8DbuShsSHz+spfjI2r9qYxwrog2fNm8bHxLx0rir8qN1+5+VOjlRkiwp/8wJPUY1hquN9/71hjiKItQk+2Q9PKb5Nicxe96chFRPzUeNlUcF88+t/DlIxRbPhrL6XwefzSs2DeF4LtTy/NzG/x7iSrhflxHZ/1VhDql4I9fHbdbFEqkv9fnH/Cv0BQ/alWS1rdsIAAAAASUVORK5CYII=";
			$this->icon_code['whiteMapMarkerFill'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAB7UlEQVRoge2aUZGDQAyGkYAEJFQCEioBCSdhHSChEpBQCUhAAhK+e+j2yvVamkAS9uH+mc70KeTbTbIkS1X966+AGmiBBFyBEZjzbwQGoAfao319qQzQZ4c16o/2vaqqH4C0AaAcoAwx7ARYagTqaIgTMBlC3DUDpyiIOq+el2a8dwb7cHqn0RskBUDclbwgavZXJ41moPEAidyNuy4eINMBILM1RLvBiQE4cyvVTf5/2WDnbAmiCat57eEZTJNrduGFruR+XEF0O3y1BJEegOLVQx5mdnmCPNHF8cwtZ8JBpDHdKGzWQptYgkhDywPE7nWFW7cnUaewKU1402TvhQ8dFDalJd20/GrOkVZgr0Wed3bdI/IKQ3bwLUyGmBT2TE92cYVZqM9O1zymK9oBhf0bMNvek/ZKnHMakO4AkC8PkC3htVeNOUiGmQIh/Pp2YsOrcwPJMFMAxETASCiid0+uEBnEO+n9B3QLmIsjSAqByCBeuxK3GwsYj1xJoRAZpMa2gk1E78YCxvJc6Q6BWMBYXDHYdYE7QJqdEKv9S6iQt8KvlI72/5fYFmLx94afhD7EygmpZ6ELsXS0v6tCNgO7FhdSz+LzFV3cFfResT5FtBvvRIjX+VLGtydaPeXLUHxevBOPryTKT+5S9A18gbyJTt3JZQAAAABJRU5ErkJggg==";
			$this->icon_code['building'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAABh0lEQVRoge2Z4Y2DMAyFO8KNwAgdgVEY4SbgvQ1uBEa4ETICIzACI6R/7FMUQblGIYHIT4paHGLyETu1msfDZDKZVCR7kkOl9swGAmACsAJYCjcPYMoNks9hreeKQw/AyfWvhFsH4Ock2yxRkA+EZC8wi1w/SX7p9zNsEloTyT4biDxgUJASArCQHLI7bhKEZDeOI7WFyx/Zh3B82BfY+2hMVxKk1+QHsIYTE/ssMe4CuxPbDMCH4JLUDoDXl1IURCcYg+hbjkF09TZAXDjWQFJBEkPLbYCor+IgbSR7CRnIkXZyxAPwGzmiLc6Rvz61BzniqyW7fM4bu9a31GYxyKQTj0Bc6LM4iE7w9ttvyopIXwwyV12R2+dICRnIkZr8Zbcy/qrbbzMgiaHldrbfKqHVRrKXkIEcKbFE2W16/2XLeLVB/u4MG6SQjHMKVyzj92zhpPdsl1qRRJDrlfGJIHVy5EifgLzxYSBv1RqIx/8OMVdsH56un/g4C6Rj+aPpLjuIyWS6t14f7rZa8TerQQAAAABJRU5ErkJggg==";
			$this->icon_code['reservation'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAABcElEQVRoge3YYW3DMBAF4EIIhEEohEIYhEIoAr/HoBACoRAGYRACIRC2H0sky3NiJ76L3faelD+NYr1P9lVpTyfLkwTAT4uXQTY/qBSDGEQpBjGIUgxiEKWoQNZeG7ReQwzyFkerRrwd6wEMAEYAd5Jd1oMH9Uxm5SiOq5iWICTPibnqFx9uZdgnxDDd+5qO1L9daRoSIkh202chZh/kiMQQwT0f81hcqCYkQPSxYQZwn3eD5GVxsVqQHATJ27wjJG+rC9aAbEU455hctOawiyEqQ+QQKYhkVI6TnyMgGxDR3c+KNmQPojlIgIi+wfoIklcViOCwZyFSfWpDshFqkD0h+bH1OIn0UYDMJZODHSKK+khDADy8ohf/XgpR1EcSQrJD8BtixniIcQlR1EcY8rkw8H0OoqiPJMQrHLuSiKI+wpAhBsDfL7+rah9hyPdc3DlHkufk/1FSfRS+fjcVF+sjDSmNQV4O0tr1vhBLpfwC/fEj/XMgqroAAAAASUVORK5CYII=";
			$this->icon_code['reservWhite'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAABaUlEQVRoge3YYZHCMBAFYCQg4SSchEpAwklAAg5OQiQgAQlIqIRKePejYaazk2Y3yW4TuH0/CUnfRxtoOZ08bxIMGocUTzSKQxxiFIc4xCgOcYhRTCAgyY3VxCGqE43ycRAAAcAMYAHwC+AsmnhQTzaZK3HJYkaCAPhmtlXITWY3Xuo9zAFFSSDmOPTAegZolqEhCcQ5vkYxdZAjkkKQsS3mnluoG4QgAhKbGes3FiJoyi3WBSJEXDdn5MoteDikAnGTLLoLIRtNfbOrITpD9BAcRDOwuJzIZHNIASJ59qUHMYXUIIaDEETyDpYgfkwguU+JjjERIbg+vSFihBmkJgC+UHg5qfQxgLxKhlJEUx8DyH1TdCJjWURTH00I1ucI+gwxxbEXYtlDNPVRhlyQTpAgmvooQwL2wyKa+ihD5h3AQ4Jo6qMMeW6K37D+suf/j9LqowmJ6xUVV+ujDWmNQz4OMlr+L8TTKX+SZv523JHR3gAAAABJRU5ErkJggg==";
			$this->icon_code['resMenu'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAABxklEQVRoge2ZzZHCMAyFKYEShNIAJVCCJ4L7lkAJdEAJWwHzSqAESqAEl5A9xNkxkB9B4sTe9ZvxJZNY/mzJ0iirVVZWlkp70E7AEPBNwNWH4y5gHEDbReyU4KOA7YiJX0YJPj5DBLVzAG2nnrwZe9CugQhuxx3z5JO7gQYkuB2p/S2UAeuBhLUTcPJKwJUHEtaO8sXbAbQ1oLWgMO/sbkwg9vmaMyBKDqTtGq2v0uJrHEhhunKNL5d3Hr55fKYDsQa07jKicbEukL6k+WijMM/f+M9UIHvwuX+3+JyIa/Uff9vORAkydPz1LZYAiAFROJAZg70v0LU73fXerMGucK3BfKIFDupaXTmkkSaXRAEidR6hntMYLMtjAanE1VmvEJurykAnyLyZ/RfGn1wL0Qcya7C3LehdN4nJtTLIPwFZJtgnB8nBHp9rZZBxIH4lPA3IQsE+Nchiwd4Uj++0gqJ0raYh7ZrR6YIIGAa01nROYgf5zMCMIPc/AGJXAv5OH2Rzbb2T0wNxOam88ClVkJe2bn2tbq4y8X++QCC2XquuOvhYBkTuD64PYkvwUZvRo5LfFysvfFpwKePk12dDfeSsrKyw+gEW7okezpS7kgAAAABJRU5ErkJggg==";
			
			$this->icon_code['fb'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAACcUlEQVRoge2a3bWqMBCFKYESLMESKMESLIES7GBW9h6eKcESKIESLIESvA8mOXCOQIKC8S5mrbwYycyXmSSTnywbESELqArJFmQH8v6h0pFsoVqTPI3Z+xegqo4grx80fLKQbEXkMAkB4Ox63/aCCFlIVR2De+LNIiIHkidjzAWqNw8FlE8/AFD6P6nWIpJvbHOQQFVGYUTk0PNEeBx+SIQsHMwgWkA21hPyQfuixHtG9ZZlWZaRPLkfUg2nMfFjBjhnUK2/zRtOjDEXG2LXzK4TXzE2fouPJrLz7pmdmxMUEcl/QOzo39QAsrBh0fjM4dGhV6jWAMrQtcvbvyWI7cHwrMHNSCmBSFUdXRiTbF2vi0huy4HkCUDpJ6AAuzYH6XmiCZnmkwSxiegdZBe6ViUJ4uZ7Y8wl9JskQVxYPVurRCQ3xlzG9j0BbW8IMrFWDbLZJ2W27YRAHnVksSTX2zq0RnW8qn8HiVUwF+9zq/tcDvgtIF2ontVBlnzrtrIk22A9KYL4gxDVOlhPkiARu9a0QSYygVE9KQ/2kF3rN4DMzlj97/cFcZGyyLqotneQJcoi66La3kGWKIusi2p7B1miLLIuqu0dZImyyLqotv8nkC40QXtZWWTdnPSuFe6bXPSsBuIuRVVvfhMTc5wZK2uB9K7Ur4PL0NfMnVC4AogNq2YQTS681roQXQPEHYzbJx2PE0r7YOCxK1vhuca7QezY6EB2QhbDBodPON7qmXeBiEhuD727yXHdhyHZGmMuf4gXyCsgIpILWQAo/RAgOwDl5KG3VNWx90FyhWQbFf4AzlCtB0+LPlPc1XUD4DzmhX+QRYQ6YahpGwAAAABJRU5ErkJggg==";
			$this->icon_code['tw'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADSElEQVRoge1Zy5GDMAxNCZSQElJCSqCElEAJ6UDjJ3OmBEqghJRACZSQPSAbYf5gkj3kzexhJ9jW90mWL5cffvjhh7NBRAkzpwAyY8wTwIOY79+WazWI+c7MLzC/J/4aY8xzaQ8wl6OKU57fYG1BRMkpChAlsJa0wKJQCWsJ1hZaQWZ+UZ7f9HpmTntGsLYYHATmSn6sYysjRqqdAgCyqTMoz29ellYeEuGb0HNa0XZx66q3WhxNGSJKlBAVEV3XrAOQhYIH3qDhIudya4vYnpE932Aut66lPL95IiC6grnUYQXmqhde7gNmTvX/sLYeuG8DmDn1YXDAKOLVMvCQj55OEYlf7XZlyfcSi0zB5wWQ7VVC9qFRJdpwS7sPJYZDq+kNQhZZgiTtG8zNESUul45ujTFPMXAzaiCXF2OCBozzhrW0JmFVslZHFRnZcyHZgceqTSR55743xjwnDzymRDMZqgAea5hFiloRximsJQCZ9qgyzqH8UPvVS8Z2Ag4SfnZjIOuFXOAtx/l7iWJKkUX5vFc0na0AMd/F+tWoUmNtxA6sUkTYgHQF3nsgEV2lq30YY55rPbwEZ5i5g5MxSzLzK4YAMSBVfTlavCeCmO8Vmy9C1aT5SPHxLQzjQuOsln4rfKuzlG+qgkcrXjHh+qxFBtR5cqRJPAubSoMvdBvp92y4/FhNProoxuL+GPCtyZZWJ7gpVv8h2V2HsJlBxZXd/Xhlt3sGFFttv61OjmsiNX9bEJaFbYunbmMfzptD3rhcgpZFWvNv5IrzxqHu+dtUrJjq2CRHpnouTz5a7YU5m2i9nnScbsPXJ5irZ8BIV+R24zy/BQxWEvP9LKXQzddep+TlyOAhapsfzAKGM93YQDjti1Bbgilic9odiIgSAI8gxKIceKoSRJRIbqQym9Lj/EZalsPx2+sgWpq97t4M7SNLzcyviTeI3itSjCRXDz7xGHEQ853Va8isNWbiycip8efMPPjs2TxkpGp2mrcRxHw3xjyDHKtOYaaJUaif725xPRElE8K3U5qIRpoFgGzy1VVCDtYWfqgnU8aZHGsJ4kvNZ3vBasOunCGBUWKAtfVXhZ+DG4XqcSiADEBGzPd/KfQPPxzDHz/jPqGXuPfUAAAAAElFTkSuQmCC";
			$this->icon_code['gp'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAC/klEQVRoge1a7Y2DMAxlBEboCB2BETpCR7gRuoGFn/nNCB2BERiBETJC70eTnKEEEgqUSvckS6cqtH7EH8/JZVkABBRlWd4AtAwYa48PmGHgziJERKeQv68EqurMwP1DTsdYM0uIgEK9ecMiRFV1JqKciPLot7EiiCgHcCnL8qYJAbiMPsDMV09CpP6U43NgkTpIhohOigR9yMdo6N3phZln+QUkHFQeN1mW+eR+MGCOGk5jIKKcRTq/K36bvmg3HFiEXE77LQpWgQPDR5NIl7nt+XIz2QGcWMU8kU+HyVL8Ezka/okcDW8RIaKcgIJF6oh5pdmyRy0mQkABoAXQ2sHr4jusM5GOgIKAYmvZs4gIM/8wYAC0QweVZnN238b1gU+pRLTUJ6AY/dLnTOPJ7CF7konogWZmXbfnrqQTUck8ua6fL2Y9l4N+xRMZxv9UAgO49DTQxkgj8syPv0RmvgbXatIi3eqeD/BWaLFIHVo3IBI9rL2o2c2IqGRn4EFVdR5bp0LLpByo7UZEz8i+6Q17yfMMqrW9Jqn07kbEOnqyjvqq5Lp7WZY3FulYpAvt1mGIOChZ0lj7C7lAs4x1aFciGkvK7dDpWNuVSFmWt68kQkT5y4/OlN1DESGinKrqbPOlHv4ogPawRIjoNLz8sX/feeROZYrMHLnU52IlSm6rlHEld6zE2h1qe05NqIDdiajQiWp03C/JUQp4cyJ6WIqpSA56Z2Ia5PZE1NtNkR36BcQ0yT2ILOraWgUn3cYmIoWIl++JoeUa5abjriZi7Fsbnfpi5buGbZINA2aJgEyBJ+KSMhQ21qn+4RvzT+iLbamuYyvcO3DhC6DV11dBWTEi353dWYSshHdq2HDMpf4K6F0b6svQuQedfB8hZRhoQo1yC/QuQ100qRK7y+ngGlDHTo3/sHdKMhH/R4E9un0wYF5y2/4fSpQM/xSU5nMv/Tq+UJOxhJaOrmvBjQv+TMDl5MTZ2vPBMQV7LGuSCoq9yBmrUHvbc+YRqacI/AIRrXPVmdbPHQAAAABJRU5ErkJggg==";
			$this->icon_code['lnk'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAACvElEQVRoge2a3ZHqMAyFXQIlUAIlUAIlUEJKoAONz3GeKSElpARKoISUwH3A8sZsbJxhN87OjWb8Qhyiz5YV/cSYhAh5hHNC8gZyAPmoNAaSNzh3JXlK6fsdoG0PILuKimcHyZuI7LMQABpdfb8KIuRR2vZQvBI/LCKyJ3my1l7g3D1AAc3kDR7iOck5EZHdwjoXCZyTJIyI7Ec7UW6HlUTIo8JE1gKy152oqN8sCTvj3N0YYwzJk/6wVnNKifeoDwBnA+euf203VKy1F29iXaDKnQ1vk733ZHeQ3RrOUrAmcjDq0lK+eUT9bVhrL8uqHouI7L5AvFJTEwGcdSKARkT2IrL3v6/CywX9syD6hgfOr9ci+6woZSAZs4u2taIUgagjSIDsNZT5dW0zUrojkjKf3LUlpQhERHZqXhpEjkL7B8ih9ku0CMSYZ1g/UjwOpytGxSrFICokTwAaAI207aH2TqjMc7/50c+dK2178O67H2WgHZwTAOc5i1QKUpS1zZnrncS71HmYend9DPL2T2bMVUWttRfNPkVkF0xXg9gn9HW1ICVO4iVbzcIsDuLPQl9q/6PI4ZEDXxxElSuBUAnxnGaBOR2WBDEmmE0PcoBz93cJXaicJA5/FZDoIE+45cQ9mptPnpUaZyRkcyRP6qlGefdknWpcU1gFCBK5TZSuToivfCavLw+SyW1y94691zpAfug5G8gGsoFsIBvIBrKB/C8gAzg/BloDSBSH5Ro9OundmDv3k+dEINoUde4ekp2pps1UhXFidHPnfvKcaAG+ihTd28RlreLNqo+sKazIH2qIamHCf9LxLGporwPMl17WIv5sDCAHIY/RxddPOOqomBff5ggl12QzdgxD8qZlzUW1fRER2Ql5BNCM+zK+OZuuk6X6IWsZs/syAM5w7hp9WlRnDF6HPtdy+Ae9stlPJrGH/AAAAABJRU5ErkJggg==";
			$this->icon_code['yt'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAACW0lEQVRoge1Z0XGDMAz1CIzACIyQETJCR+gI3UCHnv3dERiBETpCRmAE+mGbCGrATlNwen53+rCNiZ4lZElRqqCgoGANrPWNgZGIaj9HxjQMjAC+TlQtDaw1MTAy87ufa9v2g4GxbduPE1VLAxFVDIwMDH6OgZ6BkYDLiaqlQ7rXS7qVh3SvpVsRUc1Ax8DgpCOiatprrTmujQ+FdK+lW/mxFGmtrIgodXevgKKDJ0bAZU/xHIiQV0JGq1TFTyci3GsWrV6OyJoShciZ+O9EbNQypnF3SlBxMqYBcM2XiNafy3uEgV6s3wLr+RFx0ayTF+YsUwYujszAzO9ZEPk3IKIqVY5X0qYX3eQGAb8+ROzvd8z8lkxi5YP9rQwbEkvqM5qET8v9x+jC6PEu4UBEtQwKrDXFbKr8CQG4HqBnNHwBx5j3C4IQF1S/XFszd4wSzwqxk8uLfkH4QW/CgPlyIBLd5Ih58BGlnmaRjYOe4VEiy7m1sXv/VEEq5b5LW6Tda3xjmqyJsK3nex8VlZpXmvLuyJqIv93luk8iAVxDNX6WREJj72pb738pIjHRsBA5ksimYq9IJAuLkDHNVneRiCqZMyklGuIuOX0KEWZ+cy/qkojs1OGhNd9mFdm2lB+5XhIRcVrD2jMhIsIKwTrcjyeltb7J29vt6QF8se3e1yu/bXsBMUXWdLp7GebBcIc8MDDspvFKzU53ZK3pzKJKKZeLWZcfotxKYlaR3WWrVL2L1reHJK4M7pMPloxp/qh2TxX7Z9KzXH3R1ql3xZjmh+zvO799VFBQkC++ATCevFWIX5AfAAAAAElFTkSuQmCC";
			$this->icon_code['ytwite'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAEDElEQVRoQ+2a+1XVQBDGv6kAqECpQKhAqECoQKlArUCoQKhAqACsQKxArUCoQKlgPL89uzmbzeM+kvvE/YeEbLLzzePb2Zlr2pJhW4JDzwOIu7+XdCLpaMWWu5d0Z2ZXXXK0WsTdDyTdSnq5YgDl8g+STs3sZ/mgASSC+CZpV9J3SZeS7s3s7ypAuTty4BHnkl5JQo7jEkwbkN/REjdm9m4Vwnet6e7Xkt5KejCz/XxeDYi7f5D0GUuYWW9cuDvmRUNXZsZ7yhb6ZWa45+gjW/fMzAAWRgmEoHod/fCuTwp3x1pfMLWZ7UUgf6JL1hYZE427Qz7Eb03ZJRCPi+5NionouwTfDsDjeyzwhGtOen9ecHFdFCYzq+RvBZJPmGCV5LM3cR7+W8WWu3/KqBvCuIiWg0wQ5LjtfhJIdw8KHxMIcfAjMgnfhmEOYRR3h2UA8hgFeyHpwszOS0HaBJugwHGBRG2moOe2CnJ3T/ES4kcS94Ft1hVICnqErYK8T9h1BYI7heCTVJHExgGJ7tXw2W0CQiqxk5glAnsys90cZEyJIIwaCy092Hsskqg5baxsZIGa3T2AJKOF5STBaGsBhIwAQaq0Jm5cUHDK1wB2zkYZqZm0Bsbj73pYZNIGNvbz0TfEsQWc9nv/gSRNuTsnxjcxf2L/SIPredN24iQ/tHFNzH01M5LSxhhkEXcnkMlucwDTesM88wDEsTYQST7mBhIZiJPjskAkuQGzXx4JhgDJ86l5tDvkncYhbQiQtLmFNLzDb1Pa3nhc7O6zgmrUDoYASUfgVQBp1A+GAElni0qbs2h5lrkt5qpqAhl7znewShrIF2kRLhxj46mQv9V9NpfgxU2hVVyRfItB/SyxE+xIAaShtKUAKYHl99n1QSqsZdUQ9gsSymq4O8kk+1UYZQ1hiGul6kqna00JhJoZFZbTrBqSzvgpcTyMGy90v7ZAar6NZvsUsJFAyiDP43IdXavPIpSO8lHtV5sGJMUhDMaomGtMIHntqhaAHUWGvL41KQ5C5aWrWNFWUB/CWmlnn4a12AcoxIUUvAhojgGw1n3GTCGXip0AqPYyZtqhrDo2kJRrdQKR9DEKgbC3ZkZRoQRC9Z55WIBrktFauh5B8Cx1y0bNtTYz+80rhlGrnENSC6FkykXeN1oU07YVOhs9sZDG85QfLRIA3wbEUdkrzBpMvY2e1HqjlxF6F/mI2iAv4nxentHx6VBom2EgbNmhxfL877qtWeTupDKs3d16i27EhxCID53NINTCp2YE8WhmtdZ5V3s6uRCaYYfFjKtsT7M5IgeWaHW5vh8MkErP6iqLtgrdr5OpfjBQxAQxQ0zUDjqLlrbl+6QtuHrVji7nPI8f1axA83MvuTUW+QfxxcBgugWIhAAAAABJRU5ErkJggg==";
			
			$this->icon_code['insta'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAABmJLR0QA/wD/AP+gvaeTAAANyUlEQVR4nO2dfZAcRfnHv0/v3W6ytzkLiPKPClJ4REV59Q0TUX+G+xER8C2opRIUjJVgLG639y5RYfiBlDs9s/l5miiKBSpqEcVChBCiIpDwJkJ8IWUlUTHl7w/5kVCa3OXlbnYe/9hJMtuZ2Zu93Z25l/1U3R/9TM/Tz85zPT3d/XQ30KFDhw4dOnTo0KH1UByFlEqlM4QQ72Lms4moD8ApAE4EkAPQHYcNDTAOYATASwB2A9gB4A9CiN/k8/md7S68bQ5RSr0JwJUAlgJ4ZbvKiZl/MPMGIvq+lPKP7SigpQ5hZrIsawmANQAuaKXuKchjzHyLlPIBIuJWKW2ZQyzLOg/AemZ+S6t0TgeY+UkAK4vF4rOt0Ne0QwzDmJPNZr9KRNcCSIVk2w9gC4BHmXk7M+9yXff/TzzxxJHly5ePN2tDK7n11lu7X3rppZwQ4hVE9FoiegOACwEsQrXNC6IC4OuZTGZo1apVh5spvymHlMvl0yuVygYA5wRcZgAbmfn2OXPm3NesoUljGMacXC53CTNfBeBiBD+7Z5l5abFY/Otky5m0Q5RSbwdwH6pfS36YiDYw881Syucmq38qUy6X3+i67peZ+SMBl/cCeJ+U8qnJ6J6UQ0zTvIiIfgagR7u0A8DnpJQPT0bvdEMp9R4A3wTQp10aJaIPFAqFXzaqs2GHlEqltwghHsLxzvhBNptdsXLlypFGdU5nyuXyXMdxhonoau3SASHE4nw+/3gj+hpyiNdmPIXa1xQDGJRSqkZ0zTRM0xwioltQ+0z3dHV1vfW66677W1Q9kR1iGMacnp6ex1HbgDMRfbZQKNwWVc9MRil1DYBbUftcf5fJZBZG/agRUQvLZrNfxfFfU4MdZxxDSvkdAKs18fmHDh36SlQdkWqIZVnnMfNT8PUzmPnHxWLx41ELmk0opb4P4JM+UUUI8eZ8Pr9tonsnrCHMTADWo7bTt4OIrmnY0llCNptdAWCXT5RyXffrUe4N61kfJZfLvQ+A1MRXSCnbPvI5Xdm4cePY4sWL/0hEV+LYW+jV/f39T27evLlupzFKG7LGnyCiu6SUD03S1llDsVh8BMDdfhkzf3Gi+7rqXbRt+yzXdf2jtuw4zk2TM3H6Ydv2q1zXXQvgIgBg5l8z89Dg4OCOiCpuAvAhHKsli5RSZ9YbwahbQ1zX/ZQm2jg0NLQ9ojHTGs8Zv0f1gc4DMI+ILhdCPGHb9qui6PDmTDZpYv2Z1jDRK2upP0FEd0QxZCbg1Qx9nA4ATmBmO6oeZv6eJloamNEj1CGlUukM1M707U+n07+IasgM4KKwC8zcH1VJV1fXvQBGfaJTyuXy6WH5Qx2SSqXerYm2TPch9BYSeYZwYGDgIICtfpnruu8Jyx/qEGZ+kyZ6NKoRMwFm/nWdyw82qO4RLa0/26PU+8o6w59g5sQbc6VUDzMvIqJ3AjgT1WHvV+DYTN4IgBdQ7ZQ9R0SPMPNWKeVosMZwmHmIiC4EcIJ2aa/ruvlGdAkhtruu69d9RljeUIcQ0WnMx2pmKpVKpCPIzGTb9kUArmLmy4hoTp3sJ3h/CwC8n5lXAziklLqHiO7I5/ObowYkDA4O7rBt+yxmtn1txibXdfODg4P/1+Bv2KmlTwvLGzqWpZTaA+CkI+nx8fH5a9as2duIIc2ilPoAgOsBnN0ildsA3Cil/HmL9EXCsqz5zPyiT7RHSvnyoLz1Xlnz/ImxsbH9rTAuCmvXrj3NcZz1ACJ/zUTkHAD3KKU2AVghpXy+xfoDSafT+w8frvkemheWt14/JO1PGIYx1qRdkVBKLXUcZxvCnbGLiNYB+JgQ4txUKnVSb29vure3Nz0+Pj5fCHEuEX0c1QHRv4To+G8A20zTDJoTbzkBX6eZsLx1h07ixjTNG1F9Rek4AH4MYN0EwQN7vb9tXn7Ytv0213VXAvgoan/vy4hog1LKkFLe2JIf0AIiT1C1G6XU14goyBn3M/MCKeWnJhPJkc/nn5RSfpKZXw/ggYAshlLqaw0b3CamhEO8mrFKE48S0TIp5SXNxDkdoVgs7pJSLgHwaQAHtMurlFI3NFtGK0jcIUqppQE145/MvLBQKOjjQE0jpbxdCLGQmV/QLhmWZX241eU1SqIOWbt27WkAvqOJ/8nM7ywWi79vV7neVOoi3SnMfJtS6jXtKjcKiTrE+7Tt9YlGmfniYrG4K+yeVuGVsQS1r6+XAVjX7rLrkZhDvE5fzactEa1sZ83Q8SLW9bbrYtu2L43LBp0ka8iXtPSmdrQZEyGl/C6AjX6Z67o3esEdsZOIQyzL6gdwrk/kMPO1SdgCAK7rDqC6pOAIZyulFidhSyIOYeZPa6IfteLTdrJ4c+R3aeJlCZgSv0PWrVuXA6C/o9fHbYeOEKKmMSeiyw3DyMZuR9wFjo6OLgTgH0LfNdm1FK1kYGDgCWb2B0XPzWazC+O2I3aHeJNL/vTmuG0Iwpsn0W25MG47kmhDztTSjyVgQyBCiK2aSLe1/TbEXSC01Uau6/45ARsC0W3xNjmIlSQcMt+fcBznHwnYEEiALfMDM7aRJByS2EzkRORyuX2aKHRmr10kPtrboZYkHFJTI9LpdOz/hWGMjIz0aqLYa28SDtnjT2QymVcnYEMg6XRat+XFwIxtJAmH6DFKCxKwIRBmfp0mij0WLQmH1KyNYObYe8N1qLEliWjNJHrqepxraJR5nDAzEVHN/IwQ4uG47YjdIcy8FcBBn+h027bfFrcdOkqpC5j5VJ/owMjISOyjCLE7REo5SkT3+mWu666I244AVmrpewzD0KNT2k5S/ZDbtfTHTNN8bSKWALAsawERTYnVYok4pFAoPAjgGZ+oi4gireNuB8xcRu0S8W35fP5XSdiSZE9dX83br5S6Km4jvP1JLvbLmPn6Vu6j2AiJOcRbEqCvUP2GbdtBu9O1hVKpdD4APYz0/mKxeF9cNugkPZa1AsC/felspVJ5II72xLbtPiHE/QDm+sT/chwnsWALIGGHSCmfZ+aaPVOI6GQAW0zTPDfktqYplUrnu667BdXlcEdh5qtXr17993aVG4WkawiKxeJPABh+GRGdTERblVKfaXV5SqlrhBCPQnMGEd1QLBbvDrktNhJ3CAB46zOGNfFcALcppTZ5a+abwrKsBaZpbgbwbdS+pgBguFAo/E+zZbSCKeEQAJBSfgFaTfHoF0JsV0r90LbtCxqJKGRmMk3zHaZp/oiZnyOi44LfiOgGr+wpQb1FnzWffVLKWEIrLcv6MDPfhmrgcxDPM/ODQoitruv+2XGc3UdmHdPp9Lx0On0qgAXe8ul+bTjEz7+Y+eq4XlNRn2e9GlKzptAwjHRYxlZSKBR+iurizKDVTgDwGiL6HDPfSUTPdHd37+np6Tnc09NzuLu7ew8z/46Z7wSwvI4z7ncc55y4nDE8PKyvKQzdEaPeGsP98C2L9mb2YlkW7a2OXWLb9qWu696A2jjgZniGmY24+xljY2P6rGjoTGQ9h+yDzyGZTOYkxOSQI+Tz+XuZ+Rde4PMyIrocxzfIE3EAwD1EdMdkNjZuEXr0yr8Dc6G+Q54HcHQ1UaVS6UMCM2i+iMLNhmFkvfDOC71N8vsAnIzjt9bYyczbhRAPj4yMPJbEqK0fIurz74qB6rMNpJ5DdgA4umuN9wASG1IAAO/BbsbxIZ9TGtd13+BPE1HojnT1GvU/aOnY41xnEO/yJ5hZf7ZHCXWIEOI3mmiRYRj1Nn7pEEC5XJ4Lba4+lUrpz/YooQ7xDsDyh1bmcrncJU1bOMtwHOdSAP51JrsHBgbCtvyo31Nn5g1aellT1s1CiGiZltZXatVQ1yEB05hLyuXyGydl2SzEtu2zoK00FkLcWe+eug7x9pf1R16Q67pfnrSFswzXda9H7fDUloGBgT/VuyfK3u+3aOmPeCfLdKiDUuq9AD7olzHzzRPdN+GAITOTUupxIvLHTu3MZrPnzbbTdKJSKpXmCSGeBeDfDnarlHLRRPdOWEO8nvJK1K7j7jt48GDn3JAQhBDrUeuMCjN/PtK9UTJ5W1DUhOkw8xWmaQ5FtnKWYJrmGgCf0MRro24ZEnmCKpPJDKE2lgpEdItlWZ+NqmOmo5RaTkR6O/H06OjohKciHCGyQ1atWnWYma9A7YgvMfO3lFKDUfXMVLya8U3UtssvAriikf0qG54FtCzrzcz8EI4/hvTuSqXymaGhodCh5ZmI14B/C4B+/NMBAO+VUj7RiL6G59QLhcLTRPRB1G4wDwAfSqVST9u2/V+N6pyuWJa12Pua0p0xAuCyRp0BNHf06ltRHY4PWjr8UwA3tevM8aTxDrq5Hlo/w+NF13UvGRwc/O1kdDcVuOBteHwXgPMDLjOATcz8va6urnu9UwKmLeVyeW6lUrkMwJWoDocEPbunUT2fa9IbNDcdSTI8PJw5dOjQV4joCwif8BpF9ciGR4QQ2x3H2dXd3f3Cvn37RuLaoDkqhmGke3t7c+Pj4ycLIfoAvB7V+YyFqB219eMA+N/R0dEvNvt7WhbaY5rm2UT0DQDvaJXOacJWIcS1+Xw+dNKpEVoea2VZVr93GtmEwwTTnC3MfHOxWGzpdHLbgt+UUmeiegDWUgCntKucmNlNRHcx8w/adVZ8LNGI3inT70b12Ik+AKeieuBWDtqm/1OAMVQ/W/cC2A1gJxFtE0I8XG+mr0OHDh06dOjQocNU5j/+OftFWgG7WwAAAABJRU5ErkJggg==";
			

			$this->icon_code['fbGrey'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAACR0lEQVRoge2aW7HjMAyGDaEQAuFACIRCKIQiyP8zKIRAKIRAMIRACITsQ6XWpxtvLDcXdyea8Us0sfTZ8lV2LiIkawA3AB7AAGDcqQziQ0vyHPN3CuAHwH1Hx+eKJ1nNQVzwan0P4EayJvmT3BILC8mK5LlpGgLoFYjkNfbDNaBuSZ429jlJ8Aj3aRiSlfaEKQ53Ehm/CvOKFgCdKG47+meSoGd655xzJM/6odRwiomOGZIXB6D9tt5QkQlgBHB3Mjt9xdh4lyCahrB7qr0dswrJUwgyAhg3dqCWsOjw2jn0eCzELclr6tr19H9LEGlBy66hLw5Etj66MnttdZInKRXJsyzMbapfm4MEPdGlTPNFgkhvjACG1LWqSBCd75umYeo/RYJoWE2tVSRPAjp57kmoe1OQ6FqFYDc7VRLqLgZEdXXOXm9rkKiNT+0fIFYDc/H+r/ERC8dvBBlS7awOkvNvcJT1yXYKBdGLkDbZTokgMJxaSweJ7gSidkoe7Cmn1m8AmZ2xwv+PBTHLmFFnqvsAyTFm1JnqPkByjBl1proPkBxjRp2p7gMkx5hRZ6r7fwLR3GGV7WmqMaNuToK0wrhJomdFED1J9s9DjOU60yorguhJ8v4rGfqZu3FZA0TCqvsVTRpeWCkhugZIkAj1zxtKeTAwCt3izzWWBpGxMeCRpqjfleETjkV7ZikQCaebzrTRcf0G45um4V/EGfIJiKTlavFNh8Agqbv4pbdkl3wAVFrxpvCXJ08tgqdFOxVNXXckL7Fe+AOgcvGIBS3Y9AAAAABJRU5ErkJggg==";
			$this->icon_code['googleGrey'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAC0UlEQVRoge2aUXHDMAyGAyEQCiEQAqEQCmEI8v8MCiEQCiEQAiEQDCF7qJyqnp3YbeK6d9OdXjZn1mfJkmyvqgJCsu26jgBGAEZ0/oAaADcAV5KnkL0+gEY+/ITRMTpsApFs8Vh5I6vQkKxJ1tGrsaPI3GeJjgWI5Dn0wUVB9J8yfEsA9EEYkicFcf2QjdGivfMUZoqyeAgrah8PVVUtm3sGYEoNJ5+QrAFMi1eUm77GG1YAXO2eXlwUzAIFi4qmqbLu+XI1VQFG7KILyKfD5FX5BylN/kFKk7dApCNtcW9tts4rw5E16mUQARgBjF3XkeQZjwprdSLZih7a9rwEQvJHVn50DVRV1urtGNOfJRlEt/ok28CYi4bJ0fYkg0AdaDbGTTm98gqIiQTR+8XsZ3JwvngQN/7XNrBs/jl2gd6VVJCTA3JZGauhp90td+St0ALQh8Y5INGHNSfjRXvyrc0uXmkCIDa0TMqFWjYQfUa2YeOpJTWk0qem3mwgYuhJDF2ykq3ucvafBNDrrWJAFJBtSwZRHXJtKoQ2KCuIllfSrWt0rGYF6bqO3wpSeyZdTbtFgciZpBGP9J6Jx2JBSJ48jz8j7pd8vjeVIMwWXOp3sS1KjXuWMnik3D8pVqr66BgV7AKyg6jQiSp0eE7JUR3w4SD6sBSTkdQEi2diCuThIHp1U9oOvQAxRTIHyJxikBXdBSe9xiZKCsjSvqeEliqUhx53NYi9UPCe+hDZvmuRLDdIckhuIFNEg4xrYSNGGQfmJ/SHZXwfm+HeERW+o74sCLYVnvbd6g3AVYqk7YYNYh71d5CnZ0P9GLr1oWrfXSgDYAgVyiPEeQxtq6p6SrFZbgf3EBVJw/JDfUuyFv+liFzdzrIPW/eXrQqVIp+qVc9nF/0SGqhhZtz/qabNau1fm2qSjboTsJ64bH3o62BL0iEpoYh3fBkqt9ozT78G8AvHo7QilxfYbgAAAABJRU5ErkJggg==";
			$this->icon_code['instaGrey'] = "data:image/png;base64,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";
			$this->icon_code['tmblrGrey'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAACpUlEQVRoge1aYdGDMAythElAAhKQMAlImALec4AEJEwCEpCABCTw/Vg6OmjG1pYPdkfuerdbIc1r0tc2wRhFSBYAagAdgAHAuFMbxIaG5FWz1wcgB3Df0fC11pHM1kCUmGa/A1CTLEjmH89EYiGZkbxWVUUAvQVE8qa9cHNQNyQv/2zzR4JHuPvBkMysJ76Kw51E1q8FM0ULgFY66h3t+0ocz/TGGGNIXu0fRw0nTeyaIVkaAM2vecOKEMAI4G6EnZKsDSGMxZ6jMkz8eDaaBtc9Waxilx5nbUhg90JIXlwgI4AxqVJHUunX5Kk/IZBcdLXegTaS5EAsaVRVRe9AG0lSIOKNAcAwX2s/A8Q9Ffgo/CeAiCc60dG8HWgjiQYyPylrpwKFjpPtMcFAZl4YAbTv9qDZs8n3mGAgmDa9gWSZxIgUOgKA2JCIPmAeAkjM4Cl1nUCUBdu+eX4tkbHPYnfuAC9tbSANBJT9Z3MgqqLA/lg5gaiKAvtj5QSiKgrsj5UTiKoosD9WTiCqosD+WDmBeBTZLL52Q7SZzNLXbytjJIvA8ZMBsYZ6i0FyJR7xuIjdpHBkCzfu7THo8JgSSC1A1Ls3pkS5rw0xNiQD4sz4feW5qwBq8Tja1yRzJ9W6O5CnIaGJ8EMAEWXNJ15ZNSbmXYd1shBFxjy9MgDL3O/KewWmG2QfOO4TSJJCj5ONH/FI2JV2ckhepMyca4wVklpyiqK9mkWPANO/YagFYwklB6WWnJL6/aUYGgvEGaAUdrKgBvndAbhXVcXYjxAkrNqXaHLc/DMFUScJMuWdpTRgKXS3zzU+FVkbth5TzDvdTzgO6RkJp3qVIWdgOonl4l+tXdp0kfPZzVkC6yThKRscrXVfhb8wT4Pv6HSLZhmvlb3J64U/meEyK0yDZ7YAAAAASUVORK5CYII=";


			$this->icon_code['facebook'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAC10lEQVRoQ+1ai3HTQBTc7QAqgFQQqADoAFcAHZBUAFRAUgGkApIKCBUkqYCkA6hgmVXuPGf7ZF0snyTP6GY8ceyT7+17+z7Se0TLkvQBwFsAr8KrbesQn98C8OuS5FXuQK5/KOk9gG8AXg4h4Q5n3AM4JXmZXrsCRJIBnIQNDwDOAFyTtDZGW5LMCrPDsr0IgpyRPI1CLYFIstCfwhdG7P8ntyQZjBXudU6yUXwDJNDpZ/jy9dgW6NJesNBN2LcwzSKQP8EnJmuJjC9Hy9yTPKKkjwC+A3ggOVUHzxpJkh3fPrMwkB8AHGoPxhoRVeIvFwZirjkqTN43MvSy3Jb/1kDUeD25kVO6nG4K3y/lHwNIqBqceK3R1C+vAZj3zlu/S6LnKEBC2HSYLw0qTUTaZvnBgQQQvwA8s7YBOMi4dvqbOK+zt0H6rwNQJ+XHABKDygVJh/ytq5TygwJJKofiXDVVIE/OVVMF4mj0BsA7kn6/XJLsM58BOIptBIGutDA0tVpzVVJZZH3mkIA0IHPW6goIoXJ/VFIpF0t+tG3PtjP6nj8lavUqkaoDiQekVsrxPbdvzbLP06SZKRzrUmtfQEZ39j7cl+QSxeWMC0e/b12DUatLozkJJX0JuaWznJk6kFgJfCVpUAdrkdZK4FCd/Yikb7TGt0iP8PuPpOuwrau6j6Snz5m9yxyPT0nrJsTZIgVWyCqpTwYuPXP2kQJNzT5SoKSNLTO1CrQ2U6tASTO1eilJkh/hH9ds9NRy9qQpejdI660ikNgQbVpvflTpnkVnL2IX0/uaikBiN3oR29OxO1qlIVoDSNIIbZ7wDzIwsG8grQMDwfzpCMcJyfNdqdR6X51puD61aJXkMZM4XrI6whEPXptHMd18QVFTsui+ekcgwQJuS9i5Y+thCcJnt405GUCcwtmXYfb1O55aMmPax5zWblgczWIL2XlmzHWXDJ6tAIhC/QfJdOM+5ZDCYAAAAABJRU5ErkJggg==";

			$this->icon_code['bookmark'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAsklEQVRoge3SQQ2EMBSEYSQgAQlIWAkrAQk4mHGAhEpAQiWsBCQgoVzKbTchWWja5J/kHd8kXzJdRxqPpFVSevhiCcjTiCQpAQECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAiQApDd9mx7bhkSbQ/nn+1eUmgJEm2/fv3bHiV9aoacM+qv9OS5bTVBdknLVcCXvqUGSLQ9/tuZ5xZKQ0IGTHd3237nua13d5PSOQCM9+k3XpfMzwAAAABJRU5ErkJggg==";

			$this->icon_code['pencil'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAzUlEQVRYhe3XQQ3EIBCFYSQgoRIqAQlIqAQkrJNKqAQkIKESkPD30EeW7GmzCdPDwo2ZwzcMNJk6908L8E/BATi5VwFWK9gDB1CBHYhABqolXnTypPiq/bjr+MC9rgAgqROnBQ4QungrogJxNF500toenHIZyBa4V6wVEbrcYoJ3ub37/Mxx/+TJJz7xofjybW7iE5/4LwU8irepBWGbGS5oF5SEHZa4555eNu1f6kQejguMAiPvEQoTXAU0EHUiqxib36mu3ckMncs5dwGuKAAfRodhggAAAABJRU5ErkJggg==";

			$this->icon_code['house'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAABo0lEQVRoge3YW7GDMBAG4EhAQiVUAhKOhEqoguzvoBIqAQlIQAISKoHzcLKdPQtluGQT6OSfyUNLN+zXCyR1zjAAKiJqiKixPI9pBGIIo83d0+ooxCuMc2EC4skIAFcAl9NhFKLm5wFcT4NRiB99PGA+/mbEsX8jTfch3nvMITgK85DHskMA3JcgxOvrKYxuPClkLULUvTHeezjnHBE9skAU4rah/o0BcHfu73fGx5NABGLYghDz1J/mMYcExGsvQsw3iTGFALgxgr/bkeYdfcJE1JpAJEJfOiPNP4mJfZLaEsER96NBrgyiRC0vzBAcvgxHxaRGcMRyZz9GIwBUcdpcFlKr6E2TKMQzNYKzCxMQfW4Eh8QmbTEmbIIY0eZGcPiesgijEMNREBzuaxYTtqideHHaDc2CyN6IqB+90QrRnQDSjTDqH48uPD40RL/xACp5eesBXGRB5r5HkX0pTMNrm5YRuuBI0X0FTEtiMzZbsOYka8ceSPyCb4Qc6RwFUiBWNQVSIEY1BVIgRjUFUiBGNQVSIEY1BVIgRjVccNTx1ZBfD33aUxRDP6EAAAAASUVORK5CYII=";

			$this->icon_code['share'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADQAAAA0CAYAAADFeBvrAAAB9ElEQVRogd2aYbGDMBCEI+FJqAQkVEIlVAIKsuugEpCABCQgAQlI4P14SR/TKYHA5Y52Z+5vyddkjtsszp1UJK8AHgB6AGOoHkBD8ma9vs0iWQFoAUwr1ZO8WK83KZL3sBNrMM8iWVuv+61I1jkgp4YiecndmTdQlTXHUwC6IzChBmsO55xzJG8CMHGX7tY8DkAjBQSgteZx+Hu3SAGN1jwOwPA1QGEaONTdXssS5CENA+1OVxAklk5TUACZAEzFh1YtkFA9yZ9vAJkAjCSvWxcV/cgAoPXec2lrDUAmAJP3nimQrX6ki35EECT3JTuSrBeP2h4/EuCPgnRxWg5/aLcFPjlhH/EjEiBv1nPz3nMGF499R/KebAASfkQKRESQ8SP2IM7J+hFTkCjI+hE7kBmQpB+xA5kBDZIw5pcVEO5u5pd/hY5cawaGsk1BH0ypbeuCocyxswMLo48GkB6Y0XC6CEbyOhtOoyfLy4d2QMWHiIGJ50PhB7cs8tXDNAJgHUrlQ8HsNfifJMbwwMfSpbggWFYVz4cswFRGLmUwvVtTLTD1fEgBzCYfKghmHqdUkLUvpwi8Pj8fegGSHIztk3B8W2gsHOuf46MmoWNXLh/KlYAfW8+HtHXEjyXzIUvt8WPJfOgMyvBj6XzobFrwYwNW8qFfNS8Z82QNeIIAAAAASUVORK5CYII=";

			$this->icon_code['google'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAEFElEQVRoQ+2a8VEVQQzGkwqUCoQKhArUCpQKhAqECoQK1AqECsQKlArUCsQKhAri/J7Jzd6+23t3B3dv/yAzzGOYPV6+TfbLl+ypFMzM9kXkrYjw+bK0bqG/fxeRnyJyqap8rpnmf3EAHypwvrRHgDrNAbWAmNkbEfksIk9F5E5ELkTkSlV5eGtmZmQEvh2JyBMRuRWRY1W9CqcaIGbGIkBglyJyoqo8UI2ZGRv80VMevw4DzAqIme2KyA+PBEiJRLWWbDobfaCqNwHkm58JDhORqd7MjLR67al/qB6N334mdmtLp9KOeprd+JnZAwg5905EPqnqSfWhSBxs+W5mMNILEXm1bXYau4nOZhyLayLy1w/52P9T0/pbgFhNHk31pQGiqmtVfuo/XfK5CMQjkCV3ve+7HiNSSyTCj3tHxMyQB8gZdBo9S8muReRsrho1GYgXIVQyMh9VgExIJTaAaH5OkdulRuihIjsJSKI6r1W11TV6Q4ZKoF/ALlT1+KEc7tFcqzo4mH4TcclznXLGzNBqdJdhs8ue0RFJZLP0FU8zI9WeOZKvqkrazWZTgDRSZgOQUNM4f6Oqe7Oh+N8UDk+tRGWGTzulvsX7/i+xcG7pc18gTa+c73YGeo0UHjo6o4Dw5ZlKLrbEGZBzVT0b4nyuwodGcgoQBhIM7MJo+teGZQlFU2cGt85LAmEUEz1yFD3otRkZeR/NNGaHYcaYYrgYEE8v5AjTi+ceFkCshnhJdf/D74xohqRUrFkUSPKl1AYqOxqLSAUwlnSm3CZQWwGSOjWFbqe2110EMPqwl3Y0G7WyjAEzRbFotQLh3MBeIRYB0CsYqwNiZszDMCKQ9ySAa7Fa6WBvOj99KmFSarkCppZw2HEchgp2ir4kjUwRTIciaI2l5iyI7+n03IFzT58WxXpPAh2nLDaoui/CWmZGRxhT+l569aJIg9XUGlWlQPba7EAyVho06HYwpFX0JXubCuQSQLhygJmwwR1ftgEbi+QSQNJDOAYIlZ9J+Z2qUv1nscGsZWboqWCiQQcXj5P+fdZbsBTIytES3ZlZKt9ZS1Q677qTOkEEiAZt7mApPzZkfha5FrljitJ70ZNdcfFdgIGG2em1W19vrJikAGKUlJ8AJNJ3ddGz8erN6wPropIHICITd/AUyJg6LnK9nV+94QDNELsLTRbv1n23qSc8kxY9KnyA4gWDUb3I2Ej4GSR9YVQ+D+J6OtJrkengFMc7JE0U6dWAI31hIBQsA2ckSLVmZiGXmAvsNy8MeKgQgjGPgqnoK2p8hQMiCbnUfoUjoU3AACJeXIl+/Ne2QDlrch5j4h8v/Bx1vlSTgIF5AJAyVE1pxn0LIFqEUrzJdcoNhoKl0j5jSWCcA84vP5BRZzH+B8zg25A0mqpxAAAAAElFTkSuQmCC";

			$this->icon_code['twitter'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADwklEQVRoge1ZwZXiMAxNCZRACXSwOUa+QAdDB0sH0MHQAdx4lg+hA6YDpoPvsAUMHbAH24lDEkiIA3Pgv8clJLa+LMtfchS98cYbbwyNZIexUKepUNlSqGwpOPtL/O/Pq+1qjURmH4L1UbC+NPx+hMqWcYrRrTGI9YEkZtU/FWKSOr01QB8IxoSkhjOYGGfB2AuJlZBYEWMtJL5LhBhz932cYpTI7KM0hsS2MpH3wjE0GZKYGcP0RTB0rSctkh3GJLEtCGWb5hXEpG4i/6VgZARj4kjUerCJkEJsVq2wixhfnkP2lY+cB0hi6y1vEDJupbuQcBCMiZBYkcQs2WFsV8eGVfYpWB+J9aEyWaIQxylGPpnK8nUxRGLlPPnoGFFk9gexPjSEl/aYm4duBeIUI8HY1226LvAd1IeIZ8vlKtTOJUe7PyqGMNbFR/qQ7DDuMPmk4rEHQRIzktiSwsKtsh17fm3wuTYLRGbTCYb2s0gbQl5YrfsSycfk7G8jCfOCWbqmtGhitFidnNCNkMk9J7EKQaI8f0Ook8KiMaV5qOZ4fSGpQTL7FOo09bNcaCJuvpv7zXr8LFhf2oRNssOYGOvrPO+Sg5EP9oANTOT+i8UmOnaZwB5c1/LCW7Hu50etfW2IkMw+SerUj/9HJzSaDTOnofqcQz5aEWlQocE116Mw51qbFbGxXtE2N8TdM2GOgBYKwYqxi2DMjdzGjBQWzzHzPoxd97Oqt9HvvPgi5KL2nnONsrR5uoMMeRaKWqlF4shZ+7L4F8BpNmKcW31gFa/um35Dw6mOTueRYEyKzJVtfkP69Qqzbhm0TMZ0NF61b4oS/IFSwGj/olPhFTHB5HhrW2xV+NBRUCjh1xLxDsHzQyHuywFSWLg6fgBbb0K4FlAf9Vx0VTReQqI4oHWv+f1OCrE+PJNMUev3b1rkA3rZq1dbqC1sWB9D1jFRFFnp4hVMxPog1Gk6FKm8JpL4HiQKbJO5UtaGlPmui1jpVQ2BauMhDJGnkRDqNC23LKFDbES/FToICXebZGv58p2GxCpE/NrsdAxCwm4u074xnvmpr9+hQxGIoigyV212bInv3lquqYVjnmNPCouQgrFy48RYB3GOPfhKGYmkToU6TQPYHUWRC9NseUXgK8hhd4363q7+EZxtEpl9dPWaYEyEypbVOw3oR68oOsFWifOGkHOt0DS/Ui6uljelNmlNt3GQFWiDZIexkfTYl68VWvwkvomxJonZb6gyS0h2GCcKsb0vmectUdMWndvng+uxN954Iv4DKKJzVaBVE9gAAAAASUVORK5CYII=";
			$this->icon_code['tw-footer'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADKUlEQVRoge2Z0XWrMAyGOwIjMAIbXDZoNkg2aDYIGzQbwAbJBnSDZIOyQbPBdx8s1wKcYMAhfeA/h4emtqRfkmUh3t5WrFix4tkAUuAdOMjzAfx7tV3BALbAhfv4EWLJgIwa2Pj+mQOnRwJmEsiAb2XwDTgDhTxH4NohtFP7EyGgZVQ+RXbBJTYZYCOGATReT7q1KVApY8sHEcx8ijSikZFIWBLViH25RE3jS8k6+zZZD1QqvFHIqEgHk1B7M0zabSRSpSL1KTbWPmU5Jhc1meyBriFDCuvJqTJEToI53D40eqFFojae5bfWoRtpwK+DZhI548et5Wj7q0fAUW2qgXSE8qznselENpi036so03Mw7lD10giTbo3aXIYQUgqPc4komR93ScgCGzpvWZRU09GxhPIAIkUkElp/n4Qs2suCfklrr+vWeDDn4BPTbiRqbWwiFvmjRYlKrzRAaCoe6tZ5MMWhxh30qERCFloPXkYqyOm3FxrVVOM7eoaJSGqclPJyhsIcU2VsDzX5HurIDSLiQ/Seayok9YOI2Fzv5vzd5m5JSJRhqEPANGMAO8xFtgH2y5g5DLELBqqqPuiPF74IuJL/2LmYcmqRLmNeOHClfLhwKNb14OIFgevZbqEbElxPNbn8xgau66jGbMpU5Sr/QvlVaTWugnbI2IlG+hwzB22xr+DN1M3WCxrR2vERttRB1erO5r2HxOJEcJfgbVKKo9oBIZW/4qzgRkDFHCG2FH+/iIS9oJtZ+mlPUuolyeDuDZg5tNACbfWaNRYaoTNRKVXFFJzSfmGqMa+0TyGFeye6PiULJGd9r7XR2nzcFLE9q3oG6A8eohBZjISkU60INDEOIu1RaHwSuK9Jn/S/aRQx8leKySUKCTlcdnxT40b2XTSxCIjeg5J9ZW4vx/0RzhUzfdzPVtLWt+1E+BjFOZKj3Yp0At4j2G11pBIBTeCLGJedR5lvtvuDqSbbsV7D5P+B/jeNhomfKEZBCO3upJw9SyfcJ2X7lLTHpF1UT4lAIKkUc0bOtD8rhOCKifCGP/CW2YIQy+XZ4Uaihfyds0A/tmLFgvgPcxT6AgmLZxoAAAAASUVORK5CYII=";

			$this->icon_code['linkedin'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADv0lEQVRoQ+1a7VEbMRTcrSDpIFBBoIKQCoIrSKggUEGggkAFgQogFYRUELuCQAUJFbzMnp8uurNOJxv7Ds9YM/6B0fm02vf2fUhExzCzjwCOABz4p2vqEN9PAehzT/Im9UK2vzSzYwBfAewNscIV3vEA4IzkXfxsA4iZCcCpT5gBuPZd0G6MNsxMViHr+ATgrS/kkuRZWFQNxMwuAXwG8ATgnKT+fnHDzLTR5wBeAbgiWW18BcTN6dZBHJEclYG+3XOGfvm8icwsAPntPiHbe5FMJHxZTMgVHkju08xkd98AzEjKFrdmmJksRz4zERA5tKR2a9gIO+3+IlZuBES2JiYOu3zDY4qoDIxpJ6QaSU0fitLIV6YCYpXXkwsxxYVAZifzS41rkidDLTz1nnr9OSARdZJkMRKCkIKmREESeEJS5jnKKAUSzK6SuHilkUhMSR6OgmIeOuYW1cNIp9mZ2WsAf3JmOQS4UiB/3Xz2SSrHqYeZKRdT/HkiKVCjjFIgQZrvSE5aQJQJyFduSHaJwcbBlQLRrktq5dRiJHZ2/U8icNBma+Orb1pGv4+4/Cp2CMCb1gIfxcjYeVkRIy1TUhqtj4aUqqFiQ7LQWlc/I1HUz62z8p8l52pDPkQVqH5fwiIz1gZ9LzXXIkbCpL7dVlZQOtcXKpHIDYFSCnTR9+6lgGTSlzrOFKQ61VwfEgllBmKzqn08LokpgVQSW5kwgPckBSw5xgSiElrFW25xEph7V8sF6V/FR/oSymUYCVVnFkRYpAfcIP2d+dzgjPTZeur/UT5XVYEdc4pUa22MRDv9xcsCBVQFWWUPaiIkTc3MNEcxbCFxdd8aHkhGojud2szUMRH4umMyto+EZkGdEbgfKG6o7r4gqUU3hplJyX4A+EkyBOR6zuA+ErHRcNyoFZWsa6JyIeknYwDJ1TbFvphgbFgfWbWAazh0oq+wYySpGFGuVZLOdJpHdyen3yzXRXlprpUCupZnd0DiVszOtObesjOtdTTo2ju5ll3dqdYzWqY7RnJpxjNNKxxfLRz0lHZGlumi5AJiXxXZfjY66Jllj97MTA2Adz0vUA/qeJm5iRSl+D2tFCnUONXRWzgMHfWco4+Njnr9//mNO22oi7fmQDQ6TXskude+MKAGgBpi23lhwFkJVzgERlc4rlahe9PPmJmumYRLDc0rHFGrJoDRV2JFrRoV/aMy5Ook0ZE/hyPyRlel65qTALXPQza92aW/ry7MafaaU0vahD5cPAtXi0pftu556heHi2fJo/B/rbIkXGKb1eoAAAAASUVORK5CYII=";

			$this->icon_code['instagram'] = "data:image/png;base64,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";

			$this->icon_code['tumbler'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADeUlEQVRoQ+2ajXHTQBCF91UAVACpAKgAOgBXQFIBSQWECkgqIKkgSQWECnAqIKmApIJlPs2d5uScrL8jthndjMdjSzrtu919tz8naxnu/snM3pvZm/Bpu/Up/l+aGZ9LSVe5F2r1T3f/aGbfzOzVU0g44h23ZnYk6TJ9tgHE3QFwGG64M7MTM7uWxGpsbLg7VoF1INvLIMiJpKMoVA3E3RH6c7gAYn5v3XB3wLDgjFNJ1cJXQII5XYSLbzetga7VCxr6Fe5bYGYRyO/gE1uriYwvR83cStqTu++b2Xczu5O0rQ6eVZK74/j4zAIgZ2YG1e6MNiKqxF/OAYKtwQqTfcPdj83sS2b5aqfssv8h1xNfWQLEK6+XHu0pQyYNpPHHzJ7nnisxf27eWv5SQNwdAAB5kFSDKTV/26L+CyBEBFD4T0lsXtXYRSBZ0tgpIInTPbAfSbrfOY0E34D52IO+SoK56rETGnF3hMcvoO8bSXw3xtYDCfkKgSUMdUN0mprUqmmtofIzSQdDqf6R6Q5dseAPRJ+RmUh09nMgAmtdm9m7dYJO2WNG06+7xwCTfOVYEmw1agxdxKIbYomXl2S0KRopGdJMnmsGEldgxV6pbixabPhHQgxZX9qUs6e5fS1YmzAtwFNA55JI7kaN0aY1dMMrSQ5FWWsGUiBxmzXSx/u6fKDrep93rLtndvbZ2WdnX+9Fs4+M8BF6K6+r+uxKcyYkXiRotDMIVRrNmz6MVlIjUdBsyTWpz1JZoYJO4Zlcn/yeWlgsnN9LetFH+PSekkBYxQ9mdtCWLSaF8pycZJpVF2pMFFwSSOxTXElihbMjNJOiBtAKH8L/5ZRNsySQWPMFwJ4kBBw0tgJIcNhYLm1NsHqFGSP2mmIaCUBwWJz+mZn1rlO5O4xFP4XvRhW/r0pTIGtZZ8CECIPjAwbzonRK9bFubbs79S1MkXvjYQReQc2Y2tgg+k1qzjdFW29hYoSJvfCudYCxMEt65nXhu+uheH219Rb7GlV3tO8kHTZPDs68rDoaioPSKtqKxzEmHURIioWL2J6O3dGdaYgm2qi60f/XgYHAPGmZ51DSaQkzKz2HuxOXxeMlzSMcifOkYDA3ftMTnGTLU8EEEoHxiCJibNZoebcdcwJAX+aZKufQ52E6LKb9mFM6YxIbEaUShm9ywHaR6bJ7zV8Cie0+55PMmQAAAABJRU5ErkJggg==";
			
			$this->icon_code['ctumbler'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASnSURBVGhD7ZpdiFRlHMbX7EOLSsM0+oKSboQu+kAv0pssiCToZqKPoWU/ZmdmZYN1g71c0AhSU4MKhFgiMmiJosWCitgoCCnXC0EIIUglQkIrNstSzN/z+pzpzDi7zpw5uGdgHnj2PfN/3/9z/s+c93zMe7arHoaHhxf39/c/NzAwMFEoFA7DU2z/Nx9k38fhAba3FYvF1S7x0iAhT+KRuFiWSG2TcKXLvRi5XG4hA9+IJezjqBTgXUNDQ9d42GVHd3f3EmpZQ00v0550fSfYfsRDqkFnMMGAGfi0w5mCTe1xnafgGnddAHPvmVjn/Q5nFtT4quqFx5gtN4QgLhfRcVQdMhSCGYdOA2qe8pe/OQT5kHfg2xBoE5RKpfuo+xx167y5SkYmbKTfY1qCDnW5XF4aUZdyd6UO6t6v2uF6zbfD+sBO73Z/YqC118JxniVe9pBUgfYr2gf6I9p5uNm1eonl/LotVvhJ8w/HvvawVIH+C9bfIVfhm3NfYnC/WScdxD9zSDu617FvHEoV6Jat/2ZqRhAbtuhWh9rSyALEDkmHKfaoY+1nhPyNFjzExwUXom1mhNy1CP1Few4+5nBA2xhBYAOcsdhOhysgFhn5Xpf3Wvb09NzsoYmAbmtG/PD2Onk6ChIaHxsbu8LdFRAPRuag7syDHt40yE1uhKQi/NV5/8BNhCvnRRz5fP46xk7BH2tJ3s/SYHvKw5sGucmM9Pb2Xk/Sv875lCvUKnc1DfLXSge9xOdPYiOMu9OJRxxKDHQ6RiKkYeQXHkkeEP04fa2HXASm463R2DiZln3WuvxG+vr6borG1/BLD6mCTLCT03XGV0j/Xg9vGomNCCS9yPjv4H62D1qo7lQjHt1HdK/Rb4dafsWRaXyJpwboJjcSB3lznjMxI9m+s5PXMZIGOkZqQV7HSBroGKkFeR0jaSA1Izwz3T6XEe7a97j/B4dSRWpGtBxqoRmHqqBfjfQf0xhMr3O4Aow+RN/H8Ce2K6svjSI1IwK5vymfp+DlDlWBnYx4H3/Ct+Eu+AEMBmP80CkNI1UjiHxujScdqoXWvLbCM9G+IhLT+8n3vN30UzA5qRqJVhj3OFQXOp8Y86x3/oTOH8XZjn5gza+RwcHBWxA6A0/D2V9SzoLMGBEQ2m6dL3K53NUONwSOzPMupjUj/DmuD+Vyean7m4Ze7qATXt/RTl5KS2aZag8z9iNyorWxyuJ3oyBv1LlbZGTaH6rfkDYJvtlV6ERXot/Re4t2IwU/xXa3tml10n8Cw+qkyLZenY1yqb7SUg2D3HFrFOVqm0Vfcn9i8Jt+BTrvwLPWnI1aYZyG+tl8o9ObgoyTH2YT7UoZedDiJ1qZXnGgcwdHAv3Ca+i+S7ubdgfcxJF7nHaZhyYGGiUoE9MOhUM06aAuoXWXP7MELYBTa1i2pd3gcKUj/HsE7Xa9x3ZX5uBaw0sl+L7D/0NXETr+tpkpLby5KxPQOUFtJWqLjsQ+2voLg8zf1XSGVXKoy6LWnvQKeAjOF0YpehyGE9uc0Eq/y64Pr7hvgdF/4mSG1HRAFwuX2hh8KNeTPAJ3wt3zxM1Q72TmePzp6joPcBf8FcL1MYgAAAAASUVORK5CYII=";

			$this->icon_code['shareIcon'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAD00lEQVRoQ9Wa7VEbMRCGtWqAdABUAFQQU0GggpAKMA3oVmogTgWBCkIqiKkgUEGcDpIGtJnVSDdC0X355LvDM/4D5qzn9ut9lwOxsJdS6iMArIQQ5/7NJ3zmNxE9GmO+544MS+FAxCsi+iyEOOk40w4A7hDxMf7cIkCqqmKANR+MiH5LKTdCiC0iciQEInJ0VtbaNQAce4CN1vouwMwOopTaAMAtH8jfaYZofCHi2keOob8YY9wNmBXEp9M3D3ERItCV7hwhIvrp/+6a02xWkKqqfnFN9IlEChdFZqe1Pp0NBBFviOgr14QxpqvAs0FSSnHhHwPA9WwgSql7AOBWyx2otS6aUi1EhYgeZgOpqopz/BwAetdGJr1CrTzPCUJ8MK31qDNUVeWuM+oiXd0l93s/uTEMPgA4RcTdPtfiv5kcJAWoB1mB1CKil4NHJAXwkxuttStf7J8Q8X6fiExS7E0A4dCh/bIY1Fpf7AMSzaHy7bcLID5wNAcGt+AoGm4ONaZWg5zmotwS0dYY85AcimdCXcQhhdrS5qASZaicttYeDQVIboAbjDlF29D1bgHADdBG0dhDTrOUCHL6LP6iPhGIP4+IJ0RUCSFukgPviAillC+xjLfWvgcAVrpOzsQQr+bISDn9ZIxhV9f5ygGwxJBSbq21GPmN7LX8DVtnjVXJXG3RRf9FwANgPBC5m3Fr5sgHKJ4T3N2klI8pQD2P/HQsJqczeqgXQGcoOz4AheT0MwCcAUA93FpS6FUExgLUESktp6WUmBZxLoVKAdQgheX0HyHEu3DxKQBikKJymoj+CiE2Usr7Map2aMQgyOBSvsAfgIecnhREKRUKdYxTWxHRD44GABxFd3MyIDhEsfvBFmQHcx0ciNsvryp5t+TWKkNzM5lDbsfEP+P2OyWQU78l5XRuIE4B5EBGSBRXG060AdTRyEW1b4S8fbjym/iw7+q/jY9FIxGtjTFf2tJMKVXLafYoWuvLPmnZBMQeJ7YDLdfq3sbHMFwzRMTz4CmS05z3H2I5HX2hk9+p4WoTkZmUC9t4Nmi8jXfblb228Zxm1lrekIf1fauc5kmeyO9BQKFrcutmedO1dRy8jfdALldZEDINewG+U+wdUgvr5XfsJzqBQm16iNWitvFDgN7ENr4LqJB9mG4b3wQkhLh8k9v4DJBrIm92G58ClVLdB9/9Ns2R0vZhNpBC9sH9o2eSbXxTRErbh9kiUto+zAZS2j7MCjLCPizrgQEflfoRjqH2YTGPcIRG0MM+nPfexvcxRYf8zFD7sMjHnOIb1GAfOrfx/wAHwA4zK2MvHgAAAABJRU5ErkJggg==";

			$this->icon_code['infoIcon'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEfklEQVRoQ+1ai1HcMBDVqoGQCgIVBCoIqSBHBVwq4NKALKuBkAoCFQQqyFFBLhXkqCCkAW3meWSPLMsfCRuGTDTD3MxxlvT2/3ZNYoaltT6w1n4QQhwS0Sk+3Z+/+14IsWfmLT6llLda64fHHk+5G7hLnxPRWghxnLnPjpmvpJTXuWCSAWitD5n5QgiBix9kXjx8DJq4IqIvWmtoavJKAqCUKohoM+PFO0CY+dIYU05FMAmA1vqYmb8OmQoz/xRC3Egpd7BxrTU+m4U94BfWWnyuiOjtwCV3RHQ2RRujALTWa2b+HJM6M99LKS9x8SmHBYDg6Ctr7YaI3kTAPBDRJ6311ZA2BgG4y0PyrcXMf6SUm7HNp5oBzrHWXhLRq/AZIvo4dE4vgIHL30op17lRow+Ui2pwZITj1hoCEQXQd/kxaUyV+NDvBs6GT9x0wIVfOIf97tu8MxlIvbPBHJeO3AG+AW34JgWfOAl9raOBoih+hNHGRYQnuXwNRmu9YuZvAbhdWZYn/nctAEopTURF6wcjTjRg0wiZ7/B/KeVdapTCc1rrjYuAzTHMXBpjdP1FA8BlWEi/ya7MfGuMWaWaiTND7FUvqP99mBum7KuUugkcu2VKDQClFMIYSoRqObs/zIk2MU0y87UxBuVH0nLRae/7g6+FCgB+xMy/fOk/JuLMCcDdD8nUz0fQwhGEWwNo2RoyrDEGmTJrhSbktHmaY0L1BZRS0EKTsWsBVwDCyONSOEqE7AWf8jgBaqOkKjM8OOLQVUQiZz6//Qeceh51YDbyngddkIGZN4uIXgNAy75QVRpjcglKtbnb8zw4DKRlsDAbA62UQpXaVLHITxSJPq04O7Zp7P89TjzHvmGkLAFgS0RVwsGaI+suBSDMzsx8R0VRwK6aiOPqjRYZSdXCggBArPwEuQcA9i9YluUoyRkDtBQAFzFb9/0P4Cmd+N/UQCRFgzS8CCdGyfPyw+iLT2QREt2hbWNhM/z/UmE0UnSeLVLMLQGgt5iD9CJFEjpi2eX0QgBCzlIVnVFCg95mWZZHqaZT/34JAJGSp+rYNZTSWtvinQtQyuxqNCQzPl/vJfVCiIZ3pmpiTg3E+HqH1DsSgj4OCIPfDbspy/LsOQEURYHmVtPacdI/rinqIo2tgA/X+JN5cVJjy3PAFm2bi+SkajHWWozR3U7tj5aItRYsLWyswuufpD/qLo8+kN8lxEyiMZ2GQcYk85ztdaXUBRF1clAf1U0ecGCc5ELso2e8vvBctIHUO73Y5AFHvXGfJhBimXljjLlOte0eAgSpo+PcGduO5aNR/gt7jAwbmsiCsaibuic1whCpMN13Y9tOG3PqUGUUgJcjYDqDo1EhxBavEkgp72NjVmvtG/cqAl5H6G2eIdpIKVdT2pGTAPg1jhACY9HONHEOU4LUhRAYdDcDjLF9kwB42sC0fj0XkPriUsqrKVL3QSUD8BwcDof5LoAMmVavEJ2p1IPyrKiWDSAMgUKIU/caQfW6TTh9BwFHmQ4/ca8jbHOmP6E0/gKjlpwsE7XXhgAAAABJRU5ErkJggg==";

			$this->icon_code['heart'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAACx0lEQVR4nO2a0XHCMAyGMwIjMAIjdIRuUEboBmWEbtC+5fT7wWwAG4QN6AawQfui3AUjh8SWEtLzd+enkj+yLMmy06oqFAqFQqFQKBRGA2DjnPsAcADQAPjtjAP/baOk39VuNPSTIaI3IjoHRkUHEZ2J6M1Y/9VyzlVVVVVd12thNcaMQ13X67n0swCwAXDJMK4dF+fcS6jvnHvR0ldPC558LPy+AWy7L+XfbwHsY891ncCTV9VXcwKHpbQy+yHhxs9Lhl7qul5b62c7QMpJ59z7WB3n3LtgZIP73UNT/zBW5wYOs2zjHhhpqp+1Owhb0T5ZjHmQt+r6RHROFborfBo5xTkrOsBQf3xBJKJdWI1zjWuRosBSn4h2KSLHwMitooF3tcVY/5giElZnteZCSi9j/SZF5MZALeMWo29toDXZ9hPRSbtCT0WYAkR0ShE5BiL2x00liOhVowh+BiKf+qbaoGJ7eEJL7qhmIOxgpeP3IABcl5YGQvhfk8WEUMo7XU0A7k+v6akr9dXPHAXC6ufvXnwjc1MLvPcrHZP18N6vwtxXOV9wFFzVwsoIAF9h7qv1LuHJ8NlSQTpcJZ0A+wg7Q1jcviYA4bY6qfN7hJQKc9cDKe9VQz9ECjUAzRxO8N6vIFyoQvFeQUToDSZ3Qmzy6nkfI9wap3RCz+S/rd99g1AUzZ3QE/ZHq3f2GhNzgsXuwNVeWvnTbIW4xwmqW6S01c0++RZ2glQTVCpyZOeZPucf0eOEr1RNob19zsm39Hz7a8Y0J7F8B/K+HU4Ch2x4eGrrwnbg89Ln8qt5k6MFr+BPJHy9VLi4lvjIMyeLncUU3rNjX4Iv3dMkX2TE/j1mP3ulz4HrgpQSv0TkY6sO4Pr0+T4UAJtIvyCORYb8EKSLFWHyu7ntNCUWDf921WN0asP/yfWxeO9Xi67whUKhUCgUCkvmDzCY5ExUnJYjAAAAAElFTkSuQmCC";

			$this->icon_code['heartFull'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAB10lEQVRoge2Xu04CQRSG/0fgEfYJzJZEdxJaEgt6Cye0NNZWNtrCm4hPALEzNDbGwkKtjBUb0c7kt1hAue2eucBgMn8yxSbknO+b2y5ATExMTMwuwkOkVOgyw4AKYyqQCpw+d3mI1LIWXWpVN6sjYYbrhUabRoZBWfNprYGoVicb8fbmwA1eobUw27IxpoJ2qtVOycmY/Pr45uvjsQu8Cfjy0Fa1ZvB/8/5yYgZfR2Ix86srUUdiVGsdPFmsxMOdkgtI97zkTEj3/CZ4kvzMyU42ksEXN4Q7vMmogm+nxe8ktxMz9PYSvljRnkRgKGp83iIvT8lmbTfwhcCwWkBy4J7ufxu9Pa822gb8dEgEqmd+OZOxmYQlvFQgL21+pdc3lko4wFMhdz8DzdriFjKRcIMXngHJLWQj4QpfCFxUC0jfAyYSPuAVZO8BAKBC35uEL3iFvggemH8LlR9mqYQf+Jx1JGIBAGCGhrB4uYQ7PJmhYQQ/l1DQ3iVM4df8twgnsWt4rxKh4L1IhIZ3ktgXeGuJfYK3ktg3+C1J7Bbes0QYeE8SYeFnsZTQobkXYiihQ/OujVBCh+YsTYWEDs0nygYJHZrLKEsSOjSPVXiEs38LHxMTEyPKDwIuhpsFN0WeAAAAAElFTkSuQmCC";

			$this->icon_code['checked'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAFLklEQVRoQ+1azXHbOBT+nm/2Zb0VREgDUSow1IF9DHWwXYG1FaxTQZIKohykHC1XIGwFtiuAXEHsS7wnv50HghRJgSQoMc5OJpzxjDwEQXzv53sfHkj4RS76RXDgN5CQJ0dze8QEDXZ/h0QYZuOYcQvCg/ufYPCMazNWt31FxM4e0V+txjNOiXDWdVEMrMAw2MMX806Zrs8Xx28NRM/tMYALAnRhwjsGZEEGjFXR4npmh9jDoXgKgCbmYxC9yj0mzxDebwuoMxD91Q7A+JwDYL5n0BR7mJp3atXFqg4ccEzEE4D+kGedIfZxYk5UGoaRVycgzgsCgsSq/MigS5Ooj5Hvqh2mr+whvmOSAfIhd1LNIRlXBzAaiJ7ZCyK4RTPjGgc462q1NsCyUHpyofnGv+fcjNVUfuuZlRz8AGAUIokoIHpmxQsumRn4qw8vNIHSc/uRgAtmvJVFC6EQY1kF1ynZ9dxOyFmCH5lpklmozbq73pdclJzzebSUcGbGezNWl6G5Gz0iOUHAVZMldl1wo2fS3BEQQwa+mETVUnwtEMdOz7hxlniBcAoB0jMr7xdmu+N96KacrAcyt0uhWElsM1ZSM170yvNS6P2AhgJCcqWuzgSBrEOKH3mfBn2zU5tFKnmpiwnPhFEITB2Q1Bs/IaSEZonw2TPkiUnUwtPvJRH+loJpEjWqGmMDSE51zPfL8etBm/X6vF9hqLyGOCCuxvBKFEDIK5tA5nZKwGkT1fW5+GyuCrkEGUrPbOaVjfsbQEZzy86tBNVVO20L0EsUR7MA/lkmqihE82kFLDEsMx5wAFXM3RKQQt24WyYq30tsu8DY5/TcXhEgzNhKs6O5lT3Mm2p4lYGsXffJJGoSu5Bdxq3lDz8y0bAtCgrypVTlS0BGcyuC7YiBnC12WWTbs2uGcvLH0WzsM9X6VvWIq6SZWGubdJf7MUIwWO3XArKUS1WPuERfJipaFUtydhWSsUIwCCSV+t8k4c1Y/ZmN2RpIqXAxSpzfKgSfcEPAoE0I1s2TMWvR4FsD8dV2XYUZIvE/tYVbUQhuy4y9AwmAmZqxOq8DExKCbcBD92OApBztd2axL6mEWRBMVpX9Bi2KoYI5MrNDItxIzSl6tDf6TVmIF04LMUpgSkBr1Gu00dabvXrWKmiZrQqisBERGwfGt3XwHQNvQWlaRJNCbXiu9/P1BTHjdmlvmrF6G2ul4rgSGGmTwgGRXWbjVjX2XRlZNEoUmawP0ZiCgbRxsrZOL7vMTDRKni2T19KxzK8fJuMLPSq07bc7eCNexufhBaxMolTsS+qqMP7FYZsQjH2HntlvLkwDhBGUIgXx+MObcdEg8v5aeL/S2HwIbWBiX9znOL/xsnXekHfVisOCVxYmUSd9LqzrXNnGq6k11digI+ZbXxN+WoiVWkMNG6//d8u0pjUU8mjrviOziMsX6XP5Nn/X8Og6vtLfao2IViBO4foWkfzmSLnedeEVdbA+i4lUBFFAPBh/vODOSBbYx3nfrVTHTk/uWM/1mrt0OqOBeDDHBJ56hSuhdhmzmYrxjpyIyXyFY72zrF0a83wnIA5M2iQTHXXkrbZCqqvkiLnbYagcXQCnYJzJ1teH7jX2MOk6V2cgmXV8M096Xw6QX4R8FGCIYRi43zjMFDEJvMo+Kih+UCBNDCZcvtjxdNXN7oOB1KKnMSFQHuNOhhfi0W0BZPNt7ZHQov1XEJrkMw64DwOcjC9cdwAeOP3awey6+OLEvQLp7pH+nvgNpD9b9jPTfwQDNWCupe5qAAAAAElFTkSuQmCC";

			$this->icon_code['mapMarker'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAEy0lEQVRoQ91aQXbTShCszgpnQzjB93ABnBMgnwBnGXnx4QSEE8ScAHMCwsLOEucEUk4Q5wSTf4KEDbBK82YykkfG0vRISh7va5X3PJKmurqreloh/E8u6hvHeKHfMDABYQjGARFG5h3MWINwB8YNAatsqi76fHcvQJJzPcQ9TgFMiHAg2SAz7gCssI8P+ZEyf3e6OgNJzvUp7nHiAbhm4AyENe5xl0/V2uwwWegR9nAAxoiAtwBeOabusId5fqw+dkHSGkjyTR/gB7IydYCvIMzyY3Uj2ZBlkTEj4N8y9fYxbstOKyA2urAgTBpdM+EkP1a5BMD2muRcJ8SYG4Zcuo0LFmOeFw3EMaEdiEseYNI2isVGzTPpJ1YAXlsw+1Cxz4wCspVOl1mqkpiohdaOl9qwasCs86k6DK33f48DstAzIqtO1zxAEhu10MYcMwaMSbOP+VTNQvcUv4uBOIm9MinFjMM2eSzZlKuZLDbF5ECW+swoDANf81QZ+Xy0K2nxLjmQhb61bBBUSGJtLf3Ce9xbg9w4+x5WeIbPoZQ07BNDG1byqXohiZgISLLUEwK+mdrIUmU3VnclC23Y+lTn8DZlCO/yVBmVqr3GS22M9BUDR6G15iFSIEVafchTZTR/52VAEOGLM7gL59jWX0zuuw7gjf09sMHECQsDn/NUnYRYEQEpZZEwrjM+31+Y8S6fqrNdLy/Ahoq5KHoAIpkXAUkW2qjVqEmtyggyLvKpmgTSpvCLWok13QMRrqSeIgIyXmo2G8tSVbu+BNvAWgHOk9hG45O8N8pHJA+UrPFZkqyXrPnrgTiXvwX4e5a+DJ5xpKn1kNMNaVPKZURqNcn5oxR7qVoNkunJ5SpP1VGj1yx1RkDS1E956hYUD7mPFJre0Mg9pALfAPS8UX7P9SkxZiZleEDDOpf3VFDUPIpSy3P2Rk331hnDWxEwz1J1aSI2XurXDHsitK1/yBAlWeCzLgPycPC5DUmwdXDbzvCZYWZ3evF3Br1tajs2hQ7wAC9CvZk4tVxExb2Pc3kzkDDGaIcM9gzDdmoyD21MmgHRjLhIzwl4/yRt/EKviGDmY429XTsgLVrrUKO3sxfz0lhyZIgyxGJx6RUNTWGbzfv3eB20qFlsBaTUdiDPUzXuuumdjCy1JmDYJOG77hOpVtnsVb2i93N76ebM/2XTl8OYQEUBeeyiTwSOXwcuHogremtqgvO7NKqb3qrZ8XsD4ljpfaLShY0oQ6woS5WV2uPvU7HRGohlZTMc6KxgyUapRA1iZ9WqsOIrmHBkUyO3JwR8QgulauXsOzfhxj8M3GCAw1APtf2MyuSlQzA6pZbn9sGJSF2tFKNR6cinqeai5fePqLqxjZXjiOF2RW6JRqExbEg4OgOpFL7wu4ZNqZ+4cq1I6wLvrUYqrcsPXoPoH8l3jWSp7ZFAMksOMVH83gsjjhU7GQylmDcdiUrFEKDegGx5y04V21Ip8aEpBKIX1dp+ifc54I+xUNGG9KFS2+/tlRHLim1feG3HQt5RtegEQmMgSfR7dfamF1bGQgR7ACNGZutHMIlsA6Z3Rkol2wz17P+ZuI+ovUjtkzHigbHTEKdkotFnGzYepdj9jXjfzc2grffv8r0bYtso9nnfb8uVHmDpOaieAAAAAElFTkSuQmCC";

			$this->icon_code['mapMarkerGrey'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAC8UlEQVRoge1aS3HDMBA1BEMIhEAwhEAohEIIgx3tk8+FYAiGEAiBYAjpoZKyTmx9Ym2cQ9+MZ3qIpf2+/bhN849nEFFLQGeMOTMwArgwMDEwub8HtpYI6PaWdRFE1LK15IS+ZT/WEhEd9pZ/UQEAF2PMmYCO+v5IRK17DgBOxpiz885MoX2VAAYh0Eh9f8x+v++PbO2PNAARtZoyrwlxdda8bon52VnAVGKMTSCiVoTGWCPGnXfHoIy2Z2Q4aYSCVwbApea5T3C0+hdOClaT3jbGnGufHy7x7KRZB4joIELsUP2C4A1gqH74AwKbWfujcfiVgVsOqxBRy8zfDAwALu7dITdcnPdvDEybBZcAcMpNQgK6p4InHgCXnNAMlMz8VUOHpmnuYZWyKAGdqPKjqO4HACepYEoZQSz1wktQ7mlVCVlf/nqoRVZzLU0ybJxRbgyMW+UP8ALGWMTlhC+SUWr29SLmYZU8CYkeUyTDax4+52IMqKOIrx8RS+coWyqkz6cXRF5GCK0I9dZWhPr+WL1dCe16hAp9EcsJrZxEVkn2wDTM32u/EZU/ebE3TCzZA3nUpN+cOuKmxWuBgNHGU9SRetOjYJmotUU4zCq4X0rIiTIVgiUsmA2RnMlkfpj4lp4pJVzJfcUQCb+aJxJ+JeSoe2JgNMacc+YYUVzrd9rM/PW2Nr7QaEWQ3K85U88GOK2dl0pr/XiH87zq3B7Cy9qr1h2hg1Y0VtM0d69UpUWHQPNKy40ZfKHScH1Oe18NWhwviqn+gs5DTHnVqPit3vCYeaXCrla0QO/zhofcOm455y3bxZQANepKbjesChkSr7wvq7h63UhBroBK39UgjZchls5FiT+j23d93EkhWDYz8XdP8BhKBJPdwW4JvoZZiEX2umI/PH3s9/bUXvejQ+oRfP+o+bSoEMuH5H54dzzUhjCqijlc55OaBuRaiIBOfjfRmGNUIfMleGjPf9XYApEvNwaGj8+LNQiW+vzk/hT8Ak0IUQVkeTWPAAAAAElFTkSuQmCC";

			$this->icon_code['phone'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAEbElEQVRoQ81a4XnUMAy1vEC7QekEwASUCWgnoEzQY4FE9gLQCWgnoJ2AMgF0AtoJgAUivpdPyefzJU6cC5fcv/Z8iZ71JD3JJpP4MPO5iJTGmFfGmCcicsx8k/rNUt9R14uZ+VhEPhljLuPviegtMz8sZXDfe3eAKIhv8IKI/LXWMjN/ZuaNgoNnXjPznzWB2QLCzDAeIOCRR2vtJTP/bAwuiuInEb00xtw55y5WCaQDxFm868z8QkR+AQARXTDz3VrA1B5RA3+oJ26ttZs+6hRFwUSEBPCHiE7XQjGKYuLee38+tMsNxUTk2nu/GVp/iO+pKIrPRHSlMbFDp56shliCB0GxVWQxKssSnH+Ra1BAsVVkMQAR7KxzrrOmpGixJoqBWtjREw3cpxw+a6ZbBcUA5IGI3kxNpyHFnHOnORsx51oAqdPpPhmooecUr84FBum3yUBPU3ZU0/fvqXE2GxA8KIiT7FTaaDAR+e69P5vLsNzn1JkqoNet935H8fY9VL2B9H2cm75zDR1a30gUiMSaHjk8DzZgUW/UdgfK9oaI3ovIKK9EAjKbkkM7nPt9CyQyDP1GK9+7HlqW5VdjDDrIUcBzDctdv1XNg5rw4Jx7m4iNUGtBAWcV0lwjx6yPG6vjqqpQ6Y+I6CM6wx7ROGrdGAPmWtPV6oIuoA36DVCsc7d1MIF1q1DAnUKxKIo7InpnjElSLGqyEPDJuJpr97ue0ztFqaoK/fmJiDjvPfcZURRFne2MMVgPMIsMJXqlOzOf6SAiSR0UxaqqIDwxlFgMTLIHiaiTipfFwQw2U0G8JHcbdUjpeLSEZwaBRNRJzrOgpJVmAAO6YWR0kJgZBIIgj3b7xjn3IVUsAzAHi5lRQBRMu9upYhmvPRTNRgNRAy9F5IsWwQ+pyXxEs9GeAZUx1cmtSVlAJoBBAkBxbVIzwHcWTVUKV8aYpjmDVML6UZP/bCATwISpGbIHCaA1TusVRrB93SUGiDiXSSaNSUAmgoFBUABGRNhae6uHSHVHqkcYmDnXB0lBDcOfg96ZDCQXTIdxbeKDDLLW4gxma9c1ziCBQE18er2zF5ApYEAljZsjEbnXyX+ynxnjnb2BxGBEZOO9v04p3SmZacg7swCJwRhjkkVzHznf553ZgDRgqqoCjyFRkHaRPmeXKLF38J5ZgfRUdaTb/9LTbx1t7OPmhN4KC+FO7Zjzne3cec6Hhs9S1YzUiZa5rh3eezfn+4Jx7ePs1IoNjYIT0h5xszfVwlNoqIX/DkTjpq0dmM6od5Ipeih96xkmjsvrAeFBgCgYaK6Watp4YXaWNXmJTqFxqaE+wD0YkGaHoXI1RZ/o/wAOonAU3cqyRBuBduLZWvuqSe8HBxJ4Z6MXDxqMqDvXfbK9444MPNF6cxEggXeQpnH0V6ti/cAzdyLyYK19hKdU6uO2UnPRZwsEfrcokAAQusLLqqrgpYZyO/GulxrOu2i4CiBR/cFsANdI0GjhIgOmnc/wkl656pQ8/wC3pFkyvejV7AAAAABJRU5ErkJggg==";

			$this->icon_code['message'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADF0lEQVRoQ+2Z63XTQBCFd9QA6QA6IFSAqQBTAU4FcRpYjdQASgUkFWAqwFRA0gF0EBrY4VyfWbOW1tbL8kPH+pfYWu03jzt3ZTIjuWgkHOYCcmqZvGTkkpGBIkBpmspAax902fGBZFl2lo3vK2qdkdGAENE7Zn46aGH3fBgzX4vILywT9sgLEX04FxiF+GGMuSqD4G/A3DHzQ89gDXo7M89E5IuH2AARkUci+rz6J9HNqcJYa2+JqMA+N/bsux7NzsxzJcX3HrIsuxk0tC0XT9P0qzFmpsFG5RRbVUvThhtWMFpqLy2fudevM/OViGBPUxH5myTJ3FfMTvlFIznnlkT0yhjzpCJwFBiFQFNDoQAxCQWpdo4oDDLyVmHQNweVZ1Wmb8aYNyLynCTJrLyHWhDUBqKhmQHMQeU5lFeFQCYqVdEIJIApVNEOIs9hn0KZtCeipd0YxHettRZlNrg8l+U1z/OVSm27WoNodjCI1oq2b3kuyWujWdYJxMM451BqULS9yHNEXtHUiyYa3hlEYfYmz3XyWgfTC0RhJiICfceFWdNanivGr4MD7wWiG0CvXAcRayXPzIxAYEas3GvXgHQGCZ2nH1LOuXkbRYvIa+Gc88O3lcR3AknTFNZ5juiV9T2UZxGZ53l+H6vvbfKqw9fPK9xaZFl2t9ce0YZEGUywsBrJlZUOr5LhXIpIkef5d3zHWvuRiBAEv0ZUXstrENGn2ET3z22ckZLfqZi2CMzEObdQea4EVI3flJmX26JdMq2/FSbq8xqBlGoZpi3qdyIw8GiI/lRNJ0rx2RizSJKk2BVhv1bE50VPrrUg4ZRFP9RZhbpa7vq5tRZ9c6v3Vw57uw5WOMSE/n99iOm6mb73oTICN7FxPoqClKzznyRJUMsHPYPU9A1673V4pKiAQDKDQ/1PhTjKqXAHDHoPMO91BKz3XHn3KyL3eZ6vZsWpXtZaJqI03N8aRGWxses8NiQzT9UNwIX/f9M4mlemo3mJPRqQY9d83+eP5xervpE4lfvP8ue2WPAuIKdSUn4fl4xcMjJQBP4Bi/7LwV6IVyYAAAAASUVORK5CYII=";

			$this->icon_code['globe'] = "data:image/png;base64,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";

			$this->icon_code['clock'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAE8UlEQVRoQ82ai3EbNxCGsVABliuwXEHkCqRUELkCKRVYbgDAoYFQFUSqwFQFpiuIUoGpCqIUIGzmxywYEDqSuDuc5ZvheDy6x37YB/YBUo0u59xJCOGMiE6VUvidyC//wlophd8DMz9orb855/D/yRdNeYMIf0lEVz1C1756zcwLrfX9FKhRIABgZquUAkC8mPlfpdQKq621xr/rUjA8B+AQwrlo7ZyI3mTEt0TUjQEaBOKcO2bmPwqAO6310jm3rFVBfp9z7iKEcEFElwXQZ+fcU+07q0HwQWb+UykFGKw+zGEx5GP7hBIzhYavRUtPRPR77QJVgVhroYVrMaF7rfV1rfqttX/hua7rPtSsrgDBxM7k/kXXdZ8PPbsXREzpi1LqHFoQgNtDL83/bq1lAalatPSsc+4qhLAQ7ayI6OM+7e98uUB8hVMKxLlz7mEIBO4dC4JnnXOnIQRAICA8ENGvu2B2glhrAQFN/K21vqg1pRJ0CkgGA1P7RSm17LruY99i9oIYY6DST6KJ07EQUzWSmdlGM8x8472P/ppfL0AkOn2ZYk4tfKQUNDcz8ZetcL8FIn7xHSFWQt8gx+5T+VTTKvacK9kCEJrf5/6yBWKMgS1eMvO99/5iqGPPDYL3G2Pg/GfMfOe932QWGxBJO7638Is5TCvzF6Q4iGBvRCsx6dyAZNrovPeuhTZaOXspizHGEZHNtRJBkjYiGdHbVmnHXCCFvPCVdQTpI/yZNSIyR38mIiSXiwhirUWkOukLa1OBWkatIoIhiUX6tO667j3lTu69P54qePn8XCCiFYTh6PQAibG5ZcidM2rl7zbGLInoN+x5lKUjTaNV+uDMGknR6wYgcYORzBIlatNrThDnHJLar8z8jTJHj2GsJYUxxhJR3JOY2Xnvu5bvR/7FzCjc1gAZVfgcEiiZbH4fMzc33yT/bCDW2n+QfBbAT13XvT20CEP+PjuIMSaGxkIjj957tISaXbOCSDkA290SelbTMsasiehdnklOWa6i1n8U80J/6rZlMgoZs838sWn4LSBQ66NhUd1kG7qAW+G31Yb4oyGKZPemSYryGhAC8n+KkuX2o0Lja0FI1h5DfEwahSw5PLp5g5rR0hLFDju7T/Sl8cwcQ3qqEK/RZS8L+hrnM8bE7uPcjl3KkkrzrcKqr3SsgXite3aWumJeqRXUPB9qDZxF2k1L6EU7SCmF1OJD60y4FYxoA1lDdPIkZ2+Dbl+zuJVAY9+TNdf7G3Sy5R+HEBDBUAdjWjS5ZTpW4L7nnHMpKGFWc7KzZSowqTsBE8M8YvBMpKXw6V1SRGHUAZN6sU3sHSv8LP6SQ1SPFdIKpFpeJkVYgaZlcK3WBAJDWGy6O5vre0dvMvbCpOhVzKzQxN7M4eAwNISAxAwTVsCgPflDAoAx5pM0LjAOxyT5atQwNFd90UhA+wgRbRZTk30CpoTTEei+9I7aStOsHhnLCQXs/qjDn+T8yF0roOxcS2ofIcRCC1VJbDVIts9gULp13IKZl977+1oHLrSNliemY/m5FhwLwaGE6upyEEgW0zE1QrsyB8JHVzi+xMyro6Ojx75DNc/Pz+gP4DANjkLBfDYtI2TfWms3RsujQHIgpRQOxeD8yLsxGkE9gTMtSIvGAKRvTgIpCh20fs5DCJuDZyUchE4Hz7TWyBhWU4TPv/8fVZPejlNsRCUAAAAASUVORK5CYII=";

			$this->icon_code['contacts'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAADNElEQVRoge2ZLWhbURTHn3iig8IiIiomIgqrqJiomJgIrCKiomKig4iKioiKioiJiEJExURFRGEbRERMVERkENhE5BgTGUxEVERkUBERURFR8Zu45+5durzk3feRm7H8IRB455z3u9/3nOd5a6317wjYAcrAOdAEroAqcAhsuOabK8AHKsBX5qsP7LrmnSlgE+gasCMZhRpwDJwCDeBGnk+Bt8COa/Y/AjaAn0YDDgA/xNYH3j8YoUaY/VIlPQvwHdiKYO8De0AdGItvcxms86AKwL38rOe9bAoTacyzLBijglQE4jpBjHOJ8TFNNluItkAcJ4ixKzGGKaJZQ/QEopgwDgApYcUC0NtpIWEc5w3R227shQrkVqEhn4ThdYIYTyXGrzTZbCH04fYmQYznEqOfJpstRFUg3qUQ4zJNNluIA4H4nCDGtcQop8lmC1ESiElM/7zcCgD20+azAdE33lpMfx+4kBjttPlsQAYCETu/AIoSo5cmmy1E4vmNylcgwX0tsVDpLMAQqMbwr4mv88XuAx0BuYnhr6/wXVwnV8Aj4IcAvbDweyk+37LksxKqUgJQt/Cpi89VlmxWMnaeCZCLYJ8zplVxCYjRRZCbdObNd1lXOiFzt+WGieC6ohuTn2GTMxoBsOeCda5Qta2pATkGTlAFioL8HxnPR66ZQ2WcCQPCpbNKdzn6IhFcAPOow7ItozBGnRUVYHulG0JQDZkusNvSdqxSydTzPA9VOdTTaWGCBLSMKeh+wcsoNI0pBXARwa9m2N9LjOVWGlHnwCuCO5aGaROUT4/m+O8bdq0HndAFjsjyGwqq6n5GUHgGdTpfAttiUzeeNVBnS15+JbHVqolPAVUInxjPxqhS6sJbgm0jysCt8aIB6pvH5gzbU+COcE2Bs5COqhDUynRH/WUbpwE+6oONVh84jOC3I6PTkd4dy/86EbJJ1Ce6vvHe1qxOs2mIXgd3wEnsQPHfXzZGt0ecnIUgBR0ia8CFUAfoUFjsslDgCcHiK2XEaMOj04QpNgVzgg84X7LDs5MxzaMvfuCDtVPGQu2GAC0bJ3OrXTXdRm1EbmEo93ocd2TXWut/1W9KptrZf/2YyAAAAABJRU5ErkJggg==";			$this->icon_code['contacts_black'] = "data:image/png;base64,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";
						$this->icon_code['pinterest'] = "data:image/png;base64,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";
			$this->icon_code['cinterest'] = "data:image/png;base64,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";
			$this->icon_code['clinkedin'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAEBUlEQVRoQ+1a7VEbMRDVqgHoAKgAUwFOBTEVBCoAGtCt1EBMBZgKMBUEKohTAaSCkAa0mXeRPPL5PmQP3MGMb4Y/Rnfa1dt9+yVSDY8x5hsRjZVSo/DXtLSP3xdKqYWIPDrn7uo2pOqPzDwRke9KqcM+JNxijxciumbmefruiiJFUUCBKywQkV9a65lS6pGZcSKDPcwMqxh778+J6DgIMrXWXkehlooYY6ZEdCkif7XWzMzTwSRv2ZiZr7z3TER7InLjnCsPvlQkmNN9UGI8NAJdBwiERORnqQDRGcysVKQoimf4RLC9D4lEjS9fBV9+sdYeETOfi8gtfMI5B1v8NI8xZgGfASpkjJkREagWTPAp0IgnDX8BKiJyR0VRwNZGRHTS5BshpsCpImLg9GkTp/cFaeIrCygi2NhauxZTgv/cKqXOG4SbWWsv+hK8bp8of6siCXSgZCASg9DEew+63iOiC2ZGvBnkyVIkMbuS4lJJI0kgdbDWngyixX/GLS2qFZE2s2PmfRH502aWfSiXpYgx5jWYzxEzv1QQORSRZwRR59x+H0Jv7SORmuEb1tqz9ENFUdwrpZBg3jnnmsjg3fXLQoSZD733CDp7SikgsnR2ZAIhpRlV0Xp36ZMNshQJedjIez8nooNUQBH5rbWeDJ2XZSuSRFGk0Si0lNZ6UWWxPlGomHgWa5VRv0PI0n8iVeesZeaxiHxFjZF8/zVUgXOt9UOuuWYhEhd1nTaygty1wc8mHd98DSmQ7dp7I0Va0pdlepOR6pRr8YAklFJTrfU8+hjiUqgCJ0hiw1IQzRdmBlq1z2CKhBIaxVujcEgGvfePgS3XqH8bH+lKKLMRQe0QiKJViYRcltTfls/1jkiXrdf9P8nnyipw68iea/epszf5UxTCGFMQETIBtJteRGSmtb5pMjVjDNo/B7E2ryozCCItFN3o1MYYdEyKtGMyqI8ktc0yIwgpELKGYxGxzjmunniIOT9E5Mk5VwbkQRVJapuVQiy2oprqmqRcqPWT3k2rzd828cWPgEgjle8UeYtSFxCnJ/kWp5qTCu1MCyeQc1I7RCom2paG1B3ojn7rompOrrWLIx2mtzOtnWm1jC/egroxsYrjq7VBT25nZJMuShuFdlWR1XfjoAd9gNbRmzEGDYDTtg1E5ME5N9lkbfV72767Mnr7KHOOLjQaAmUcG56V47akLv40A9G04nTOHa5cGFBKYR6ChtigVza60Gm8MBBQKa9wQBkRYefcTdcHh/i/MeaSiMox+toVjqRVE5XBTxhBo1XzNDRCofN4GtpIZVO92lWpveYUJrYr85AhTr9uzzCXuWq95pS+CDYL8xBcJohXiwbRB3ECFqK1xpWr2lH4PxVzvVlIavAKAAAAAElFTkSuQmCC";
			
			$this->icon_code['vk'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAEcklEQVRoQ+2ajVEUQRCFuyNQI1AjUCIQIlAjUCJQI1AiECNQI1AjUCJQIxAjECJo61u6t3pnZ+7GY5GDYqoojr1ht1//vu4dlcYys4ci8kxE+M3P7dbeC75+IiI//OejqvJ5trS8Ymb3ROS9iOxesICb3v6biOyr6nG+wQSImT1xEGj/VEQ+iMhntKGqaOa/LzNDFjwC2Z6LyC0RQRbAINuwRiAO4pNf/ygiLy9L+BXuDqhDd3m2PQ0wAxB3p+8eB69Ulc1bu8zsjYi8dsvs4GYB5KvHBMGE+bZ+mRluTzL6pqp76tkJaxAT97bNnda4GQFPzOwABDd6ISLvVPXl1psiCTiR3cxIZ49EZE9V+XxllplRIgiLIyzyhyBX1VlN2XZEnpqR/wQgNuThKwjEM+6Z/DdAtsTvRkPcWOSqWcTpy92K3L9LBup8jWoLwSsX9Puzqh706sDMKAunLereHeyp4LSefaiqr/yGFNO3HULOCq+ZQYtoHVatA1WFY01WV4zEJhH56QQt3wRtsSBtP8wMSv3Yrx1hlUx3UvE6VtX7cSO3+K+axUUECkJ/NHhErUT0AgnhZtpIpG0gml6c0Cxag//cr7jerGYlq1cJa2ovcGVAbWSRoAA0MgNdbmhyFHoV5SkzpIPHGvQZg2UrgvI9AKrtRZdF3PeDi800VlrF9wcJnTw4udCo2dRXHKnqrLVO31et0R3svhFthA9P3KXw74F0podP3HFC8FR3U/swxlm2RtrP5Sah7baIg4kmhvT5tHhgdGv09TvJ59cBoQeiF69lMVwtXK6arZKL93Mt1zz+SxDPtGNmfPfAhxVkpFlbkDQcox0Sw2/AlM2cmQXIqssViuwH4lYJzU/Sp3+HZnl4XrPgTek89tX2RIx1daz/5FrJjKH5WjrORe2nqgKuTJVZSKY0uOy4irjpavQ2BRLpuBWgJAb6/man6cKelDWmsHr3EGQjIEV6pabgGosN7hJV4Z5YpDoePVeMFP88Breq7pcudJ6/E9XpArOxRVJw4z5ksZXpsRInxA5Z7UvDvfI0cS2YcwFxMDlemMNOArdmlWIsO5vfFlaP2rUSzLmBOJicqXgwtKQZM2YWvAl2PGHPDeABphmPiwBJYEirMSXnM2NMhC3TL8WLRul24mnrNB7x2GLH/1YQVwWwp1QAhJZXbR+rdQGGusJbgBL8yMBV9U5DOcuOgxwQ7hZvubBSXlASBB7fayQw65Ld5v3Iujsv9b3XD1pl+FptfaFha/Qry7nWUoA2uc9iwb7Jw5f8nxsgS2pziXtli5DHb13FaXx6rXDKNP7avOi5Nq/eok3FxZiSLNZfLBEDrXvMZmLOl8K9PizdX1wUGDNjVgyLGChPPjAQUxIqaPfE/KIEXcPtOCzAMIQBBVOYswMDbhVeBcQRjrWU/JIA0HQx8Y9DDdMjHAUYQAQlj0M1TEUuJXY8FuBgcagmDvw8rx6qSWCYhACgh5JfhmHocwDRPuaUpeqg5P8LBHEQ00mSUXWy8hc1mlevOMjbBAAAAABJRU5ErkJggg==";
			
			$this->icon_code['cvk'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASASURBVGhD7ZlLaFxVGMcn1gdGsXXhQq1atNQu1CKCXejCSlfahSgR1NBpMnlNaAhZCIJiVGyxVRFBKBYFUSuijV30tWgXhRYKknYRBLGl1ooFUUnSh6/UVH//0/8d7kxn0jzudC54//Dn3PP/vvOd77uvc+5MLkOGDLNCU2dnZ76rq2uYdoL23wZznDw+p13q/KaFJgZ8GAUhwCQcbRTJ4XQslzNwhfOcGt3d3as96BTM9/b2Xm9Tw0BOi8jpUxf0c19f3w021QaOwy4kbykt0O2+X7l1dHR0WqsJOU/AyTRciUqQV79P8iZL1YHTfDnCcUupAgU860K2WKqOrJDLhKyQtCErZLZoaWm5msluLhaLd7KY3aq+TXNCYoWQ2G1KLs54ku3t7bcwdisT/e44gfTPwZ0sZAvtWsLg4OCVlTGJcwer9zV2KSGRQhi8zbZKnsS2XD4cb6+w/QK/h3+rj99QCGZQ2Bq0M/Yto3Tsq+wagDa3QlpbW69DO2+bEj9m/mTtG67MPPrvuS8+7+G5np6eu6VhP24p19bWdhOaNoTnY/EiarN4UcL0E7kiux3kLUvyv4r+Eek8CwVpnMWnHWNfcAIc3y4N3xOWpL1pbZulADTFPGzbWssB9OdeCIkuI4C29H/pHras4E95zEnYXCgUFquPPmKXeCHfqq9nieM/4CRX657gZKC9Jl/43cDAwLWWA7Al87ArgAN9YknQ98tBj1sPQ9LwqO2Ku1Qa40JxtF+6X3nrLIfnsP2jY8sloCVWyF0w7I45k/db1u30gCefiG4tjo/YrHH3WhvRA+7jUb2a7RKeGbQTssHXLZcBezKFCNg22OegHnDLmuRd63+qpb/XpnACbBuH4Q2mgmzWujMPbY99hmutO0kX0kyg4/brsxwWQfrRLabJXrFJ0HfOjzHbRusB9Iu2naXAJZYvAn7JFSJwSzxmv9PxB1+foGivMtHLtM2WA/yyeB/9SUsloB9QPNqiparAnmwhAsE+s+/XtW6F6YIYWxWLmENTxapLIfl8fgF+P9h/s+VZwQumdgFTFlOXQgRulwfxjR7ufstVwR7qRvy+wu83Wr2Vmi5YLoD15z5svzqWiim9SCKg16cQgYfzOfyj7ct6bQJtKgOTb7JPxI+Qy4rBR+vIKdlp37FcAlr9ChG4MgWCayHTJNorvcjxE7QrI9LX5lH2dsX38dsMLyuGE/MoNl1lnZyHLQfgX99CBILrbB7y+Foc0xVzsmE9gdr2Pw5LRcMh2Wg/cPgA+vUvxGji6jzE+Bfgx0yojaYWOnE7/ZX2U1K6SqWfQ2vwJbsHXM5CZgSuzEKSeoP5dsGoYHEXen/lA5/aQmaKrJC0ISskbfhfFtLsQs5aShXIq9WFxD+1qwPHMTmzsC2ylBpQwDrlBjdYqg2c9e9pqJrtxBWWGw59wJFT9HvXpf8Q1acmjuEnT9oDUH93tTSK3BnPkMM6GBWxw6leGjivYFD40EkTVcS0/tGNQ3+GMriLwfqO+KJRZP4tcCNX5hGnliFDhhkjl/sPHiF4bLSQ+JcAAAAASUVORK5CYII=";
			
			$this->icon_code['app_phone'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAACe0lEQVRIS8WWgVEbMRBF/3ZAKojTASWQCkIHMRVABzgdkAqACkIqCKkASnAqCB38zNOsbnSXw76zj0EzjAedpL/79++XQu80Yi6u7TtJLxFxNXdvu34nsO0zSduI2LLJNmBrSWcR8bIosO0TSbeSziX9ycPvImJje5XZFlDbp5JWEfEwN4j/Mrb9LAk6OexREoczd1qztE1Q15LYvzka2PZG0kmtn22AmYPex4ggIDLlf0rA94NGL2Pb1LLNrNRT0g0sRATZLzI64BQStAHUDdvUE0CoX0fEc9b2Sy66r+KbE1ELTN1Qa69Nkn7OhA2+rxOY9YybQxTeAkMrCqWmbcYomfqubDsiZvf+GBN7qU4xQbMlfRiWYg697doWmP5Fqfz2RhoHJeiEdyhg3TdUNZmh3p4hpMCoL/28yBgCo+gxZSOs8zcDznpiCmRdzQKKASag5fu48pd+DDjUbtNCUTrtg6ovluB6tDXSEq/IMC8NBIeREBB9W9g4Zrzak+29m+DFQPICuY2I768Bp+l8lISrjfr5vvsYFZcMk4V6YfD7V9LF0LVs4+swBCD6YN23YQD7gOsBY+Bkz8GXEXGfwsT9qvNdM1/vgDSgLoC99pc0d7VNn6bPf0BlghPEL0mfsxzEQQDMtwHARkliL3BmUjMvtc1gyjMoPRw/5697JuU+5roAJH1invtgEnADjprx7FJbAphyM2WLEsDX3Dst41a9qVhqWSic01L50Cj+MDnjAXiPwikBDJ/FBwE3Lod4yB5XQ2wPEfFzECTfLnmx8ogYvZ3m0DY4HPEBUF4xkp7yO97+O5XcM5KjMt7hXEXlu16hbwI8hbl3A/4H+MVJLuHKNL4AAAAASUVORK5CYII=";
			$this->icon_code['app_form'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAABv0lEQVRIS+WW7VECQRBEezIwAzQCyUCMQI1AiECMQIxAjUCNQI1AzUAjUDMwg7be1R61fNyBcHA/2D9QxbFve6Z7bkMtrWiJqx0E236T5G2XPGwDfZT0vSX4vqTzEnwcESjf+LLdk/Ragj8kAf/dJNn2HlBJ3RL8k/p8FhEcovFluyvpSSqS1BmXWlJf0klS3ig8QVH6IukhL3XRY9sjSVeSBhHBA2sv2wi6l3QdEaPpHo/NlT04jIi7dcjzhFSCAaUfn+lJRAxWgdumYqeSerlvasEJjhmIGL2h9Es5PjkXEx0AnjbrQnCCY/9ysi2MWxYXnIvSmcMuBc7KjmomW2XcMudy2MqBtBQ4MxomY0PiBnxiyqXNKC9xQeVFVTIWgjNz4O4iWraHkm4k8cl8ZwEhhpcRcZueI0J8nzFnXZwY4uWE6c8xB05l004CM/U4HCkYr1R6DsxLaOyPueCsZO9Msjonp41VN2KT2YAflS2aATO4UxmLCbNKdqv+kw0SWvQ5/XYid6icKFlTB7BNi1D/lb+dOAVh3+hlwDb+Qdhh6xcBSrBRtVnLUN1H8VauPNNe2cF7dVNx+e8+rZX6D45VP1danI7yAAAAAElFTkSuQmCC";
			$this->icon_code['app_gaddress'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeCAYAAAA7MK6iAAAChklEQVRIS62X/VEUQRDFX0egRKBEIGQAEYARQAZCBGAEYARgBGoEYgRKBGAEkkFbv6ueq9m5+drS+Wer9nb6db9+/WbOtHK5+2tJ7yTxZL1IejQzntPLZr909yNJHySdxp7HeJIE66ukT2b2MBNzCBwV3kg6l/RZ0q2Z/cqDu/uBpAtJZ5LuJV2OGOgCB+h3SXx3ambPvWrc/W1U7pKOe+AjYOgj2NGogpRQJAvdT2b2vpVoE9jdofYW4FnQDJxkace5mZH8zuoBQ+u9mV2Xu4LSJKoftcTcnX1nZrY/DRxi+SlprwwaAa8k/Y6AbyRdm9nHQnCM2x9J+zVtVCt2dxQKTah1u+I9lSC0zdjEmEEn4LQm/x66YW3xng9awARHUMxuHgiTuDAzRiZ/jx5uzGyveE9yD7V29YARFQE3K/r61KC/Squ7k+DzWuBFxTEm1Z61knL31RVD8V2pSHenZ1CHBnKq6eFBozVbPeR7WlQjqh1Vh9qpAjdLfaYdx6GJrZVmDB2WFtsUV/SUOUappZAwh02FUQFgCG5hp2FA7Of7ndUzkORa6TSq7W++c3dGDGEt2pI29IAB/FJT8SiDEc1dqjO6q7bZAw93Q1QLAxqKK5tdhHPV8tsaeFTLvHMmL/QxDRxVV92qVXFUi91WRTXscVY14uBQwOy796rZaoc9zsCbR2RhJFCL1S48ftU4FQEJhGlUj7hoSTIdrjzDC9/wspdVzVy+MjNcame17LSlhTXAnEDJzcpzl2OUCcCvp+7X08BBZzKVrf9mt5UpiqdVXVLl7lR7IukwfuMw+dayxn+muhAbBwMmwUJwTYf638Dp+krc1dff6TluqHjjTKN/F62K/wJMt08u3bnztwAAAABJRU5ErkJggg==";
			$this->icon_code['icon_banner_cat'] = "data:image/png;base64,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";
			$this->icon_code['plans_thumbnail_section'] = "data:image/png;base64,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";
			$this->icon_code['plan_pending'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATpSURBVGhD7VpbbFRFGK73SzQYL/EWNRGJisEHEuKTlyeTmmj0oUp5AcXdc8423Aw8aqNBwdDdmdOCsSbIi7ERfbCBoj4YjdFHfeiLlwRMFNoIogYSIFJm/P6Zr3sKtstu9+zuhPAlk22/f2bO/8//z5yZf07XRVyosEV9t43UKhPr9/D7NX4nUI7ZWFsTqykTqb9MpH/C35+Cf8sk6ZO2OHwtm3cWZnX5Rii3AYp9Lwo3WtD2BAwcgXHdtstewm7bB1scuBkP3wYljleVivURG+ndJq70wSNPmL6hO+zKXVezCdpsXWCLgw/YRD2LuptRvhVPzWg/bqL0+bYYJA+xSVrEQ4/6hyvjQqVYeRphcgWr1Q0x1hTVK+jjwLRBLiwT9SCr5A/nhUjvrY5gpEdNobyE4qZg+/svx+CshIcPcYBOyoBRnB/g8sVQ/DdvgJoUD1CUK2xp+3UwYkg8zcHaKUZS3BxMopdVQynSX+Jht1HUMrh5FOm/OXB7bE//lRTNDxI66OgwOxxpusMGgAF8GAM4wWd/Ynt2X0ZRY+Cc8OEU6w/g4kspahtMqXxfdSBjXSZdP2R1QpyOsYOv2umJc2EK6hEM6AmZNyjPkK4PsmLQpZNmtb6VdMcAPSLqcxhL9k2ka8OsSW9Bgz9dwxatTvMBvOKWfkTIu6RqA+7b5q3Xo6SCgE0q90K3kyjYt+lFpGeH3zup4y4ec3rZ5QnoNchB3klqdqDi+hC9MQ2TDNwF3U6LZ+w6dQPp/wPe+CG0uXEuoOMe0XHOLYwpbb/HewMTfR4bwHYB+vUyavaROhtyKHIVYvURqSAhyy+MOIPV69isAw5Lh70hlT5SwQJGjDtdC5WlpDLAym+cMEkfJxUsYMiHPrxUL6kMEB70wvKdpIIFDHjDR49+lVQGF3Mi3FC+hlSwwDxeS48MkMrgBfoM/w0a2OK/SH3fIZUB5GkR8t+gAU/4TWSsdpDKAEPciUyyHaSCBY7eG71H1BZSGWDdj16YLiYVLKCr9rrqdaQygByluxo7vHQA0NEf+iL9FKkMcNOb3hC9mVSQcKdXHn8lTUs6g8vFOivVd6SChBwv6I39pM6GJJQhlLPxFF79t5MODvISZOTMfVKEN0a8telGUkGBSZFfnI61tlKo1O2tVQdyy/DlCJnc9MavNZPd3mK/s5RtPelgIPPXR4wukZobNtE9tPqgeent60l3HNBnBaPl97r2g+IVSe2z0RDpjsLfxzB9GuvlpM8PU6o8BCMk9dJ4di9ncILzBai+IF0/0MhtzFD+6WRqCHpsoScm5p31RONdvhPEZazuJ902yG2W9wTeb82cXCWVj078HkzyroleRlFL4eep3spBnMolvM2a9Cp45mN22porsRlgloR5XszTSD9HUfPwnlED6Hj6SmyvKaQLKc4NGLAVMhcYAZMmrjxKUb7g1fIRGiP7ssFZd6ANAv10Q3H3smPfn7f8io+J7mE83N2R4/dflDEYuFzWe1arCbekyrUeNoAoP2cGqEOY4C+wWnuAUVuEB7+PcmrGSEoGcBzcCH5fh4FrER4v+7t5tQlFo3yGen9Mt3HtsHdyHxrM+MCg7XBfNHhFx2BA9UuI8xUYsx/1h+GBxzpxP1kT7uK/UFkKBXtRXoNx8pmHhOEOWU7xux6lW64H2OQiLlB0df0H9RBc3CKU2AgAAAAASUVORK5CYII=";
			$this->icon_code['lp_menu_drop'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAYAAADEtGw7AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAABtSURBVEhLYxgFgwN4R2UKekXl7gJhEBsqTDnwiM4N8YrO/Q/GUTlBUGHKAciVntG5O0DYJTSNHyo8UoFnVI61V0yuFZRLHQAyEBZ5PpHZllBhygHIMKjB/6hqMAiADKS6oUMPjGbpUUANwMAAAIAtN4uDPUCkAAAAAElFTkSuQmCC";
			
			$this->icon_code['lp_lead_success'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQpSURBVFhH7ZhbiFVVGMf/XcwS1DIhCMHLS5SWgnbTp0yhiSyoxhs+WJBi9RD10AVq7WOYBgrjPCTzJEN5yQd9ERrmaRAE8UFhRgTJl7yGmoalOYyO/v/r+4Y5c2Yf995z9tiLP/izzv7W2mt9Z12+tdbGff5XNuIJVNCEBF8gYDPTNmobtYH6iLZXqIe99D3iR4xn459QB9n4Taa3M/QP9SvLvsGnB7yWUWALHmND37Khy7HhgFNUK/U+1uMZpo96SevZgHkst5bpHuq6v9PNHl/ipUqkgldZ+Ulv5Bj1FvWg52azCRP57tfUFa9jL37Ak57bIAGfstI+6iL1QSHHagmYTLVQ/azrD6YveM4I0ZDaPOrB95ju1sap4D069y/rvcLfL7u1IAnWuXO/xYVRNgFzqAvUJeo5t+YkYD4d62PaHefPaGHt9DI9To1zawZajVoQ9u9muHX0CFgdR0pzMxcD804vlo1CVVosDNhP3WS4et4tdbAgrFDQw+j1kFvLIWAK673I9Cu3DBIwKzqYYJdb6hDwcey9soOpei2gg3X3se4X3TqUBO3RyYCn3ZKCtq8Ep1lo5LEujYA18Y8HDmI9bMGozOduqcG2J/2DVreUg+Kn7cdHWfcjbh2O9fI5qtMtNQS8Gf+BgmhZaCQCulhvb/YCIJqDCuCpI6iulYPa+Msi4LNYp/bhPNh+fZu9PtUtVSQMAspUKLgbAW9Tk/2pPnbCuU4dyh0RAlZFHypY4JYqAn6i+v0pHTty9VIn0v+lI4fkmBwsMiKKHuZgk1uqkIPKzKKCd1j2BsueZuPPunUoA0OlIS5CwLv+3iK3VGHHdGVOckt9AhZSV6lLdHhoXNNisP21iyoWrgI+dB9ecksVg7Fqnlvujhyzk8hV/n4t2hRGFE4UVkZyPAs8xtbtJF1wlKljel40xBrqBP/50K/3BtZ4iWIoBgac8aca2jCGmRq2PW7JhxaLFo3tpTqiddDF4pcjHbds1f/ilhQCdnuhCW7JxwY8xXeOUJepKW4tRsDy2PsVNLslBV0NbYiGnziy0MG2gtf9qRi2zR1m238xHbwdDsMKdlN/l3frykHA0tgxCX9lMhAsc59wG8Tmnq6055k+7tYMEuxj4X46W97BoR5aFNZ7K9ySAw2v7q0JrjFwzHZr+ST40p1rd0sBtCNoLgb8Sc13a3mYc7dYt3acnDe6WvTJw1bWDaqcS5RWaYIdlOb5gcavtdotdG+1CvfzeabnFEMRIsEy6vdYV4Lt0dlSsJXWwkr1jeYW1R57Nw92RFvB9xXn5JhW60rPLRldD+1Ybt8F7Q6xk/qGWhlDlH130alkI9NOptdiWZsq31E5Q0kj6GpoX1W1uesjkBxI01nqZzrdjK0Y62/fY2z3mUYnFlCL+XsR5+lcptnnyvuMOsAd91OP7sjXywsAAAAASUVORK5CYII=";
            $this->icon_code['lp_blank_trophy'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAKQAAACyCAYAAADMOmTHAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6OEQyNDlDQkM5NTAzMTFFOEJFQTI5NDA0NjYwRDlEOUEiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6OEQyNDlDQkQ5NTAzMTFFOEJFQTI5NDA0NjYwRDlEOUEiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo4RDI0OUNCQTk1MDMxMUU4QkVBMjk0MDQ2NjBEOUQ5QSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo4RDI0OUNCQjk1MDMxMUU4QkVBMjk0MDQ2NjBEOUQ5QSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PnIScaMAAEPXSURBVHja7F0HmFTV2X6nz/Ze2WWX3kFQuqioKEHFgsaGJcYeY4vGqIk9RhM11t+SaBJLEo0lRgUbTYqI9LIssLvAsmzvbfrMf75zz71zp+3OshWY73kOszs73Ln33Pd+vWjQyzRlxsU69jKeLSP6jrRsaTAwSIeBQ9pePHbz5vUfbuvuQfR9sAm5bCUjQsc6JfXEQfoCkE76Jz7WgMvOyu34kxrG1PTsujRBHmRnK+C2hvWFJqMORoN2QNylmCgdtJpeYNbGDGm/7LWAxxn8b2rWqNUixugAHA09eholh9vwygdFPXa8vgBkC/1jtblw3flDYNB3AhRDorSh/uS2A5b9ET4kU/QI6cG1HGB7Ywv+t4CHugmwGXr0NBpaDvswnoGsU3BiegXbBXjsDjc27w7j6XQ0SeALOFOmgupiI0AcYPTd5hr5x9ajApCC2umfj5aXhfFRDxND1SG4Z0QVHUh0qKoda7bWKr8eLSKbqxpsTVi2oRpLVhZgwcxwOJ2bPS5RQThoVaCIOhLyeCTw9zu5xbl0VWQPk/iJjT3kzubgf/MnF9OeLMWhGUEX9sPNTvv6Rw+xV/5/HEwS1h01gGQnWztlxsXEJaMfefMwxuZmIT+rk69u2RJhQZ1JEv7CVDePI/jfgj2EAZ89MvrFczWobXLJvxb21FX1pSm6lbbExZ6syx+vxM4SewRTRyE5Gf6v/UM1NhQqHo9qYjhHHSDZSZOc3SYZOB5c+1QVHn6rHnZn5CYfDUQi+q0lzTj1jjLsKFFUpgZ2X3f15Pf0eTSDie4E9jIJIoKhY4/EiFwjpowwIS9Dj/iYjp+RFosbNnvf6n6NrW5+Q/pMGHvoO10dfmbCpKnQ6XTYU7gDlva2oH/zp/r6GpQeCK5DOtjXtVkDL9LBGEZplQPltU64fP9cxsC4r6evvV/CawyUhLpxbKVg4IT4IhQekXungIGxrTcO3q9gYMAky2YwW6lsmWWuqdUEBBq8OoZGWn1Jel3o8+ktMun79gu1jEUYVXZms8XDpJFiIZEvmZzIhxkQHb15HppuAsrEXhLFihKvGj8/AjF6ughSPNrEoqeslV2cy+94I9hLTmaiBm/fZobZGGFH/UGH6z24+mUrF9eMdrH7VN1X3605AhCSuKXYXhZbCT3kv6BnsUqAdThxyyvn6HHTPEMEHf1Av37XjvV7Oa+opwweds+NKgOY7hf5Hd39Ckh2UvTZQWzlQaSSEZsfM0iLE/K1GJapRXq8hlvN1c0efPyDE3vL3UcKUA0ZO2/cZMaIrNCnqDXooTNGQNuTtG63A7/6a4t8H9rVqlQQJtIiRDlZ29Y+AyQDYxx7GcNWDP2ekaDBxTP1OGuiDkmxvof45xon/r7CAatK00hNicPk8XkYOyITWWlxSEmOYda1B3a7HU1NbSivbkbR/hpsL6zEoYomH73mvBP1WHyKnn9nACCZJRmVnhRBUQ8R9xE/Wonicl81kZhDlEkrrG4PbI6gXg67CqDVws3X84BkYMwRYlSTGKPB9afrcQ4Dic7PO1Nc5cY9b9tR1yKdrIlxrvmnT8T8ueMxbiQxVhc0Hhd/5Q+YR/pdw1VMCp+5+XuVNc1Yuf4gvlhZhJJDjYpRQeC/7nQD0v2AaU6Oh84UXNl06+I7vkRNf9h0/ZEWpwnrWj9fdRiP/q2aG40XzInB7PFRGJFrQFaynjMHos37bHjzi2ZsLLTB6erQ/UY3lm7gQQbOxh4BpGxk0M+njNXh1wsNiI8O/C8frnfi5aUOUFhTx5B6wU+m4ZpLT0ZinFFEsWQwCi94CDDSzxoBVnpv864K/OO/u/HjjioJfEw6X3OaAT+dpYdBCBEds3zMSfHBd0SfBKd5VIib4RGX7+lgazx+Npr68539vbeP19nxw9KMlOO7XU5cfMdnqKh14u6fJuLKeXHKJ9ttbjz3fhO+3NAGi83jZ51rkcz2PzY2GlarDQ2NLbDZAqJwJPoPkp3AwOk5IkAyMI4knZGeFjIuLj85eOz5uc8d+O8GCWjD8jPxwJ0XYviQNAY4ZyAYCXjsTQmMLgFCiFf6nFtwT7f0d5F4sHNfHV56dzu2763nHx+cqsHvmJ49Klt6bKMzkqHRakOAMhEu8/CIPO6E1vxYhHue24GMZB0+eSILJoMGrRYP45h1WLnNogQG9Ho9Tpw8BrNmTMLo0UMxOCcTRj89vqamHgWFJVi/YQdWr90Ei0WR3pQFUtiRD1MTAoxkuAwlMD64yIh5E4OXhfzpUwc+2ySBcd6pE3HvbQuZqNZKABRZzByYAnw1dS04XNGA2voWhjk3EuJMjIsaMCQ3gXE/jQqMgmOSpBHc0sPW0jWH8NJ7BWhotnOVgUT4lexBMSfGwBATFVp26FPhMg3qJsfqGsfp+v/vKgfvKgcO/XnOHe/+FuU1Dty/OAmLTonFK5804p2vWxWxnJGejAsXnoEF8+cgpoO9DmCNFis+/WwF/vXBUrS1WUhYuRmPIcd6TViAZGAkK4FCe5q7zjXgwmnBOeO/1jrx2lcOfknnz5+Ku25ewL7MLQDkUkTvtoJSfLmyAD9sOcgA2RrCKavB0JwETJ+UiVOnZmP8iGQOSo0AqKx3atiVNLXa8NSbO7F8gyTGTxqmxeNXxiA9N7Fjhd2UC48uPsIKg9APW0tx+58KkJKgwwu3p+Kul2pR0yhJr8SEWPxs8QKcc/ZMaHQmFWLED5rwEsZq6xrxp+f+jo2bd8lPy24GyqoOASkiJ9PIJll4kh73LAzuUtlb4caNr9m4zkic8cG7zmdg1AgxLYnobQWH8Mo/VmH3vsqOn2tNYDpgXnYcLjwzH+fPzWPWHQTXhFffZK9frC7HH/+2B1a7C1lJGjx/exqG55g6+CIdnKY8/npEKl93GVx3j9ddFTjU/2eS6pqH1qPwgBWzxpvx/S6rcj/OP2cWbrzmHERHm4RhpPM5oIdYBgMkMQ4Pf18j/awJjhs3+64XXvknPl+ySj6D7QyU9R0BkhsxuSkavHWrmekRwa/l/KetaGjzYOSwLPzf09fBYNAqnNHpsOOVv6/ER0u2qK2tKpXjO034Mjl6SFe5ZG4sf/12YztKq53KhqQkmnD1ecOw6MwcqRZHgJEbP+wzRYeace/zO3G42ooYswbP3JqKaWPMoe8h45BuQ0rvAGygSfwwaU9JHa56eBdXgeTkifTUBNx/18WYPGG4+H4VCAVHLCopR+G+Q+y1AvUNLVylSoiPRXZWGiZNGMn0yyFKcZv0f8TP7OY++8LbWPrVGmJGTvbrBrWLSKMCI93JGfTen6814cShwY2E179x4L3VTgYQHd568WYMHsTEq1syStrb2nHvEx9jR6FS+FPO1n72hfYgTnZCxgjheEVynA4PXZuEE4ab8MKHTfjf2ja2QdLdycuKwT3XjMa08UkKGGUx3tJqx6+eL8DWPc3Q6zR4+uYUnHZCaB3HZcwOW8wcD/Toa7vwxTqvV2b6icPx27svQnxslGqfuPLExG4LPlmyAStWb0N5ZX2Hx83OSsXiS8/C/DOnMUAaGfg84rnTwul04s57n8PuPbxor5bhY0cwQI6i40wbrsMzVwf36znZE3T24xaeqnTVJXNww5WnCHnrgt1mw52PfICdheWEfBcZx/7sOET0J1P4OfnVz2Zi4+Frk5EQq8Mf3m3Ap2tbFY558ZmDcNulQxFt1gnx7eLf72CK98Ov7cW3G+pgZJz2vd9mYGi2IQSXjGErMYJERk2tFpz1y22KBb140SzcsPg04SUjcSyJaALiX99bjm9WbmdGjhJ9cwo/o01IPSP9v6xEDSqbPMoxp0wagYd+8zPGPWMUtk/i/WBZLW74xe8ZOLmuupVhhVcA6lS6I0VitPddYAQlNwSjv3zrwNYDbsTHReGxey+AkTzWwq3z7OtfYc2GEpkNb2Zf0NzZhlSUFdBqzcoZe1gAMv4QE9n/WdmKnDQ9fn5OPC5iFt/aHVaek1hQ0oJVm+tw4ph4JDGOypFKpdzs6Tv9pCTsLG7FwUoryuuc+Mn0mOCqFdNzPVqTIvqP5/X56kqs2dbKAXjfL+bjigumCt+wlBPjZhzo3Y/W4JE/fcTEczk3jxlR7QwVYu8ho4Tdvzp2/0gdS6d7SP7qV35uRptNsjWIk36/YQdOmz0BZsFIiN8mJkSjpcWCgj0HuIuZHadSASQ7ICVLpOenaXDL2aFjw4984ICNPReXLJyGmVOGCMvXie83FzG9cbVaUW3pypPKTsYjLow4ajJ7aPTLN1tQXO7EvKnR3EkbbdZiw26muzY78Pl3VRiSHY387ChlA0kkTBoRgw++rUZplRMXzIlFbFSIqAjVLPO6ZU8vLll9BrxJT/J7nv5fDFyP/PUgGlvcWLRgEq6+eLpXP2er9HAdfv3Eh/hm1S6ZKxI33MHu7SF2ryzETFT3z8XuHTGg7H0VHpw2Todzpuhx6lg9vt7mQm19G3YWlODsuZO4rqoR6tbQ/Cx8/Nlq0ivN7P/XsuPY5TtGLBdnTAitWx2ocfMcOaKF8yYq3MbtdspgJDrUlTCRPwmu+gNbpfT7sk3tWPTbCuw55MBVZ8XhP49mMuNFyyxrN379YiHe+aLMe7PZBg9KM2HiCKmicfPe0KFUjdvGnfC9u1yqV5ffe/2/SspasL/cwVQcHW66fLpU/MWXC8vX7sb1976LPcWVXOJBSsjdwlZrJ/eOp6l9sE7yQQ9J1+AvN5u4wbqrsBTvfbBcFKU5ud2RlhyFWdPGyIfg3SG0Qo/jStWcMaHjrGTIEI0dmY2s9HjF4b36h31MH+CqIkXkD3RXr6G0JrYoz56KwpzVjS5c9UQl/ru6DflZBnzzbDYvdSB66YNSPPfPA8z49qZe5mdJrp+qhg6KdYR7yhu2dPu4lHx+9oS5uvv/u7s6+36/vy//UeIbc6blIyZKI3lJGEjeeG8NHn52KaxSdkyjsIKrwrx9vDZ71W4XbCI/gzw2950vSd33PvoOdXX17LscjEs6OIbmnjxO/r8pcqSfWIqOYtRD0kMDcut+SeRMn5yvhPro9bNvdiqc2z/htpvAJCV3PW0KSYzH367HE2zp9Rp8/EQW95lxB/1XVXj67QPcnUAb3W6VTiHapO3YxyK4gWStu3yuyedn+e9wq17dfu+5vA58BQCq94Iu/+P5L7/jd/r9/ufvzQ/w+Vn8/Yvvpayq02fk8wfU6bTj8Re/xjsfb1KDa2tXsnYEl7Ra7cCmEi8Uzpig49iy25l98Ola4a928O+dekK+nGoQQ3mXMiAxMkvTYUJIrcjiOWHsIOXCrRYrNu5QulFU9rQVSOnyJCpEYB6fMC553dPVaLW48dIdaTh3lmS4fLSiFn96t5QXrW/dK4VJ8zI7du3ITvzwl1P16vR7L5y/d3Y8/9XTx/e+V1LWjrIaJ8wmPWZOzoLD4cCDz3yNr1cXyQovGSxFnSVChKBGKXji8Ql+3HCmdD+WLNvOwa9xk9h2ICFGj7ycVPmjcfQp7rTLTwvNUZjVrzhNRw5NFdEYN3buKYdL+oOtt4p+BDBL2NPTzC5s3M4Sm/byx6rwyl1puP/KJJiNGnzIrPL/LKvFwQorqhscvHJx8ghTJ0cVock+IvKpFh+242ClA1X1DgYIenXy3ELKC0lmt2JothEThpkxNt+k5B/2Bq3dLtmcUydkQadx4cFnV2LtpjIZjDu7WWfN9cx9Fb7J2TNG6HhJSjOzrHcUHMCUCUOEo1yDoXlpOHCIf2WMXo6YpMaHZo8FZSKuGR+F2Gi9kjpWdLBOncXRqyS6X5A8mVJe69Rd+GCF8vTJ4ccNBZLOfc38OBg7K5JS9Kneo+Z2N77e0IoVm1qwpcgWKrE1gHRaDSYNN+PKsxJwyqSYHi9qW7WVt1rC7CmZeOzltVjjBeOOHmiJwkvDmtp9r5U8hOTj/q7AhZ2FZZgyPldxhGenK6luJr3skE6K0XRoYXNTPCXWJ3WsvFLJ7m7vCy5DVh4D5WZ6uBVc+d1jSiK+8oyYMGN1vcMhqxkHfOPTWizZYA0JQhKXY4enY3B2IjMqjNy1UlXbir37a3kG/ea9Fr5y0w144CoKiUb1yLlZbG5sL5GqDXburcGy70vlzdjVQ/15OPdqD6J5UqkLAXJPcZWqpYuGWdvR8keMSpBR24GEkA8eE2XwyWNsalHKKBzoIxKgJI4c/5sLjDh5tBbtTIlus3mwt9zDftdBy8ME4XRS7lkO6XQ48e6SOry+1KJ05BiUrEE9Y9wW0dxg5uTBuPSciZg+KZe7XILR/rIG/G/Zbnz81U4cqrbjlmcrcOEpcbjvimQYulkeu3lvO4+iJMab8PlKxSmyJ1Q62JEC0hrkQRyWIYGs9HCD8NJIvuAok7IPWr3MJjrqzNBs8QJSnVTrcDrVYaS+JFKc47cfdGHBFB3io6UnbZjoc+p2uRgcwyj+EpGe7hJZ+A1VLbj/b03YWCxtJKXFDc/Ucp8ceaWG5CThwVvnYvLY7E6PR5+945pZuPaiKXjl3fX4iAHzk+9asKfUhlfvzpAc/uFm8/gla2zaYxXMRGFhxQyMFT14bzjqpPxWf+klvba02YRzXMKSVutWhywkMLVZQ4uvOCEt2i12pdyADhhtUizZvm7szuOe2w4Gf4o8rnC9Tx7REezIl5tZqBX763DjixIYY80aPHSJEaeM0eHfayUwnjt3NP753GVhgVFNCXFmPHDLaXj+t+cimon1ggN2XPdUJS8pUNoJhjo3qF5VP2/dZ1OrOpUMjKU9fG+MasyoKcYkgbSNRJrK+ve4lfvl0cowlaMwwShGGKxW7u30CLHtZnqQgsO+Tp/hXXmpoJ3S4AIB6Q4fkN1YLrsdjeWNuPNNC/ZXu7l4fu1GExiO8OcvJC2GuNyjd5wJo/HIn9k5J+XjzT9chDh2I6gi8O6Xq4XftWuL9NTdB+1qa3hPL9wbyUiOC+SQInmLZ2XJESwCZWubovo5tbJVVFYXGpCywdPIdEaNyvk6KENRRqP6Eo3CAc8NqYJD7m4A8sjJzfRFW30znv7UxisuKSHlxetM/OF97EMH50AXnDkWv7x6Vo9838j8VLzwu3N5XuiPhTbeiayrVHTYwXRb5T5v76Vif24y5wVxI7YIpqeofgKUDY2KTezQyje2tDY0IMcPlg5eVdsGl9OpiOzcTKUTbjT6nvgdKQzSjGDnAQeW/tCu3vweJQpVWhuasWa3E99ud/EKyMcvMyItXsM5I2386GFpuO+mU9CTCRGTRmfinuvn8HN47X9NOFzTNdV9T6lie3qOtG46HE2D/pkwOBCQFQ3S/aAYtjoIQN4FQTa97MgsYSKHLENjEOErO80pElJR3cyAGMMt1HHDlLzCOBqQ1JOhwzCIvLtZRRW+oCNudfPrNsahLCgsjcNdl/R87qO9uZVZ1G68sES6wVedauAVkNuZTktuDSoFfvT208VoEu/5uVwe/LijDLUN7UyPcmBLQTksNinBgRb9Xces6FSm/d921YwgEys0WHT2OCxbV4wN28vwu7fq8dZ96WGf994yBZDW3rghoqGEmRzgY3MCASnr/HnZscKokSytw9VKcphVT08KO5DN6YKp8LAbE/OC+3+YTg2yaQpLapGbYeYHSk82cXAeqmyjI1NH+po+BCR/kIoqfTlkOdMrZd+kSl/qMXLZHXBabPiGccbKRg/nileIEuG/r5Ru+AVnjsHwwSkBbs6nX1+BH7bux5AsAwoPWpRCqmB0+oyhnCP667y00Xf/bDYuv/t9bCuyMTFsx/BB4XXlKvF2pCjtpXvC/RwUlQlW/vJjkXSvxg5NUKpSKVJTXKr4s9u0aqv1+72hN2iw4JI79tZK9T4ie2TeTKW8NLOPRTYPVVY1MfFp78Bm6WFytEj6jlyLfvEMPZcqpPKQlU0VlD+/5MSA/1dQVI2l3+3DG79KwQOL49Hc5uYRJqon+vm5ibjx/GTcuigNJ4yUKiNFJnVQGpGfgtOmD+U/UwF/uHSwyuHzMPcwd9TKGFgwOdCAI3u4tE4k6ExMUVLxyiqaYLE6ZaewRQYk52wrdrpCDgSYMUL66LrNFUqtNB3jnFOy5WKeVHZSfaZLMs5OV8GheKiub9rbkiFDHJI4Y0GZm4f05ovN/3qbBNBTmEWckRLjo/uRRfz0Gyvws5/E8kL8596XUr8WzDDjN1ck4dbz43DTuTH4+XwzpvpEZELrk5cuGM8/sXGvNazuvtRGu6peAXlvRNaIMxmykzSYNiIQkMTs6Dyz0qKQm26GnKm0tVARqjQr0SMDkhIaneVM6dxUEvzqLp9t4E/04eo2JrbrIKcy5aRH44zpCnMc2sdcsl0CZN8kSTitkh2woUi6saTeyB6ItYXSvp01J7BLxv+W70ZTUwsWnxWHTXttWLXNwps2XXVWYJ14uH76E8dlIyk+CuRy/frHzvFVUaeA0Ske5p7kjoTAwRwnTH0JFnt/XyTtzp+VJZU1Cwt70y4lj6NR8aoL85976z/4Pvi5Umku1T9zcbXsoLC0JS55/UVDmSLP/5YmGg30FXGEEMfqC3IJ3WCHUM5lfZusajKm6IGdeYLvPMfWdjteensd7r08gSdNPPlOPRPHHlw4JwojgtSRR0eFB0lSDWZNkb7rq7AA6exNgyafHOLEHRdMCbSKZYlCdN6pWZDTF6n6cN02hUPWK4AUxOsBqFHlrkPBueTiOdKXLV1T5o1jM7RTbculZ+XIHxsjisb6DJBVfQBIav3iFnrd/mrp+0YPkrZvT7n0e/6gJMTHmqBO3Hj1ve8xYYiBV1P+Z0ULqoUhc8W87nfRmDgqU2W8aTpcNU1unz3rQe5Iahp/Mu44x4Bg4fm3lkt+2enjk5GTZhQ9nFzYyLhjSxvXa+2yG0+r0skIYTzJ9tWvHUF1yXNP1HNr22Z34e3/lSh6JHHKmxblM+s7SvbUj+5LQNY0dw5ITzcx61bNL6kQDwBFZtQ67JDcJAFFDV/7Dtbh02V7cM9l8ahvceGV/zah3ephojsB+ZkdW8bheCaHiPYxTW3uTgHZ0KKIbHsPglEj7rVm9igdZo4MRCNF06jQi+imRXmK7kig/GyVUr9fLScD+/t4aAScm/xpS7YEt/KoHR7Rf74pRUVNm2JtU8bGo7eM4mEhIbrz+gCQfHPV4UN11pJZxE6p6cCsW8tw3VPVXLn31djCW24R/SFgyxEHOTwmPxBZabEq096DP76xElfOi8WgVD1vfiD/6dIz4rrCm0OujFQpMEH6qJQYCm+CqN/vjW3uHgek0BsTKDpF3DEYvbhEatM4Y0ISxg+LUVot1jS0Y+VGRVwryR1aP8vVLkCJl790BOU85HOj+hua7vqnvxcqX0Cv44fG4J6rhigGDgNlRl9wSHUy6An5OozJ0bJz1OKnp0k37MNVrTxqs63YhgIf32T4gJQTNtpU/RHlZAG5WzDlNcpmyf6yRuw9UIfrFsRx/e3rHy1oF//32icrcN5vpHXdU1XcBRTAkeXWhEHNHmnFx5r9uL8mpIlE5a6y56qHuCPpHPxm33lu8Fr+tYUubl2Tvnv7ZTJ3lDjke0vK5M5qDepqxmBecNIlmyn755EP7AgWFn7oYiO/1LXb6rB0bRWk3ibSWjQ3HZfNy1Trk6m9zSGbVDo9Pa2v32jCsmcycPLEKC8HUaIl6vulCcJZ/LmMtIKJfJkby8fUqthzRkosjHo9bnmuHk++2+gDFXKIUzMDWtuK7dhzKFCto0hO8IcjFGnE7RSvGt+lajTq6QEwEjukckHN3PE6nD0pUFRTo4A/fCIiWT/J5AacXIJbU2fFh8sqgjrptUH8e3TCVAXu3FHqxmvfBD5Q04ZrMVX4mp76+z4cqmgTpryE3ruuGIwzpibJuzS+F0HJN9cSbLKXqmJtbJ6kr1H9zeAMfQc30v9nFYcUqSomVZ6fnLgsRyXsDqfKWjbg3y9cjisXzcH0qZNxwbwxGDcivUcuWF4kpbyXoRPgk4fqaH1WuxeQzm6CkQ4+lraTdOhfh+iQ9+h/7DyDLCfdhBvOz4K3WYIbL//noHzujf7tdrQhnM6UAcRTk95f68QXmwP1yacuN4IkhsXqwn0vFcJqcylbpWUc8/GbhmLOCQlqUKb3AiD55pLx6/A7RXVH3fuuTMIfb0nFP3+XibREnReI/AZqwluCyIqULUk5ZS9R+CKr69t9AJOUGIW5M4biioWTcM8Np2BEvvRc/vKiBMyfFt0J8DRBl/ohoZg4kU7r/wAFPlQ+4O0ekZhOpofwCYYB6jrnTx9+7+RjRei8HrsxH7wFvCgP/nFXI5auq5OfraIAqdNBJIS6EPDy02c/sweEFZk04ulWtBdFh9rx4Kt7pdnJwvI26D14+rahjFMmyqAcy0A5qNeUSb+UeY3KO0sFX2dMiQpSGqsNe6kBLvtjyYIkypZ/5zVGofVQs0hopnPVhyhFCJZpHUqHPFQhpaBFmzt7oLS8c2N3OaSwCbixes9Co1KSoCbKhyD7g+i2S7IwYXiUwhlbLQ489uYBxQAP1nKnw1pLKj8lNx9xoIfet2OzXxSHUvSpqSld6uotDfjTuweg7l1DoHzy5sFYOCdZ3smR7KKGCbbfbQoVcdBowygh1ajAognjhqqOmZsq/VxSJe0Hzejh/sDiGq6od8zdAkndSF493SL4cbwceFeRNGArJ93ofXg02iA6pAYOd/dURzE0dbQcjQmmN5IRfPtbUiPbOZPisfjsVFUWuxtP/u0gKuu42m+RjecuAVIGPVt1FBy/7z1bACjJN0kzazirXlbN9APRb0ecCG3w7342CDddkKF2FUzoTee5Jqy6UY2q6ZR66aSlUS3ikDqvrjQ+V9q27SJiQ+1CEqI1TG1xoqCopgMuGZwcro6t6VBrk2jSMGNcrO+1aHVSb0e+pGsw6rTdASO5K6ihk3b2aB1uOjNQb6RMsOtftXGPw5BsE1PZcngDMI3wU//7m2p8s6FRFtUFoVIVtWFwIdp1agzdIINSjuXK9MufGHCmaIz/jy+q8PIHh5XnW3p144aFqXjshkG8fyOkPi4n9lYyRlgcUm5RHLCCgJT9rjV4HdlThkjH31jskucBYrpIPln+fXFYgDR1QTQHW5QsXSA45OVnp0n1evJSX4e4Lo0OoXxDnYGRMkVOIC2Nkm4fvsQYUKFKSRM/f1Xqqpwcr8cLd+bx2iJZb9ywqwXP/1uxqos6atWoDVM0EgKpy2ktgfI379nx1TZXgCto1igByiXVeOH9ct7mFx5vS7oFM+Px5v15SE/izDFagDKlxwEZDjfwMWi0nS6tyZuFQyFDmixGro01hdI+nD5euvYlKwphd7qDilvqiUj03ret+HaT11e1pUiLD75z4Z1lTny33aKypv2PoVXWp99K7fAykw1ISTB1qgMnRHe9IE+AcTLZciOYWvLHxUY+K8g/Anb9azZeAkPM5tlfDkJ2ql65guLDVvz6lVK5GzLNqSnr6DvD5uMClMQpq0mn/P1Hdry9yunjn3vqSiPmihvz7pc1eOSvZYyD+PZDHJNnwrsP5WHySH6D6cwnHqleqRb7spO6a4D044odLI3eoHBJwrCcRCAno1BSKk0Za2i2YMnKwqC66HlnjEd2RjzaLG40tXpVn399U4un3ynnXGT1Fik1zUCzXzSBuiAtC1MNPv5K6oL8s4VZ4T1QOk2XOKQQ0xyM9AA+e02gRU33/ua/2HiSNEXonro5GxOGmhUjprzWhl8+d5D3YoJUmFfY2fd2qRRONBatycoZS3cjYfN+N0/9mjFSx1tlEM0dp0N1k9TbZd8hK3aWWHDKCVJTexm9UQw8C2bE8Qn2O6UuCqQwJ1HDUmp+Ge75sM9rZauPZtYoHgCzqfOhnFr2d60xvEiNAC1Fa9w2ibMNzdDgkx+cvE6ErM38dC3Hy4YiN+8+ccFZk9ie6HyOQ6WslyyYjDNPHomZU/KRnZ7Ae1+fOm0YJozKwuSxOZg2aTDmsN/nzRkNrUYb1J3zziebsObHEl6f/dRtwyWHfCeA3FzYjJ3F/Nwb2R43hxGFITFtoKjXnxkYg01wu4WBcbfIC33s+iyccZJSY8Vj5zc+XSpnGVEy9bZwSlyOqDaTXVA9AwOZSyn7qz0augkUWJe5FHWPoJtDLfyoqdKKzS2YMTYaibFa2c3MjZ1Z46MwMseEtTvbKZpCj1YmO24rdWgNE5CEulzyiV19qgqQ0WamSnViM9HMFQKkv8jW6kJyJuKSzuZ6xT3j9miwhV3jzkNu/GSyDuMH63giQVW9jSegzKAuwz6RH8laT0qI4cMCTpqUh4VnTsCsE4fyjsTTTsjHlAmDMWF0tgAZ9fn25bKlFY343bNfcBfb/dcMxphh8YHcWKv34/46bN/XxEDJI3TNbH8bOwCjPKdIPylfiz8tDu5rvPkNm5JS9sDV6Thvdrzy2JAEuOWZQ9hfzi1q4jhb/Qcf9CggBShbGCDowlLrWjw6qr4j61MejkkxZSqFXL3bhUb2tCxd38zEtRk56XqvFU5e1iwj5k2NwdYiK2qbXDoBSh1bTcSROwEkKWXZVNdyyUwvAI2x0Z2Lbeozro8OW2RzMDFLmzikxyHt7bgcqVcN+SMpJY0mnuWlaXi9zc49FRg1LIsBL0Wly2m6tSj4cOejH6K2vhVjBhtx/w2jVeDzB6Hvg1ZW2YbvtvByh3Zqnx0CjKmyNU2dN55ebEK0SRNgwNz4uo37G4nuX5yGRad5x6aTeL712cPYfdAmx823dGV0cbc6TrALszJQkKmXzMx+45dbXYgyaviNov2gJpWnjpW4BsXGv2SgpF7hE4aYRPBDwhu1zztvdhx/snbut8kiPIUdu4F9h7MDQJKMyMxJYf//JD9Adub60Zml5cMF/W9koMGjNZjgbKlTfIaTh+qwdKsTBxggyxgwL5ttQAvj77vZDVu3qQRTJuYhLTU+/IhQiOVwufHbP/4PWwvKOEjefPRExFLgXg4Vhjp/Ic6r6y346nt+3ja2p9UhnN48Pk1dN5643ASTn5Ah2+Hql60oEfmg9y9OxcX+YHyuHLuke+gUYOxSuUS3W6AQYBgwKI/SzJheLFWWFVd5uBuEIiSU4r9ohgGrdrl4EsT6Xe28Uo7EtdHgbT5DN3f2hCjGRY1YzyS2ze4h0zGLHdvKvqMtBCBJ10kjx/RZKketMT6M7mc6wSGD6V/clxfKuDHB43QouiSFDcfl6LBsh4sp9x6e3PyLsw3YxxR9GgK1fO0ejB81CFkZyV2KDKkXhWcfeOoTrNtYzHX1F+4ajpE8Lq4JeZ7+q73dgY+X887MTrafFX5gzBJObw2578i1o/dDBtNAcOULVpQ3yGBMYWD0Jhlb7R7c/kIFthcrYNzWUU/yXgOkn7FDLDqptNajoYKxCXlanjNIsd9FM/Q4WCOJtv0VDnyzsQ1TRpmRmqCDOocwL8OA+dNjUXjQTgox3ZE0dtwowS09foCku5xMqgKNo5AtbEM4wyEJkIa4MG6mXtIraau00s+6aGaMtNYxI8ephBLH5eqwZo+bX+PXTGT/dKYBTW0eHGZK/VerdnEDZ9yoXOEjDV9M7y2pwt2P/JupAIc5SJ66IQuzZ48Ocp46FXf0E9vMgHMw9vavpVIfSLaPZSowUjiXZhRpzp+qx33nB/oZqRXP5c9beSRGMmBScf7JcT5gvOPFSmzea1WD8Yh6hvZokyihV5LWn9RiheHLLZIIHytEOI2LyE7WYt0eF89y/mxtK5LjtdwVJOmV0nHIejxnZgzfmC17bfR2rAAm6ZV2FSBpekTC9BE6nDRMuhQtu2uGaHPnJ0sgMyb6GTQGLwh9Xv24JAOmLjoJrpYaxc+anazh6glxSPLJUS4gidbMJKl8YOP2A1j5fSGSkuIxOCdNAmYHD8Lhqia8+vYyPPPqEjQw0RIfpcHzN2dg9mmTvYALdgzx0EhLdpRreaLD3z7h0TrSzw/SWA+RRM2r0kgHv2OBIQCM9FBd+aINDa0e7tp59Lo0LJgR4wfGKmwstPKBWd0BY5e99l30D5II4ONGyC30wIUGJSumooFZYX+xo75VQiDNovntVSmquTLemhSq0vvtX+rkWhS38PQfFt9DOk86bSRxYNnlY0oKIyObLOz4kZ1si7qnnf977GQszbAe2qZwSiLKH/34Byf+scqJZpE4rBUqnpxbmpochznTR2PCmMEMnKmIizXDZnPysc37Sirw/aZ92LbroGgoJXktHrhqEDJGTVTF4D1Qh186va0uG2ZcvlTODV0HqYaaV4kuPkWPG4OEA+tbPFj8kg2tVgmMlDF16qRoXzC+VM3BKO7Nlu6AsdcA6ScO6AnUpjDR/btFRkwZqlWstQf+ZefcknOYFD1+f0MKJg4zwT+HlKZ4PfRWHZ/oJcfxKZdBuCcSnrjMqIhsEtdh6ZBESRM6uKnBtsoT8DPpkjYGSrfNV82lXMkvmbHz+SZXQHeNcGnyEC2um2vE1OkjYMgY1b1byQB50a1LcLCKPzw0g5L3BrxpngFXzgl0kVHh3NUv23iuKfmQ/3xbGqaPNfuBsUYNxu3yeLjuUK/2dRQinApvE8kKp3Aj5S2SS4iMGFKgs5IkEU79uD9f18b1pEnDTT4TISixdv60GD40aeMenk1CiCOtnh5r/U9n6XlLk7Cd4or1wyxEXXQYeqRKP6MkC5U41BiiYEjOZTecGToWbxcJA/szOZVJL5t/gp470lPitLxIjvZATr6RuSd166MEDWrsReKT0rt+emoi8iZPgz4lv4PzCifapKMnB6t/OMCnL0B0KOsIjFcxMBLoaM+f/2Uapo0xKcCn9+96uQY/9jAYe51DqjilTnBK/lSOY0YIxb7lvMJaxuRv/atVqa+mEcOPXZesSqb10o4SO+57vVbdhQGf3GtGiii4MiXGQR9lCu/EophxGZsXWlzL3FMT3la6rc1wVBTC2VSB7lQKaAxmGNJHwZA2TFj9XfnPGt+v1oprsNbhyReX46NVkuEbCozUG+na/xNgZCrU/92VhvFDjEE4o63HwdjrHNLPCqdZhuQrSWbWmnbpFic3cMhXSU0IiCtUNgLFTLwdrmWi7vs2DMs2YHCGL7fLSNJxg2dfmUN+2rmOM3WYFL4kka3VhXlZbmYfxeQKjmf0zZjxiXYIjght8Awh8TfilvqkXBgYR9PojbwzrMcRpk+YDKX4TBgHTYApbxp0cemB59DZ4pEn/2sQXNJeh+KScmzYbeOd2h5cZAwKxmtesfI+PJ2BURgw27szSrDfAKkCZptwpMczsWVeucuF6iYvmOaMoYpBaXQEd6RvaEcLMwxOGm0SafoqET49Bnr2Hs00pCE9cvgyMTkqvOQKzgTZnppSmLyMC1Mk6jpIWfP+rtGbGbiyGYcj3W8MdAnZ0MWmQcssc110MrRR8ez3dPaZLM4FjVnjOAj1qcPYZ5JDhC+1gR4BvkI8QOqHhY7XehA1NQ34dpOF52/+ZLIvdyR31XWvhgYjd3r/uQZb99nVrp2mnsaIBv1AIrMnXyRGaIZmaEGGSU6K6EHNpMFtb9o4tyQalWvAUzenYnB6oIihCbG/eaOOZ88kx2qYvpOKcUPN4Z+MiQEgbVr3tiScgfAazZHfHgKUf4P74Ia/n9GlevPQF9hV1Iyrn6ziJasf3G324YwUgaFeCB2Bcdd+e7f9jAOKQ6o4Ja1G8iuSCG9o8+go/EYhQMqaofZ2FzBjgCzx7aVu1Da58RkzeKhi0H8w+6A0Pc48KRobmBgpr3Nh6QYL30yatx0WuSyM5aYLJ3lHIlFwIJ1RxZ3kpQuxZJ+gNnyxy5M+xHHpO3V64ZT353x+P/v4H1V/p1c7U/Ga9vI6qHe+auGO7qtOMXCDirt2XrZxzkjJL3/9dTpGDw4JRocAY0tvYaNfAOkXC6+SRfgKJsJbmcp14lAdv4dT2Csl/S7f4eJulG83WtgGebjFp1WJcGoKcM6MGD6lgNwaX/1owUjGVfMzw7S27UwNih+m0rnkm2kSVrUQjTIolciNusxB5y0d8AeENgiA/MGngDDI57S6jsVxyL+La2gsYApgLR9X9zYDJGW5L2Aim2beXP6CjatHZE3TuD41GBta3LjpmWoUSq2g5USJ1t7ERL8CUoDSJUBJil8CpTRtLHFzIFKUh0KPl8w04MdiNx8ASlY2iemZ46J8BrTT5p41NRoHKp28ufuKzRZMGm7kbUzCMm7IYIzLE8aNivMF3OBgHErfMfBkcPuAzxgGx9QHro50Rs69Td7j06Jrq1gFeUjUV0wvJ6BRbcx979pQ2yz5GV+8Iw2Thpl8wfhsNd9LFRjbehsP/Q5IlQhvoFxI9msKWeGUrDCJYuHxGm7wUDYP6TiUe0gunyXr2zA2zyTS5cXFaKncNZpb4DQ+Y/kWCxfnCTFhGDm2OmbcJDHxnRYeODoFhlEFbmMIsaqXxLnyqlOpACpxrxOcW6fi4D7c1egV8f7nUrOBEs6Uy1yz04pSJkX2lrt5118SNH+4MVUZ96wGY7EERvLvbO0LMA4YQKqA2c5ASVGYZCaiDZSkQG4hecQExasn5evARTsT3Ut/aENinA7j8o0+tsPpU6J4yPFQtZM70hfOjpGbYHVMbWVMq89mhk6SCij6QHDIVjC9H6BTGoMDI2xOGELU+6sAQRKIA5atllksy318opSNs4upNo0CXndcnIgL5sT4gPFGJqZFP3IbjiCF7JgBpAClU4jwOJcbUeQaSmZim3xnPKEiSYMLphmwfKeL5x2u2WHl4a3pY8yKIUuckvoxLvmhnY/OoLenjg7H8qbWZiUMlDmS9a3RBTcUfMSxJjxwdHV1mgnUmRrCAHXgv8wm9sUSqTTrd0m+UZIev7o00cfPeMtzNVzCqMBo6cv7P+AAKUDpFv5KM2X6rNvj5pEYGZRUsrBoup5Z4B5e07K92I76ZjdOnhClgJISgXPT9bzd8U5mIS6YGY246DBEN2XvMIsU5hRpoQfA0efEdu3Ql0xUHw74y+FaF5Yz/Zr0xrfuy1CGeVIexwN/qeNDmSA18epzMA5YQKr0yloGTJLH8ev3ujE6R8tdQ7Jonn+CjgOSEmOpzZ6dPdjqBACysrcV2XmirI79h5njzOHf0KZ90l2KzRmgoOuAyr6WHqogREPjKeCQlaLH1Wd7s6Le+boF/17WKocDt/WVzhgQsBroe8s2hna2gpIRnvjQoaSsyfTARUYOTKK/f9mMbzf6iqirxKZT09IuT/Yig4DEnst6dADRzay+Q0uBxtDVpuT6kSSI9yEj4+X//qsEXYp6y+l9TABSEHVia6FuY3/5NrA9IIFSHn/35HsNPHNIJuKYlKRB7wnnbteotRTY9w7jOHsG9g6RL7Xk/ZCcUSanW87R9ALy6X82yHmSdXKuaQSQHXNJ2i2+01+JgjF/evFaE4/wUAjxX996Awnk1pgyQvKvyaN5u0xkGJBOduBjpvnXDKzNIZ2XOPm+d7nzu1NHgjwAU3BI8umSR0KI6r39fTlHC4eEECOtVPm2McgsHQqLLZwq+ST9x2SMFg1Ly2q6OZ6l9RATaP+UxGJ/A5OAWL+DAfFtphh+LyWKhKObi/EgcmrfR98pqmJFV8pVe4v0OLqIWF8sZaYEo8tm6XmzzIOVTt7iLkrUFMuO8ca2HmraSWKRVuxgIHkCEDekC5nn3SQH24KGArZ2sp+7HsWjAjuiPBFWXbdTMaTLB8INPtoAyZEYKrtMblJA1G6VJkMQxQp3j+gx03NE+iUtqu9OGM6AOYx9WW7Pg9PeJPlHm4uZzC1Hd5J/Kd5PNHyQgY8qaZfUH09vx6iPOUBOmXExyV1eNBZs9C2R3OWXABuvChfWN0vvJ0T3koZCVnj9TmkRGKMz2RrETNo0kW+ZGH76mZNxLFu9pA9aKhkAD0tcsQeIojA0ophOZcpIE/fL0l653NBQp7P+cvUcdYBkm0UORCYbpbZwJ+QHGw7uxsPvS0//KZOiFIcvEYlwoozkPrhc0uUIRG1+xqrcOEoTxJkutywMOQqkZ2j1dgt3rY4abOSpZvJerdjCxfY4ts8F/c0p9QMYhHTXqEyTHIkJsgF20nAtqGWLTDSeeNsBN7bsd/HCKXrq7/Qb2r5ul6QnjRvcj3EABXT9dwqfrpawdtZUbyMF2qst+2xU2UkB7als32mzNvb0gM5jgUPS/LzB/m/+a03ofaKk3KdvTvFJzt1aZOMckqoAp2RZmUQ0hl8EdgzRrqI2bC228/yQ82bG+OzZPx7IwB//1cAMHCtxUEIrSaTWCCB9iTvHKPUsoYMJqXUicnPfFUk8a8WoEtUknl4QNUjzJkjtAm2NLXzuddi128cA2Zvb8ManUiTmVCaiUxJ0AQ/yi7en4dzfVKinxkZEdjBA5qdp8datoTnaqQ9ZuBQ8eaLZB4xEby5p5okXlIxx7Vxv9rijzQKXwwFTQhxvvXKsEk2vpQdw8z670no6M3lgmw3ao33TZeO13S968/F3rXhVxGdvPdsQMIuPprtaahsZOK3HJBgdrRZ+fe3tTjz9X2/IlOY+/rDbGgHkkTzg9I/V4QkLkHLfHOoxSfrQ79+RatcvnK7HhdNCcAUm0+3NrfzGuR3OYwKILrsDlpoG2Fva+PU995mdN1QlHy2VLVDM+vYXavnDqu5zLm2Hp9/PXz/QAensJCIm8z3KcF6xpR2ffNdGnXj5ezS5ljo0dPpFDolbkrFjjIsJv657gIln0hVdNi83/Pdap+KRaGzz8BYpVKNEtUl//aIZ//iqBROHGTEix4jkOC3PKRXUb0/ngE30E1MAphIH9G8rrKZgiRaEp1+dZ8S5J+qOaEf0Uebw2kIPBCCyh4l0YqfFN3Hkkw1O/Plzh/rh7srFbOzNUtejlUOSokNDCnTBQBeCo5LSGM3Et+lvKxwYNUiDEZldBJWHknusfBHH5K1ZDANvm4gTcuPM5vDXQvD3lQ78bYXC5A6xVSxcOeTSoYiXQTAjk3hP/p02uq2/wDigOaTgkvowHho59GGhNDUxy5nmq8SY2dY/fLGR607dUrQZIKkJqi6KurL135bRWBLihI52mzJQXk003o0MGKo3ElTK9qT4qDJSj0ULUwB5PFt8aDd1+br+DAO6LYEZGPUmI3RmafUFON0MeC6GNKfV1qHhVVwlhU6ptFVwur0MjOVH2707JgEpQEnXRi0AqSiG92p88CIjBqf23CVrjXrei1Je6AGAepi+QZYyLTetTqw68i68t9qJfzAxLWaGkzK5qzcaQUUA2TPApAwhai+tlwcsXTZbrwxh70miYU1admBytmt0Om4UUS9xjdZ3CDwF3T1uN1seaToYLYYmt9PJARkuUZeP5z5zYG+F8n8oZbyQgdFxtN6vYx6QApQmAUo+uJuGG9HoDup9fjQSTUN4c5kDS7e65PlTBMB9DIhVR/u9Oi4AqQJmhhDjvKbhxKFarluOyz06/I5UcfnBOic+XO/kbWUEUZ+UknBHt0UAOTANnjyhW3IkTh2uxeWzDaBxagORaFgRAfHzTT5ApKyR4v4sWY0AsmeBaRbAzJL3gRqnXjhNh3kT9bzNdH8S9cb8fp+LT3GgoQCqqB4BcD8DYv2xeF+OW0D6ATNXAJMrleS/nMX0S5r9TXOwTYY+AiED3c5SN/cjripwoa7FJyBAgwrLjlUgRgAZXJQTKGlShDIdSAYnTQujuTH+WUPdJYoxbzvoBs0e/y4QhGSs0BzJ8r7sQBYB5MADJ02VpElXabIBJBMBkmp6yK9Jg9vJYk+IDm8bKQRKjmuapkrTYrcfcOFAYEmvS3BDspjrGRDdx9PeRwDZMTBpfwic1AaNXEZBZ9aRvklZNDQ6L94vu73N5uFzAutagRZLyJg8cb8GAcSG4w2EEUB2T6wTQBPESjrCQ1G9Sr0wUJqOFZdNBJD9D9C59Prn21KREKvlMxmb/bpjUDP5pDgt4mN1+OlDSmvlDQOhBnogkj6yBd0iPgymgQGR6ps7ItGVllMEjKFJG9mCbhFPZyit7DzBWu6pg36tzI4A8rgAZHkYpaNiLDCRO7JtEUD2FnFjpKKu81Z45d5WgK7ItkUA2auAbGjpHGM1TcpnnJFtiwCyt4g3DWpp71wK13oBGXHxRADZu4Bst3Vup6jcQRFARgDZa8TdN87Opjto9MySUZKBrZFtiwCyt4iXi3ogNQMN3F0TYMoFoobDbFRcvu2RbYsAsldI3UNx90E/SayLBsx57FXqslbdYI0AMgLIPiHOGlWOb2mIpnGQsr3tVhdsdrePmI9QBJC9Rdx8psmzCumTfBrf1zTYgnLVCEUA2RvEAXa4VoUznW+WWn2zzYebRigCyN4krjzWNqmwpvXJ6VVzyAggI4DsdeLWSmNr6GhNXaPdh5tGKALIXgdkqzpa4zfmrbbR5sNNIxQBZG8Sd+PY1J1+AwCp4NAR2a4IIHub+PgMasnjdvsY3l6R3WTz4aYRigCyN0nxKyq+yNAiOwLICCB7l8Qsby6v95XZgwJSZdREojQRQPYJcWGtZIWrAOlyedDQYg/gphGKALI3iSPRG63xArK+2a705WHc1BLZqggg+wyQlfWuAA6pcopHirsigOwzskncUAak1//d0Gz3EesRigCyL4hbz01yVriKQ1Z7OWSkuCsMijQK6BniumGrxYOXP25CQ2sToGuD2aRFdb0CyIhTPAyKtFLpAZoy42IaQZIWhp65/mhuSB8B5MAHIiU9ToM0JYsT9fKJEqPwhuZnYe/+WjQ2W9V65JZjrQ1zBJADB5AzII1mw9RRZjxxQwpSE1RqeeIcuHVJ+GZtEZ55czXqG9tlUBKntEV2MGLU9CQYh8hg/MWFCXjtnjRfMHLbuwxarQZnzxmBd5/5KTJSYuU9nxjZwQgge5qoLzkmDTPhugXxIUydg0xzlKRzRmosHrnjTPkvsQzQUZEtjIjs7nJF6j9OfcijZQ+FUa8JmChHzevdbo93izXerXa73LKHnF7IFUQKJvURLxNx8QggIxQWEGngUm+O/iLdkubOlEUAGaGOwDiBvaTKv+ekGXDNwhHITDHDZAyu8eh1GphNHWPXanOhotaK77fXYdmGKlhsit+cGt1viwAyQh2CMSNZh+d+kYrRg42AeTDTvqN77HsoAeP59/biizVKy+c6Bsrtx+Oe6yKw61BMD+Y/jzTh/YczmRUttsvDpKs+vse+K4px07lT06FlyujG3TSMAdFZOWMdFWUFLRErO0IyDZc541/uTff9i4vhxH2E9VqGRMCUyXbeHPCnGy4airNnZsq/DjseNz0CyODccZAsPZ6/LTX4hxyVR6gkMZGvT5CAGYTuXjwSZiP/ap3g0hFARoi7dpCVosfIXGPwT7jaAWfDEdjSIkCjiw2qwqcmmnDKlDSf84gAMkLcaT1jbCcjYe3VDJhdrErwCFFPvX90wX3j08Yn+5xHBJAR4vsyNFsaA0s+7q9/bMe3G9vVY4LBfdu2w5JOGTaHVDWv0AbHG7mUjlejMwLIEJoeF5/Cqv7fmjbc/0Yd7nu9Dl9u8C8cdEugtFdJ1nenHFLdlCo4IOOi9T7nEQHk8W3Q6GUg5GdKwCg67E1hLK0Kkc5I+qS1mBk7NV49MTgivaDUBB/EnZqkqAoacT7HDUUyxgOJJ01oGSRDGjQhseZigKyTFumIBDiyqrUG8bNBep8+R01NtYYQItuE5Hgjd5iL89kfAeTxS4M4d8zygmVIlnebctL04YPTI3In/KtpzLlS/3FixJYSiWPyDA2PIvZTEyiCI33l8QTISKTGV1wPhTQXGw9dk4y8TAmUFC4kIJ55UjR+Mj0mILuny2TKFm4fRhaGNY9DAqOqUnYI++7P1nELXpuVMzaqoqygNqJDHl9gJM6YJwNQPd1Vy3bp3FkxDIzR3Qcj556e4EaOik4cZcK00Yq1ncnOb8RxY01GjBiMZSuFfo+N0mLJH7N4bUyvUcwYwJgh/dy4JiQonezt8x4oR3WDIvPJxC/YvP7Dlgggjy6Q0XVRUDiqA8lASlys+AzfBxq0/v4jWUiJHziCg0C5+PeVPvO2IVUwkikfqoKR3j/MgNsQAWT/g5GCz+O6oo6QSJ4/LRqP/iyF/zwQ6b1vWvD6/5rRZu1SA4wGBsqtEUD2HxgpSZHKUjWk68V2IHbNJg1SE3WYM8GMa+bHwWw8OtTpzfts+HxtG0oqnLA7glc80ORZpa2LxCn3Hi338Fhz+4whMFKdy4ePZ2JQ6rHn1ZoywsRXZ3T9H6uxZR930FPG0FEDyKOOQzIuSL4YsogThR6ovgauM1KhfkpC73u0iEO5+6CFlNPlgauLnYGcbg8s3im16rNUF5eRK4mKy1wRQHYdiATAUZAq/iLUc0QArRfWuzMCyPAs5klkBMvvUc4gpWhlpZqRGOcN720pbMC+Q60wGXXQ94HL36jX8YIu2TDSaXtnOw16bdCCMmpCoO/ECktPMWH2JG+ScXObg/es3L6vCeu21aKp1aHmogTKmgggQ4ORYDVdiGbMnJiC6y8YikkjE3vGQX0sEU2d9ZsgBkcjOuqT6nC6sXRtJV75oIg35qc99Xiwrz9LcQd06DArZyz1zjEbDVo8dONY3HnFSGQyrhgBYzDzNEZythMw5eWxdVj7Qxx9VH4cFp6ajd37m3G42kJ7m8L2vbmirMASAaQvdxxNYppE4ou/noK5J6VHQNehJsjUP0Oyn/zTKq1cOiKq4Zk3PRObmMpTWcs7taUxUJYyUEbcPipLmpffnT0jCdOGW6QkWK7m9FG3EY+n776LrsvTA99lTGF3NNFXjNsr/cosgl8X6UT3XhqNxY830qkQo6Kqy30RQEpEm6Eh7vjbxTFdKxE4nslW7gtIzv5ygdYdYf330bk67uPctJf7LzP7A5ADNTzBEx2mjzUzSzaCs/ABWRFEHg+WkoHDpLsvVQCt748ObQMVkDwR8bxZMRGQdYVcrYHShMBoGhT2ISj1zqBXrMa0vr6Ebtur7Cki/2Csykjq7jHpGLyMICNJFzTZwelCyAiJu58a2lH7PZdHUgU9nv7rqhdlMsBg0DMLWsv9lHQmNrsTTS3hj1lUxcjpP7UeIaPrjNmRXlC4ef2H7p7WISf0lrVe1RCZpNFVareSm6fHxnKboeqf3gt0AH7zH3sCkBS4l6Morh4yTZNlsR3KBu7ge/qLPXk6Oa8+Zdiqc3J34xg1R/j/5Xh5R+Rg3DFgGOn/CzAAiJPvy1u28IUAAAAASUVORK5CYII=";


            $this->icon_code['lp_blank_right_quote'] = "data:image/png;base64,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";




            $this->icon_code['lp_def_author'] = "data:image/png;base64,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";


			$this->icon_code['google_login'] = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAVdSURBVGhD7ZlrUFRlGMfPOcssH2waR0tFiMGckMEJnKAUNjBuJgqCFzInE8QmVG7qmDAruCJ3EVyIuEhyqSGM4bY3FmWKBUVrcLp9akKbpM+lgICVPG/voXdphffILnsW9wP/md8H5rzP8/yffW9nWWZRi1rUwgkUUk90ii2AI9x1OMANwT72T9jNjvGgd9gH8D73OyRw/XCcLUIKqQcJsw8hBeMKqZIm2MuOokAGoQAzwWMhhh2GZMkVkDNOJN3CC3IYZ0jEn3woA1SjFsDnwDPVB7nMSpJ+YQQfST6GLcwkzZQ1wFZ2Ei+7ElLGdkLnmVUQz92hmRATiOMG8ZJdSsqKKzgnXQd78KalFLYFeP+MiN4MfxpBNPsXraCtwPtPS8qLI1TNvIA/nQWbCR7Rm+AFB7lfacWeylv/LQ04xN3Bp9EA+pC7DXHsXf64RZsp402wTRP4dKIVE4LfQ/hOqYZixpmkmCU4zayFFEkVXqoTs+Jt0kQB4wLbWLOOWHibwcempAI1MxISPqfwRnaYaojcQzZpghfUOFxG4SzVuCn49WMcMh1kJMxiwWmHQJQqqSd/iivUwywFg+MI6pQiFM9RG+DhlwdeKi+RMPsT9DomoV5HNIUBk+swtYGfaCIMv1ZkOfiREPsUno1vpxsx8gWenaj/lxq/J8hw+xT0L1mBG4FZjfBcxSRyCHay45Zs7GciZJDGUJswAT6TppDhZklRlbZfDLIqT0YVXUpaU1qa/DxJLSw8G3k080bw/vkHbjLLyHCz5HTqJyQmHxQrb5DUwsJmm2eaNwUM0rmTzBDNjDXsKqy9R1ILC3qlfbQGjOAZaSRDzRbNjDVsyW5+QFILCxv9ntaAEfy8mAw1WzQz1hCYpRonqYWFjX5Ha8CIPTQSYF4j9r+0QrNb5l5a2Kzdb/bdBXVDJLWw8CeeS2vACH7+zI/fg8Vl/SS1sOa6EH/+aiWq13tdJMPNEu1yEyL+gvIWzbwpGZXp+SS1sKDvuReFXlHU19xRdMcOdFgVOt6MxH9FUSgUHH8i0cwbcUn7AVVWJriRkKcL74NvTBuYMCxBhbqNKKI9ehql1reGDBdNx8uyL9PMmxKc0zJChs8tvA8SjU0Mfb0cHVaHPtEEz7vt26C50/NNEmK15BXyTR6nrwPNvCmJpQVXSMjcIl+shg3da9CejohZTRhJUIVN1Lavt/qLVX5lqpssSzNBM26Ku7wfKusPCP4/gKov9Z5tNPMz4Ztp7J7/zJyvOSbzP6t9RDM+k7gL5bdImPnS97o6xaq2PqaZn8k+VfikUu9TbckBoEAMd1Hv+2lsa/TjsLwmqnFTPOV9k9mfnJjf7Fd1eitpxoU4qgoZV3b61nR1rRUsWNfjuaq006c2QR06boyLbt2FYkrKqA0YSVQWVpEU89NZjWzQ1Kw5RLVHoSR18GimRnY3R+t3O1vjN5ChlQ0mqUNG+We0mMi2nSiuKhOtTvtxVhNR+Q2/ETvz180ul2XJ2BStuC04VJ+I3NIHppvwz9KNpdTkivO7SV2Xj8cRVcgjWmFbENsYh17N7EG+Z679nVZ2zpvYEEdt3R7uSeqgh7TCtuBEy477GeUZ60l5cdV69eUVWVp/i/eMpZzRyn5pa/NYTsraTlVd3sr3OsInaSasYT/OWaHbYPuf3kyl0bziXKR7wxDTHgE0U5awt3075Os29XV0rFtN0i+8GtSeruX61z4/pgoajqSYFCISH8Mp6qCREt3rTa348iXp7ENNOi/3S3qvnHzdxj65NuDeSfXmP46qgx/ii3IsRR18P10TOJSn8btRod9Q0IDHkrBFLWpRNhfD/AvExD6LqAHXuwAAAABJRU5ErkJggg==";

			$this->icon_code['facebook_login'] = "data:image/svg+xml;utf8;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pgo8IS0tIEdlbmVyYXRvcjogQWRvYmUgSWxsdXN0cmF0b3IgMTkuMC4wLCBTVkcgRXhwb3J0IFBsdWctSW4gLiBTVkcgVmVyc2lvbjogNi4wMCBCdWlsZCAwKSAgLS0+CjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeD0iMHB4IiB5PSIwcHgiIHZpZXdCb3g9IjAgMCA1MTIgNTEyIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCA1MTIgNTEyOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSIgd2lkdGg9IjI0cHgiIGhlaWdodD0iMjRweCI+CjxwYXRoIHN0eWxlPSJmaWxsOiMzODVDOEU7IiBkPSJNMTM0Ljk0MSwyNzIuNjkxaDU2LjEyM3YyMzEuMDUxYzAsNC41NjIsMy42OTYsOC4yNTgsOC4yNTgsOC4yNThoOTUuMTU5ICBjNC41NjIsMCw4LjI1OC0zLjY5Niw4LjI1OC04LjI1OFYyNzMuNzhoNjQuNTE5YzQuMTk1LDAsNy43MjUtMy4xNDgsOC4yMDQtNy4zMTVsOS43OTktODUuMDYxYzAuMjY5LTIuMzQtMC40NzItNC42ODQtMi4wMzgtNi40NCAgYy0xLjU2Ny0xLjc1Ny0zLjgxLTIuNzYzLTYuMTY0LTIuNzYzaC03NC4zMTZWMTE4Ljg4YzAtMTYuMDczLDguNjU0LTI0LjIyNCwyNS43MjYtMjQuMjI0YzIuNDMzLDAsNDguNTksMCw0OC41OSwwICBjNC41NjIsMCw4LjI1OC0zLjY5OCw4LjI1OC04LjI1OFY4LjMxOWMwLTQuNTYyLTMuNjk2LTguMjU4LTguMjU4LTguMjU4aC02Ni45NjVDMzA5LjYyMiwwLjAzOCwzMDguNTczLDAsMzA3LjAyNywwICBjLTExLjYxOSwwLTUyLjAwNiwyLjI4MS04My45MDksMzEuNjNjLTM1LjM0OCwzMi41MjQtMzAuNDM0LDcxLjQ2NS0yOS4yNiw3OC4yMTd2NjIuMzUyaC01OC45MThjLTQuNTYyLDAtOC4yNTgsMy42OTYtOC4yNTgsOC4yNTggIHY4My45NzVDMTI2LjY4MywyNjguOTkzLDEzMC4zNzksMjcyLjY5MSwxMzQuOTQxLDI3Mi42OTF6Ii8+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+Cjwvc3ZnPgo=";

			$this->icon_code['twitter_login'] = "data:image/svg+xml;utf8;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pgo8IS0tIEdlbmVyYXRvcjogQWRvYmUgSWxsdXN0cmF0b3IgMTkuMC4wLCBTVkcgRXhwb3J0IFBsdWctSW4gLiBTVkcgVmVyc2lvbjogNi4wMCBCdWlsZCAwKSAgLS0+CjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiBpZD0iQ2FwYV8xIiB4PSIwcHgiIHk9IjBweCIgdmlld0JveD0iMCAwIDUxMiA1MTIiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDUxMiA1MTI7IiB4bWw6c3BhY2U9InByZXNlcnZlIiB3aWR0aD0iNTEycHgiIGhlaWdodD0iNTEycHgiPgo8cGF0aCBzdHlsZT0iZmlsbDojMDNBOUY0OyIgZD0iTTUxMiw5Ny4yNDhjLTE5LjA0LDguMzUyLTM5LjMyOCwxMy44ODgtNjAuNDgsMTYuNTc2YzIxLjc2LTEyLjk5MiwzOC4zNjgtMzMuNDA4LDQ2LjE3Ni01OC4wMTYgIGMtMjAuMjg4LDEyLjA5Ni00Mi42ODgsMjAuNjQtNjYuNTYsMjUuNDA4QzQxMS44NzIsNjAuNzA0LDM4NC40MTYsNDgsMzU0LjQ2NCw0OGMtNTguMTEyLDAtMTA0Ljg5Niw0Ny4xNjgtMTA0Ljg5NiwxMDQuOTkyICBjMCw4LjMyLDAuNzA0LDE2LjMyLDIuNDMyLDIzLjkzNmMtODcuMjY0LTQuMjU2LTE2NC40OC00Ni4wOC0yMTYuMzUyLTEwOS43OTJjLTkuMDU2LDE1LjcxMi0xNC4zNjgsMzMuNjk2LTE0LjM2OCw1My4wNTYgIGMwLDM2LjM1MiwxOC43Miw2OC41NzYsNDYuNjI0LDg3LjIzMmMtMTYuODY0LTAuMzItMzMuNDA4LTUuMjE2LTQ3LjQyNC0xMi45MjhjMCwwLjMyLDAsMC43MzYsMCwxLjE1MiAgYzAsNTEuMDA4LDM2LjM4NCw5My4zNzYsODQuMDk2LDEwMy4xMzZjLTguNTQ0LDIuMzM2LTE3Ljg1NiwzLjQ1Ni0yNy41MiwzLjQ1NmMtNi43MiwwLTEzLjUwNC0wLjM4NC0xOS44NzItMS43OTIgIGMxMy42LDQxLjU2OCw1Mi4xOTIsNzIuMTI4LDk4LjA4LDczLjEyYy0zNS43MTIsMjcuOTM2LTgxLjA1Niw0NC43NjgtMTMwLjE0NCw0NC43NjhjLTguNjA4LDAtMTYuODY0LTAuMzg0LTI1LjEyLTEuNDQgIEM0Ni40OTYsNDQ2Ljg4LDEwMS42LDQ2NCwxNjEuMDI0LDQ2NGMxOTMuMTUyLDAsMjk4Ljc1Mi0xNjAsMjk4Ljc1Mi0yOTguNjg4YzAtNC42NC0wLjE2LTkuMTItMC4zODQtMTMuNTY4ICBDNDgwLjIyNCwxMzYuOTYsNDk3LjcyOCwxMTguNDk2LDUxMiw5Ny4yNDh6Ii8+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+CjxnPgo8L2c+Cjwvc3ZnPgo=";




		 }
		 
		 // Returns colored string
		 public function listingpro_icon($icon_name = null) {
			 $icon = "";
			 
			 // Check if given foreground color found
			 if (isset($this->icon_code[$icon_name])) {
				$icon .= $this->icon_code[$icon_name];
			 }
			 
			 return $icon;
		 }
	 }
 }
 
?>