<?php
/**
 * Single Product Navigation
 * 
 * @package Botiga_Pro
 */

/**
 * Product navigation init.
 */
function botiga_single_product_navigation_init() {

    if ( ! is_singular( 'product' ) ) {
        return;
    }

    $single_product_navigation = get_theme_mod( 'single_product_navigation', 0 );

    if ( ! $single_product_navigation ) {
        return;
    }

    add_action( 'woocommerce_before_main_content', 'botiga_single_product_navigation', 15 );

}
add_action( 'wp', 'botiga_single_product_navigation_init' );

add_action( 'wp_enqueue_scripts', function(){

    if ( ! is_singular( 'product' ) ) {
        return;
    }

    $single_product_navigation = get_theme_mod( 'single_product_navigation', 0 );

    if( ! $single_product_navigation ) {
        return;
    }

    $inline_script = "
        (function($){
            $( document ).ready(function(){

                $( '.botiga-product-navigation a' ).on( 'mouseover', function(){
                    const elRect = $( this ).find( 'span' )[0];
                    if( ! botiga.helpers.isInViewport( elRect ) ) {
                        $( this ).addClass( 'out-from-viewport' );   
                    }
                });

            });
        })(jQuery);
    ";
    wp_add_inline_script( 'botiga-custom', $inline_script );
} );

/**
 * Product navigation.
 */
function botiga_single_product_navigation() {

    echo '<div class="botiga-product-navigation">';

        $prev_product = get_previous_post();

        if ( $prev_product ) {
        
            $icon  = botiga_pro_get_svg_icon( 'icon-down', false );

            if ( has_post_thumbnail( $prev_product ) ) {
                $image = get_the_post_thumbnail( $prev_product->ID, 'thumbnail' );  
            } else {
                $image = '<img src="'. esc_url( wc_placeholder_img_src( 'thumbnail' ) ) .'" alt="'. esc_attr( $prev_product->post_title ) .'" />';
            }
            
            echo get_previous_post_link( '%link', sprintf( '<i></i><span><figure>%s</figure><h2>%s</h2></span>', $image, '%title' ) );

        }

        $next_product = get_next_post();

        if ( $next_product ) {

            $icon  = botiga_pro_get_svg_icon( 'icon-down', false );

            if ( has_post_thumbnail( $next_product ) ) {
                $image = get_the_post_thumbnail( $next_product->ID, 'thumbnail' );  
            } else {
                $image = '<img src="'. esc_url( wc_placeholder_img_src( 'thumbnail' ) ) .'" alt="'. esc_attr( $next_product->post_title ) .'" />';
            }

            echo get_next_post_link( '%link', sprintf( '<i></i><span><figure>%s</figure><h2>%s</h2></span>', $image, '%title' ) );

        }

    echo '</div>';

}
