<?php
/**
 * Single Product Brand Image
 * 
 * @package Botiga_Pro
 */
require BOTIGA_PRO_DIR . 'inc/classes/class-botiga-product-brand-image-metabox.php';

/**
 * Extend single product elements defaults with new options
 * 
 */
function botiga_pro_single_product_brand_image_default_components( $components ) {
    $components[] = 'botiga_single_product_brand_image';

    return $components;
}
add_filter( 'botiga_default_single_product_components', 'botiga_pro_single_product_brand_image_default_components', 13 );

/**
 * Product brand image callback.
 */
function botiga_single_product_brand_image() {
    
    global $product;

    $post_id = ( ! empty( $product ) ) ? $product->get_id() : get_the_ID();

    if ( empty( $post_id ) ) {
        return;
    }

    $attachment_id = get_post_meta( $post_id, '_botiga_brand_image_id', true );

    if ( empty( $attachment_id ) ) {
        return;
    }

    echo '<div class="botiga-product-brand-image">'. wp_get_attachment_image( $attachment_id, 'medium' ) .'</div>';

}
