<?php
/**
 * Shop Page Header
 * 
 * @package Botiga_Pro
 */

/**
 * Category Post Count
 * Add shop page header category post count
 * 
 */
function botiga_shop_page_header_category_post_count_append( $html, $cat_id ) { 
    $hide_cat_term_count = get_theme_mod( 'shop_archive_header_style_hide_cat_term_count', 0 );
    if( $hide_cat_term_count ) {
        return '';
    }
    
    $cat = get_term( $cat_id, 'product_cat' );

    if ( ! is_wp_error( $cat ) ) {
        return ' ('. $cat->count .')';
    }

    return;
}
add_filter( 'botiga_shop_page_header_category_inner_item_after_name', 'botiga_shop_page_header_category_post_count_append', 10, 2 );

/**
 * Custom CSS
 * 
 */
function botiga_shop_page_header_custom_css( $css ) {
    
    // Background Image
    $background_image = get_theme_mod( 'shop_archive_header_background_image', '' );
    if( $background_image ) {
        $image_url           = wp_get_attachment_image_url( $background_image, 'full' );

        $css .= '.woocommerce-page-header { background-image: url(' . esc_url( $image_url ) . '); }';
        $css .= Botiga_Custom_CSS::get_css( 
            'shop_archive_header_background_size', 
            'cover', 
            '.woocommerce-page-header', 
            'background-size', 
            '' 
        );
        $css .= Botiga_Custom_CSS::get_css( 
            'shop_archive_header_background_position', 
            'center', 
            '.woocommerce-page-header', 
            'background-position', 
            '' 
        );
        $css .= Botiga_Custom_CSS::get_css( 
            'shop_archive_header_background_repeat', 
            'no-repeat', 
            '.woocommerce-page-header', 
            'background-repeat', 
            '' 
        );
    }

    // Border Style
    // We don't have any customizer control for it yet, so for now we just need to force the style
    $css .= '.woocommerce-page-header { border-style: solid; }';

    // Border Color
    $css .= Botiga_Custom_CSS::get_border_color_css( 'shop_archive_header_border_color', 'transparent', '.woocommerce-page-header' );

    // Border Size
    if( method_exists( 'Botiga_Custom_CSS', 'get_dimensions_css' ) ) {
        $css .= Botiga_Custom_CSS::get_dimensions_css( 
            'shop_archive_header_border_size_desktop', 
            '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            '.woocommerce-page-header', 
            'border-width'
        );
    }

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_shop_page_header_custom_css' );