<?php
/**
 * Pagination PPP (Posts Per Page)
 * 
 * @package Botiga_Pro
 */

/**
 * Main hook
 */
function botiga_shop_pagination_ppp_init() {

    $shop_pagination_ppp = get_theme_mod( 'shop_pagination_ppp', 0 );

    if( ! $shop_pagination_ppp ) {
        return;
    }

    add_action( 'woocommerce_before_shop_loop', 'botiga_shop_pagination_ppp', 30 );

}
add_action( 'wp', 'botiga_shop_pagination_ppp_init', 4 );

/**
 * Pagination posts per page query.
 */
function botiga_shop_pagination_ppp_query( $query, $instance ) {

    if ( isset( $_GET['ppp'] ) ) {

        $ppp = sanitize_key( wp_unslash( $_GET['ppp'] ) );

        $query->set( 'posts_per_page', $ppp );
    
        wc_setcookie( 'woocommerce_botiga_pagination_ppp', strval( $ppp ), time() + DAY_IN_SECONDS * 2 );

    }
}
add_action( 'woocommerce_product_query', 'botiga_shop_pagination_ppp_query', 10, 2 );

/**
 * Pagination posts per page.
 */
function botiga_shop_pagination_ppp( $product ) {

    echo '<div class="botiga-pagination-ppp">';

        echo '<div class="botiga-pagination-ppp-view">'. esc_html__( 'View', 'botiga-pro' ) .':</div>';

        $default_ppp = botiga_loop_shop_per_page();

        $loop_ppp   = array();
        $loop_ppp[] = $default_ppp;
        $loop_ppp[] = $default_ppp * 2;

        $loop_ppp = apply_filters( 'botiga_show_all_ppp', $loop_ppp );

        $loop_ppp[] = -1;

        $ppp = ( isset( $_COOKIE['woocommerce_botiga_pagination_ppp'] ) ) ? sanitize_key( wp_unslash( $_COOKIE['woocommerce_botiga_pagination_ppp'] ) ) : $default_ppp;
        $ppp = ( isset( $_GET['ppp'] ) ) ? sanitize_key( wp_unslash( $_GET['ppp'] ) ) : $ppp;

        echo '<ul>';

            if ( ! empty( $loop_ppp ) ) {

                foreach ( $loop_ppp as $value ) {
                    
                    $text = ( strval( $value ) === '-1' ) ? esc_html__( 'All', 'botiga-pro' ) : $value;

                    if ( strval( $value ) === strval( $ppp ) ) {
                        echo '<li class="active">'. esc_html( $text ) .'</li>';
                    } else {
                        echo '<li><a href="'. esc_url( add_query_arg( 'ppp', $value ) ) .'">'. esc_html( $text ) .'</a></li>';
                    }

                }

            }
            
        echo '</ul>';
      
    echo '</div>';

}