<?php
/**
 * Product Image Swap
 * 
 * @package Botiga_Pro
 */

/**
 * Main hook
 */
function botiga_shop_product_image_swap() {
    $shop_product_image_swap = get_theme_mod( 'shop_product_image_swap', 0 );

    if( ! $shop_product_image_swap ) {
        return;
    }

    add_filter( 'botiga_wc_loop_image_wrap_extra_class', function( $class ){ return $class . ' botiga-image-swap'; } );
    add_action( 'woocommerce_before_shop_loop_item_title', 'botiga_template_loop_product_second_thumbnail', 9 );

    add_filter( 'botiga_wc_block_product_loop_image_wrap_extra_class', 'botiga_wc_blocks_product_image_wrapper_extra_class' );
    add_filter( 'botiga_wc_block_product_loop_image_wrap_image_output', 'botiga_wc_blocks_product_image_wrapper_image_output', 10, 2 );
}
add_action( 'wp', 'botiga_shop_product_image_swap' );

/**
 * Render the second product image to 'swatch' effect
 * the second image always will be the first on the product gallery
 */
function botiga_template_loop_product_second_thumbnail( $product = null, $echo = true ) {
    if( ! $product ) {
        global $product;
    }

    $gallery_image_ids = $product->get_gallery_image_ids();

    if ( ! empty( $gallery_image_ids ) ) {
        $gallery_first_image_id = $gallery_image_ids[0];

        if( $echo ) {
            echo wp_get_attachment_image( $gallery_first_image_id, 'woocommerce_thumbnail', false, array( 'class' => 'botiga-image-to-swap' ) );
        } else {
            return wp_get_attachment_image( $gallery_first_image_id, 'woocommerce_thumbnail', false, array( 'class' => 'botiga-image-to-swap' ) );
        }
    }
}

/**
 * Inject the image swap html content on WooCommerce blocks
 */
function botiga_wc_blocks_product_image_wrapper_extra_class( $class ) {
    $class .= ' botiga-image-swap';
    return $class;
}


function botiga_wc_blocks_product_image_wrapper_image_output( $output, $product ) {
    $output .= botiga_template_loop_product_second_thumbnail( $product, false );
    return $output;
}

/**
 * Custom CSS
 * The purpose is avoid unnused CSS when this feature is not enabled.
 */
function botiga_image_swap_custom_css( $css ) {
    $shop_product_image_swap = get_theme_mod( 'shop_product_image_swap', 0 );

    if( ! $shop_product_image_swap ) {
        return $css;
    }

    $css .= '
    .botiga-image-swap img {
        position: relative;
        z-index: 1;
    }
    
    .botiga-image-swap .botiga-image-to-swap {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        -o-object-fit: cover;
            object-fit: cover;
        -o-object-position: center;
            object-position: center;
        z-index: 0;
        opacity: 0;
        -webkit-transition: ease opacity 300ms;
        transition: ease opacity 300ms;
    }

    .botiga-image-swap .botiga-wishlist-button {
        z-index: 2;
    }

    ul.wc-block-grid__products li.wc-block-grid__product:hover img, 
    ul.wc-block-grid__products li.product:hover img, 
    ul.products li.wc-block-grid__product:hover img, 
    ul.products li.product:hover img {
        opacity: 1 !important;
    }

    ul.wc-block-grid__products li.wc-block-grid__product:hover .botiga-image-to-swap, 
    ul.wc-block-grid__products li.product:hover .botiga-image-to-swap, 
    ul.products li.wc-block-grid__product:hover .botiga-image-to-swap, 
    ul.products li.product:hover .botiga-image-to-swap {
        z-index: 2;
    }';

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_image_swap_custom_css' );