<?php
/**
 * Grid & List View
 * 
 * @package Botiga_Pro
 */

/**
 * Main hook
 */
function botiga_shop_grid_list_view() {

    $shop_grid_list_view = get_theme_mod( 'shop_grid_list_view', 0 );

    if( ! $shop_grid_list_view ) {
        return;
    }

    add_filter( 'theme_mod_shop_archive_layout', 'botiga_shop_archive_layout_option_change', 30 );
    add_action( 'woocommerce_before_shop_loop', 'botiga_shop_grid_list_view_buttons', 30 );
    add_action( 'wp_enqueue_scripts', 'botiga_shop_grid_list_view_scripts' );

}
add_action( 'wp', 'botiga_shop_grid_list_view', 5 );

/**
 * Shop grid view scripts
 */
function botiga_shop_grid_list_view_scripts() {

    if ( is_shop() || is_product_tag() || is_product_category() ) {
        wp_enqueue_script( 'botiga-grid-list-view', BOTIGA_PRO_URI . 'assets/js/botiga-grid-list-view.min.js', array(), BOTIGA_PRO_VERSION, true );
    }

}

/**
 * Shop layout option change
 */
function botiga_shop_archive_layout_option_change( $value ) {

    global $botiga_archive_layout;

    $botiga_archive_layout = $value;

    if ( isset( $_GET['view'] ) ) {
        return sanitize_key( wp_unslash( $_GET['view'] ) );
    }

    return $value;

}

/**
 * Add grid list view buttons
 */
function botiga_shop_grid_list_view_buttons( $product ) {

    global $botiga_archive_layout;
    
    $layout = get_theme_mod( 'shop_archive_layout', 'product-grid' );
    $view   = ( isset( $_GET['view'] ) ) ? sanitize_key( wp_unslash( $_GET['view'] ) ) : '';

    echo '<div class="botiga-grid-list-view">';

        $list_active = ( $layout === 'product-list' ) ? ' active' : '';
        $grid_active = ( in_array( $layout, array( 'product-grid', 'product-masonry' ) ) ) ? ' active' : '';
        
        if ( $botiga_archive_layout !== 'product-list' ) {
            $layout = $botiga_archive_layout;
        } else {
            $layout = 'product-grid';
        }

        echo '<a href="#" role="button" class="botiga-list-view'. esc_attr( $list_active ) .'" data-layout="product-list" title="'. esc_attr__( 'List view', 'botiga-pro' ) .'">'. botiga_pro_get_svg_icon( 'icon-list', false ) .'</a>';
        echo '<a href="#" role="button" class="botiga-grid-view'. esc_attr( $grid_active ) .'" data-layout="'. esc_attr( $layout ) .'" title="'. esc_attr__( 'Grid view', 'botiga-pro' ) .'">'. botiga_pro_get_svg_icon( 'icon-grid', false ) .'</a>';
        
    echo '</div>';

}