<?php
/**
 * Quantity Input Styles
 * 
 * @package Botiga_Pro
 */

/**
 * Add quantity input style class to the body tag.
 *
 */
function botiga_woocommerce_quantity_input_body_class( $classes ) {
    $qty_style = get_theme_mod( 'shop_general_quantity_style', 'style1' );

	$classes[] = 'quantity-button-' . esc_attr( $qty_style );

    // position absolute
    if( in_array( $qty_style, array( 'style2', 'style3', 'style7' ) ) ) {
        $classes[] = 'quantity-button-style-abs-pos';
    }

    // arrows
    if( in_array( $qty_style, array( 'style3', 'style7', 'style9' ) ) ) {
        $classes[] = 'quantity-button-style-arrows';
    }

	return $classes;
}
add_filter( 'body_class', 'botiga_woocommerce_quantity_input_body_class' );