<?php
/**
 * Masonry Layout
 * 
 * @package Botiga_Pro
 */

/**
 * Enqueue css and js
 */
function botiga_masonry_layout_enqueue_scripts() {

    if ( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() ) {

        $layout = get_theme_mod( 'shop_archive_layout', 'product-grid' );

        if ( $layout !== 'product-masonry' ) {
            return;
        }

        wp_enqueue_script( 'jquery' );
        wp_enqueue_script( 'jquery-masonry' );
        wp_enqueue_script( 'botiga-masonry-layout', BOTIGA_PRO_URI . 'assets/js/botiga-masonry-layout.min.js', array(), BOTIGA_PRO_VERSION, true );
    
    }

}
add_action( 'wp_enqueue_scripts', 'botiga_masonry_layout_enqueue_scripts' );
