<?php
/**
 * Side Mini Cart
 * 
 * @package Botiga_Pro
 */

/**
 * Enqueue css and js
 */
function botiga_side_mini_cart_enqueue_scripts() {

    if( is_cart() || is_checkout() ) {
        return;
    }

    $mini_cart_style = get_theme_mod( 'mini_cart_style', 'default' );
    if( $mini_cart_style !== 'side' ) {
        return;
    }

    wp_enqueue_style( 'botiga-side-mini-cart', BOTIGA_PRO_URI . 'assets/css/botiga-side-mini-cart.min.css', array(), BOTIGA_PRO_VERSION );
    wp_enqueue_script( 'botiga-side-mini-cart', BOTIGA_PRO_URI . 'assets/js/botiga-side-mini-cart.min.js', array(), BOTIGA_PRO_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'botiga_side_mini_cart_enqueue_scripts' );

function botiga_side_mini_cart_output() { 

    if( is_cart() || is_checkout() ) {
        return;
    }

    $mini_cart_style = get_theme_mod( 'mini_cart_style', 'default' );
    if( $mini_cart_style !== 'side' ) {
        return;
    } 
    
    $side_mini_cart_ajax_addtc_open = get_theme_mod( 'side_mini_cart_ajax_addtc_open', 1 ); ?>

    <div class="botiga-side-mini-cart"<?php echo ( $side_mini_cart_ajax_addtc_open ? ' data-auto-open="1"' : '' ); ?>>
        <div class="botiga-side-mini-cart__body">
            <a href="#" class="botiga-side-mini-cart__close-button" title="<?php echo esc_attr__( 'Close the side mini cart', 'botiga-pro' ); ?>" onclick="botiga.toggleClass.init(event, this, 'side-mini-cart-toggle');" data-botiga-selector=".botiga-side-mini-cart" data-botiga-toggle-class="show">
                <i class="ws-svg-icon icon-cancel"><?php echo botiga_pro_get_svg_icon( 'icon-cancel' ); ?></i>
            </a>

            <?php 
            do_action( 'botiga_before_mini_cart_title' );

            $instance = array(
                'title' => apply_filters( 'botiga_mini_cart_title', esc_html__( 'Your Cart', 'botiga-pro' ) )
            );

            do_action( 'botiga_after_mini_cart_title' );

            the_widget( 'WC_Widget_Cart', $instance, array(
                'before_title' => '<div class="widgettitle">',
                'after_title'  => '</div>'
            )  ); ?>

        </div>
    </div>

    <?php
}
add_action( 'wp_body_open', 'botiga_side_mini_cart_output' );

/**
 * Floating Mini Cart Icon
 * 
 */
function botiga_floating_mini_cart_icon_output() {
    if( is_cart() || is_checkout() ) {
        return;
    }

    $mini_cart_style = get_theme_mod( 'mini_cart_style', 'default' );
    if( $mini_cart_style !== 'side' ) {
        return;
    }

    $enabled = get_theme_mod( 'side_mini_cart_floating_icon', 0 );
    if( ! $enabled ) {
        return;
    }

    $display       = get_theme_mod( 'side_mini_cart_floating_icon_display', 'cart-not-empty' );
    $icon          = get_theme_mod( 'side_mini_cart_floating_icon_icon', 'icon-cart' ); 
    
    ob_start(); ?>

    <a href="#" class="botiga-floating-mini-cart-icon" title="<?php echo esc_attr__( 'Floating mini cart button', 'botiga-pro' ); ?>" data-display="<?php echo esc_attr( $display ); ?>">
        <div class="botiga-floating-mini-cart-icon-counter">0</div>
        <div class="botiga-floating-mini-cart-icon-icon">
            <?php
                if ( $icon === 'icon-custom' ) {
                    $image_id = get_theme_mod( 'side_mini_cart_floating_icon_custom_image', 0 );
                    echo botiga_get_image( $image_id, apply_filters( 'botiga_side_mini_cart_floating_icons_image_size', 'botiga-header-icons' ) );
                } else {
                    echo botiga_pro_get_svg_icon( $icon );
                }
            ?>
        </div>
    </a>

    <?php
    $output = ob_get_clean();
    
    echo apply_filters( 'botiga_floating_mini_cart_icon_output', $output );
}
add_action( 'botiga_after_site', 'botiga_floating_mini_cart_icon_output' );

/**
 * Floating Mini Cart Icon
 * Custom CSS
 * 
 */
function botiga_floating_mini_cart_icon_custom_css( $css ) {
    $mini_cart_style = get_theme_mod( 'mini_cart_style', 'default' );
    if( $mini_cart_style !== 'side' ) {
        return $css;
    }

    $enabled = get_theme_mod( 'side_mini_cart_floating_icon', 0 );
    if( ! $enabled ) {
        return $css;
    }

    $icon_size     = get_theme_mod( 'side_mini_cart_floating_icon_size', 18 );
    $position      = get_theme_mod( 'side_mini_cart_floating_icon_position', 'right' ) === 'right' ? 'right' : 'left';

    $transform     = $position === 'right' ? '20' : '-20';

    $css .= "
        .botiga-floating-mini-cart-icon {
            position: fixed;
            font-size: ${icon_size}px;
            z-index: 999;
            opacity: 0; 
            visibility: hidden;
            -webkit-transform: translate3d(${transform}px, 0, 0);
            transform: translate3d(${transform}px, 0, 0);
            -webkit-transition: ease opacity 300ms, ease transform 300ms;
            transition: ease opacity 300ms, ease transform 300ms;
        }

        .botiga-floating-mini-cart-icon.show {
            opacity: 1;
            visibility: visible;
            -webkit-transform: none;
            transform: none;
        }

        .botiga-floating-mini-cart-icon:hover {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

        .botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-counter {
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: -0.9em;
            left: -0.9em;
            border-radius: 35px;
            font-size: .6em;
            width: 1.9em;
            height: 1.9em;
            padding: 1.1em;
        }

        .botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon {
            display: flex;
        }

        .botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon svg {
            width: 1.7em;
            height: 1.7em;
            padding: 0.9em;
            box-sizing: content-box;
        }
    ";

    // Responsive Corner Offset and Position
    $devices 	= array( 
        'desktop' 	=> '@media (min-width: 992px)',
        'tablet'	=> '@media (min-width: 576px) and (max-width:  991px)',
        'mobile'	=> '@media (max-width: 575px)'
    );

    $defaults = array(
        'desktop' => 30,
        'tablet'  => 30,
        'mobile'  => 30
    );

    foreach ( $devices as $device => $media ) {
        $mod = get_theme_mod( 'side_mini_cart_floating_icon_corner_offset_' . $device, $defaults[$device] );
        $css .= "
            $media { 
                .botiga-floating-mini-cart-icon {
                    bottom: ${mod}px;
                    $position: ${mod}px;
                }
            }
        ";
    }

    // Icon Color
    $icon = get_theme_mod( 'side_mini_cart_floating_icon_icon', 'icon-cart' );
    if( $icon === 'icon-cart2' ) {
        $css .= Botiga_Custom_CSS::get_stroke_css( 'side_mini_cart_floating_icon_icon_color', '#FFF', '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon svg' );
    } else {
        $css .= Botiga_Custom_CSS::get_fill_css( 'side_mini_cart_floating_icon_icon_color', '#FFF', '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon svg' );
    }

    // Background Color
    $css .= Botiga_Custom_CSS::get_background_color_css( 'side_mini_cart_floating_icon_background_color', '#212121', '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon' );

    // Counter Color
    $css .= Botiga_Custom_CSS::get_color_css( 'side_mini_cart_floating_icon_counter_color', '#FFF', '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-counter' );

    // Counter Background Color
    $css .= Botiga_Custom_CSS::get_background_color_css( 'side_mini_cart_floating_icon_counter_background_color', '#757575', '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-counter' );

    // Border Radius
    $radius = get_theme_mod( 'side_mini_cart_floating_icon_border_radius', 35 );
    $css .= ".botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon { border-radius: ${radius}px; }";

    // Display Shadow
    $box_shadow = get_theme_mod( 'side_mini_cart_floating_icon_shadow', 0 );
    if( $box_shadow ) {
        $css .= '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-icon { box-shadow: inset 0 0 2px rgb(0 0 0 / 3%), 0 4px 10px rgb(0 0 0 / 17%); }';
    }

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_floating_mini_cart_icon_custom_css' );

/**
 * Floating Mini Cart Quantity
 */
function botiga_floating_mini_cart_quantity( $html, $cart_item, $cart_item_key ) {

    $enabled = get_theme_mod( 'enable_mini_cart_quantity', 0 );

    if ( ! $enabled ) {
        return $html;
    }

    $quantity = '';
    $product  = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

    if ( $product && ! $product->is_sold_individually() ) {

        $quantity .= '<div class="quantity-wrap">';
        $quantity .= woocommerce_quantity_input(
            array(
                'input_name'  => $cart_item_key,
                'input_value' => $cart_item['quantity'],
                'max_value'   => $product->get_max_purchase_quantity(),
            ),
            $product,
            false
        );
        $quantity .= '</div>';

    }

    return $quantity . $html;
}
add_filter( 'woocommerce_widget_cart_item_quantity', 'botiga_floating_mini_cart_quantity', 10, 3 );

/**
 * Update Floating Mini Cart Quantity
 */
function botiga_update_floating_mini_cart_quantity() {

    $key = isset( $_POST['cart_item_key'] ) ? sanitize_text_field( wp_unslash( $_POST['cart_item_key'] ) ) : '';
    $qty = isset( $_POST['quantity'] ) ? sanitize_text_field( wp_unslash( $_POST['quantity'] ) ) : '';

    // qty as number
    $qty = ( $qty !== '' ) ? $qty + 0 : 0;

    $product_id = 0;

    if ( ! empty( $key ) ) {

        $cart_items = WC()->cart->get_cart();

        if ( ! empty( $cart_items ) ) {
            foreach ( $cart_items as $cart_item_key => $cart_item ) {
                if ( $cart_item_key === $key ) {
                    $product_id = $cart_item['product_id'];
                }
            }
        }

        if ( ! empty( $product_id ) ) {

            $max_purchase_quantity = wc_get_product( $product_id )->get_max_purchase_quantity();

            // Quantity step control validation
            if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'quantity-step-control' ) ) {

                // meta
                $qty_min_meta  = get_post_meta( $product_id, '_botiga_quantity_min', true );
                $qty_max_meta  = get_post_meta( $product_id, '_botiga_quantity_max', true );
                $qty_step_meta = get_post_meta( $product_id, '_botiga_quantity_step', true );

                // option
                $qty_min_opt  = get_theme_mod( 'shop_general_quantity_min', '' );
                $qty_max_opt  = get_theme_mod( 'shop_general_quantity_max', '' );
                $qty_step_opt = get_theme_mod( 'shop_general_quantity_step', '' );

                // maybe meta/option
                $qty_min  = ( $qty_min_meta !== '' ) ? $qty_min_meta : $qty_min_opt;
                $qty_max  = ( $qty_max_meta !== '' ) ? $qty_max_meta : $qty_max_opt;
                $qty_step = ( $qty_step_meta !== '' ) ? $qty_step_meta : $qty_step_opt;

                // product max quantity
                if ( $qty_max === '' && $max_purchase_quantity !== -1 ) {
                    $qty_max = $max_purchase_quantity;
                }

                // sanitize as number
                $qty_min  = ( $qty_min !== '' ) ? $qty_min + 0 : 0;
                $qty_max  = ( $qty_max !== '' ) ? $qty_max + 0 : 0;
                $qty_step = ( $qty_step !== '' ) ? $qty_step + 0 : 0;

                // extra check for float/int and min/max
                if ( ( is_float( $qty_step ) && ( is_float( $qty ) || is_int( $qty ) ) ) || ( is_int( $qty_step ) && is_int( $qty ) ) ) {
                    if ( $qty >= $qty_min && ( $qty_max === -1 || $qty <= $qty_max ) ) {
                        WC()->cart->set_quantity( $key, $qty, true );
                    } else if ( $qty > $qty_max ) {
                        WC()->cart->set_quantity( $key, $qty_max, true );
                    }
                }

            } else {

                // check max quantity
                $qty = ( $qty > $max_purchase_quantity && $max_purchase_quantity !== -1 ) ? $max_purchase_quantity : $qty;
                WC()->cart->set_quantity( $key, $qty, true );

            }

        }

    }

    WC_AJAX::get_refreshed_fragments();

}
add_action( 'wp_ajax_botiga_update_floating_mini_cart_quantity', 'botiga_update_floating_mini_cart_quantity' );
add_action( 'wp_ajax_nopriv_botiga_update_floating_mini_cart_quantity', 'botiga_update_floating_mini_cart_quantity' );
