<?php
/**
 * WooCommerce Breadcrumb
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_wc_breadcrumb_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/wc-breadcrumb/block.json',
        array(
            'render_callback' => 'botiga_wc_breadcrumb_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_wc_breadcrumb_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_wc_breadcrumb_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() || is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    if( ! $edit_mode ) {
        woocommerce_breadcrumb();
    } else { ?>
        <nav class="woocommerce-breadcrumb" style="margin: 0;">
            <a href="#" style="pointer-events: none;"><?php echo esc_html__( 'Home', 'botiga-pro' ); ?></a>&nbsp;/&nbsp;<a href="#" style="pointer-events: none;"><?php echo esc_html__( 'Category', 'botiga-pro' ); ?></a>&nbsp;/&nbsp;<?php echo esc_html__( 'Product Title', 'botiga-pro' ); ?>
        </nav>
        <?php
    }
    $output = ob_get_clean();

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-wc-breadcrumb"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}