<?php
/**
 * WooCommerce Single Product Tabs
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_tabs_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-tabs/block.json',
        array(
            'render_callback' => 'botiga_single_product_tabs_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_tabs_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_tabs_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    global $post;
    $post = Botiga_Templates_Builder_Gutenberg_Helper::get_first_post();
    setup_postdata( $post );

    if( ! $edit_mode ) {
        woocommerce_output_product_data_tabs();
    } else { ?>

        <div class="woocommerce-tabs wc-tabs-wrapper" style="margin: 0;">
            <ul class="tabs wc-tabs" role="tablist">
                <li class="description_tab active" id="tab-title-description" role="tab" aria-controls="tab-description">
                    <a href="#tab-description" style="pointer-events: none;"><?php echo esc_html__( 'Description', 'botiga-pro' ); ?></a>
                </li>
                <li class="additional_information_tab" id="tab-title-additional_information" role="tab" aria-controls="tab-additional_information">
                    <a href="#tab-additional_information" style="pointer-events: none;"><?php echo esc_html__( 'Additional Information', 'botiga-pro' ); ?></a>
                </li>
            </ul>
            <div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--description panel entry-content wc-tab" id="tab-description" role="tabpanel" aria-labelledby="tab-title-description">
                <p>Cras mattis consectetur purus sit amet fermentum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum id ligula porta felis euismod semper. Maecenas faucibus mollis interdum.</p>
            </div>
        </div>
        
        <?php
    }

    wp_reset_postdata();
    $output = ob_get_clean();

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-tabs"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}