<?php
/**
 * WooCommerce Single Product Rating
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_rating_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-rating/block.json',
        array(
            'render_callback' => 'botiga_single_product_rating_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_rating_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_rating_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    global $post;
    $post = Botiga_Templates_Builder_Gutenberg_Helper::get_first_post();
    setup_postdata( $post );

    woocommerce_template_single_rating();

    wp_reset_postdata();
    $output = ob_get_clean();

    // Placeholder content if output is empty
    if( $edit_mode && empty( $output ) ) {
        ob_start(); ?>

        <div class="woocommerce-product-rating">
            <div class="star-rating">
                <span style="width:80%"><?php echo esc_html__( 'Rated 4 out of 5', 'botiga-pro' ); ?></span>
            </div>
            <a href="#reviews" class="woocommerce-review-link" rel="nofollow"><?php echo esc_html__( 'Reviews (1)', 'botiga-pro' ); ?></a>
        </div>

        <?php
        $output = ob_get_clean();
    }

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-rating"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}