<?php
/**
 * WooCommerce Single Product Price
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_price_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-price/block.json',
        array(
            'render_callback' => 'botiga_single_product_price_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_price_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_price_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    global $post;
    $post = Botiga_Templates_Builder_Gutenberg_Helper::get_first_post();
    setup_postdata( $post );

    woocommerce_template_single_price();

    wp_reset_postdata();
    $output = ob_get_clean();

    // Placeholder content if output is empty
    if( $edit_mode && empty( $output ) ) {
        ob_start(); ?>

        <p class="price"><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">$</span>100.00</span></p>

        <?php
        $output = ob_get_clean();
    }

    // Wrap the output with a product gallery summary div
    $output = '<div class="product-gallery-summary" style="margin-bottom: 0;">' . $output . '</div>';

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-price"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}