import { __ } from '@wordpress/i18n';

import { useState } from '@wordpress/element';

import {
	__experimentalBoxControl as BoxControl
} from '@wordpress/components';

/**
 * Dimensions Custom Component
 * 
 */
export default function BotigaDimensions( props ) {
    const { attributes, setAttributes } = props;
    const { 
        customCss
    } = attributes;
    const idPrefix = props.idPrefix ? props.idPrefix : 'dimensions';
    const typeCapitalized = props.type.charAt(0).toUpperCase() + props.type.slice(1);

    // Custom CSS Selector
    const customCssSelector = props.customCssSelector ? props.customCssSelector : '{{WRAPPER}}';

    // Defaults
    let defaults = {
        dimensions: {
            top: 0,
            left: 0,
            right: 0,
            bottom: 0
        }
    }

    if( typeof customCss[ idPrefix + typeCapitalized ] !== 'undefined' ) {
        defaults.dimensions = customCss[ idPrefix + typeCapitalized ].value;
    }

    return (
        <div className={ `botiga-dimensions-control` }>
            <span style={ { display: 'block', marginBottom: '-18px' } }>{ props.label }</span>
            <BoxControl
                label={ false }
                values={ defaults.dimensions }
                isLinked={ false }
                onChange={ ( values ) => {
                    const css = {
                        [idPrefix + typeCapitalized]: {
                            selector: customCssSelector,
                            props: `${ props.type }: ${ values.top } ${ values.right } ${ values.bottom } ${ values.left } !important;`,
                            value: values
                        }
                    };

                    setAttributes( { customCss: { ...customCss, ...css } } )
                } }
            />
        </div>
    );
}
