import { __ } from '@wordpress/i18n';

import { useState } from '@wordpress/element';

import {
	ColorPicker,
	Button,
	Popover
} from '@wordpress/components';

/**
 * Spacing Custom Component
 * 
 */
export default function BotigaColorPicker( props ) {
    const { attributes, setAttributes } = props;
    const { 
        customCss
    } = attributes;
    const idPrefix = props.idPrefix ? props.idPrefix : 'color';

    // Type
    const css_prop = props.cssProp ? props.cssProp : 'color';

    // Custom CSS Selector
    const customCssSelector = props.customCssSelector ? props.customCssSelector : '{{WRAPPER}}';

    // Popover State (default)
    const [ isDefaultVisible, setIsDefaultVisible ] = useState( false );
    const toggleDefaultVisible = () => {
        setIsDefaultVisible( ( state ) => ! state );
    };

    // Popover State (hover)
    const [ isHoverVisible, setIsHoverVisible ] = useState( false );
    const toggleHoverVisible = () => {
        setIsHoverVisible( ( state ) => ! state );
    };

    // Color Picker Display Style
    let colorPickerStyle = {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginBottom: '15px'
    };

    if( props.displayStyle === 'stacked' ) {
        colorPickerStyle[ 'flexDirection' ] = 'column';
    }

    // Defaults
    let defaults = {
        color: '',
        colorHover: ''
    }

    if( typeof props.defaults !== 'undefined' ) {
        defaults = props.defaults;
    }

    if( typeof customCss[ idPrefix + 'Color' ] !== 'undefined' ) {
        defaults.color = customCss[ idPrefix + 'Color' ].value;
    }

    if( typeof customCss[ idPrefix + 'ColorHover' ] !== 'undefined' ) {
        defaults.colorHover = customCss[ idPrefix + 'ColorHover' ].value;
    }

    return (
        <div style={ colorPickerStyle }>
            <span style={ { display: 'block', marginBottom: '5px' } }>{ props.label }</span>
            <Button 
                label={ __( 'Default State', 'botiga-pro' ) }
                variant="secondary" 
                onClick={ toggleDefaultVisible } 
                style={ { 
                    backgroundColor: defaults.color,
                    textIndent: '-99999px',
                    width: '25px',
                    height: '25px',
                    boxShadow: 'none',
                    outlineColor: '#adadad',
                    borderRadius: '100%',
                    marginLeft: ! props.withHover ? 0 : 'auto',
                    marginRight: ! props.withHover ? 0 : '10px'
                } }>

                { isDefaultVisible && (
                    <Popover
                        onClick={ ( event ) => event.stopPropagation() }
                        onFocusOutside={ toggleDefaultVisible }>
                        <ColorPicker
                            color={ defaults.color }
                            enableAlpha
                            onChangeComplete={ ( value ) => { 
                                let propsOutput = ''; 
                                if( typeof css_prop === 'object' ) {
                                    css_prop.forEach( ( prop ) => {
                                        propsOutput += prop + ':' + value.hex + ' !important;';
                                    } );
                                } else {
                                    propsOutput = css_prop + ':' + value.hex + ' !important;';
                                }

                                const css = {
                                    [idPrefix + 'Color']: {
                                        selector: customCssSelector,
                                        props: propsOutput,
                                        value: value.hex
                                    }
                                };

                                setAttributes( { customCss: { ...customCss, ...css } } )
                            } }
                        />  
                    </Popover>
                ) }

            </Button>

            {
                props.withHover && (
                    <Button 
                        label={ __( 'Hover State', 'botiga-pro' ) }
                        variant="secondary" 
                        onClick={ toggleHoverVisible } 
                        style={ { 
                            backgroundColor: defaults.colorHover,
                            textIndent: '-99999px',
                            width: '25px',
                            height: '25px',
                            boxShadow: 'none',
                            outlineColor: '#adadad',
                            borderRadius: '100%' 
                        } }>

                        { isHoverVisible && (
                            <Popover
                                onClick={ ( event ) => event.stopPropagation() }
                                onFocusOutside={ toggleHoverVisible }>
                                <ColorPicker
                                    color={ defaults.colorHover }
                                    enableAlpha
                                    onChangeComplete={ ( value ) => { 
                                        let propsOutput = ''; 
                                        if( typeof css_prop === 'object' ) {
                                            css_prop.forEach( ( prop ) => {
                                                propsOutput += prop + ':' + value.hex + ' !important;';
                                            } );
                                        } else {
                                            propsOutput = css_prop + ':' + value.hex + ' !important;';
                                        }

                                        const css = {
                                            [idPrefix + 'ColorHover']: {
                                                selector: customCssSelector + ':hover',
                                                props: propsOutput,
                                                value: value.hex
                                            }
                                        };

                                        setAttributes( { customCss: { ...customCss, ...css } } )
                                    } }
                                />  
                            </Popover>
                        ) }
                        
                    </Button>
                )
            }
        </div>
    );
}
