<?php
/**
 * Load Gutenberg blocks for templates
 *
 * @package Botiga_Pro
 */

if ( !class_exists( 'Botiga_Templates_Builder_Gutenberg_Loader' ) ) :
	
	Class Botiga_Templates_Builder_Gutenberg_Loader {

		/**
		 * Instance
		 */		
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			$this->load_blocks();
		}	

		/**
		 * Load all blocks
		 */
		public function load_blocks() {

			// General
			// could be used in both archive/single products
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/wc-breadcrumb/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/wc-notices/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/wc-products/block.php' );

			// Shop Archive
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/shop-archive-title/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/shop-archive-description/block.php' );

			// Single Product
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-add-to-cart/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-additional-information/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-description/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-image/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-meta/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-price/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-rating/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-sharing/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-short-description/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-tabs/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-title/block.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/gutenberg/src/single-product-next-prev/block.php' );
		}
	
	}

	/**
	 * Initialize class
	 */
	Botiga_Templates_Builder_Gutenberg_Loader::get_instance();

endif;