<?php
/**
 * Helper class for templates builder gutenberg blocks
 *
 * @package Botiga_Pro
 */

if ( !class_exists( 'Botiga_Templates_Builder_Gutenberg_Helper' ) ) {
	
	Class Botiga_Templates_Builder_Gutenberg_Helper {
        public static function get_block_custom_css( $block_atts ) {
            $blockId    = $block_atts['blockId'];
            $customCss  = $block_atts['customCss'];
            $custom_css = '';

            // Add to array in favor to don't duplicate css selectors
            $values = array();
            foreach( $customCss as $attributeId => $css ) {
                $selector = $css[ 'selector' ];
                $props    = $css[ 'props' ];

                if( ! isset( $values[ $selector ] ) ) {
                    $values[ $selector ] = $props;
                } else {
                    $values[ $selector ] = $values[ $selector ] . $props;
                }
            }

            // Mount Output
            foreach( $values as $selector => $css_props ) {
                $selector = str_replace( '{{WRAPPER}}', '.' . $blockId, $selector );
                $custom_css .= "$selector { $css_props }";
            }

            return $custom_css;
        }

        /**
         * Get the first post found in the database
         * 
         */
        public static function get_first_post() {
            if( is_singular( 'product' ) ) {
                global $post;
                return $post;
            }
            
            $first_product = wc_get_products( array(
                'limit' => 1,
                'orderby' => 'date',
                'order' => 'DESC',
                'return' => 'ids'
            ) );

            $post = get_post( $first_product[0] );

            return $post;
        }

        /**
         * Get the first product found in the database
         * 
         */
        public static function get_first_product() {
            $first_product = wc_get_products( array(
                'limit' => 1,
                'orderby' => 'date',
                'order' => 'DESC',
                'return' => 'ids'
            ) );

            $product = wc_get_product( $first_product[0] );

            return $product;
        }

        /**
         * Get empty block output placeholder
         * 
         */
        public static function filter_block_output( $output = '' ) {
            if( empty( $output ) ) {
                return '<div class="botiga-tb-block-empty-placeholder"><span class="dashicons dashicons-layout"></span></div>';
            } else {
                return $output;
            }
        }
    }

}