<?php

// Register Custom Post Type
if( ! function_exists( 'botiga_register_templates_cpt' ) ) {
	function botiga_register_templates_cpt() {

		$plural_name = apply_filters( 'botiga_templates_cpt_name', __( 'Botiga Templates', 'botiga-pro' ) );

		$labels = array(
			'name'                  => $plural_name,
			'singular_name'         => _x( 'Template', 'Post Type Singular Name', 'botiga-pro' ),
			'menu_name'             => $plural_name,
			'name_admin_bar'        => __( 'Post Type', 'botiga-pro' ),
			'archives'              => __( 'Item Archives', 'botiga-pro' ),
			'attributes'            => __( 'Item Attributes', 'botiga-pro' ),
			'parent_item_colon'     => __( 'Parent Template:', 'botiga-pro' ),
			'all_items'             => $plural_name,
			'add_new_item'          => __( 'Add New Template', 'botiga-pro' ),
			'add_new'               => __( 'Add Template', 'botiga-pro' ),
			'new_item'              => __( 'New Item', 'botiga-pro' ),
			'edit_item'             => __( 'Edit Template', 'botiga-pro' ),
			'update_item'           => __( 'Update Template', 'botiga-pro' ),
			'view_item'             => __( 'View Template', 'botiga-pro' ),
			'view_items'            => __( 'View Templates', 'botiga-pro' ),
			'search_items'          => __( 'Search Template', 'botiga-pro' ),
			'not_found'             => __( 'Not found', 'botiga-pro' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'botiga-pro' ),
			'featured_image'        => __( 'Featured Image', 'botiga-pro' ),
			'set_featured_image'    => __( 'Set featured image', 'botiga-pro' ),
			'remove_featured_image' => __( 'Remove featured image', 'botiga-pro' ),
			'use_featured_image'    => __( 'Use as featured image', 'botiga-pro' ),
			'insert_into_item'      => __( 'Insert into item', 'botiga-pro' ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', 'botiga-pro' ),
			'items_list'            => __( 'Items list', 'botiga-pro' ),
			'items_list_navigation' => __( 'Items list navigation', 'botiga-pro' ),
			'filter_items_list'     => __( 'Filter items list', 'botiga-pro' ),
		);
		$args = array(
			'label'                 => __( 'Post Type', 'botiga-pro' ),
			'description'           => __( 'Post Type Description', 'botiga-pro' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'elementor', 'editor' ),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => 'themes.php',
			'menu_position'         => 60,
			'menu_icon'           	=> 'dashicons-cart',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
			'show_in_rest'          => true
		);
		register_post_type( 'athemes_hf', $args );

	}
	add_action( 'init', 'botiga_register_templates_cpt', 11 );
}

//Override menu name if white label plugin is active
if( ! function_exists( 'botiga_override_templates_cpt_name' ) ) {
	function botiga_override_templates_cpt_name() {
		if ( function_exists( 'athemes_wl_get_data' ) ) {
			return __( 'Templates', 'botiga-pro' );
		} else {
			return __( 'Botiga Templates', 'botiga-pro' );
		}
	}
	add_filter( 'botiga_templates_cpt_name', 'botiga_override_templates_cpt_name' );
}