<?php
/**
 * Modal Popup
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'modal-popup' ) ) {
    return;
}

/**
 * Modal Popup customize options.
 */
function botiga_modal_popup_options( $wp_customize ) {
    require BOTIGA_PRO_DIR . 'inc/modules/modal-popup/customizer/options.php';
}
add_action( 'customize_register', 'botiga_modal_popup_options', 999 );

/**
 * Enqueue CSS and JS
 */
function botiga_modal_popup_enqueue_scripts() {

    if( ! botiga_show_modal_popup() ) {
        return;
    }

    wp_enqueue_style( 'botiga-modal-popup', BOTIGA_PRO_URI . 'assets/css/botiga-modal-popup.min.css', array(), BOTIGA_PRO_VERSION );
    wp_enqueue_script( 'botiga-popup' );

}
add_action( 'wp_enqueue_scripts', 'botiga_modal_popup_enqueue_scripts', 10 );

/**
 * Popup HTML output
 */
function botiga_modal_popup() {

    if( ! botiga_show_modal_popup() ) {
        return;
    }
    
    $modal_popup_layout            = get_theme_mod( 'modal_popup_layout', 'style1' );
    $modal_popup_open_delay        = get_theme_mod( 'modal_popup_open_delay_desktop', 3 );
    $modal_popup_content_type      = get_theme_mod( 'modal_popup_content_type', 'default' );
    $modal_popup_cookie            = get_theme_mod( 'modal_popup_cookie', 1 );
    $modal_popup_cookie_name       = get_theme_mod( 'modal_popup_cookie_name', 'botiga-show-modal-popup' );
    $modal_popup_cookie_expiration = get_theme_mod( 'modal_popup_cookie_expiration_desktop', 7 ); 
    
    if( $modal_popup_content_type === 'content-block' ) {
        $modal_popup_layout = 'style3';
    }
    
    ?>

    <a href="#" class="has-popup" data-popup-id="modalPopup" data-auto-open="true" data-auto-open-delay="<?php echo absint( $modal_popup_open_delay ); ?>" style="display: none;"></a>
    <div id="modalPopup" class="botiga-popup" data-cookie="<?php echo absint( $modal_popup_cookie ); ?>" data-cookie-name="<?php echo esc_attr( $modal_popup_cookie_name ); ?>" data-cookie-expiration="<?php echo absint( $modal_popup_cookie_expiration ); ?>">
        <div class="botiga-popup-wrapper botiga-popup-wrapper--layout-<?php echo esc_attr( $modal_popup_layout ); ?>">
            <a href="#" class="botiga-popup-wrapper__close-button" role="button" title="<?php echo esc_attr__( 'Close popup.', 'botiga-pro' ); ?>">
                <?php echo botiga_pro_get_svg_icon( 'icon-cancel' ); ?>
            </a>
            <div class="botiga-popup-wrapper__content">

                <?php if( $modal_popup_layout !== 'style3'  ) : ?>
                    <div class="botiga-popup-wrapper__content-side-image">
                        <?php 
                        $modal_popup_side_image      = get_theme_mod( 'modal_popup_side_image', 0 );
                        $modal_popup_side_image_link = get_theme_mod( 'modal_popup_side_image_link', '' );

                        $modal_image_output  = '';
                        $modal_image_output .= wp_get_attachment_image( $modal_popup_side_image, 'botiga-big' );

                        if( $modal_popup_side_image_link ) {
                            $link_url = get_theme_mod( 'modal_popup_side_image_link_url', '' );
                            $target   = get_theme_mod( 'modal_popup_side_image_link_new_tab', 0 ) ? '_blank' : '_self';

                            $modal_image_output = '<a href="' . esc_url( $link_url ) . '" target="'. esc_attr( $target ) .'" title="'. esc_attr__( 'Modal popup link title', 'botiga-pro' ) .'">' . $modal_image_output . '</a>';
                        }

                        echo wp_kses_post( $modal_image_output );

                        ?>
                    </div>
                <?php endif; ?>
                
                <?php if( $modal_popup_layout !== 'style4' ) : ?>
                <div class="botiga-popup-wrapper__content-html" style="width: 100%;">
                    <?php 
                    if( $modal_popup_content_type === 'default' ) {
                        $modal_popup_content = get_theme_mod( 'modal_popup_content', 'botiga-pro' );
                        echo do_shortcode( wp_kses_post( $modal_popup_content ) );
                    } else {
                        $modal_popup_content_block_id = get_theme_mod( 'modal_popup_content_block', '' );

                        if( $modal_popup_content_block_id ) {
                            if ( class_exists( 'Elementor\Plugin' ) && Elementor\Plugin::$instance->documents->get( $modal_popup_content_block_id )->is_built_with_elementor() ) {
                                echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $modal_popup_content_block_id );
                            } else {
                                $content_block_post = get_post( $modal_popup_content_block_id );
                                if( isset( $content_block_post->post_content ) ) {
                                    echo do_blocks( $content_block_post->post_content );
                                }
                            }
                        }
                    }

                    ?>
                </div>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <?php
}
add_action( 'wp_footer', 'botiga_modal_popup' );

function botiga_show_modal_popup() {
    $modal_popup_display           = get_theme_mod( 'modal_popup_display', 'all' );
    $modal_popup_display_on_search = get_theme_mod( 'modal_popup_display_on_search', 1 );
    $modal_popup_display_on_404    = get_theme_mod( 'modal_popup_display_on_404', 1 );

    if( $modal_popup_display === 'all' ) {
        return true;
    }

    if( is_search() && $modal_popup_display_on_search ) {
        return true;
    }

    if( is_404() && $modal_popup_display_on_404 ) {
        return true;
    }

    if( $modal_popup_display === 'post-types' ) {
        $pts = get_theme_mod( 'modal_popup_display_post_types', 'post,page,product' );
        $pts = strpos( $pts, ',' ) !== FALSE ? explode( ',', $pts ) : $pts;

        global $post;

        if( ! $post ) {
            return false;
        }

        $post_type = get_post_type( $post );

        if( is_array( $pts ) && in_array( $post_type, $pts ) || $pts === $post_type ) {
            return true;
        }
    }
    
    if( $modal_popup_display === 'posts-in' ) {
        $post_ids = get_theme_mod( 'modal_popup_display_post_ids', '' );
        $post_ids = strpos( $post_ids, ',' ) !== FALSE ? explode( ',', $post_ids ) : $post_ids;

        global $post;

        if( ! $post ) {
            return false;
        }

        $post_id = $post->ID;

        if( is_array( $post_ids ) && in_array( $post_id, $post_ids ) || (int) $post_ids === $post_id ) {
            return true;
        }
    }

    return false;
}

/**
 * Modal Popup Custom CSS
 */
function botiga_modal_popup_custom_css( $css ) {
    $content_padding = get_theme_mod( 'modal_popup_content_padding', 25 );
    $css .= '.botiga-popup-wrapper { padding: '. esc_attr( $content_padding ) .'px; }';
    $css .= '.botiga-popup-wrapper .botiga-popup-wrapper__close-button { top: 20px; right: 20px; position: absolute; margin: 0; transform: none; z-index: 5; }';

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_modal_popup_custom_css' );