<?php 
/**
 * Linked Variations Customizer Options
 */
$controls_general = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general );

$new_controls_general = array(
	'#customize-control-accordion_single_product_linked_variations',
	'#customize-control-single_product_linked_variations_tooltip',
	'#customize-control-single_product_linked_variations_learn_more',
);

$wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );

// Linked Variations
$wp_customize->add_setting( 'accordion_single_product_linked_variations', 
  array(
    'sanitize_callback' => 'esc_attr'
  )
);
$wp_customize->add_control(
  new Botiga_Accordion_Control(
    $wp_customize,
    'accordion_single_product_linked_variations',
    array(
      'label'    => esc_html__( 'Linked Variations', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'until'    => 'single_product_linked_variations_learn_more',
      'priority' => 115
    )
  )
);

$wp_customize->add_setting(
  'single_product_linked_variations_tooltip',
  array(
    'default'           => 0,
    'sanitize_callback' => 'botiga_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  new Botiga_Toggle_Control(
    $wp_customize,
    'single_product_linked_variations_tooltip',
    array(
      'label'    => esc_html__( 'Enable Tooltip', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 115
    )
  )
);

$wp_customize->add_setting(
  'single_product_linked_variations_learn_more',
  array(
    'default'           => '',
    'sanitize_callback' => 'esc_attr',
  )
);
$wp_customize->add_control(
  new Botiga_Text_Control(
    $wp_customize,
    'single_product_linked_variations_learn_more',
    array(
      'description'       => esc_html__( 'Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro' ),
      'link_title'        => esc_html__( 'Learn more', 'botiga-pro' ),
      'link'              => 'https://docs.athemes.com/article/pro-single-product-linked-variations/',
      'check_white_label' => true,
      'section'           => 'botiga_section_single_product',
      'priority'          => 115
    )
  )
);