<?php
/**
 * Header/Footer Builder
 * Shortcode Component CSS Output
 * 
 * @package Botiga_Pro
 */

// Text Alignment
$css .= Botiga_Custom_CSS::get_responsive_css( 
    'botiga_section_hb_component__shortcode_text_align', 
    array( 'desktop' => 'left', 'tablet' => 'left', 'mobile' => 'left' ), 
    '.bhfb.bhfb-header .bhfb-component-shortcode',
    'text-align',
    '' 
);

// Visibility
$css .= Botiga_Custom_CSS::get_responsive_css( 
    'botiga_section_hb_component__shortcode_visibility', 
    'visible', 
    '.bhfb.bhfb-header .bhfb-builder-item.bhfb-component-shortcode, .bhfb-mobile_offcanvas .bhfb-builder-item.bhfb-component-shortcode', 
    'display',
    ''
);

/**
 * Colors Default State
 */

// Text Color
$css .= Botiga_Custom_CSS::get_color_css( 'botiga_section_hb_component__shortcode_text_color', '', '.bhfb.bhfb-header .bhfb-component-shortcode' );

// Links Color
$css .= Botiga_Custom_CSS::get_color_css( 'botiga_section_hb_component__shortcode_link_color', '', '.bhfb.bhfb-header .bhfb-component-shortcode a' );

// Links Color Hover
$css .= Botiga_Custom_CSS::get_color_css( 'botiga_section_hb_component__shortcode_link_color_hover', '', '.bhfb.bhfb-header .bhfb-component-shortcode a:hover' );

/** 
 * Colors Sticky Header State
 */

// Text Color
$css .= Botiga_Custom_CSS::get_color_css( 'botiga_section_hb_component__shortcode_sticky_text_color', '', '.sticky-header-active .bhfb.bhfb-header .bhfb-component-shortcode' );

// Links Color
$css .= Botiga_Custom_CSS::get_color_css( 'botiga_section_hb_component__shortcode_sticky_link_color', '', '.sticky-header-active .bhfb.bhfb-header .bhfb-component-shortcode a' );

// Links Color Hover
$css .= Botiga_Custom_CSS::get_color_css( 'botiga_section_hb_component__shortcode_sticky_link_color_hover', '', '.sticky-header-active .bhfb.bhfb-header .bhfb-component-shortcode a:hover' );

// Padding
if( method_exists( 'Botiga_Custom_CSS', 'get_responsive_dimensions_css' ) ) {
    $css .= Botiga_Custom_CSS::get_responsive_dimensions_css( 
        'botiga_section_hb_component__shortcode_padding',
        array(
            'desktop' => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'tablet'  => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'mobile'  => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
        ), 
        '.bhfb.bhfb-header .bhfb-component-shortcode', 
        'padding'
    );
    
    // Margin
    $css .= Botiga_Custom_CSS::get_responsive_dimensions_css( 
        'botiga_section_hb_component__shortcode_margin',
        array(
            'desktop' => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'tablet'  => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'mobile'  => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
        ), 
        '.bhfb.bhfb-header .bhfb-component-shortcode', 
        'margin',
        true
    );
}