<?php
/**
 * Footer Builder
 * Shortcode Component
 * 
 * @package Botiga_Pro
 */

// List of options we'll need to move.
$opts_to_move = array(
    'general' => array(
        'footer_shortcode_content'
    ),
    'style'   => array()
);

$wp_customize->add_section(
    'botiga_section_fb_component__shortcode',
    array(
        'title'      => esc_html__( 'Shortcode', 'botiga-pro' ),
        'panel'      => 'botiga_panel_footer'
    )
);

$wp_customize->add_setting(
    'botiga_section_fb_component__shortcode_tabs',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control(
    new Botiga_Tab_Control (
        $wp_customize,
        'botiga_section_fb_component__shortcode_tabs',
        array(
            'label' 				=> '',
            'section'       		=> 'botiga_section_fb_component__shortcode',
            'controls_general'		=> json_encode(
                array_merge(
                    array(
                        '#customize-control-botiga_section_fb_component__shortcode_title',
                        '#customize-control-botiga_section_fb_component__shortcode_text_align',
                        '#customize-control-botiga_section_fb_component__shortcode_visibility'
                    ),
                    array_map( function( $name ){ return "#customize-control-$name"; }, $opts_to_move[ 'general' ] )
                )
            ),
            'controls_design'		=> json_encode(
                array_merge(
                    array(
                        '#customize-control-botiga_section_fb_component__shortcode_text_color',
                        '#customize-control-botiga_section_fb_component__shortcode_link',
                        '#customize-control-botiga_section_fb_component__shortcode_padding',
                        '#customize-control-botiga_section_fb_component__shortcode_margin'
                    ),
                    array_map( function( $name ){ return "#customize-control-$name"; }, $opts_to_move[ 'style' ] )
                )
            ),
            'priority' 				=> 20
        )
    )
);

$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_title',
    array(
        'default' 			=> '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    new Botiga_Text_Control( 
        $wp_customize, 
        'botiga_section_fb_component__shortcode_title',
        array(
            'label'			  => esc_html__( 'Shortcode Content', 'botiga-pro' ),
            'section' 		  => 'botiga_section_fb_component__shortcode',
            'priority'	 	  => 29
        )
    )
);

// Text Alignment.
$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_text_align_desktop',
    array(
        'default' 			=> 'left',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_text_align_tablet',
    array(
        'default' 			=> 'left',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_text_align_mobile',
    array(
        'default' 			=> 'left',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control( 
    new Botiga_Radio_Buttons( 
        $wp_customize, 
        'botiga_section_fb_component__shortcode_text_align',
        array(
            'label'         => esc_html__( 'Text Alignment', 'botiga-pro' ),
            'section'       => 'botiga_section_fb_component__shortcode',
            'is_responsive' => true,
            'settings' => array(
                'desktop' 		=> 'botiga_section_fb_component__shortcode_text_align_desktop',
                'tablet' 		=> 'botiga_section_fb_component__shortcode_text_align_tablet',
                'mobile' 		=> 'botiga_section_fb_component__shortcode_text_align_mobile'
            ),
            'choices'       => array(
                'left' 		=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h10v1H0zM0 4h16v1H0zM0 8h10v1H0zM0 12h16v1H0z"/></svg>',
                'center' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3 0h10v1H3zM0 4h16v1H0zM3 8h10v1H3zM0 12h16v1H0z"/></svg>',
                'right' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 0h10v1H6zM0 4h16v1H0zM6 8h10v1H6zM0 12h16v1H0z"/></svg>'
            ),
            'priority'      => 30
        )
    ) 
);

// Visibility
$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_visibility_desktop',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_visibility_tablet',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_fb_component__shortcode_visibility_mobile',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control( 
    new Botiga_Radio_Buttons( 
        $wp_customize, 
        'botiga_section_fb_component__shortcode_visibility',
        array(
            'label'         => esc_html__( 'Visibility', 'botiga' ),
            'section'       => 'botiga_section_fb_component__shortcode',
            'is_responsive' => true,
            'settings' => array(
                'desktop' 		=> 'botiga_section_fb_component__shortcode_visibility_desktop',
                'tablet' 		=> 'botiga_section_fb_component__shortcode_visibility_tablet',
                'mobile' 		=> 'botiga_section_fb_component__shortcode_visibility_mobile'
            ),
            'choices'       => array(
                'visible' => esc_html__( 'Visible', 'botiga' ),
                'hidden'  => esc_html__( 'Hidden', 'botiga' )
            ),
            'priority'      => 42
        )
    ) 
);

// Text Color.
$wp_customize->add_setting(
	'botiga_section_fb_component__shortcode_text_color',
	array(
		'default'           => '',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
	new Botiga_Alpha_Color(
		$wp_customize,
		'botiga_section_fb_component__shortcode_text_color',
		array(
			'label'         	=> esc_html__( 'Text Color', 'botiga-pro' ),
			'section'       	=> 'botiga_section_fb_component__shortcode',
            'priority'          => 40
		)
	)
);

// Link Color.
$wp_customize->add_setting(
	'botiga_section_fb_component__shortcode_link_color',
	array(
		'default'           => '',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
    'botiga_section_fb_component__shortcode_link_color_hover',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'botiga_section_fb_component__shortcode_link',
        array(
            'label'    => esc_html__( 'Link Color', 'botiga-pro' ),
            'section'  => 'botiga_section_fb_component__shortcode',
            'settings' => array(
                'normal' => 'botiga_section_fb_component__shortcode_link_color',
                'hover'  => 'botiga_section_fb_component__shortcode_link_color_hover',
            ),
            'priority' => 41
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {

    // Padding
    $wp_customize->add_setting( 
        'botiga_section_fb_component__shortcode_padding_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_fb_component__shortcode_padding_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_fb_component__shortcode_padding_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'botiga_section_fb_component__shortcode_padding',
            array(
                'label'           	=> __( 'Wrapper Padding', 'botiga' ),
                'section'         	=> 'botiga_section_fb_component__shortcode',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'botiga_section_fb_component__shortcode_padding_desktop',
                    'tablet'  => 'botiga_section_fb_component__shortcode_padding_tablet',
                    'mobile'  => 'botiga_section_fb_component__shortcode_padding_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

    // Margin
    $wp_customize->add_setting( 
        'botiga_section_fb_component__shortcode_margin_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_fb_component__shortcode_margin_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_fb_component__shortcode_margin_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'botiga_section_fb_component__shortcode_margin',
            array(
                'label'           	=> __( 'Wrapper Margin', 'botiga' ),
                'section'         	=> 'botiga_section_fb_component__shortcode',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'botiga_section_fb_component__shortcode_margin_desktop',
                    'tablet'  => 'botiga_section_fb_component__shortcode_margin_tablet',
                    'mobile'  => 'botiga_section_fb_component__shortcode_margin_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

}

// Move existing options.
$priority = 30;
foreach( $opts_to_move as $tabs ) {
    foreach( $tabs as $option_name ) {
        $wp_customize->get_control( $option_name )->section  = 'botiga_section_fb_component__shortcode';
        $wp_customize->get_control( $option_name )->priority = $priority;
        $wp_customize->get_control( $option_name )->active_callback  = function(){};
        
        $priority++;
    }
}