<?php
/**
 * Custom Fonts
 *
 * @package Botiga
 */

if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'custom-fonts' ) ) {
	return;
}

/**
 * Custom fonts customize options.
 */
function botiga_custom_fonts_options( $wp_customize ) {
	require BOTIGA_PRO_DIR . 'inc/modules/custom-fonts/customizer/options.php';
}
add_action( 'customize_register', 'botiga_custom_fonts_options', 999 );

/**
 * Custom fonts allowed mimes.
 */
function botiga_add_fonts_to_allowed_mimes( $mimes ) {

	$mimes['woff']  = 'font/woff';
	$mimes['woff2'] = 'font/woff2';
	$mimes['ttf']   = 'font/ttf';
	$mimes['eot']   = 'font/eot';
	$mimes['otf']   = 'font/otf';
	$mimes['svg']   = 'image/svg+xml';

	return $mimes;

}
add_filter( 'upload_mimes', 'botiga_add_fonts_to_allowed_mimes' );

/**
 * Custom fonts update mime types.
 */
function botiga_update_mime_types( $defaults, $file, $filename ) {

	if ( pathinfo( $filename, PATHINFO_EXTENSION ) === 'woff2' ) {
		$defaults['type'] = 'font/woff2';
		$defaults['ext']  = 'woff2';
	}

	if ( pathinfo( $filename, PATHINFO_EXTENSION ) === 'woff' ) {
		$defaults['type'] = 'font/woff';
		$defaults['ext']  = 'woff';
	}

	if ( pathinfo( $filename, PATHINFO_EXTENSION ) === 'ttf' ) {
		$defaults['type'] = 'font/ttf';
		$defaults['ext']  = 'ttf';
	}

	if ( pathinfo( $filename, PATHINFO_EXTENSION ) === 'otf' ) {
		$defaults['type'] = 'font/otf';
		$defaults['ext']  = 'otf';
	}

	if ( pathinfo( $filename, PATHINFO_EXTENSION ) === 'eot' ) {
		$defaults['type'] = 'font/eot';
		$defaults['ext']  = 'eot';
	}

	return $defaults;

}
add_filter( 'wp_check_filetype_and_ext', 'botiga_update_mime_types', 10, 3 );