<?php
/**
 * Breadcrumbs
 * 
 * @package Botiga_Pro
 */

if( ! class_exists( 'Botiga_Modules' ) ) {
	return;
}

if ( ! Botiga_Modules::is_module_active( 'breadcrumbs' ) ) {
	return;
}

/**
 * Load breadcrumbs class
 */
require 'class-botiga-breadcrumb-trail.php';

/**
 * Options
 */
function botiga_load_breadcrumbs_options( $wp_customize ) {
	require 'customizer/options.php';
}
add_action( 'customize_register', 'botiga_load_breadcrumbs_options', 999 );

/**
 * Render breadcrumbs
 */
function botiga_breadcrumb_trail( $args = array() ) {
	if ( is_front_page() ) {
		return;
	}

	$source = get_theme_mod( 'breadcrumbs_source', 'builtin' );

	if ( 'builtin' === $source ) {
		$breadcrumb = new botiga_Breadcrumb_Trail( $args );

		return $breadcrumb->trail();	
	} else {
		if ( function_exists( $source ) ) {
			echo '<div class="botiga-breadcrumb-trail"><div class="container">';
			call_user_func( $source );
			echo '</div></div>';
		}
	}
}

/**
 * Add breadcrumbs
 */
function botiga_add_breadcrumbs() {
	$position 		    = get_theme_mod( 'breadcrumbs_position', 'botiga_after_header' );
	$shop_breadcrumbs   = get_theme_mod( 'shop_breadcrumbs', 1 );
	$single_breadcrumbs = get_theme_mod( 'single_breadcrumbs', 1 );

	// Remove woo breadcrumbs
	add_filter( 'botiga_show_woo_page_header_breadcrumbs', '__return_false' );

	if ( 'botiga_after_header' === $position ) {
		add_action( 'botiga_header', 'botiga_breadcrumb_trail', 20 );

		if( class_exists( 'Woocommerce' ) ) {
		
			// Product Catalog
			if( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() ) {
				if( ! $shop_breadcrumbs ) {
					remove_action( 'botiga_header', 'botiga_breadcrumb_trail', 20 );	
				}
			}
	
			// Single Product
			if( is_singular( 'product' ) ) {
				if( $single_breadcrumbs ) {
					remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
				} else {
					remove_action( 'botiga_header', 'botiga_breadcrumb_trail', 20 );					
				}
			}
	
		}
	} else {
		add_action( 'botiga_before_title', 'botiga_breadcrumb_trail' );

		if( class_exists( 'Woocommerce' ) ) {
		
			// Product Catalog
			if( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() ) {
				if( $shop_breadcrumbs ) {
					add_action( 'botiga_before_shop_archive_title', 'botiga_breadcrumb_trail', 20 );	
				}
			}
	
			// Single Product
			if( is_singular( 'product' ) ) {
				if( $single_breadcrumbs ) {
					remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );					
					add_action( 'woocommerce_before_main_content', 'botiga_breadcrumb_trail', 20 );
				}
			}
	
		}
	}
}
add_action( 'wp', 'botiga_add_breadcrumbs' );

/**
 * Breadcrumbs CSS
 */
function botiga_breadcrumbs_custom_css( $css ) {

	$css .= '
		.rank-math-breadcrumb p {
			margin-bottom: 0;
		}
		.botiga-breadcrumb-trail {
			border-bottom: 1px solid rgba(0, 16, 46, 0.1);
			text-transform: uppercase;
			letter-spacing: 1px;
			font-size: 0.8em;
			font-weight: 600;	
		}
		.botiga-breadcrumb-trail ul {
			list-style: none;
			padding: 0;
			margin: 0;
		}
		.botiga-breadcrumb-trail .botiga-svg-icon {
			margin: 0 9px;
			position: relative;
			top: 1px;
		}
		.botiga-breadcrumb-trail .botiga-svg-icon,
		.botiga-breadcrumb-trail .botiga-svg-icon svg {
			width: 0.9em;
			height: 0.9em;
		}
		.botiga-breadcrumb-trail ul li {
			display: inline;
			padding-bottom: 0;
		}
		.botiga-breadcrumb-trail ul li:last-of-type .botiga-svg-icon {
			display: none;
		}
	';

	$breadcrumbs_align = get_theme_mod( 'breadcrumbs_align', 'left' );
	$css .= ".botiga-breadcrumb-trail { text-align:" . esc_attr( $breadcrumbs_align ) . ";}" . "\n";
	$css .= Botiga_Custom_CSS::get_background_color_css( 'breadcrumbs_background', '', '.botiga-breadcrumb-trail' );
	$css .= Botiga_Custom_CSS::get_color_css( 'breadcrumbs_link_color', '', '.botiga-breadcrumb-trail ul li a' );
	$css .= Botiga_Custom_CSS::get_color_css( 'breadcrumbs_link_hover_color', '', '.botiga-breadcrumb-trail ul li a:hover' );
	$css .= Botiga_Custom_CSS::get_color_css( 'breadcrumbs_color', '#47425d', '.botiga-breadcrumb-trail' );
	$css .= Botiga_Custom_CSS::get_fill_css( 'breadcrumbs_color', '#47425d', '.botiga-breadcrumb-trail svg' );
	$css .= Botiga_Custom_CSS::get_border_color_css( 'breadcrumbs_border_bottom_color', '#dbdbdb', '.botiga-breadcrumb-trail' );
	$css .= Botiga_Custom_CSS::get_top_bottom_padding_css( 'breadcrumbs_padding', $defaults = array( 'desktop' => 15, 'tablet' => 15, 'mobile' => 15 ), '.botiga-breadcrumb-trail' );
	$css .= Botiga_Custom_CSS::get_responsive_css( 
		'breadcrumbs_margin_bottom', 
		array( 'desktop' => 15, 'tablet' => 15, 'mobile' => 15 ), 
		'.botiga-breadcrumb-trail',
		'margin-bottom',
		'px' 
	);

	return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_breadcrumbs_custom_css' );