<?php
/**
 * Single Product Advanced Reviews
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'advanced-reviews' ) ) {
    return;
}

require BOTIGA_PRO_DIR . 'inc/modules/advanced-reviews/advanced-reviews-pagination.php';

/**
 * Size chart customize options.
 */
function botiga_advanced_reviews_options( $wp_customize ) {
    require BOTIGA_PRO_DIR . 'inc/modules/advanced-reviews/customizer/options.php';
}
add_action( 'customize_register', 'botiga_advanced_reviews_options', 999 );

/**
 * Main hook
 */
function botiga_single_product_reviews_hook() {
    if( ! is_singular( 'product' ) ) {
        return;
    }

    if( get_option( 'woocommerce_enable_reviews' ) === 'no' ) {
        return;
    }

    global $post, $_product;
    $_product = wc_get_product( $post->ID );

    $display_order = get_theme_mod( 'single_product_reviews_advanced_display_order', '10' );

    add_filter( 'woocommerce_product_tabs', 'botiga_woocommerce_product_tabs_remove_reviews' );
    add_action( 'woocommerce_after_single_product_summary', 'botiga_single_product_reviews_advanced', apply_filters( 'botiga_single_product_reviews_advanced_order', $display_order ) );
    add_action( 'wp_footer', 'botiga_single_product_reviews_advanced_modal' );

}
add_action( 'wp', 'botiga_single_product_reviews_hook' );

/**
 * Enqueue CSS and JS
 */
function botiga_single_product_reviews_advanced_enqueue_scripts() {
    if( ! is_singular( 'product' ) ) {
        return;
    }

    wp_enqueue_style( 'botiga-reviews-advanced', BOTIGA_PRO_URI . 'assets/css/botiga-reviews-advanced.min.css', array(), BOTIGA_PRO_VERSION );
    wp_enqueue_script( 'botiga-reviews-advanced', BOTIGA_PRO_URI . 'assets/js/botiga-reviews-advanced.min.js', array(), BOTIGA_PRO_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'botiga_single_product_reviews_advanced_enqueue_scripts', 10 );

/**
 * Remove "reviews" from tabs
 */
function botiga_woocommerce_product_tabs_remove_reviews( $tabs_items ) {
    unset( $tabs_items[ 'reviews' ] );
    return $tabs_items;
}

/**
 * Advanced Reviews Output
 */
function botiga_single_product_reviews_advanced() {
    get_template_part( 'template-parts/single-product/content-reviews', 'advanced' );
}

/**
 * Advanced Reviews Modal Output
 */
function botiga_single_product_reviews_advanced_modal() {
    get_template_part( 'template-parts/single-product/content-reviews-advanced', 'modal' );
}

/**
 * Advanced reviews custom pagination links
 */
function botiga_paginate_advanced_reviews_links( $args, $pages, $product_id ) {
    global $wp_rewrite;

    if ( ! is_singular() ) {
        return;
    }
 
    $page = get_query_var( 'cpage' );
    if ( ! $page ) {
        $page = 1;
    }
    
    $max_page = ceil( $pages );
    $defaults = array(
        'base'         => add_query_arg( 'cpage', '%#%' ),
        'format'       => '',
        'total'        => $max_page,
        'current'      => $page,
        'echo'         => true,
        'type'         => 'plain',
        'add_fragment' => '#comments',
    );
    if ( $wp_rewrite->using_permalinks() ) {
        $defaults['base'] = user_trailingslashit( trailingslashit( get_permalink( $product_id ) ) . $wp_rewrite->comments_pagination_base . '-%#%', 'commentpaged' );
    }
 
    $args       = wp_parse_args( $args, $defaults );
    $page_links = paginate_links( $args );
 
    if ( $args['echo'] && 'array' !== $args['type'] ) {
        echo $page_links;
    } else {
        return $page_links;
    }
}

/**
 * Creates the data to display in the single product
 * reviews rating bars
 */
function botiga_get_advanced_reviews_bars_rating_data( $product_id ) {
    $data = array();

    // Count each star rating quantity
    for( $i=1;$i<=5;$i++ ) {
        $data[ "$i-stars" ] = count( get_comments( array(
            'post_id' => $product_id,
            'fields' => 'ids',
            'meta_key' => 'rating',
            'meta_value' => $i
        ) ) );
    }

    // The sum of all ratings
    $total = 0;
    foreach( $data as $stars ) {
        $total = $total + $stars;
    }

    $data[ 'total' ] = $total;

    if( $data[ 'total' ] == 0 ) {
        return $data;
    }

    // Calculate percents
    for( $i=1;$i<=5;$i++ ) {
        $data[ "$i-stars-percent" ] = ( $data[ "$i-stars" ] / $total ) * 100;
    }

    return $data;
}

/**
 * Change the comments orderby when a new 
 * comment is sent
 */
function botiga_wc_advanced_reviews_comment_post_redirect( $location, $comment ) {
    if( isset( $_POST['rating'] ) ) {
        $location = str_replace( '#comment-', '?orderby=oldest#comment-', $location );
        return $location;
    }

    return $location;
}
add_filter( 'comment_post_redirect', 'botiga_wc_advanced_reviews_comment_post_redirect', 2, 99 );