<?php
/**
 * Botiga Hooks
 *
 * @package Botiga
 */

if ( ! class_exists( 'Botiga_Customizer_Hooks' ) ) {

	class Botiga_Customizer_Hooks {

		private static $instance;

		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 *  Constructor
		 */
		public function __construct() {

			// General
			add_action( 'wp_head', array( $this, 'hook_wp_head' ) );
            add_action( 'wp_body_open', array( $this, 'hook_wp_body_open' ) );
            
			add_action( 'botiga_before_site', array( $this, 'hook_before_site' ) );
			add_action( 'botiga_after_site', array( $this, 'hook_after_site' ) );

			//Header
			add_action( 'botiga_before_header', array( $this, 'hook_before_header' ) );
			add_action( 'botiga_after_header', array( $this, 'hook_after_header' ) );
	
			//Content
            add_action( 'botiga_before_page_header', array( $this, 'hook_before_page_header' ) );
			add_action( 'botiga_after_page_header', array( $this, 'hook_after_page_header' ) );

            add_action( 'botiga_before_main_wrapper', array( $this, 'hook_before_main_wrapper' ) );
            add_action( 'botiga_after_main_wrapper', array( $this, 'hook_after_main_wrapper' ) );

            //WooCommerce - Page Header
            add_action( 'botiga_before_page_header', array( $this, 'hook_woocommerce_before_page_header_shop_loop' ) );
            add_action( 'botiga_after_page_header', array( $this, 'hook_woocommerce_after_page_header_shop_loop' ) );

            //WooCommerce - General
            add_action( 'woocommerce_before_main_content', array( $this, 'hook_woocommerce_before_main_content' ) );
            add_action( 'woocommerce_after_main_content', array( $this, 'hook_woocommerce_after_main_content' ) );

			//WooCommerce - Shop Archive 
            add_action( 'woocommerce_before_shop_loop', array( $this, 'hook_woocommerce_before_shop_loop' ) );
            add_action( 'woocommerce_after_shop_loop', array( $this, 'hook_woocommerce_after_shop_loop' ) );

            add_action( 'woocommerce_before_shop_loop_item', array( $this, 'hook_woocommerce_before_shop_loop_item' ) );
            add_action( 'woocommerce_after_shop_loop_item', array( $this, 'hook_woocommerce_after_shop_loop_item' ) );

            add_action( 'woocommerce_before_shop_loop_item_title', array( $this, 'hook_woocommerce_before_shop_loop_item_title' ) );
            add_action( 'woocommerce_after_shop_loop_item_title', array( $this, 'hook_woocommerce_after_shop_loop_item_title' ) );
            
			//WooCommerce - Shop Single
			add_action( 'woocommerce_before_single_product', array( $this, 'hook_woocommerce_before_single_product' ) );
            add_action( 'woocommerce_after_single_product', array( $this, 'hook_woocommerce_after_single_product' ), 99 );

			add_action( 'woocommerce_before_single_product_summary', array( $this, 'hook_woocommerce_before_single_product_summary' ) );
            add_action( 'woocommerce_after_single_product_summary', array( $this, 'hook_woocommerce_after_single_product_summary' ) );

			add_action( 'woocommerce_before_add_to_cart_form', array( $this, 'hook_woocommerce_before_add_to_cart_form' ) );
            add_action( 'woocommerce_after_add_to_cart_form', array( $this, 'hook_woocommerce_after_add_to_cart_form' ) );

			add_action( 'woocommerce_before_add_to_cart_button', array( $this, 'hook_woocommerce_before_add_to_cart_button' ) );
            add_action( 'woocommerce_after_add_to_cart_button', array( $this, 'hook_woocommerce_after_add_to_cart_button' ) );

			add_action( 'woocommerce_before_add_to_cart_quantity', array( $this, 'hook_woocommerce_before_add_to_cart_quantity' ) );
            add_action( 'woocommerce_after_add_to_cart_quantity', array( $this, 'hook_woocommerce_after_add_to_cart_quantity' ) );

			add_action( 'woocommerce_product_meta_start', array( $this, 'hook_woocommerce_product_meta_start' ) );
            add_action( 'woocommerce_product_meta_end', array( $this, 'hook_woocommerce_product_meta_end' ) );

			//WooCommerce - Shop Cart
			add_action( 'woocommerce_before_cart', array( $this, 'hook_woocommerce_before_cart' ) );
            add_action( 'woocommerce_after_cart', array( $this, 'hook_woocommerce_after_cart' ) );

			add_action( 'woocommerce_before_cart_table', array( $this, 'hook_woocommerce_before_cart_table' ) );
            add_action( 'woocommerce_after_cart_table', array( $this, 'hook_woocommerce_after_cart_table' ) );

			add_action( 'woocommerce_before_cart_contents', array( $this, 'hook_woocommerce_before_cart_contents' ) );
            add_action( 'woocommerce_after_cart_contents', array( $this, 'hook_woocommerce_after_cart_contents' ) );

			add_action( 'woocommerce_before_cart_collaterals', array( $this, 'hook_woocommerce_before_cart_collaterals' ) );

			//WooCommerce - Shop Checkout
			add_action( 'woocommerce_before_checkout_form', array( $this, 'hook_woocommerce_before_checkout_form' ) );
            add_action( 'woocommerce_after_checkout_form', array( $this, 'hook_woocommerce_after_checkout_form' ) );
			
			add_action( 'woocommerce_checkout_before_customer_details', array( $this, 'hook_woocommerce_checkout_before_customer_details' ) );
            add_action( 'woocommerce_checkout_after_customer_details', array( $this, 'hook_woocommerce_checkout_after_customer_details' ) );

			add_action( 'woocommerce_checkout_before_order_review', array( $this, 'hook_woocommerce_checkout_before_order_review' ) );
            add_action( 'woocommerce_checkout_after_order_review', array( $this, 'hook_woocommerce_checkout_after_order_review' ) );

			add_action( 'woocommerce_before_checkout_billing_form', array( $this, 'hook_woocommerce_before_checkout_billing_form' ) );
            add_action( 'woocommerce_after_checkout_billing_form', array( $this, 'hook_woocommerce_after_checkout_billing_form' ) );

			add_action( 'woocommerce_before_checkout_registration_form', array( $this, 'hook_woocommerce_before_checkout_registration_form' ) );
            add_action( 'woocommerce_after_checkout_registration_form', array( $this, 'hook_woocommerce_after_checkout_registration_form' ) );

			add_action( 'woocommerce_before_checkout_shipping_form', array( $this, 'hook_woocommerce_before_checkout_shipping_form' ) );
            add_action( 'woocommerce_after_checkout_shipping_form', array( $this, 'hook_woocommerce_after_checkout_shipping_form' ) );

			add_action( 'woocommerce_before_order_notes', array( $this, 'hook_woocommerce_before_order_notes' ) );
            add_action( 'woocommerce_after_order_notes', array( $this, 'hook_woocommerce_after_order_notes' ) );

			add_action( 'woocommerce_checkout_before_terms_and_conditions', array( $this, 'hook_woocommerce_checkout_before_terms_and_conditions' ) );
            add_action( 'woocommerce_checkout_after_terms_and_conditions', array( $this, 'hook_woocommerce_checkout_after_terms_and_conditions' ) );

			add_action( 'woocommerce_before_thankyou', array( $this, 'hook_woocommerce_before_thankyou' ) );
			
			//WooCommerce - Shop My Account
			add_action( 'woocommerce_before_my_account', array( $this, 'hook_woocommerce_before_my_account' ) );
            add_action( 'woocommerce_after_my_account', array( $this, 'hook_woocommerce_after_my_account' ) );

			add_action( 'woocommerce_before_account_downloads', array( $this, 'hook_woocommerce_before_account_downloads' ) );
            add_action( 'woocommerce_after_account_downloads', array( $this, 'hook_woocommerce_after_account_downloads' ) );

			add_action( 'woocommerce_before_edit_account_form', array( $this, 'hook_woocommerce_before_edit_account_form' ) );
            add_action( 'woocommerce_after_edit_account_form', array( $this, 'hook_woocommerce_after_edit_account_form' ) );

			add_action( 'woocommerce_before_edit_account_address_form', array( $this, 'hook_woocommerce_before_edit_account_address_form' ) );
            add_action( 'woocommerce_after_edit_account_address_form', array( $this, 'hook_woocommerce_after_edit_account_address_form' ) );

			add_action( 'woocommerce_before_customer_login_form', array( $this, 'hook_woocommerce_before_customer_login_form' ) );
            add_action( 'woocommerce_after_customer_login_form', array( $this, 'hook_woocommerce_after_customer_login_form' ) );

			add_action( 'woocommerce_before_account_navigation', array( $this, 'hook_woocommerce_before_account_navigation' ) );
            add_action( 'woocommerce_after_account_navigation', array( $this, 'hook_woocommerce_after_account_navigation' ) );

			add_action( 'woocommerce_before_account_orders', array( $this, 'hook_woocommerce_before_account_orders' ) );
            add_action( 'woocommerce_after_account_orders', array( $this, 'hook_woocommerce_after_account_orders' ) );

			//Sidebar
			add_action( 'botiga_before_sidebar', array( $this, 'hook_before_sidebar' ) );	
			add_action( 'botiga_after_sidebar', array( $this, 'hook_after_sidebar' ) );	

			//Footer
			add_action( 'wp_footer', array( $this, 'hook_wp_footer' ) );
			add_action( 'botiga_footer_before', array( $this, 'hook_footer_before' ) );
			add_action( 'botiga_footer_after', array( $this, 'hook_footer_after' ) );

			if( class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'hf-builder' ) ) {
				add_action( 'botiga_bhfb_footer_inner_before', array( $this, 'hook_bhfb_footer_inner_before' ) );
				add_action( 'botiga_bhfb_footer_inner_after', array( $this, 'hook_bhfb_footer_inner_after' ) );
			} else {
				add_action( 'botiga_before_footer_widgets', array( $this, 'hook_before_footer_widgets' ) );
				add_action( 'botiga_after_footer_widgets', array( $this, 'hook_after_footer_widgets' ) );

				add_action( 'botiga_footer_widgets_content_start', array( $this, 'hook_footer_widgets_content_start' ) );
				add_action( 'botiga_footer_widgets_content_end', array( $this, 'hook_footer_widgets_content_end' ) );

				add_action( 'botiga_before_footer_copyright', array( $this, 'hook_before_footer_copyright' ) );
				add_action( 'botiga_after_footer_copyright', array( $this, 'hook_after_footer_copyright' ) );

				add_action( 'botiga_footer_copyright_content_start', array( $this, 'hook_footer_copyright_content_start' ) );
				add_action( 'botiga_footer_copyright_content_end', array( $this, 'hook_footer_copyright_content_end' ) );
			}
		}

        /**
         * String patterns to replace
         */
        private function replace_custom_markup( $str = '' ) {

            //Default
			$str = str_replace( 
				array( 
					'{{front_page_url}}',
					'{{blog_page_url}}'
				),
				array( 
					get_permalink( get_option('page_on_front') ),
					get_permalink( get_option('page_for_posts') )
				),
				$str 
			);

			// WooCommerce
            if( class_exists( 'Woocommerce' ) ) {
                $str = str_replace( 
                    array( 
						'{{front_page_url}}',
						'{{blog_page_url}}',
                        '{{cart_page_url}}',
                        '{{checkout_page_url}}',
                        '{{shop_page_url}}',
                        '{{shop_myaccount_url}}'
                    ),
                    array( 
						get_permalink( get_option('page_on_front') ),
						get_permalink( get_option('page_for_posts') ),
                        get_permalink( wc_get_page_id( 'cart' ) ), 
                        get_permalink( wc_get_page_id( 'checkout' ) ), 
                        get_permalink( wc_get_page_id( 'shop' ) ), 
                        get_permalink( wc_get_page_id( 'myaccount' ) ) 
                    ),
                    $str 
                );
            }

            return $str;
        }

		/**
		 * General hooks
		 */
		public function hook_wp_head() {
			$output = get_theme_mod( 'botiga_hook_wp_head' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	

        public function hook_wp_body_open() {
            $output = get_theme_mod( 'botiga_hook_wp_body_open' );
            echo do_shortcode( $this->replace_custom_markup( $output ) );
        }

		public function hook_before_site() {
			$output = get_theme_mod( 'botiga_hook_before_site' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

		public function hook_after_site() {
			$output = get_theme_mod( 'botiga_hook_after_site' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

		/**
		 * Header
		 */		
		public function hook_before_header() {
			$output = get_theme_mod( 'botiga_hook_before_header' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}		
		public function hook_after_header() {
			$output = get_theme_mod( 'botiga_hook_after_header' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

		/**
		 * Content
		 */		
		public function hook_before_page_header() {
			$output = get_theme_mod( 'botiga_hook_before_page_header' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_after_page_header() {
			$output = get_theme_mod( 'botiga_hook_after_page_header' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_before_main_wrapper() {
			$output = get_theme_mod( 'botiga_hook_before_main_wrapper' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_after_main_wrapper() {
			$output = get_theme_mod( 'botiga_hook_after_main_wrapper' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

		/**
		 * WooCommerce - Page Header
		 */		
		public function hook_woocommerce_before_page_header_shop_loop() {
		    if ( class_exists('WooCommerce') && ( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() ) ) {
		        $output = get_theme_mod( 'botiga_hook_woocommerce_before_page_header_shop_loop' );
		        echo do_shortcode( $this->replace_custom_markup( $output ) );
		    }
		}
		public function hook_woocommerce_after_page_header_shop_loop() {
		    if ( class_exists('WooCommerce') && ( is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() ) ) {
		        $output = get_theme_mod( 'botiga_hook_woocommerce_after_page_header_shop_loop' );
		        echo do_shortcode( $this->replace_custom_markup( $output ) );
		    }
		}

        /**
         * WooCommerce - General
         */
        public function hook_woocommerce_before_main_content() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_main_content' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_woocommerce_after_main_content() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_main_content' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

        /**
         * WooCommerce - Shop Archive
         */
        public function hook_woocommerce_before_shop_loop() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_shop_loop' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_woocommerce_after_shop_loop() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_shop_loop' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_woocommerce_before_shop_loop_item() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_shop_loop_item' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_woocommerce_after_shop_loop_item() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_shop_loop_item' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_woocommerce_before_shop_loop_item_title() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_shop_loop_item_title' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        public function hook_woocommerce_after_shop_loop_item_title() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_shop_loop_item_title' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

		/**
         * WooCommerce - Shop Single
         */
        public function hook_woocommerce_before_single_product() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_single_product' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_single_product() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_single_product' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_single_product_summary() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_single_product_summary' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_single_product_summary() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_single_product_summary' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_add_to_cart_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_add_to_cart_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_add_to_cart_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_add_to_cart_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_add_to_cart_button() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_add_to_cart_button' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_add_to_cart_button() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_add_to_cart_button' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_add_to_cart_quantity() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_add_to_cart_quantity' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_add_to_cart_quantity() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_add_to_cart_quantity' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_product_meta_start() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_product_meta_start' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_product_meta_end() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_product_meta_end' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
        
		/**
         * WooCommerce - Shop Cart
         */
        public function hook_woocommerce_before_cart() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_cart' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_cart() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_cart' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_cart_table() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_cart_table' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_cart_table() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_cart_table' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_cart_contents() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_cart_contents' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_cart_contents() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_cart_contents' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_cart_collaterals() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_cart_collaterals' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}

		/**
         * WooCommerce - Shop Checkout
         */
        public function hook_woocommerce_before_checkout_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_checkout_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_checkout_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_checkout_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_checkout_before_customer_details() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_checkout_before_customer_details' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_checkout_after_customer_details() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_checkout_after_customer_details' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_checkout_before_order_review() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_checkout_before_order_review' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_checkout_after_order_review() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_checkout_after_order_review' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_checkout_billing_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_checkout_billing_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_checkout_billing_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_checkout_billing_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_checkout_registration_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_checkout_registration_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_checkout_registration_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_checkout_registration_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_checkout_shipping_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_checkout_shipping_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_checkout_shipping_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_checkout_shipping_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_order_notes() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_order_notes' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_order_notes() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_order_notes' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_checkout_before_terms_and_conditions() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_checkout_before_terms_and_conditions' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_checkout_after_terms_and_conditions() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_checkout_after_terms_and_conditions' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_thankyou() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_thankyou' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		
		/**
         * WooCommerce - Shop My Account
         */
        public function hook_woocommerce_before_my_account() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_my_account' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_my_account() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_my_account' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_account_downloads() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_account_downloads' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_account_downloads() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_account_downloads' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_edit_account_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_edit_account_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_edit_account_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_edit_account_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_edit_account_address_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_edit_account_address_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_edit_account_address_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_edit_account_address_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_customer_login_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_customer_login_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_customer_login_form() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_customer_login_form' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_account_navigation() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_account_navigation' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_account_navigation() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_account_navigation' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_before_account_orders() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_before_account_orders' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_woocommerce_after_account_orders() {
			$output = get_theme_mod( 'botiga_hook_woocommerce_after_account_orders' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		
		/**
		 * Sidebar
		 */
		public function hook_before_sidebar() {
			$output = get_theme_mod( 'botiga_hook_before_sidebar' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_after_sidebar() {
			$output = get_theme_mod( 'botiga_hook_after_sidebar' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		
		/**
		 * Footer
		 */		
		public function hook_footer_before() {
			$output = get_theme_mod( 'botiga_hook_footer_before' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}		
		public function hook_footer_after() {
			$output = get_theme_mod( 'botiga_hook_footer_after' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_bhfb_footer_inner_before() {
			$output = get_theme_mod( 'botiga_hook_bhfb_footer_inner_before' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}
		public function hook_bhfb_footer_inner_after() {
			$output = get_theme_mod( 'botiga_hook_bhfb_footer_inner_after' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_before_footer_widgets() {
			$output = get_theme_mod( 'botiga_hook_before_footer_widgets' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_after_footer_widgets() {
			$output = get_theme_mod( 'botiga_hook_after_footer_widgets' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_footer_widgets_content_start() {
			$output = get_theme_mod( 'botiga_hook_footer_widgets_content_start' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_footer_widgets_content_end() {
			$output = get_theme_mod( 'botiga_hook_footer_widgets_content_end' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_before_footer_copyright() {
			$output = get_theme_mod( 'botiga_hook_before_footer_copyright' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_after_footer_copyright() {
			$output = get_theme_mod( 'botiga_hook_after_footer_copyright' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_footer_copyright_content_start() {
			$output = get_theme_mod( 'botiga_hook_footer_copyright_content_start' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_footer_copyright_content_end() {
			$output = get_theme_mod( 'botiga_hook_footer_copyright_content_end' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}	
		public function hook_wp_footer() {
			$output = get_theme_mod( 'botiga_hook_wp_footer' );
			echo do_shortcode( $this->replace_custom_markup( $output ) );
		}			

	}
}

Botiga_Customizer_Hooks::get_instance();