<?php
/**
 * Sanitize functions
 *
 * @package Botiga_Pro
 */

/**
 * Single Post Share Box
 */
function botiga_sanitize_single_post_share_box_networks( $input ) {
    $input     = (array) $input;
    $sanitized = array();

    foreach ( $input as $sub_value ) {
        if ( in_array( $sub_value, array( 'facebook', 'twitter', 'linkedin', 'pinterest', 'whatsapp', 'telegram', 'vk', 'weibo', 'reddit', 'ok', 'xing', 'mail', 'copyclipboard' ), true ) ) {
            $sanitized[] = $sub_value;
        }
    }
    return $sanitized;
}

/**
 * Sanitize quick links
 */
function botiga_sanitize_quick_links( $input ) {
	$input_decoded = json_decode( $input, true );
	if ( ! empty( $input_decoded ) ) {
		foreach ( $input_decoded as $boxk => $box ) {
			foreach ( $box as $key => $value ) {
				$input_decoded[ $boxk ][ $key ] = wp_kses_post( force_balance_tags( $value ) );
			}
		}
		return json_encode( $input_decoded );
	}
	return $input;
}