<?php
/**
 * Topbar Customizer options
 *
 * @package Botiga_Pro
 */

/**
 * Extend top bar elements with new options
 */
function botiga_topbar_elements_pro() {
    $elements = array(
		'social' 			=> esc_html__( 'Social', 'botiga-pro' ),
		'text' 				=> esc_html__( 'Text', 'botiga-pro' ),
		'secondary_nav' 	=> esc_html__( 'Secondary menu', 'botiga-pro' ),
		'contact_info' 		=> esc_html__( 'Contact info', 'botiga-pro' ),
        'html' 		        => esc_html__( 'HTML', 'botiga-pro' ),
        'shortcode'         => esc_html__( 'Shortcode', 'botiga-pro' )
	);

    if( class_exists( 'Woocommerce' ) ) {
        $elements['login_register'] = esc_html__( 'Login/Register', 'botiga-pro' );
    }

    return $elements;
}
add_filter( 'botiga_topbar_elements', 'botiga_topbar_elements_pro' );

/**
 * Extend top bar customizer with new features
 */
function botiga_pro_topbar_options( $wp_customize ) {
    
    // Tabs control
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_topbar_tabs' )->controls_general );
    $new_controls_general = array( '#customize-control-topbar_divider_8','#customize-control-topbar_html_content_title','#customize-control-topbar_html_content','#customize-control-topbar_divider_9','#customize-control-topbar_shortcode_content_title','#customize-control-topbar_shortcode_content','#customize-control-topbar_divider_10','#customize-control-topbar_login_register_title','#customize-control-topbar_login_register_settings_link' );
    $wp_customize->get_control( 'botiga_topbar_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );

    // Divider
    $wp_customize->add_setting( 'topbar_divider_8',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'topbar_divider_8',
            array(
                'section' 		  => 'botiga_section_top_bar',
                'active_callback' => function() { return botiga_callback_topbar_elements( 'html' ); },
                'priority'        => 231
            )
        )
    );

    // HTML field content
    $wp_customize->add_setting( 
        'topbar_html_content_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'topbar_html_content_title',
            array(
                'label'			  => esc_html__( 'HTML Content', 'botiga-pro' ),
                'section' 		  => 'botiga_section_top_bar',
                'active_callback' => function() { return botiga_callback_topbar_elements( 'html' ); },
                'priority'	 	  => 231
            )
        )
    );

    $wp_customize->add_setting(
        'topbar_html_content',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'topbar_html_content', 
        array(
            'label'           => '',
            'type'            => 'textarea',
            'section'         => 'botiga_section_top_bar',
            'active_callback' => function() { return botiga_callback_topbar_elements( 'html' ); },
            'priority'        => 231
        ) 
    );

    // Divider
    $wp_customize->add_setting( 'topbar_divider_9',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'topbar_divider_9',
            array(
                'section' 		  => 'botiga_section_top_bar',
                'active_callback' => function() { return botiga_callback_topbar_elements( 'shortcode' ); },
                'priority'        => 231
            )
        )
    );

    // Shortcode field content
    $wp_customize->add_setting( 
        'topbar_shortcode_content_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'topbar_shortcode_content_title',
            array(
                'label'			  => esc_html__( 'Shortcode Tag', 'botiga-pro' ),
                'section' 		  => 'botiga_section_top_bar',
                'active_callback' => function() { return botiga_callback_topbar_elements( 'shortcode' ); },
                'priority'	 	  => 231
            )
        )
    );

    $wp_customize->add_setting(
        'topbar_shortcode_content',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'topbar_shortcode_content', 
        array(
            'label'           => '',
            'type'            => 'text',
            'section'         => 'botiga_section_top_bar',
            'active_callback' => function() { return botiga_callback_topbar_elements( 'shortcode' ); },
            'priority'        => 231
        ) 
    );

    if( class_exists( 'Woocommerce' ) ) {        
        // Divider
        $wp_customize->add_setting( 'topbar_divider_10',
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'topbar_divider_10',
                array(
                    'section' 		  => 'botiga_section_top_bar',
                    'active_callback' => function() { return botiga_callback_topbar_elements( 'login_register' ); },
                    'priority'        => 231
                )
            )
        );

        // Login/register field
        $wp_customize->add_setting( 
            'topbar_login_register_title',
            array(
                'default' 			=> '',
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control( 
            new Botiga_Text_Control( 
                $wp_customize, 
                'topbar_login_register_title',
                array(
                    'label'			  => esc_html__( 'Login/Register', 'botiga-pro' ),
                    'section' 		  => 'botiga_section_top_bar',
                    'active_callback' => function() { return botiga_callback_topbar_elements( 'login_register' ); },
                    'priority'	 	  => 231
                )
            )
        );

        $wp_customize->add_setting( 
            'topbar_login_register_settings_link',
            array(
                'default' 			=> '',
                'sanitize_callback' => 'esc_attr'
            )
        );
    
        $wp_customize->add_control( 
            new Botiga_Text_Control( 
                $wp_customize, 
                'topbar_login_register_settings_link',
                array(
                    'label'           => '',
                    'description'     => '<a class="footer-widget-area-link footer-widget-area-link-1" href="javascript:wp.customize.section( \'botiga_login_register_popup\' ).focus();">' . esc_html__( 'Login/Register Settings', 'botiga-pro' ) . '<span class="dashicons dashicons-arrow-right-alt2"></span></a>',
                    'section' 		  => 'botiga_section_top_bar',
                    'active_callback' => function() { return botiga_callback_topbar_elements( 'login_register' ); },
                    'priority'        => 231
                )
            )
        );
    }
}
add_action( 'customize_register', 'botiga_pro_topbar_options', 999 );