<?php
/**
 * Login/Register Popup Customizer options
 *
 * @package Botiga_Pro
 */

function botiga_login_register_popup_options( $wp_customize ) {

    if( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'login-popup' ) ) {
        return;
    }

    // OBS: This section is hidden trough customizer.min.css from parent theme
    $wp_customize->add_section(
        'botiga_login_register_popup',
        array(
            'title'         => esc_html__( 'Login/Register Popup', 'botiga-pro'),
            'priority'      => 999
        )
    );

    $wp_customize->add_setting(
        'login_register_link_text',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => esc_html__( 'Login', 'botiga-pro' ),
        )       
    );
    $wp_customize->add_control( 
        'login_register_link_text',
        array(
            'label'           => esc_html__( 'Login Link Text', 'botiga-pro' ),
            'description'     => esc_html__( 'Visible only to no logged in users.', 'botiga-pro' ),
            'type'            => 'text',
            'section'         => 'botiga_login_register_popup',
            'priority'        => 60
        ) 
    );

    $wp_customize->add_setting(
        'login_register_show_welcome_message',
        array(
            'sanitize_callback' => 'botiga_sanitize_checkbox',
            'default'           => 1,
        )       
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'login_register_show_welcome_message',
            array(
                'label'           => esc_html__( 'Show Welcome Message', 'botiga-pro' ),
                'description'     => esc_html__( 'Show a welcome message when the user it\'s logged in.', 'botiga-pro' ),
                'section'         => 'botiga_login_register_popup',
                'priority'        => 80
            )
        )
    );

    $wp_customize->add_setting(
        'login_register_welcome_message_text',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => sprintf( esc_html__( 'Welcome %s', 'botiga-pro' ), '{display_name}' ),
        )       
    );
    $wp_customize->add_control( 
        'login_register_welcome_message_text',
        array(
            'label'           => esc_html__( 'Welcome message text', 'botiga-pro' ),
            'description'     => esc_html__( 'You can use the following tags: {user_firstname}, {user_lastname}, {user_email}, {user_login}, {display_name}', 'botiga-pro' ),
            'type'            => 'text',
            'section'         => 'botiga_login_register_popup',
            'active_callback' => 'botiga_login_register_has_welcome_message',
            'priority'        => 90
        ) 
    );
}
add_action( 'customize_register', 'botiga_login_register_popup_options', 999 );