<?php
/**
 * Header Mobile Customizer options
 *
 * @package Botiga_Pro
 */

function botiga_mobile_header_elements_pro() {
    $elements = array(
		'search' 			=> esc_html__( 'Search', 'botiga-pro' ),
		'mobile_woocommerce_icons' => esc_html__( 'Cart &amp; account icons', 'botiga-pro' ),
		'button' 			=> esc_html__( 'Button', 'botiga-pro' ),
		'contact_info' 		=> esc_html__( 'Contact info', 'botiga-pro' ),
        'html'              => esc_html__( 'HTML', 'botiga-pro' ),
        'shortcode'         => esc_html__( 'Shortcode', 'botiga-pro' )
	);

    if( class_exists( 'Woocommerce' ) ) {
        $elements['login_register'] = esc_html__( 'Login/Register', 'botiga-pro' );
    }

    return $elements;
}
add_filter( 'botiga_mobile_header_elements', 'botiga_mobile_header_elements_pro' );

function botiga_mobile_offcanvas_header_elements_pro() {
    $elements = array(
		'search' 			=> esc_html__( 'Search', 'botiga-pro' ),
		'mobile_offcanvas_woocommerce_icons' => esc_html__( 'Cart &amp; account icons', 'botiga-pro' ),
		'button' 			=> esc_html__( 'Button', 'botiga-pro' ),
		'contact_info' 		=> esc_html__( 'Contact info', 'botiga-pro' ),
        'html'              => esc_html__( 'HTML', 'botiga-pro' ),
        'shortcode'         => esc_html__( 'Shortcode', 'botiga-pro' )
	);

    if( class_exists( 'Woocommerce' ) ) {
        $elements['login_register'] = esc_html__( 'Login/Register', 'botiga-pro' );
    }

    return $elements;
}
add_filter( 'botiga_mobile_offcanvas_header_elements', 'botiga_mobile_offcanvas_header_elements_pro' );

/**
 * Extend header customizer with new features
 */
function botiga_pro_header_mobile_options( $wp_customize ) {
    
    // Tabs control
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_mobile_header_tabs' )->controls_general );
    $new_controls_general = array( '#customize-control-enable_mobile_header_wishlist_icon', '#customize-control-enable_mobile_header_offcanvas_wishlist_icon','#customize-control-mobile_offcanvas_hide_logo' );
    $wp_customize->get_control( 'botiga_mobile_header_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );
    
    $controls_design     = json_decode( $wp_customize->get_control( 'botiga_mobile_header_tabs' )->controls_design );
    $new_controls_design = array();
    $wp_customize->get_control( 'botiga_mobile_header_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

    // Wishlist Icon
    $wp_customize->add_setting(
        'enable_mobile_header_wishlist_icon',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'enable_mobile_header_wishlist_icon',
            array(
                'label'         	=> esc_html__( 'Enable wishlist icon', 'botiga-pro' ),
                'section'       	=> 'botiga_section_mobile_header',
                'active_callback' 	=> 'botiga_callback_shop_product_wishlist_layout',
                'priority'			=> 61
            )
        )
    );

    // Offcanvas Hide logo
    $wp_customize->add_setting(
        'mobile_offcanvas_hide_logo',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'mobile_offcanvas_hide_logo',
            array(
                'label'         	=> esc_html__( 'Hide Offcanvas Logo', 'botiga-pro' ),
                'section'       	=> 'botiga_section_mobile_header',
                'priority'  		=> 81
            )
        )
    );

    // Offcanvas Wishlist Icon
    $wp_customize->add_setting(
        'enable_mobile_header_offcanvas_wishlist_icon',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'enable_mobile_header_offcanvas_wishlist_icon',
            array(
                'label'         	=> esc_html__( 'Enable wishlist icon', 'botiga-pro' ),
                'section'       	=> 'botiga_section_mobile_header',
                'active_callback' 	=> 'botiga_callback_shop_product_wishlist_layout',
                'priority'			=> 121
            )
        )
    );
    
}
add_action( 'customize_register', 'botiga_pro_header_mobile_options', 999 );