<?php 

/**
 * Backward compatibility
 * 
 * Ensure compatibility with older versions from Botiga (free theme) and Botiga Pro (plugin)
 * The main purpose is avoid fatal errors when the user updates the plugin or the theme
 */

/**
 * Botiga Color Group
 * 
 * Refers to the 'Botiga_COlor_Group' customizer class that is added in Botiga free theme since version 2.0.0
 * We have to check if the class exists to avoid fatal errors
 * 
 * @since 1.1.4
 * 
 */

if( is_customize_preview() ) {

    function botiga_customize_register_backward_color_group_control( $customizer ) {
        if( class_exists( 'Botiga_Color_Group' ) ) {
            return;
        }

        class Botiga_Color_Group extends WP_Customize_Control {

            public $type = 'botiga-color-group-control';
        
            public function render_content() { ?>
                <p><?php echo esc_html__( 'This control is not working properly. To get it working you jsut have to update Botiga (free theme) to the latest version.', 'botiga-pro' ); ?></p>
                <?php
            }
        
        }
    }
    add_action( 'customize_register', 'botiga_customize_register_backward_color_group_control', 100 );

}