/**
 * Side Mini Cart
 * 
 * jQuery dependent: true
 * 
 */
(function($){

    'use strict';

    var botiga = botiga || {};

    botiga.sideMiniCart = {
        $miniCartWrapper: $( 'body' ).hasClass( 'has-bhfb-builder' ) ? $( '.bhfb-header.bhfb-desktop .site-header-cart' ) : $( '#masthead .site-header-cart' ),

        init: function() {
            const _this = this;

            window.addEventListener( 'side-mini-cart-toggle', function(){
                const side_mini_cart = document.getElementsByClassName( 'botiga-side-mini-cart' )[0];

                if( typeof side_mini_cart === 'undefined' ) {
                    return false;
                }

                if( side_mini_cart.classList.contains( 'show' ) ) {
                    if( typeof jQuery !== 'undefined' ) {
                        _this.layoutButtons();
                    }

                    if( window.matchMedia( 'screen and (max-width: 767px)' ).matches ) {
                        document.getElementsByTagName( 'html' )[0].classList.add( 'botiga-overflow-hidden' );
                    }

                    document.body.classList.add( 'side-mini-cart-overlay' );
                    document.body.addEventListener( 'click', _this.overlayCloseHandler );
                } else {
                    if( window.matchMedia( 'screen and (max-width: 767px)' ).matches ) {
                        document.getElementsByTagName( 'html' )[0].classList.remove( 'botiga-overflow-hidden' );
                    }
                    
                    document.body.classList.remove( 'side-mini-cart-overlay' );
                    document.body.removeEventListener( 'click', _this.overlayCloseHandler );
                }

                // The side mini cart bottom area buttons are hidden in some devices because the bottom address bar covers the bottom part of the screen
                // This code will simulate a bit of scroll to show the buttons
                if( _this.isSafari() && window.matchMedia('(max-width: 767px)').matches ) {
                    setTimeout(function(){
                        jQuery( 'html, body' ).animate( { scrollTop: 50 }, 500 );
                    }, 1000);
                }
            } );

            if( typeof jQuery !== 'undefined' ) {
                
                // Layout buttons
                $( document.body ).on( 'wc_fragment_refresh added_to_cart removed_from_cart', function(){
                    _this.layoutButtons();
                });

                // Open side mini cart on ajax add to cart
                const side_mini_cart = document.getElementsByClassName( 'botiga-side-mini-cart' );

                if( side_mini_cart && side_mini_cart[0] && side_mini_cart[0].getAttribute('data-auto-open') ) {
                    $( document.body ).on( 'added_to_cart', function() {
                        side_mini_cart[0].classList.add( 'show' );
                        window.dispatchEvent( new Event( 'side-mini-cart-toggle' ) );
                    });
                }

            }

            _this.floatingMiniCartIcon();

        },

        isSafari: function() {
            return /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
        },

        overlayCloseHandler: function() {
            if( event.target.closest( '.botiga-side-mini-cart' ) === null ) {
                const side_mini_cart_close = document.getElementsByClassName( 'botiga-side-mini-cart__close-button' )[0];
                side_mini_cart_close.dispatchEvent( new Event( 'click' ) );
            }
        },

        layoutButtons: function() {
            setTimeout(function(){
                if( $( '.widget_shopping_cart > .side-mini-cart-actions-wrapper' ).length ) {
                    $( '.widget_shopping_cart > .side-mini-cart-actions-wrapper' )[0].remove();
                }
                $( '<div class="side-mini-cart-actions-wrapper"></div>' ).appendTo( '.widget_shopping_cart' );

                if( $( '.widget_shopping_cart > .woocommerce-mini-cart__total' ).length ) {
                    $( '.widget_shopping_cart > .woocommerce-mini-cart__total' )[0].remove();
                }
                $( '.woocommerce-mini-cart__total' ).first().clone().appendTo( '.botiga-side-mini-cart .side-mini-cart-actions-wrapper' );
                
                if( $( '.widget_shopping_cart > .woocommerce-mini-cart__buttons' ).length ) {
                    $( '.widget_shopping_cart > .woocommerce-mini-cart__buttons' )[0].remove();
                }
                $( '.woocommerce-mini-cart__buttons' ).first().clone().appendTo( '.botiga-side-mini-cart .side-mini-cart-actions-wrapper' );

                // No products in the cart
                if( ! $( '.woocommerce-mini-cart .mini_cart_item' ).length ) {
                    $( '.widget_shopping_cart > .woocommerce-mini-cart__total' ).remove();
                    $( '.widget_shopping_cart > .woocommerce-mini-cart__buttons' ).remove();
                }
            }, 300);   
        },

        floatingMiniCartIcon: function() {
            const
                _this            = this,
                floatingMiniCart = $( '.botiga-floating-mini-cart-icon' ), 
                miniCartButton   = _this.$miniCartWrapper.find( 'a.cart-contents' );

            if( ! floatingMiniCart.length ) {
                return false;
            }

            if( ! miniCartButton.length ) {
                return false;
            }

            // Better UX inside customizer
            // Always show on customizer, even if display 'when cart is not empty' is set.
            if( typeof window.parent.wp.customize !== 'undefined' ) {
                floatingMiniCart.addClass( 'show' );
            } else {

                // Do the check to display the floating mini cart icon after user interaction.
                let flag = false;
                $( window ).on( 'scroll mousemove touchstart', function(){
                    if( ! flag ) {
                        _this.updateFloatingMiniCartIconCount();
                        _this.checkMiniCartCountAndDisplay();
                        flag = true;
                    }
                } );

            }

            $( document.body ).on( 'added_to_cart', function(e){
                _this.updateFloatingMiniCartIconCount();
                _this.checkMiniCartCountAndDisplay();
            });

            $( document.body ).on( 'removed_from_cart', function(e){
                _this.updateFloatingMiniCartIconCount();
                _this.checkMiniCartCountAndDisplay();
            });

            floatingMiniCart.on( 'click', function(e){
                e.preventDefault();

                setTimeout(function(){
                    miniCartButton.trigger( 'click' );
                }, 50);
            } );
        },

        checkMiniCartCountAndDisplay: function() {
            const 
                _this            = this,
                floatingMiniCart = $( '.botiga-floating-mini-cart-icon' ),
                miniCartCount    = _this.$miniCartWrapper.find( '.count-number' ).text();

            if( floatingMiniCart.data( 'display' ) === 'always' ) {
                $( '.botiga-floating-mini-cart-icon' ).addClass( 'show' );
                return false;
            }

            if( miniCartCount == '0' ) {
                $( '.botiga-floating-mini-cart-icon' ).removeClass( 'show' );
            } else {
                $( '.botiga-floating-mini-cart-icon' ).addClass( 'show' );
            }
        },

        updateFloatingMiniCartIconCount: function() {
            const
                _this         = this, 
                miniCartCount = _this.$miniCartWrapper.find( '.count-number' ).text();

            $( '.botiga-floating-mini-cart-icon .botiga-floating-mini-cart-icon-counter' ).text( miniCartCount );

            $( window ).trigger( 'botiga.floting.mini.cart.count.updated' );
        }

    }

    jQuery( document ).ready(function(){
        botiga.sideMiniCart.init() 
    } );

})(jQuery);