/**
 * Shopify Checkout
 * 
 */
(function($){

    'use strict';

    var botiga = botiga || {};

    botiga.shopifyCheckout = {

        init: function() {

            this.i18n();
            this.attributes();
            this.breadcrumbs();
            this.events();
            
            return this;

        },

        i18n: function(){
            $.extend( $.validator.messages, {
                required: botiga_shopify_checkout.i18n.validation.required,
                remote: botiga_shopify_checkout.i18n.validation.remote,
                email: botiga_shopify_checkout.i18n.validation.email,
                url: botiga_shopify_checkout.i18n.validation.url,
                date: botiga_shopify_checkout.i18n.validation.date,
                dateISO: botiga_shopify_checkout.i18n.validation.dateISO,
                number: botiga_shopify_checkout.i18n.validation.number,
                digits: botiga_shopify_checkout.i18n.validation.digits,
                equalTo: botiga_shopify_checkout.i18n.validation.equalTo,
                maxlength: $.validator.format( botiga_shopify_checkout.i18n.validation.maxlength ),
                minlength: $.validator.format( botiga_shopify_checkout.i18n.validation.minlenght ),
                rangelength: $.validator.format( botiga_shopify_checkout.i18n.validation.rangelenght ),
                range: $.validator.format( botiga_shopify_checkout.i18n.validation.range ),
                max: $.validator.format( botiga_shopify_checkout.i18n.validation.max ),
                min: $.validator.format( botiga_shopify_checkout.i18n.validation.min ),
                step: $.validator.format( botiga_shopify_checkout.i18n.validation.step )
            } );
        },

        attributes: function() {

            $('.validate-required').each(function() {
                $(this).find(':input').attr('required', true);
            });

        },

        validate: function() {

            var $form = $('.botiga-sc-form');

            var valid = $form.valid();

            if ( ! valid ) {
                var $error = $form.find('.error').first();
                if ( $error.length ) {
                    window.scrollTo({ top: $error.offset().top - 100, behavior: 'smooth' });
                }
            }

            return valid;

        },

        breadcrumbs: function() {

            var self   = this;
            var $items = $('.botiga-sc-breadcrumb-item');

            if ( ! $items.length ) {
                return;
            }

            $items.on('click', function( e ) {

                e.preventDefault();

                var $item = $(this);
                var contentId = $item.data('content-id');

                if ( contentId !== 'information' && ! self.validate() ) {
                    return;
                }

                if ( contentId === 'payment' ) {

                    var $shippingContent = $('.botiga-sc-content-item[data-content-id="shipping"]');
                    var $shippingMethods = $('.botiga-sc-shipping-method');

                    if ( $shippingContent.length && $shippingMethods.length === 0 ) {
                        return;
                    }

                }

                $items.removeClass('active');
                $item.addClass('active');

                var $content  = $('.botiga-sc-content-item[data-content-id="'+ contentId +'"]');
                var $siblings = $content.siblings();

                $siblings.find(':input').attr( 'readonly', 'readonly' );
                $siblings.removeClass('active');

                $content.find(':input').removeAttr( 'readonly' );
                $content.addClass('active');

                if ( $content.data('content-id') !== 'information' ) {

                    var $fields = $('.botiga-sc-content-item[data-content-id="information"]');
                    var $shipTo = $('.botiga-sc-detail-shipping');

                    $('.botiga-sc-detail-email').html( $('.botiga-sc-field-email').val() );

                    var stateObj    = [];
                    var addressObj  = [];
                    var shippingObj = [];

                    // Address 1-2
                    addressObj.push( $fields.find('.botiga-sc-field-address_1').val() );
                    addressObj.push( $fields.find('.botiga-sc-field-address_2').val() );

                    shippingObj.push( addressObj.filter(Boolean).join(', ') );
                    
                    // Postcode / City / State
                    stateObj.push( $fields.find('.botiga-sc-field-postcode').val() );
                    stateObj.push( $fields.find('.botiga-sc-field-city').val() );
 
                    var $stateField = $fields.find('.botiga-sc-field-state');
                    var stateValue  = $stateField.hasClass('state_select') ? $stateField.children(':selected').text() : $stateField.val();
                    stateObj.push( stateValue );

                    shippingObj.push( stateObj.filter(Boolean).join(' ') );

                    // Country
                    shippingObj.push( $fields.find('.botiga-sc-field-country').children(':selected').text() );

                    $shipTo.html( shippingObj.filter(Boolean).join(', ') );

                    var $shippingContent = $('.botiga-sc-content-item[data-content-id="shipping"]');
                    var $shippingMethods = $('.botiga-sc-shipping-method');

                    if ( $shippingContent.length && $shippingMethods.length ) {
                        $('.botiga-sc-detail-method').html( $shippingMethods.find('input:checked').data('label') );
                    }

                }

            });

            var $change = $('.botiga-sc-detail-change');

            $change.on('click', function( e ) {

                e.preventDefault();

                var contentId = $(this).data('content-id');

                $('.botiga-sc-breadcrumb-item[data-content-id="'+ contentId +'"]').trigger('click');

            });

            $(document).on('click', '.botiga-sc-prev', function( e ) {

                var $prev = $(this);

                if ( ! $prev.hasClass('botiga-sc-return-cart') ) {

                    e.preventDefault();

                    var contentId = $prev.closest('.botiga-sc-content-item').prev().data('content-id');

                    $('.botiga-sc-breadcrumb-item[data-content-id="'+ contentId +'"]').trigger('click');

                }

            });

            $(document).on('click', '.botiga-sc-next', function( e ) {

                e.preventDefault();

                var $next = $(this);
                var contentId = $next.closest('.botiga-sc-content-item').next().data('content-id');

                $('.botiga-sc-breadcrumb-item[data-content-id="'+ contentId +'"]').trigger('click');

            });

        },

        events: function() {

            var self = this;

            $(document).on('click', '.botiga-sc-submit-button', function( e ) {

                if ( ! self.validate() ) {
                    e.preventDefault();
                    return;
                }

            });

            $(document).on('change', '.botiga-sc-different-address input[name="bill_to_different_address"]', function( e ) {

                e.preventDefault();

                var $input = $(this);

                if ( $input.is(':checked') && $input.val() === 'different_from_shipping' ) {
                    $( '.botiga-sc-shipping-address' ).slideDown(200);
                    $('.botiga-sc-different-address-input').trigger('change');
                } else {
                    $( '.botiga-sc-shipping-address' ).slideUp(200);
                    $('.botiga-sc-different-address-input').trigger('change');
                }

            });

            var $accountFields = $('.botiga-sc-create-account-fields');

            if ( $accountFields.length ) {

                $(document).on('change', '.botiga-sc-create-account-input', function( e ) {

                    e.preventDefault();

                    $accountFields.slideToggle(200);

                });

            }
            
            $(document).on('click', '.botiga-sc-apply-coupon', function( e ) {

                e.preventDefault();

                var couponCode = $('.botiga-sc-coupon-code').val();

                if ( ! couponCode ) {
                    return;
                }

                $.ajax({
                    type: 'POST',
                    url: wc_checkout_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'apply_coupon' ),
                    data: {
                        security: wc_checkout_params.apply_coupon_nonce,
                        coupon_code: couponCode,
                    },
                    dataType: 'html',
                    success: function( html ) {
                        $( '.woocommerce-error, .woocommerce-message:not(.botiga-sc-shipping-method-message)' ).remove();
                        $( document.body ).trigger( 'applied_coupon_in_checkout', [ couponCode ] );
                        $( document.body ).trigger( 'update_checkout', { update_shipping_method: false } );
                        $('.botiga-sc-form').before(html);
                    }
                });

            });

            $(document).on('change', '.update_totals_on_change select', function() {
                self.attributes();
            });

        },

    };

    $(document).ready( function(){
        botiga.shopifyCheckout.init();
    });

})(jQuery);