/**
 * Botiga Product Swatch
 * 
 * jQuery dependent: true
 */

'use strict';

var botiga = botiga || {};

/**
 * Product Swatch
 */
botiga.productSwatch = {
	init: function() {
		var wrapper = document.querySelectorAll( '.botiga-variations-wrapper:not(.botiga-widget-variations)' );

		this.initInsideQuickView();

		if( ! wrapper.length ) {
			return false;
		}

		for( var i=0;i<wrapper.length;i++ ) {
			this.variations( wrapper[i] );
		}

		this.resetVariationsEvent();
		this.variationMouseOver();
	},

	variations: function( wrapper ) {
		var self   = this,
			select = wrapper.querySelector( 'select' ),
			items  = wrapper.querySelectorAll( '.botiga-variation-item' );

		for( var i=0;i<items.length;i++ ) {

			if( select.value ) {
				var variation_item_selected = wrapper.querySelector( '.botiga-variation-item[value="'+ select.value +'"]' );

				variation_item_selected.classList.add( 'active' );
				variation_item_selected.dispatchEvent( new Event( 'botiga.variations.selected' ) );
			}

			items[i].addEventListener( 'click', function(e){

				e.preventDefault();

				var value = this.getAttribute( 'value' );

				self.removeActiveClass( this );

				if ( value === select.value ) {
					value = '';
				} else {
					this.classList.add( 'active' );
				}

				jQuery( select ).val( value ).trigger( 'change' );

				self.matchVariations( this );

			} );
			
			items[i].addEventListener( 'botiga.variations.selected', function(e){
				var _self = this;
				setTimeout(function(){
					self.matchVariations( _self );
				}, 300);
			});
			
		}

	},

	matchVariations: function( variation ) {
		var wrapper = variation.closest( '.variations' ).querySelectorAll( '.botiga-variations-wrapper' );
		
		for( var i=0;i<wrapper.length;i++ ) {
			var arr 		  = [],
				items  		  = wrapper[i].querySelectorAll( '.botiga-variation-item' ),
				selectOptions = wrapper[i].querySelector( 'select' ).options;

			for( var u=0;u<selectOptions.length;u++ ) {
				arr.push( selectOptions[u].value );
			}

			arr = arr.filter( e => e);
			for( var a=0;a<items.length;a++ ) {
				if( arr.includes( items[a].getAttribute( 'value' ) ) ) {
					items[a].classList.remove( 'disabled' );
				} else {
					items[a].classList.add( 'disabled' );
				}
			}

		}
	},

	removeActiveClass: function( item ) {
		var 
			self = this,
			items = typeof item !== 'undefined' ? item.closest( 'div' ).querySelectorAll( '.botiga-variation-item' ) : document.querySelectorAll( '.botiga-variations-wrapper .botiga-variation-item' );

		for( var u=0;u<items.length;u++ ) {
			items[u].classList.remove( 'active' );
			items[u].classList.remove( 'disabled' );
		}
	},

	resetVariationsEvent: function() {
		var self = this,
			resetbtn = document.querySelectorAll( '.reset_variations' );

		for( var i=0;i<resetbtn.length;i++ ) {
			resetbtn[i].addEventListener( 'click', function(){
				self.removeActiveClass( this );
			} );
		}
	},

	initInsideQuickView: function() {
		const self = this;

		window.addEventListener( 'botiga.quickview.ajax.loaded', function(){
			var wrapper = document.querySelectorAll( '.botiga-quick-view-popup .botiga-variations-wrapper:not(.botiga-widget-variations)' );

			if( ! wrapper.length ) {
				return false;
			}

			for( var i=0;i<wrapper.length;i++ ) {
				self.variations( wrapper[i] );
			}

			self.resetVariationsEvent();
		} );
	},

	getVariationAttributes: function( variations, value ) {
		for ( var index in variations ) {
			if ( variations[ index ] ) {
				var variation = variations[ index ];
				var attributes = variation.attributes;
				for ( var attribute in attributes ) {
					if ( attributes.hasOwnProperty( attribute ) ) {
						if ( attributes[ attribute ] === value ) {
							return variation;
						}
					}
				}
			}
		}
	},

	variationMouseOver: function() {

		var self = this;

		var $variations = jQuery( '.botiga-variations-mouseover' );

		$variations.each( function() {

			var $variation    = jQuery(this);
			var $block        = $variation.closest('.wc-block-grid__product');
			var $product      = $block.length ? $block : $variation.closest( '.product' );
			var $galleryImage = $product.find('.woocommerce-product-gallery__image');
			var $productImage = $product.find('.woocommerce-loop-product__link');
			var $blockImage   = $product.find('.wc-block-grid__product');
			var $mainImage    = $product.find('img').first();
			var $selector     = $variation.find('select');

			if ( $galleryImage.length ) {
				$mainImage = $galleryImage.first().find('img').first();
			} else if ( $productImage.length ) {
				$mainImage = $productImage.first().find('img').first();
			} else if ( $blockImage.length ) {
				$mainImage = $blockImage.first().find('img').first();
			}

			$mainImage.attr({
				'data-o_src': $mainImage.attr('src'),
				'data-o_srcset': $mainImage.attr('srcset'),
				'data-o_sizes': $mainImage.attr('sizes'),
			});

			var variations = $product.find('form').data('product_variations');

			var $items = $variation.find('.botiga-variation-item');

			$items.each( function() {

				var $item = jQuery(this);
				var atts  = {};

				$item.on('mouseover mouseout', function( event ) {

					if ( event.type === 'mouseover' ) {

						var variation = self.getVariationAttributes( variations, $item.attr('value') );

						atts.src    = variation.image.thumb_src;
						atts.srcset = variation.image.srcset;
						atts.sizes  = variation.image.sizes;

						if ( $galleryImage.length ) {
							atts.src = variation.image.src;
						}

					} else {

						if ( $selector.val() ) {

							var variation = self.getVariationAttributes( variations, $selector.val() );

							atts.src    = variation.image.thumb_src;
							atts.srcset = variation.image.srcset;
							atts.sizes  = variation.image.sizes;

							if ( $galleryImage.length ) {
								atts.src = variation.image.src;
							}

						} else {

							atts.src    = $mainImage.attr('data-o_src');
							atts.srcset = $mainImage.attr('data-o_srcset');
							atts.sizes  = $mainImage.attr('data-o_sizes');

						}

					}

					if ( $mainImage.attr('src') !== atts.src ) {
						$mainImage.attr( atts );
					}

				});

			});

		});

	},

}

/**
 * Archive Product Swatches
 */
 botiga.archiveProductSwatch = {

	init: function() {

		if ( typeof jQuery !== 'function' ) {
			return;
		}

		var $forms = jQuery('.botiga-product-swatches .variations_form');

		if ( ! $forms.length || typeof wc_add_to_cart_variation_params === 'undefined' ) {
			return;
		}

		var ajaxAddToCart = ( typeof wc_add_to_cart_params !== 'undefined' ) ? true : false;

		$forms.each( function() {

			var $form          = jQuery(this);
			var isGutenberg    = $form.closest('.wc-block-grid__products').length;
			var $product       = isGutenberg ? $form.closest( '.wc-block-grid__product' ) : $form.closest( '.product' );
			var $price         = $product.find('.price').first();
			var $image         = $product.find('img').first();
			var $button        = $product.find('.add_to_cart_button').first();

			if( ! $button.length ) {
				$button = $product.find('.button.product_type_variable');
			}

			var $swatches      = $product.find('.botiga-product-swatches');
			var $clonedPrice   = $price.clone();
			var $clonedImage   = $image.clone();
			var $clonedButton  = $button.clone();
			var buttonLayout   = $swatches.data('button-layout');
			var foundVariation = false;

			if( buttonLayout === 'layout3' || buttonLayout === 'layout4' ) {
				jQuery( document ).on('added_to_cart', function() {
					jQuery('.added_to_cart').remove();
				});
			}

			$form.on( 'found_variation', function( event, variation ) {
				var imageSrc    = $clonedImage.attr( 'src' ),
					imageSrcSet = $clonedImage.attr( 'srcset' ),
					imageSizes  = $clonedImage.attr( 'sizes' );

				if( variation.image.thumb_src !== $clonedImage.attr( 'src' ) ) {
					imageSrc    = variation.image.thumb_src;
					imageSrcSet = variation.image.srcset;
					imageSizes  = variation.image.sizes;
				}

				$image.attr({
					'src': imageSrc,
					'srcset': imageSrcSet,
					'sizes': imageSizes,
				});

				$price.html( jQuery(variation.price_html).html() );

				if ( $button.hasClass('added') ) {
					$button.removeClass('added');
					$button.next('.added_to_cart').remove();
				}

				if ( buttonLayout !== 'layout4' ) {
					if ( variation.is_in_stock || variation.backorders_allowed ) {

						if ( ajaxAddToCart ) {

							if( $button.closest( '.button-layout3' ).length ) {
								$button.addClass( 'add_to_cart_button' );
							}

							$button.attr({
								'data-quantity': 1,
								'data-product_id': variation.variation_id,
								'data-product_sku': variation.variation_sku,
							});
						} else {
							$button.attr( 'href', '?add-to-cart='+variation.variation_id );
						}

						$button.html( $swatches.data('button-add-text') ).addClass('ajax_add_to_cart');

					} else {

						if ( ! ajaxAddToCart ) {
							$button.attr( 'href', $clonedButton.attr('href') );
						}

						$button.html( $swatches.data('button-select-text') ).removeClass('ajax_add_to_cart');

					}
				}

				const 
					$productStockMessage = $product.find( '.botiga-product-stock' ),
					initialStockValue    = $product.find( '.botiga-product-stock > span' ).text();

				if( typeof $productStockMessage.data( 'initial-stock-status' ) === 'undefined' ) {
					$productStockMessage.data( 'initial-stock-status', initialStockValue );
				}

				$productStockMessage.removeClass( 'botiga-product-stock-low' );

				if( $productStockMessage.length ) {
					if( variation.is_in_stock && variation.availability_html.indexOf( 'available-on-backorder' ) !== -1 ) {
						$productStockMessage.find( '> span' ).html( $product.find( '.botiga-product-stock' ).data( 'backorder-text' ) );
					} else if( variation.is_in_stock ) {
						$productStockMessage.find( '> span' ).html( $product.find( '.botiga-product-stock' ).data( 'in-stock-text' ) );
					} else {
						$productStockMessage.find( '> span' ).html( $product.find( '.botiga-product-stock' ).data( 'out-of-stock-text' ) );
						$productStockMessage.addClass( 'botiga-product-stock-low' );
					}

					$product.find( '.woocommerce-variation-availability' ).css( 'display', 'none' );
				}

				foundVariation = true;
			});

			$form.on( 'reset_data', function() {

				if ( foundVariation ) {
					$image.attr({
						'src': $clonedImage.attr('src'),
						'srcset': $clonedImage.attr('srcset'),
						'sizes': $clonedImage.attr('sizes'),
					});

					$price.html( $clonedPrice.html() );

					if ( buttonLayout !== 'layout4' ) {
						$button.html( $swatches.data('button-select-text') ).removeClass('ajax_add_to_cart');
					}

					if ( ! ajaxAddToCart ) {
						$button.attr( 'href', $clonedButton.attr('href') );
					}

					if ( $button.hasClass('added') ) {
						$button.removeClass('added');
						$button.next('.added_to_cart').remove();
					}

					$product.find( '.botiga-product-stock > span' ).html( $product.find( '.botiga-product-stock' ).data( 'initial-stock-status' ) );

					foundVariation = false;

				}

			});

		});

	}

}

jQuery( document ).ready(function(){
	botiga.productSwatch.init();
	botiga.archiveProductSwatch.init();
} );