(function ($) {

	'use strict';

	window.botigaProductSwatches = {

		init: function () {

			this.wooTermColor();
			this.wooTermImageField();

		},

		wooTermColor: function () {

			var $colorType = $('.botiga-color-type');

			if ($colorType.length) {
				$colorType.on('change', function() {
					$('.botiga-color-field-items').addClass('hidden');
					$('.botiga-color-type-'+ $(this).val()).removeClass('hidden');
				});
			}

			var $colorField = $('.botiga-color-field');

			if ($colorField.length) {
				$colorField.each(function () {
					$(this).wpColorPicker();
				});
			}

		},

		wooTermImageField: function () {

			var $uploadField = $('.botiga-image-field');

			if ($uploadField.length) {

				$uploadField.each(function () {

					var $field = $(this);
					var $input = $field.find('.botiga-image-field-input');
					var $image = $field.find('.botiga-image-field-preview img');
					var $upload = $field.find('.botiga-image-field-button-upload');
					var $remove = $field.find('.botiga-image-field-button-remove');
					var placeholder = $image.data('placeholder');
					var wpMediaFrame;

					$upload.on('click', function (e) {

						e.preventDefault();

						if (wpMediaFrame) {
							wpMediaFrame.open();
							return;
						}

						wpMediaFrame = window.wp.media({
							library: {
								type: 'image'
							},
						});

						wpMediaFrame.on('select', function () {

							var attachment = wpMediaFrame.state().get('selection').first().toJSON();
							var thumbnail;

							if (attachment && attachment.sizes && attachment.sizes.thumbnail) {
								thumbnail = attachment.sizes.thumbnail.url;
							} else {
								thumbnail = attachment.url;
							}

							$input.val(attachment.id);

							$image.attr('src', thumbnail);

							$remove.removeClass('hidden');

						});

						wpMediaFrame.open();

					});

					$remove.on('click', function (e) {

						e.preventDefault();

						$input.val('');
						$image.attr('src', placeholder);
						$remove.addClass('hidden');

					});

					$('form#addtag #submit').bind('click', function () {
						if ($input.val()) {
							$remove.trigger('click');
						}
					});

				});

			}

		},

	};

	$(document).ready(function () {
		botigaProductSwatches.init();
	});

})(jQuery);