/**
 * Mega Menu
 * 
 */

(function($){

    'use strict';

    window.botigaMegaMenu = {
        init: function() {
            this.events();
        },

        events: function() {
            const self = this;

            $( document ).on( 'click', '#botiga-menu-options-popup .botiga-popup-close', this.closePopup );
            $( document ).on( 'click', '.botiga-menu-options > a', function( e ) {
                self.renderPopupContent( e, $( this ) );
            } );
            $( document ).on( 'change', '.botiga-popup-field-checkbox', this.checkboxFieldOnOffValue );
            $( document ).on( 'change', '.botiga-popup-field', this.conditionalFieldsShowHide );
            $( document ).on( 'sortstop', '#menu-to-edit', this.updateDepth );
            $( document ).on( 'click', '.botiga-popup-media-upload', this.mediaUpload );
            $( 'body' ).on( 'click', '.botiga-popup-media-upload-remove', this.removeMedia );
            $( document ).on( 'click', '.botiga-popup-save-button', this.saveOptions );
        },

        renderPopupContent: function( e, $this ) {
            e.preventDefault();

            const 
                self           = this,
                $popup         = $( '#botiga-menu-options-popup' ),
                $popup_content = $( '#botiga-menu-options-popup .botiga-popup-content' );

            $popup.addClass( 'show' );
            $popup.removeClass( 'content-loaded' );

            const 
                top_parent    = $this.parents( '.menu-item' ).prevAll( '.menu-item-depth-0' ),
                top_parent_id = top_parent.length ? $( top_parent[0] ).attr( 'id' ).split( 'menu-item-' )[1] : 0;

            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action        : 'botiga_render_popup_content',
                    item_id       : $this.data( 'item-id' ),
                    item_depth    : $this.data( 'item-depth' ),
                    top_parent_id : top_parent_id,
                    nonce         : $this.data( 'nonce' )
                },
                success: function(response) {
                    if( response.success ) {
                        $popup_content.html( response.data );
                        $popup.addClass( 'content-loaded' );

                        $( '.botiga-popup-save-button' ).data( 'item-id', $this.data( 'item-id' ) );
                        $( '.botiga-popup-save-button' ).data( 'top-parent-id', top_parent_id );

                        $( '.botiga-popup-editing-item' ).text( $this.parent().parent().find( '.edit-menu-item-title' ).val() );

                        self.initColorPicker();
                        self.checkboxFieldOnOffValue();
                        self.conditionalFieldsShowHide();
                    } else {
                        $popup_content.html( 'error' );
                    }
                }
            });
        },

        closePopup: function( e ) {
            e.preventDefault();

            $( '#botiga-menu-options-popup' ).removeClass( 'show content-loaded' );
        },

        // Checkbox input.
        // Toggle checked attributes due to conditional fields.
        checkboxFieldOnOffValue: function() {
            $( '.botiga-popup-field-checkbox' ).each( function(){
                if( $( this ).is( ':checked' ) ) {
                    $( this ).val( 'on' );
                } else {
                    $( this ).val( 'off' );
                }
            });
        },

        // Conditional Fields.
        conditionalFieldsShowHide: function() {
            $( '.botiga-popup-field-wrapper[data-display-cond-target]' ).each(function(){
                const
                    target       = $( this ).data( 'display-cond-target' ),
                    target_value = $( this ).data( 'display-cond-target-value' ),
                    is_multiple  = $( this ).data( 'display-cond-multiple' ) ? true : false;
    
                if( ! is_multiple ) {
                    if( $( `.botiga-popup-field[name="${ target }"]` ).val() === target_value ) {
                        $( this ).show();
                    } else {
                        $( this ).hide();
                    }
                } else {
                    const
                        targets       = target.split( ',' ),
                        target_values = target_value.split( ',' );
    
                    let show = false;
                    for( const [ index, value ] of target_values.entries() ) {
                        if( $( `.botiga-popup-field[name="${ targets[ index ] }"]` ).val() === value ) {
                            show = true;
                        } else {
                            show = false;
                            break;
                        }
                    }
    
                    if( show ) {
                        $( this ).show();
                    } else {
                        $( this ).hide();
                    }
                }
            });
        },

        // Update depth on sorting/dragging.
        updateDepth: function( e, ui) {
            const $item = $( ui.item );
            let depth   = 0;

            setTimeout( function() {
                for( const classname of $item[0].classList ) {
                    if( classname.startsWith( 'menu-item-depth-' ) ) {
                        depth = classname.split( 'menu-item-depth-' )[1];
                        break;
                    }
                }

                $item.find( '.botiga-menu-options > a' ).data( 'item-depth', depth );
            });
        },

        // Media upload.
        mediaUpload: function( e ) {
            e.preventDefault();

            var button = $(this),
            custom_uploader = wp.media({
                library : {
                    type : 'image'
                },
                multiple: false
            }).on( 'select' , function() {
                var attachment = custom_uploader.state().get('selection').first().toJSON();
                button.html('<img src="' + attachment.url + '">').next().show().next().val( attachment.id );
            }).open();
        },

        removeMedia: function( e ) {
            e.preventDefault();

            var button = $(this);
            button.next().val('');
            button.hide().prev().html( 'Upload image' );
        },

        saveOptions: function( e ) {
            e.preventDefault();

            const $this = $( this ),
                $popup  = $( '#botiga-menu-options-popup' ),
                fields  = $( '.botiga-popup-field' );

            let options = {};

            // Change button to loading state.
            $this.addClass( 'disabled' ).text( $this.data( 'loading-text' ) );

            // Mount options array.
            fields.each(function(){

                // Checkbox.
                if( $( this ).attr( 'type' ) && $( this ).attr( 'type' ) === 'checkbox' ) {
                    if( $( this ).is( ':checked' ) ) {
                        options[ $( this ).attr( 'name' ) ] = 1;
                    } else {
                        options[ $( this ).attr( 'name' ) ] = 0;
                    }
                }

                // Select.
                if( $( this ).is( 'select' ) ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

                // Colorpicker.
                if( $( this ).hasClass( 'botiga-popup-colorpicker' ) ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

                // Media uploader.
                if( $( this ).hasClass( 'botiga-popup-media-upload' ) ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

                // Number.
                if( $( this ).attr( 'type' ) && $( this ).attr( 'type' ) === 'number' ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

                // Textarea.
                if( $( this ).is( 'textarea' ) ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

                // Text.
                if( $( this ).attr( 'type' ) && $( this ).attr( 'type' ) === 'text' ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

                // Hidden.
                if( $( this ).attr( 'type' ) && $( this ).attr( 'type' ) === 'hidden' ) {
                    options[ $( this ).attr( 'name' ) ] = $( this ).val();
                }

            });

            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action        : 'botiga_save_popup_options',
                    item_id       : $this.data( 'item-id' ),
                    top_parent_id : $this.data( 'top-parent-id' ),
                    options       : options,
                    nonce         : $popup.find( '.botiga-popup-content-save-nonce' ).val()
                },
                success: function(response) {
                    if( response.success ) {
                        
                        // Change button to default state.
                        $this.removeClass( 'disabled' ).text( $this.data( 'default-text' ) );

                    }
                }
            });
        },

        initColorPicker: function() {
            const picker = $( '.botiga-popup-colorpicker' ).wpColorPicker({
                // TODO: Get theme palettes colors.
                palettes: false,
                change: function( event, ui ) {
                    $( this ).val( ui.color.toString() );
                }
            });
        }

    }

    $( document ).ready( function(){
        window.botigaMegaMenu.init();
    } );
    
})(jQuery);