<?php
/**
 * Table layout
 * Used on Cart and Wishlist tables
 * 
 * @package Botiga_Pro
 */

/**
 * Main hook
 */
function botiga_table_layouts_hook() {
    $table_layout = get_theme_mod( 'shop_cart_table_content_layout_style', 'layout1' );
    if( $table_layout === 'layout1' ) {
        return;
    }

    // Cart
    add_filter( 'woocommerce_cart_item_quantity', '__return_false' );
    if( is_cart() ) {
        add_filter( 'woocommerce_cart_item_remove_link', '__return_false' );
    }
    add_action( 'woocommerce_after_cart_item_name', 'botiga_woocommerce_after_cart_item_name', 2, 10 );

    // Wishlist
    add_filter( 'botiga_wishlist_remove_item_button', '__return_false' );
    add_filter( 'botiga_wishlist_out_of_stock', '__return_false' );
    add_filter( 'botiga_wishlist_in_stock', '__return_false' );
    add_action( 'botiga_wishlist_after_item_name', 'botiga_wishlist_after_item_name_callback', 2, 10 );

}
add_action( 'wp', 'botiga_table_layouts_hook' );

/**
 * Add identifier class in the body tag
 */
function botiga_shop_table_layout_body_class( $classes ) {
    if( ! is_cart() && ! is_page_template( 'page-templates/template-wishlist.php' ) ) {
        return $classes;
    }

    $table_layout = get_theme_mod( 'shop_cart_table_content_layout_style', 'layout1' );

    $classes[] = 'shop-table-' . esc_attr( $table_layout );

    return $classes;
}
add_filter( 'body_class', 'botiga_shop_table_layout_body_class' );

/**
 * Append content after cart item name
 */
if( ! function_exists( 'botiga_woocommerce_after_cart_item_name' ) ) {
    function botiga_woocommerce_after_cart_item_name( $cart_item, $cart_item_key ) {
        $_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
        $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
        
        if ( $_product->is_sold_individually() ) {
            $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
        } else {
            $product_quantity = woocommerce_quantity_input(
                array(
                    'input_name'   => "cart[{$cart_item_key}][qty]",
                    'input_value'  => $cart_item['quantity'],
                    'max_value'    => $_product->get_max_purchase_quantity(),
                    'min_value'    => '0',
                    'product_name' => $_product->get_name(),
                ),
                $_product,
                false
            );
        }

        echo '<div class="botiga-qty-remove-wrapper">';
            echo apply_filters( 'botiga_woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
            echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                'botiga_woocommerce_cart_item_remove_link',
                sprintf(
                    '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">%s</a>',
                    esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
                    esc_html__( 'Remove this item', 'botiga-pro' ),
                    esc_attr( $product_id ),
                    esc_attr( $_product->get_sku() ),
                    esc_html__( 'Remove', 'botiga-pro' )
                ),
                $cart_item_key
            );
        echo '</div>';
    }   
}

/**
 * Append content after wishlist item name
 */
if( ! function_exists( 'botiga_wishlist_after_item_name_callback' ) ) {
    function botiga_wishlist_after_item_name_callback( $_product, $product_id ) {

        echo '<span class="botiga-stock-wrapper">';
            if ( ! $_product->is_in_stock() ) {
                echo esc_html__( 'Out of Stock', 'botiga-pro' );
            } else {
                echo esc_html__( 'In Stock', 'botiga-pro' );
            }
        echo '</span>';

        echo '<div class="botiga-qty-remove-wrapper">';
            echo sprintf(
                '<a href="#" class="botiga-wishlist-remove-item remove" data-type="remove" aria-label="%s" data-product-id="%s" data-product_sku="%s" data-nonce="%s">Remove</a>',
                esc_html__( 'Remove this item', 'botiga-pro' ),
                esc_attr( $product_id ),
                esc_attr( $_product->get_sku() ),
                esc_attr( wp_create_nonce( 'botiga-wishlist-nonce' ) )
            );
        echo '</div>';
    }
}
