<?php
/**
 * Single Product Reasons To Buy
 * 
 * @package Botiga_Pro
 */

/**
 * Extend single product elements defaults with new options
 * 
 */
function botiga_pro_single_product_reasons_to_buy_default_components( $components ) {
    $components[] = 'botiga_single_product_reasons_to_buy';

    return $components;
}
add_filter( 'botiga_default_single_product_components', 'botiga_pro_single_product_reasons_to_buy_default_components', 11 );

/**
 * Reasons to buy output 
 * 
 */
function botiga_single_product_reasons_to_buy() {
    $reasons_list       = explode( ',', get_theme_mod( 'botiga_single_product_reasons', '' ) );
    $reasons_list_title = get_theme_mod( 'botiga_single_product_reasons_title', '' ); 
    $reasons_list_icon  = botiga_pro_get_svg_icon( 'icon-check-circle', false );
    $allowed = array(
        'svg'     => array(
            'class'       => true,
            'xmlns'       => true,
            'width'       => true,
            'height'      => true,
            'viewbox'     => true,
            'aria-hidden' => true,
            'role'        => true,
            'focusable'   => true,
        ),
        'path'    => array(
            'fill'      => true,
            'fill-rule' => true,
            'd'         => true,
            'transform' => true,
        ),
        'polygon' => array(
            'fill'      => true,
            'fill-rule' => true,
            'points'    => true,
            'transform' => true,
            'focusable' => true,
        ),
    );

    if( empty($reasons_list[0]) && empty($reasons_list_title) ) {
        return;
    } ?>

    <div class="botiga-reasons-list">
        <?php if( !empty($reasons_list_title) ) : ?>
            <strong class="botiga-reasons-list-title"><?php echo esc_html( $reasons_list_title ); ?></strong>
        <?php endif; ?>

        <?php if( !empty($reasons_list[0]) ) : ?>
            <?php foreach( $reasons_list as $list_text ) : ?>

                <div class="botiga-reasons-list-item">
                    <div class="botiga-reasons-list-item-icon">
                        <?php echo wp_kses( apply_filters( 'botiga_reasons_list_icon', $reasons_list_icon ), $allowed ); ?>
                    </div>  
                    <p class="botiga-reasons-list-item-text">
                        <?php esc_html_e( $list_text ); ?>
                    </p>
                </div>

            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <?php
}

/**
 * Reasons to buy custom css
 * 
 */
function botiga_reasons_to_buy_custom_css( $css ) {
    $reasons_list_title = get_theme_mod( 'botiga_single_product_reasons_title', '' ); 
    $reasons_list       = get_theme_mod( 'botiga_single_product_reasons', '' );

    if( $reasons_list_title ) {
        $css .= '
            .botiga-reasons-list .botiga-reasons-list-title {
                display: block;
                margin-bottom: 7px;
            }
        ';
    }

    if( $reasons_list ) {
        $css .= '
            .botiga-reasons-list .botiga-reasons-list-item {
                display: -webkit-box;
                display: -ms-flexbox;
                display: flex;
                -webkit-box-align: start;
                    -ms-flex-align: start;
                        align-items: start;
            }

            .botiga-reasons-list .botiga-reasons-list-item-text {
                margin-bottom: 0;
            }
            
            .botiga-reasons-list .botiga-reasons-list-item .botiga-reasons-list-item-icon {
                margin-right: 0.5em;
            }
            
            .botiga-reasons-list .botiga-reasons-list-item .botiga-reasons-list-item-icon svg {
                width: 0.9em;
                height: 0.9em;
                position: relative;
                top: 0.1em;
            }
        ';

        $css .= Botiga_Custom_CSS::get_fill_css( 'color_link_default', '#212121', '.botiga-reasons-list .botiga-reasons-list-item .botiga-reasons-list-item-icon svg' );
    }

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_reasons_to_buy_custom_css' );