<?php
/**
 * Login Register Popup
 * 
 * @package Botiga_Pro
 */

/**
 * Enqueue CSS and JS
 */
function botiga_login_register_popup_enqueue_scripts() {
    if( is_account_page() ) {
        return;
    }

    $login_register_popup = class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'login-popup' );

    if( is_user_logged_in() || ! $login_register_popup ) {
        return;
    } 

    wp_enqueue_style( 'botiga-login-register-popup', BOTIGA_PRO_URI . 'assets/css/botiga-login-register-popup.min.css', array(), BOTIGA_PRO_VERSION );
    wp_enqueue_script( 'botiga-popup' );
}
add_action( 'wp_enqueue_scripts', 'botiga_login_register_popup_enqueue_scripts', 10 );

/**
 * Popup HTML output
 */
function botiga_login_register_popup() {
    if( is_account_page() ) {
        return;
    }
    
    $login_register_popup = class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'login-popup' );

    if( is_user_logged_in() || ! $login_register_popup ) {
        return;
    } ?>

    <div id="loginRegisterPopup" class="botiga-popup">
        <div class="botiga-popup-wrapper">
            <a href="#" class="botiga-popup-wrapper__close-button" role="button">
                <?php echo botiga_pro_get_svg_icon( 'icon-cancel' ); ?>
            </a>
            <div class="botiga-popup-wrapper__content show-login">
                <?php wc_get_template( 'myaccount/form-login.php' ); ?>
                
                <?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>
                    
                    <p class="switch-form-wrapper switch-form-wrapper-register">
                        <?php echo esc_html__( 'Not a member?', 'botiga-pro' ); ?>
                        <a href="#" class="switch-form-wrapper__link" onclick="botiga.toggleClass.init(event, this, false);" data-botiga-selector="#loginRegisterPopup .botiga-popup-wrapper__content" data-botiga-toggle-class="show-register" data-botiga-toggle-class-remove="show-login">
                            <?php echo esc_html__( 'Register', 'botiga-pro' ); ?>
                        </a>
                    </p>
                    <p class="switch-form-wrapper switch-form-wrapper-login">
                        <?php echo esc_html__( 'Already a member?', 'botiga-pro' ); ?>
                        <a href="#" class="switch-form-wrapper__link" onclick="botiga.toggleClass.init(event, this, false);" data-botiga-selector="#loginRegisterPopup .botiga-popup-wrapper__content" data-botiga-toggle-class="show-login" data-botiga-toggle-class-remove="show-register">
                            <?php echo esc_html__( 'Login', 'botiga-pro' ); ?>
                        </a>
                    </p>

                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php
}
add_action( 'wp_footer', 'botiga_login_register_popup' );