<?php
/**
 * Additional woocommerce functions
 * The functions here are loaded only when the WooCommerce plugin is active
 *
 * @package Botiga_Pro
 */

/**
 * Template functions
 */
require 'woocommerce/template-functions.php';

/**
 * Quantity input styles
 */
require 'woocommerce/qty-styles.php';

/**
 * Table Layouts
 */
require 'woocommerce/table-layout.php';

/**
 * Masonry Layout
 */
require 'woocommerce/masonry-layout.php';

/**
 * Shop Archive
 */
require 'woocommerce/shop-archive/image-swap.php';
require 'woocommerce/shop-archive/product-stock.php';
require 'woocommerce/shop-archive/grid-list-view.php';
require 'woocommerce/shop-archive/product-pagination-ppp.php';
require 'woocommerce/shop-archive/product-quantity.php';
require 'woocommerce/shop-archive/shop-page-header.php';

/**
 * Single Product
 */
require 'woocommerce/single-product/reasons-to-buy.php';
require 'woocommerce/single-product/trust-badge.php';
require 'woocommerce/single-product/product-navigation.php';
require 'woocommerce/single-product/brand-image.php';

/**
 * Cart
 */
require 'woocommerce/cart/side-mini-cart.php';

/**
 * Checkout
 */
require 'woocommerce/checkout/distraction-free.php';
require 'woocommerce/checkout/multi-step-checkout.php';
require 'woocommerce/checkout/shopify-checkout.php';

/**
 * Login Register Popup
 */
require 'woocommerce/login-register-popup.php';

/**
 * Shop Pagination Types
 */
require 'woocommerce/shop-pagination.php';

/**
 * Misc
 */
function botiga_woocommerce_login_form() {
    woocommerce_login_form(
        array(
            'message'  => esc_html__( 'If you have shopped with us before, please enter your details below. If you are a new customer, please proceed to the Billing section.', 'botiga-pro' ),
            'redirect' => wc_get_checkout_url(),
            'hidden'   => true,
        )
    );
}

/**
 * Extend single product elements defaults with new options
 * 
 */
function botiga_pro_single_product_html_shortcode_default_components( $components ) {
    $components[] = 'botiga_single_product_html';
    $components[] = 'botiga_single_product_shortcode';

    return $components;
}
add_filter( 'botiga_default_single_product_components', 'botiga_pro_single_product_html_shortcode_default_components' );