<?php
/**
 * Product Video Metabox
 *
 * @package Botiga
 */
if ( class_exists( 'Botiga_Metabox' ) ) {

	class Botiga_Product_Video_Metabox extends Botiga_Metabox {

		public function __construct() {
			add_action( 'botiga_metabox_options', array( $this, 'add_product_video_metabox_options' ) );
		}

		public function add_product_video_metabox_options() {

			$this->add_section( 'video', array(
				'post_type' => array( 'product' ),
				'title'     => esc_html__( 'Featured Video', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_enable_featured_video', array(
				'section'   => 'video',
				'type'      => 'switcher',
				'title'     => esc_html__( 'Enable Featured Video', 'botiga-pro' ),
				'desc'      => esc_html__( 'Check this option to display a video in the place of featured image on shop catalog/archive pages.', 'botiga-pro' ),
				'separator' => 'none',
			) );

			$this->add_field( '_botiga_featured_video_url', array(
				'section'   => 'video',
				'type'      => 'text',
				'title'     => esc_html__( 'Featured Video URL', 'botiga-pro' ),
				'desc'      => esc_html__( 'Enter the URL for the video you want to show in place of the featured image. (Youtube, Vimeo, Dailymotion, Self-Hosted and more)', 'botiga-pro' ),
				'depend'    => '_botiga_enable_featured_video', 
				'separator' => 'none',
			) );

			$this->add_field( '_botiga_featured_video_autoplay', array(
				'section'   => 'video',
				'type'      => 'switcher',
				'title'     => esc_html__( 'Autoplay', 'botiga-pro' ),
				'desc'      => esc_html__( 'Autoplay may cause usability issues for some users.', 'botiga-pro' ),
				'depend'    => '_botiga_enable_featured_video', 
				'separator' => 'none',
			) );

			$this->add_field( '_botiga_enable_gallery', array(
				'section'   => 'video',
				'type'      => 'switcher',
				'title'     => esc_html__( 'Enable Video Gallery', 'botiga-pro' ),
				'separator' => 'before',
			) );

			$this->add_field( '_botiga_videos_in_gallery', array(
				'section'   => 'video',
				'type'      => 'repeater',
				'title'     => '',
				'button'    => esc_html__( 'Add Video Link', 'botiga-pro' ),
				'depend'    => '_botiga_enable_gallery', 
				'class'     => 'botiga-metabox-field-no-padding',
				'separator' => 'none',
			) );

			$this->add_field( '_botiga_upload_videos_in_gallery', array(
				'section'   => 'video',
				'type'      => 'uploads',
				'title'     => '',
				'library'   => 'video',
				'button'    => esc_html__( 'Upload Videos', 'botiga-pro' ),
				'depend'    => '_botiga_enable_gallery', 
				'separator' => 'none',
			) );

			$this->add_field( '_botiga_video_position', array(
				'section'   => 'video',
				'type'      => 'select',
				'title'     => esc_html__( 'Position', 'botiga-pro' ),
				'options'   => array(
					'before'  => esc_html__( 'Before Image Gallery', 'botiga-pro' ),
					'after'   => esc_html__( 'After Image Gallery', 'botiga-pro' ),
				),
				'depend'    => '_botiga_enable_gallery', 
				'separator' => 'before',
			) );

			$this->add_field( '_botiga_video_aspect_ratio', array(
				'section' => 'video',
				'type'    => 'select',
				'title'   => esc_html__( 'Aspect Ratio', 'botiga-pro' ),
				'desc'    => esc_html__( 'The aspect ratio definition is the proportional relationship between the width and height of a video.', 'botiga-pro' ),
				'options' => array(
					'16-9'  => '16:9',
					'9-16'  => '9:16',
					'4-3'   => '4:3',
					'3-2'   => '3:2',
					'1-1'   => '1:1',
					'auto'  => 'auto',
				),
				'separator' => 'before',
			) );

		}
	}

	new Botiga_Product_Video_Metabox();

}