<?php
/**
 * Botiga Product Variation Gallery
 *
 * @package Botiga_Pro
 */

if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'variations-gallery' ) ) {
    return;
}

class Botiga_Product_Variation_Gallery {
    
    public function __construct() {

        add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_scripts' ) );
        add_action( 'woocommerce_product_after_variable_attributes', array( $this, 'add_variation_gallery_options' ), 10, 3 );
        add_action( 'woocommerce_save_product_variation', array( $this, 'save_product_variation' ), 10, 2 );
        add_filter( 'woocommerce_available_variation', array($this, 'add_available_variation_gallery_images' ), 10, 3 );

    }

    public function admin_enqueue_scripts( $hook ) {

        if ( $hook === 'post.php' ) {

            wp_enqueue_media();
            wp_enqueue_script( 'jquery-ui-sortable' );

            wp_enqueue_style( 'botiga-product-variation-gallery', BOTIGA_PRO_URI . 'assets/css/admin/botiga-product-variation-gallery.min.css', array(), BOTIGA_PRO_VERSION );
            wp_enqueue_script( 'botiga-product-variation-gallery', BOTIGA_PRO_URI . 'assets/js/admin/botiga-product-variation-gallery.min.js', array(), BOTIGA_PRO_VERSION, true );

        }

    }

    public function wp_enqueue_scripts() {
        wp_register_script( 'botiga-variation-gallery', BOTIGA_PRO_URI . 'assets/js/botiga-variation-gallery.min.js', array(), BOTIGA_PRO_VERSION, true );
    }

    public function add_variation_gallery_options( $loop, $variation_data, $variation ) {

        $attachment_ids = get_post_meta( $variation->ID, 'botiga_variation_gallery', true );

        echo '<div class="form-row form-row-full botiga-variation-gallery">';
            
            echo '<p><strong>'. esc_html__( 'Variation Gallery Images', 'botiga-pro' ) .'</strong></p>';
            
            echo '<ul class="botiga-variation-gallery-sortable">';

                if ( ! empty( $attachment_ids ) ) {

                    foreach ( $attachment_ids as $attachment_id ) {

                        $image = wp_get_attachment_image_src( $attachment_id, 'thumbnail' );
                        $image = ( ! empty( $image[0] ) ) ? $image[0] : wc_placeholder_img_src( 'thumbnail' );

                        echo '<li>';
                        echo '<figure><img src="'. esc_url( $image ).'" /></figure>';
                        echo '<span class="botiga-remove-item dashicons dashicons-no"></span>';
                        echo '<input type="hidden" name="botiga_variation_gallery['. esc_attr( $loop ) .'][]" value="'. esc_attr( $attachment_id ) .'" />';
                        echo '</li>';

                    }

                }

            echo '</ul>';

            echo '<p><a href="#" class="botiga-add-item button" data-button-text="'. esc_attr__( 'Add to gallery', 'botiga-pro' ) .'" data-loop="'. esc_attr( $loop ) .'">'. esc_html__( 'Add Gallery Images', 'botiga-pro' ) .'</a></p>';

        echo '</div>';

    }

    public function save_product_variation( $variation_id, $i ) {

        if ( ! empty( $_POST['botiga_variation_gallery'][ $i ] ) && is_array( $_POST['botiga_variation_gallery'][ $i ] ) ) {

            $gallery_image_ids = array_map( 'sanitize_text_field', $_POST['botiga_variation_gallery'][ $i ] );

            update_post_meta( $variation_id, 'botiga_variation_gallery', $gallery_image_ids );

        } else {

            delete_post_meta( $variation_id, 'botiga_variation_gallery' );

        }

    }

    public function add_available_variation_gallery_images( $variation_details, $variable_product, $variation ) {
        $has_variation_gallery_images = get_post_meta( $variation->get_id(), 'botiga_variation_gallery', true );
        
        if ( ! empty( $has_variation_gallery_images ) ) {

            wp_enqueue_script( 'botiga-variation-gallery' );

            $variation_thumbnail_id = get_post_meta( $variation->get_id(), '_thumbnail_id', true );

            if ( ! empty( $variation_thumbnail_id ) ) {
                $has_variation_gallery_images = array_merge( array( $variation_thumbnail_id ), $has_variation_gallery_images );
            }

            foreach ( $has_variation_gallery_images as $attachment_id ) {
                $attachment = wc_get_product_attachment_props( $attachment_id );
                if ( ! empty( $attachment['src'] ) ) {
                $variation_details['variation_gallery_images'][] = $attachment;
                }
            }

        }

        return $variation_details;
    
    }

}

new Botiga_Product_Variation_Gallery();