<?php
/**
 * WooCommerce Single Product Sharing
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_sharing_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-sharing/block.json',
        array(
            'render_callback' => 'botiga_single_product_sharing_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_sharing_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_sharing_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    if ( !$edit_mode && ! wp_doing_ajax() ) {
        woocommerce_template_single_sharing();
    } else { ?>

        <div class="botiga-block-no-preview">
            <p style="margin: 0;"><?php echo esc_html__( 'No preview available. Share buttons from third party plugins will render in this area.', 'botiga-pro' ); ?></p>
        </div>

    <?php
    }
    $output = ob_get_clean();

    // Check if output is empty
    $output = Botiga_Templates_Builder_Gutenberg_Helper::filter_block_output( $output );

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-sharing"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}