<?php
/**
 * WooCommerce Single Product Additional Information
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_next_prev_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-next-prev/block.json',
        array(
            'render_callback' => 'botiga_single_product_next_prev_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_next_prev_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_next_prev_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    global $post;
    $post = Botiga_Templates_Builder_Gutenberg_Helper::get_first_post();
    setup_postdata( $post );

    botiga_single_product_navigation();

    wp_reset_postdata();
    $output = ob_get_clean();

    // Placeholder content if output is empty
    if( $edit_mode && empty( $output ) ) {
        ob_start(); ?>

        <div class="botiga-product-navigation">
            <a href="#" rel="prev"><i></i></a>
            <a href="#" rel="next"><i></i></a>
        </div>

        <?php
        $output = ob_get_clean();
    }

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-next-prev"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}