<?php
/**
 * WooCommerce Single Product Image
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_image_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-image/block.json',
        array(
            'render_callback' => 'botiga_single_product_image_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_image_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_image_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) ? false : true;

    ob_start();
    if ( !$edit_mode && ! wp_doing_ajax() ) {
        if( function_exists( 'botiga_single_product_wrap_before' ) ) { 
            botiga_single_product_wrap_before();
        }
    
        woocommerce_show_product_images();
    
        if( function_exists( 'botiga_single_product_wrap_after' ) ) {
            botiga_single_product_wrap_after();
        }
    } else {
        $product = Botiga_Templates_Builder_Gutenberg_Helper::get_first_product(); ?>

        <div class="image-placeholder flex-viewport">
            <?php 

            // Sale badge
            echo botiga_sale_badge( '', '', $product );

            // Product main image
            echo $product->get_image( 'botiga-large' ); ?>
        </div>
        <?php
        
        // Product image thumbnails/gallery
        $attachment_ids = $product->get_gallery_image_ids();
        if( $attachment_ids ) {
            echo '<div class="image-placeholder-thumbnails flex-control-thumbs">';
            foreach ( $attachment_ids as $attachment_id ) {
                echo wc_get_gallery_image_html( $attachment_id );
            }
            echo '</div>';
        }
    }
    $output = ob_get_clean();

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-image"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}