import { __ } from '@wordpress/i18n';

import { useState } from '@wordpress/element';

import {
	RangeControl,
    SelectControl,
    Button,
	Popover,
    Dashicon
} from '@wordpress/components';

/**
 * Spacing Custom Component
 * 
 */
export default function BotigaTypography( props ) {
    const { attributes, setAttributes } = props;
    const { 
        customCss
    } = attributes;
    const idPrefix = props.idPrefix ? props.idPrefix : 'typography';

    // Custom CSS Selector
    const customCssSelector = props.customCssSelector ? props.customCssSelector : '{{WRAPPER}}';

    // Popover State
    const [ isVisible, setIsVisible ] = useState( false );
    const toggleVisible = () => {
        setIsVisible( ( state ) => ! state );
    };

    // Typography Wrapper Display Style
    let typographyWrapperStyle = {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginBottom: '10px'
    };

    // Defaults
    let defaults = {
        fontSize: '',
        fontLineHeight: '',
        fontWeight: '',
        fontTransform: '',
        fontDecoration: '',
        fontStyle: '',
        fontLetterSpacing: ''
    }

    if( typeof customCss[ idPrefix + 'FontSize' ] !== 'undefined' ) {
        defaults.fontSize = customCss[ idPrefix + 'FontSize' ].value;
    }

    if( typeof customCss[ idPrefix + 'FontLineHeight' ] !== 'undefined' ) {
        defaults.fontLineHeight = customCss[ idPrefix + 'FontLineHeight' ].value;
    }

    if( typeof customCss[ idPrefix + 'FontWeight' ] !== 'undefined' ) {
        defaults.fontWeight = customCss[ idPrefix + 'FontWeight' ].value;
    }

    if( typeof customCss[ idPrefix + 'FontTransform' ] !== 'undefined' ) {
        defaults.fontTransform = customCss[ idPrefix + 'FontTransform' ].value;
    }

    if( typeof customCss[ idPrefix + 'FontDecoration' ] !== 'undefined' ) {
        defaults.fontDecoration = customCss[ idPrefix + 'FontDecoration' ].value;
    }

    if( typeof customCss[ idPrefix + 'FontStyle' ] !== 'undefined' ) {
        defaults.fontStyle = customCss[ idPrefix + 'FontStyle' ].value;
    }

    if( typeof customCss[ idPrefix + 'FontLetterSpacing' ] !== 'undefined' ) {
        defaults.fontLetterSpacing = customCss[ idPrefix + 'FontLetterSpacing' ].value;
    }

    return (
        <div style={ typographyWrapperStyle }>
            <span style={ { display: 'block', marginBottom: '5px' } }>{ props.label }</span>
            <Button 
                label={ __( 'Options', 'botiga-pro' ) }
                variant="secondary" 
                onClick={ toggleVisible } 
                style={ { 
                    padding: 3,
                    height: 'auto'
                } }>
                <Dashicon icon="edit" style={ { fontSize: 16, lineHeight: '20px' } } />
                { isVisible && (
                    <Popover
                        onClick={ ( event ) => event.stopPropagation() }
                        onFocusOutside={ toggleVisible }>

                        <div style={{
                            width: '250px',
                            padding: '15px'
                        }}>
                            <RangeControl
                                label={ __( 'Size (px)', 'botiga-pro' ) }
                                labelPosition="edge"
                                value={ defaults.fontSize }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontSize']: {
                                            selector: customCssSelector,
                                            props: `font-size: ${ value }px !important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                                min={ 1 }
                                max={ 200 }
                            />
                            <RangeControl
                                label={ __( 'Line Height (px)', 'botiga-pro' ) }
                                labelPosition="edge"
                                value={ defaults.fontLineHeight }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontLineHeight']: {
                                            selector: customCssSelector,
                                            props: `line-height: ${ value }px !important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                                min={ 1 }
                                max={ 220 }
                            />
                            <SelectControl
                                label={ __( 'Weight', 'botiga-pro' ) }
                                value={ defaults.fontWeight }
                                options={ [
                                    { label: '100', value: '100' },
                                    { label: '200', value: '200' },
                                    { label: '300', value: '300' },
                                    { label: '400', value: '400' },
                                    { label: '500', value: '500' },
                                    { label: '600', value: '600' },
                                    { label: '700', value: '700' },
                                    { label: '800', value: '800' },
                                    { label: '900', value: '900' },
                                ] }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontWeight']: {
                                            selector: customCssSelector,
                                            props: `font-weight: ${ value } !important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                            />
                            <SelectControl
                                label={ __( 'Transform', 'botiga-pro' ) }
                                value={ defaults.fontTransform }
                                options={ [
                                    { label: 'Default', value: '' },
                                    { label: 'Uppercase', value: 'uppercase' },
                                    { label: 'Lowercase', value: 'lowercase' },
                                    { label: 'Capitalize', value: 'capitalize' },
                                    { label: 'Normal', value: 'normal' },
                                ] }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontTransform']: {
                                            selector: customCssSelector,
                                            props: `text-transform: ${ value } !important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                            />
                            <SelectControl
                                label={ __( 'Style', 'botiga-pro' ) }
                                value={ defaults.fontStyle }
                                options={ [
                                    { label: 'Default', value: '' },
                                    { label: 'Normal', value: 'normal' },
                                    { label: 'Italic', value: 'italic' },
                                    { label: 'Oblique', value: 'oblique' },
                                ] }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontStyle']: {
                                            selector: customCssSelector,
                                            props: `font-style: ${ value }!important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                            />
                            <SelectControl
                                label={ __( 'Decoration', 'botiga-pro' ) }
                                value={ defaults.fontDecoration }
                                options={ [
                                    { label: 'Default', value: '' },
                                    { label: 'Overline', value: 'overline' },
                                    { label: 'Underline', value: 'underline' },
                                    { label: 'Line Through', value: 'line-through' },
                                    { label: 'None', value: 'none' },
                                ] }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontDecoration']: {
                                            selector: customCssSelector,
                                            props: `text-decoration: ${ value }!important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                            />
                            <RangeControl
                                label={ __( 'Letter Spacing (px)', 'botiga-pro' ) }
                                labelPosition="edge"
                                value={ defaults.fontLetterSpacing }
                                onChange={ ( value ) => { 
                                    const css = {
                                        [idPrefix + 'FontLetterSpacing']: {
                                            selector: customCssSelector,
                                            props: `letter-spacing: ${ value }px !important;`,
                                            value: value
                                        }
                                    };
                                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                                } }
                                min={ -5 }
                                max={ 10 }
                                step={ 0.1 }
                            />
                        </div>

                    </Popover>
                ) }
            </Button>
        </div>
        // <PanelBody title={ __( 'Typography', 'botiga-pro' ) } initialOpen={ false }>
            
        // </PanelBody>
    );
}
