<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor icon list widget.
 *
 * Elementor widget that displays a bullet list with any chosen icons and texts.
 *
 * @since 1.0.0
 */
class Botiga_Elementor_Single_Product_Add_To_Cart extends Widget_Base {

	/**
	 * Constructor
	 */
	public function __construct( $data=[], $args=null ){
		parent::__construct( $data, $args );
	}

	/**
	 * Load styles dependencies
	 */
	public function get_style_depends(){
		return [ 'botiga-builder-widgets-styles' ];	
	}

	public function get_help_url() {
		return 'https://docs.athemes.com/article/pro-templates-builder-overview/';
	}
		
	/**
	 * Get widget name.
	 *
	 * Retrieve icon list widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'botiga-elementor-single-product-add-to-cart';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon list widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Single Product Add To Cart', 'botiga-pro' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon list widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-product-add-to-cart';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the icon list widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'botiga-woocommerce' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'add to cart', 'add', 'cart', 'product', 'shop', 'botiga' ];
	}	


	/**
	 * Register icon list widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Style
		$this->start_controls_section(
			'section_style_stock',
			[
				'label' => __( 'Stock', 'botiga-pro' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'stock_typography',
				'selector' 	=> '{{WRAPPER}} .stock',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'in_stock_heading',
			[
				'label' => esc_html__( 'In Stock', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'in_stock_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .stock.in-stock' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'out_of_stock_heading',
			[
				'label' => esc_html__( 'Out Of Stock', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'out_of_stock_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .stock.out-of-stock' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_quantity',
			[
				'label' => __( 'Quantity', 'botiga-pro' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'quantity_typography',
				'selector' 	=> '{{WRAPPER}} .quantity .qty',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'quantity_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'quantity_border',
				'selector' => '{{WRAPPER}} .quantity',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '2',
							'right' => '2',
							'bottom' => '2',
							'left' => '2',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_control(
			'quantity_text_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .qty' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_minus_heading',
			[
				'label' => esc_html__( 'Minus Icon', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'quantity_minus_color',
			[
				'label' => __( 'Icon Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-minus' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_minus_color_hover',
			[
				'label' => __( 'Icon Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-minus:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_minus_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-minus' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_minus_background_color_hover',
			[
				'label' => __( 'Background Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-minus:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'quantity_minus_border',
				'selector' => '{{WRAPPER}} .quantity .botiga-quantity-minus',
			]
		);

		$this->add_control(
			'quantity_plus_heading',
			[
				'label' => esc_html__( 'Plus Icon', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'quantity_plus_color',
			[
				'label' => __( 'Icon Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-plus' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_plus_color_hover',
			[
				'label' => __( 'Icon Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-plus:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_plus_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-plus' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quantity_plus_background_color_hover',
			[
				'label' => __( 'Background Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .quantity .botiga-quantity-plus:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'quantity_plus_border',
				'selector' => '{{WRAPPER}} .quantity .botiga-quantity-plus',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_addtocart',
			[
				'label' => __( 'Add To Cart Button', 'botiga-pro' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'addtocart_typography',
				'selector' 	=> '{{WRAPPER}} .single_add_to_cart_button',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'addtocart_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_add_to_cart_button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'addtocart_background_color_hover',
			[
				'label' => __( 'Background Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_add_to_cart_button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'addtocart_border',
				'selector' => '{{WRAPPER}} .single_add_to_cart_button',
			]
		);

		$this->add_control(
			'addtocart_text_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_add_to_cart_button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'addtocart_text_color_hover',
			[
				'label' => __( 'Text Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single_add_to_cart_button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_grouped_product',
			[
				'label' => __( 'Grouped Product', 'botiga-pro' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'grouped_product_typography',
				'selector' 	=> '{{WRAPPER}} .group_table',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'grouped_product_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table, {{WRAPPER}} .group_table .woocommerce-Price-amount' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'grouped_product_links_color',
			[
				'label' => __( 'Links Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'grouped_product_links_color_hover',
			[
				'label' => __( 'Links Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'grouped_product_buttons_heading',
			[
				'label' => esc_html__( 'Buttons', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'grouped_product_buttons_typography',
				'selector' 	=> '{{WRAPPER}} .group_table .add_to_cart_button',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'grouped_product_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table .add_to_cart_button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'grouped_product_background_color_hover',
			[
				'label' => __( 'Background Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table .add_to_cart_button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'grouped_product_text_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table .add_to_cart_button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'grouped_product_text_color_hover',
			[
				'label' => __( 'Text Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .group_table .add_to_cart_button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'grouped_product_border',
				'selector' => '{{WRAPPER}} .group_table .add_to_cart_button',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '2',
							'right' => '2',
							'bottom' => '2',
							'left' => '2',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_variable_product',
			[
				'label' => __( 'Variable Product', 'botiga-pro' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'variable_product_att_heading',
			[
				'label' => esc_html__( 'Attributes Title', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'variable_product_att_typography',
				'selector' 	=> '{{WRAPPER}} .variations_form.cart .variations .label label',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'variable_product_att_text_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .variations_form.cart .variations .label label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_product_reset_heading',
			[
				'label' => esc_html__( 'Clear/Reset Button', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'variable_product_reset_typography',
				'selector' 	=> '{{WRAPPER}} table.variations .reset_variations',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'variable_product_reset_text_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.variations .reset_variations' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_product_reset_text_color_hover',
			[
				'label' => __( 'Text Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.variations .reset_variations:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_product_reset_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.variations .reset_variations' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_product_reset_background_color_hover',
			[
				'label' => __( 'Background Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.variations .reset_variations:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'variable_product_reset_border',
				'selector' => '{{WRAPPER}} table.variations .reset_variations',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border (hover)', 'botiga-pro' ),
				'name' => 'variable_product_reset_border_hover',
				'selector' => '{{WRAPPER}} table.variations .reset_variations:hover',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_control(
			'variable_product_reset_padding',
			[
				'label' => __( 'Padding', 'botiga-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} table.variations .reset_variations' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'variable_price_heading',
			[
				'label' => esc_html__( 'Variable Price', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'variable_price_alignment',
			[
				'label' 		=> __( 'Alignment', 'botiga-pro'),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'left',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'botiga-pro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'botiga-pro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'botiga-pro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-variation-price' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_regular_price_heading',
			[
				'label' => esc_html__( 'Regular Price', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'variable_regular_price_typography',
				'selector' 	=> '{{WRAPPER}} .woocommerce-variation-price .price',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'variable_regular_price_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-variation-price .price .woocommerce-Price-amount' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_sale_price_heading',
			[
				'label' => esc_html__( 'Sale Price', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'variable_sale_price_typography',
				'selector' 	=> '{{WRAPPER}} .woocommerce-variation-price .price del',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'variable_sale_price_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-variation-price .price del .woocommerce-Price-amount' => 'color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce-variation-price .price del' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_default_heading',
			[
				'label' => esc_html__( 'Dropdown Swatch', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'variable_default_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.variations td select' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_default_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.variations td select' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border', 'botiga-pro' ),
				'name' => 'variable_default_border',
				'selector' => '{{WRAPPER}} table.variations td select',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_control(
			'variable_default_padding',
			[
				'label' => __( 'Padding', 'botiga-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} table.variations td select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'variable_color_heading',
			[
				'label' => esc_html__( 'Color Swatch', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border', 'botiga-pro' ),
				'name' => 'variation_color_border',
				'selector' => '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-color > a',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border (hover)', 'botiga-pro' ),
				'name' => 'variation_color_border_hover',
				'selector' => '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-color > a:hover:not(.disabled):before',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_control(
			'variation_color_border_radius',
			[
				'label' => __( 'Border Radius', 'botiga-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-color > a, {{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-color > a:not(.disabled):before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'variation_color_gap',
			[
				'label' => esc_html__( 'Gap', 'botiga-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-color > a' => 'margin-right: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'variable_button_heading',
			[
				'label' => esc_html__( 'Button Swatch', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'variable_button_typography',
				'selector' 	=> '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a',
				'scheme' 	=> Core\Schemes\Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_control(
			'variable_button_text_color',
			[
				'label' => __( 'Text Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_button_text_color_hover',
			[
				'label' => __( 'Text Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_button_background_color',
			[
				'label' => __( 'Background Color', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'variable_button_background_color_hover',
			[
				'label' => __( 'Background Color (hover)', 'botiga-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'variable_button_border',
				'selector' => '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border (hover)', 'botiga-pro' ),
				'name' => 'variable_button_border_hover',
				'selector' => '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a:hover',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_control(
			'variable_button_border_radius',
			[
				'label' => __( 'Border Radius', 'botiga-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'variable_button_gap',
			[
				'label' => esc_html__( 'Gap', 'botiga-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a' => 'margin-right: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'variable_button_padding',
			[
				'label' => __( 'Padding', 'botiga-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-button > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'variable_image_heading',
			[
				'label' => esc_html__( 'Image Swatch', 'botiga-pro' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border', 'botiga-pro' ),
				'name' => 'variation_image_border',
				'selector' => '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-image > a',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'label' => __( 'Border (hover)', 'botiga-pro' ),
				'name' => 'variation_image_border_hover',
				'selector' => '{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-image > a:hover:not(.disabled):before',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#212121',
					],
				],
			]
		);

		$this->add_control(
			'variation_image_border_radius',
			[
				'label' => __( 'Border Radius', 'botiga-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-image > a, {{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-image > a:not(.disabled):before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'variation_image_gap',
			[
				'label' => esc_html__( 'Gap', 'botiga-pro' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .botiga-variations-wrapper .botiga-variation-type-image > a' => 'margin-right: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Get the first product found in the database
	 * 
	 * @access protected
	 */
	protected function get_first_post() {
		if( is_singular( 'product' ) ) {
			global $post;
			return $post;
		}
		
		$first_product = wc_get_products( array(
			'limit' => 1,
			'orderby' => 'date',
			'order' => 'DESC',
			'return' => 'ids'
		) );

		$post = get_post( $first_product[0] );

		return $post;
	}

	/**
	 * Render icon list widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$edit_mode = \Elementor\Plugin::$instance->editor->is_edit_mode();

		echo '<div class="botiga-tb-el-block botiga-tb-el-sp-add-to-cart">';
			echo '<div class="product-gallery-summary" style="margin-bottom: 0;">';

				global $post;
				$post = $this->get_first_post();
				setup_postdata( $post );

				if( ! $edit_mode ) {
					botiga_single_addtocart_wrapper_open();
					woocommerce_template_single_add_to_cart();
					botiga_single_addtocart_wrapper_close();
				} else {

					global $product;
					if( 'simple' === $product->get_type() ) {
						woocommerce_simple_add_to_cart();
					} elseif( 'variable' === $product->get_type() ) {
						woocommerce_variable_add_to_cart();
					} elseif( 'grouped' === $product->get_type() ) {
						woocommerce_grouped_add_to_cart();
					} elseif( 'external' === $product->get_type() ) {
						woocommerce_external_add_to_cart();
					}

				}
				
				wp_reset_postdata();

				if( $edit_mode ) {
					echo '<script>';
						echo 'botiga.qtyButton.init();';
					echo '</script>';
				}

			echo '</div>';
		echo '</div>';
	}

	/**
	 * Render icon list widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {	
	}
}
Plugin::instance()->widgets_manager->register_widget_type( new Botiga_Elementor_Single_Product_Add_To_Cart() );