<?php
/**
 * Single page metabox
 *
 * @package Botiga
 */


function botiga_template_rules_metabox_init() {
    new Botiga_Templates_Display();
}

if ( is_admin() ) {
    add_action( 'load-post.php', 'botiga_template_rules_metabox_init' );
    add_action( 'load-post-new.php', 'botiga_template_rules_metabox_init' );
}

class Botiga_Templates_Display {

	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'scripts') );
	}

	public function add_meta_box( $post_type ) {
		
		$types = get_post_types(
			array(
				'public' => true,
			)
		);

        if ( in_array( $post_type, $types ) && ( 'attachment' !== $post_type ) ) {
			add_meta_box(
				'botiga_single_page_metabox'
				,__( 'Botiga Templates', 'botiga-pro' )
				,array( $this, 'render_meta_box_content' )
				,'athemes_hf'
				,'normal'
				,'low'
			);
        }
	}

	public function save( $post_id ) {
		if ( ! isset( $_POST['athemes_display_rules_nonce'] ) ||
		! wp_verify_nonce( $_POST['athemes_display_rules_nonce'], 'athemes_display_rules_nonce' ) )
			return;
		
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
			return;
		
		if (!current_user_can('edit_post', $post_id))
			return;
		
		$old = get_post_meta($post_id, 'ahf_display_rules', true);
		$new = array();
		$options = $this->display_locations();
		
		$selects = $_POST['select'];
		
		if ( isset( $selects ) ) {
			$count = count( $selects );

			for ( $i = 0; $i < $count; $i++ ) {		
				$new[$i]['select'] = $selects[$i];
			}			
		}

		if ( !empty( $new ) && $new != $old && '' !== $new ) {
			update_post_meta( $post_id, 'ahf_display_rules', $new );
		} elseif ( empty($new) && $old ) {
			delete_post_meta( $post_id, 'ahf_display_rules', $old );
		}

		//Save template type
		$templates = array( 'content', 'page404', 'shop-archive', 'shop-single' );
		$template_type = $this->sanitize_selects( $_POST['ahf_template_type'], $templates );
		update_post_meta( $post_id, '_ahf_template_type', $template_type );

		//Save hooks type
		$hooks = $this->hooks();
		$all_hooks = array();
		foreach ( $hooks as $hook_group ) {
			if ( ! empty( $hook_group['group'] ) ) {
				foreach ( $hook_group['group'] as $hook_key => $hook_name ) {
					$all_hooks[ $hook_key ] = $hook_name;
				}
			}
		}
		$hooks_type = $this->sanitize_selects( $_POST['ahf_hook_type'], array_keys( $all_hooks ) );
		update_post_meta( $post_id, '_ahf_hook_type', $hooks_type );

		//Save hooks priority
		$priority = intval( $_POST['ahf_hook_priority'] );
		update_post_meta( $post_id, '_ahf_hook_priority', $priority );
		
	}

	public function render_meta_box_content( $post ) {
		global $post;

		$repeatable_fields 	= get_post_meta($post->ID, 'ahf_display_rules', true);
		$priority 			= get_post_meta($post->ID, '_ahf_hook_priority', true);

		if ( !$priority ) {
			$priority = 10;
		}

		$options 			= $this->get_products_posts();

		wp_nonce_field( 'athemes_display_rules_nonce', 'athemes_display_rules_nonce' );
		?>
		<script type="text/javascript">
		jQuery(document).ready(function( $ ){
			$( '#add-row' ).on('click', function() {
				var row = $( '.regular-target.empty-row.screen-reader-text' ).clone(true);
				row.removeClass( 'empty-row screen-reader-text' );
				row.insertBefore( '#repeatable-fieldset-one tbody>tr:last' ).css('display', 'flex');
				row.find( 'select' ).attr( 'name', 'select[]' );

				$( '.is-visible .athemes-rule-select' ).select2({
					minimumResultsForSearch: Infinity
				});

				return false;
			});

			$( '#add-specific-page' ).on('click', function() {
				var row = $( '.specific-page-select-row.empty-row.screen-reader-text' ).clone(true);
				row.removeClass( 'empty-row screen-reader-text' ).addClass( 'is-visible' );
				row.insertBefore( '#repeatable-fieldset-one tbody>tr:last' ).css('display', 'flex');
				row.find( 'select' ).attr( 'name', 'select[]' );
				
				$( '.is-visible .athemes-specific-page-select' ).select2();

				return false;
			});			
		  
			$( '.remove-row' ).on('click', function() {
				$(this).parents('tr').remove();
				return false;
			});

			//Init select2
			$( '.is-visible .athemes-specific-page-select' ).select2();

			$( '.is-visible .athemes-rule-select' ).select2({
				minimumResultsForSearch: Infinity,
			});	

			$( '.ahf-hook-select' ).select2({
				minimumResultsForSearch: Infinity
			});	

			if( $( '.ahf-hook-select' ).val() === 'none' ) {
				$( 'input[name="ahf_hook_priority"]' ).closest( 'p' ).hide();
			}

			$( '.ahf-hook-select' ).on( 'select2:select', function(){
				if( $( this ).val() !== 'none' ) {
					$( 'input[name="ahf_hook_priority"]' ).closest( 'p' ).fadeIn( 'fast' );
				} else {
					$( 'input[name="ahf_hook_priority"]' ).closest( 'p' ).fadeOut( 'fast' );
				}
			} );

			// first load
			displayConditionsSelector( $, $( '.ahf-template-select[checked]' ) );

			// on change
			$( '.ahf-template-select' ).change(function () {                            
				displayConditionsSelector( $, $(this) );
			});
        });

		function displayConditionsSelector( $, $this ) {
			if ( $this.length === 0 || 'page404' == $this.val() || 'content' == $this.val() || 'shop-archive' == $this.val() ) {
				$( '.ahf-rules-group,.rules-hr' ).fadeOut( 'fast' );	
			} else {
				$( '.ahf-rules-group,.rules-hr' ).fadeIn( 'fast' );	
			}

			if( 'content' === $this.val() ) {
				$( '.ahf-hook-group' ).fadeIn( 'fast' );
			} else {
				$( '.ahf-hook-group' ).fadeOut( 'fast' );
			}
		}
		</script>
		<style type="text/css">
			.target-rules-wrapper { display: -webkit-box; display: -ms-flexbox; display: flex; -ms-flex-wrap: wrap; flex-wrap: wrap; gap:30px;}
			.target-rules-column:first-of-type {-webkit-box-flex: 0;-ms-flex: 0 0 calc(65% - 15px);flex: 0 0 calc(65% - 15px);max-width:calc(65% - 15px);}
			.target-rules-column:last-of-type {-webkit-box-flex: 0;-ms-flex: 0 0 calc(35% - 15px);flex: 0 0 calc(35% - 15px);max-width:calc(35% - 15px);}
			@media screen and (max-width: 991px) {
				.target-rules-wrapper { display: block; }
				.target-rules-column:first-of-type {-webkit-box-flex: 0;-ms-flex: 0 0 100%;flex: 0 0 100%;max-width:100%;}
				.target-rules-column:last-of-type {-webkit-box-flex: 0;-ms-flex: 0 0 100%;flex: 0 0 100%;max-width:100%;}
			}				
			.is-visible .select2-container {width:100% !important;}
			.ahf-template-select + .select2-container, .ahf-hook-select + .select2-container { max-width: 500px; }
			.ahf-template-group label,.ahf-hook-group label { display: inline-block;min-width:80px;color: #939393;padding-right:15px; }
			.ahf-template-group label {text-align: center;padding:0;margin-bottom:15px;margin-right:25px;width: 115px;}
			.ahf-template-group, .ahf-rules-group { margin-bottom: 20px; }
			.ahf-template-group > div { display: flex; flex-wrap: wrap; }
			.ahf-hook-group,.hooks-hr, .ahf-rules-group, .rules-hr, .ahf-header-group, .header-hr {display:none;}
			.target-rule-td {min-width:80px;color: #939393;padding-right:15px;padding-top:5px;}
			.target-rule-td-large {max-width:500px;width:100%;display:block;}
			.tips-wrapper {padding: 30px;background-color: #f7f7f7;height:100%;box-sizing:border-box;}
			.tips-list {list-style:disc;padding-left:20px;}
			.ahf-template-select {position: absolute;opacity: 0;}
			.ahf-template-select+img {max-width:100%;cursor: pointer;display:block;margin-bottom:10px;outline:3px solid rgba(0,0,0,0.05);transition:outline 0.2s;}
			.ahf-template-select:checked + img, .ahf-template-select:hover + img {outline: 2px solid #2271b1;}
			.option-info {display:block; color: #939393; font-style: italic; margin-left: 26px;}
			.target-rules-wrapper input[type=checkbox] {margin-right:10px;}
		</style>

		<div class="target-rules-wrapper">
			<div class="target-rules-column">
				<?php $template_type = get_post_meta( $post->ID, '_ahf_template_type', true ); ?>
				<div class="ahf-template-group">
					<h4><?php echo esc_html__( 'What would you like to build?', 'botiga-pro' ); ?></h4>
					<div>
						<label>
							<input class="ahf-template-select" type="radio" name="ahf_template_type" value="shop-archive" <?php checked( $template_type, 'shop-archive' ); ?>>
							<img src="<?php echo BOTIGA_PRO_URI . 'assets/img/templates/archive.svg'; ?>"/>

							<?php esc_attr_e( 'Shop Catalog', 'botiga-pro' ); ?>
						</label>
						<label>
							<input class="ahf-template-select" type="radio" name="ahf_template_type" value="shop-single" <?php checked( $template_type, 'shop-single' ); ?>>
							<img src="<?php echo BOTIGA_PRO_URI . 'assets/img/templates/single.svg'; ?>"/>

							<?php esc_attr_e( 'Single Product', 'botiga-pro' ); ?>
						</label>
						<label>
							<input class="ahf-template-select" type="radio" name="ahf_template_type" value="content" <?php checked( $template_type, 'content' ); ?>>
							<img src="<?php echo BOTIGA_PRO_URI . 'assets/img/templates/content.svg'; ?>"/>
							<?php esc_attr_e( 'Content block', 'botiga-pro' ); ?>
						</label>
						<label>
							<input class="ahf-template-select" type="radio" name="ahf_template_type" value="page404" <?php checked( $template_type, 'page404' ); ?>>
							<img src="<?php echo BOTIGA_PRO_URI . 'assets/img/templates/404.svg'; ?>"/>
							<?php esc_attr_e( '404 page', 'botiga-pro' ); ?>
						</label>				
					</div>
				</div>		

				<hr class="rules-hr" style="display: none;">
			
				<div class="ahf-rules-group" style="display: none;">
				<h4><?php echo esc_html__( 'Display rules', 'botiga-pro' ); ?></h4>
				<table id="repeatable-fieldset-one" width="100%">
				<tbody>
				<?php
				
				if ( $repeatable_fields ) :
				
					$counter = 0;
					foreach ( $repeatable_fields as $field ) { ?>

						<?php if ( 0 === intval( $field['select'] ) ) : ?>
							<tr class="rule-select-row is-visible" style="display:flex;margin-bottom:10px;">		
								<?php if ( 0 === $counter ) : ?>
								<td class="target-rule-td"><?php echo esc_html__( 'Display on:', 'botiga-pro' ); ?></td>
								<?php else : ?>
								<td class="target-rule-td"><?php echo esc_html__( 'and', 'botiga-pro' ); ?></td>
								<?php endif; ?>
								<td class="target-rule-td-large">
									<select class="athemes-rule-select widefat" name="select[]">
										<option value="" disabled selected><?php esc_html_e( 'Select &hellip;', 'botiga-pro' );?></option>
										<?php foreach ( $options as $group => $data ) : ?>
											<optgroup label="<?php echo esc_html( $data['label'] ); ?>">

											<?php foreach ( $data['group'] as $value => $label ) : ?>
												<option class="<?php echo strpos( $value, 'archives' ) !== false ? 'is-archive-option' : 'is-singular-option'; ?>" value="<?php echo $value; ?>" <?php selected( $field['select'], $value ); ?>><?php echo $label; ?></option>
											<?php endforeach; ?>

											</optgroup>

										<?php endforeach; ?>		
									</select>
								</td>
									
								<td style="padding-left:10px;"><a class="button remove-row" href="#"><?php echo esc_html__( 'Remove', 'botiga-pro' ); ?></a></td>
							</tr>
						<?php else : ?>

							<tr style="display:flex;margin-bottom:10px;" class="specific-page-select-row is-visible">
								<?php if ( 0 === $counter ) : ?>
								<td class="target-rule-td"><?php echo esc_html__( 'Display on:', 'botiga-pro' ); ?></td>
								<?php else : ?>
								<td class="target-rule-td"><?php echo esc_html__( 'and', 'botiga-pro' ); ?></td>
								<?php endif; ?>
								<td class="target-rule-td-large">
									<select class="athemes-specific-page-select widefat" name="select[]">
									<?php foreach ( $options as $group => $data ) : ?>

										<optgroup label="<?php echo esc_html( $data['label'] ); ?>">

										<?php foreach ( $data['group'] as $value => $label ) : ?>
											<option value="<?php echo $value; ?>" <?php selected( $field['select'], $value ); ?>><?php echo $label; ?></option>
										<?php endforeach; ?>

										</optgroup>

									<?php endforeach; ?>		
									</select>
								</td>
											
								<td style="padding-left:10px;"><a class="button remove-row" href="#"><?php echo esc_html__( 'Remove', 'botiga-pro' ); ?></a></td>
							</tr>			
						<?php endif; ?>	

						<?php
							$counter++;
					}
				else :
				// show a blank one
				?>
					<tr class="rule-select-row is-visible" style="display:flex;margin-bottom:10px;">		
						<td class="target-rule-td"><?php echo esc_html__( 'Display on:', 'botiga-pro' ); ?></td>
						<td class="target-rule-td-large">
							<select class="athemes-rule-select widefat" name="select[]">
								<option value="" disabled selected><?php esc_html_e( 'Select &hellip;', 'botiga-pro' );?></option>

							<?php foreach ( $options as $group => $data ) : ?>

								<optgroup label="<?php echo esc_html( $data['label'] ); ?>">

								<?php foreach ( $data['group'] as $value => $label ) : ?>
									<option value="<?php echo $value; ?>"><?php echo $label; ?></option>
								<?php endforeach; ?>

								</optgroup>

							<?php endforeach; ?>		
							</select>
						</td>
							
						<td style="padding-left:10px;"><a class="button remove-row" href="#"><?php echo esc_html__( 'Remove', 'botiga-pro' ); ?></a></td>
					</tr>
				<?php endif; ?>
				
				<!-- empty hidden one for jQuery -->
				<tr class="regular-target rule-select-row empty-row screen-reader-text" style="margin-bottom:10px;">	
					<td class="target-rule-td"><?php echo esc_html__( 'and', 'botiga-pro' ); ?></td>
					<td class="target-rule-td-large">
						<select class="athemes-rule-select widefat">
							<option value="" disabled selected><?php esc_html_e( 'Select &hellip;', 'botiga-pro' );?></option>
						<?php foreach ( $options as $group => $data ) : ?>

							<optgroup label="<?php echo esc_html( $data['label'] ); ?>">

							<?php foreach ( $data['group'] as $value => $label ) : ?>
								<option class="<?php echo strpos( $value, 'archives' ) !== false ? 'is-archive-option' : 'is-singular-option'; ?>" value="<?php echo $value; ?>"><?php echo $label; ?></option>
							<?php endforeach; ?>

							</optgroup>

						<?php endforeach; ?>		
						</select>
					</td>
								
					<td style="padding-left:10px;"><a class="button remove-row" href="#"><?php echo esc_html__( 'Remove', 'botiga-pro' ); ?></a></td>
				</tr>

				<tr class="specific-page-select-row empty-row screen-reader-text" style="margin-bottom:10px;">
					<td class="target-rule-td"><?php echo esc_html__( 'and', 'botiga-pro' ); ?></td>
					<td class="target-rule-td-large">
						<select class="athemes-specific-page-select widefat">
							<option value="" disabled selected><?php esc_html_e( 'Select &hellip;', 'botiga-pro' );?></option>
						<?php foreach ( $options as $group => $data ) : ?>

							<optgroup label="<?php echo esc_html( $data['label'] ); ?>">

							<?php foreach ( $data['group'] as $value => $label ) : ?>
								<option value="<?php echo $value; ?>"><?php echo $label; ?></option>
							<?php endforeach; ?>

							</optgroup>

						<?php endforeach; ?>		
						</select>
					</td>
								
					<td style="padding-left:10px;"><a class="button remove-row" href="#"><?php echo esc_html__( 'Remove', 'botiga-pro' ); ?></a></td>
				</tr>

				</tbody>
				</table>
				
				<p><a id="add-specific-page" class="button" href="#"><?php echo esc_html__( 'Add another rule', 'botiga-pro' ); ?></a></p>
				</div>	
				
				<hr class="hooks-hr">
				
				<?php $hook_type = get_post_meta( $post->ID, '_ahf_hook_type', true ); ?>
				<?php $hooks = $this->hooks(); ?>
				<div class="ahf-hook-group">
					<h4><?php echo esc_html__( 'Display Rule (hook)', 'botiga-pro' ); ?></h4>
					<p>
					<label for="ahf_hook_type"><?php esc_html_e( 'Select hook', 'botiga-pro' ); ?></label>
					<select class="ahf-hook-select" style="max-width:500px;width:100%;" name="ahf_hook_type">
						<?php foreach ( $hooks as $group => $data ) : ?>

							<optgroup label="<?php echo esc_html( $data['label'] ); ?>">

							<?php foreach ( $data['group'] as $hook => $label ) : ?>
								<option value="<?php echo $hook; ?>" <?php selected( $hook_type, $hook ); ?>><?php echo $label; ?></option>
							<?php endforeach; ?>

							</optgroup>
						<?php endforeach; ?>
					</select>
					<smal style="display: block; margin-top: 9px; color: #777; margin-left: 99px; padding-right: 260px;"><?php echo esc_html__( 'Selecting a hook display rule is optional. For example, you might create a custom \'content block\' without any display rule to be rendered in other website areas through the theme options.', 'botiga-pro' ); ?></smal>
					</p>		
					<p>
					<label for="ahf_hook_priority"><?php esc_html_e( 'Priority', 'botiga-pro' ); ?></label>
					<input style="max-width:500px;width:100%;" type="number" name="ahf_hook_priority" value="<?php echo esc_attr( $priority ); ?>"/>
					</p>
				</div>
			</div>
			<?php if ( !function_exists( 'athemes_wl_get_data' ) ) : ?>
			<div class="target-rules-column">
				<div class="tips-wrapper">
					<h4><?php echo esc_html__( 'Quick tip', 'botiga-pro' ); ?></h4>
					<p><?php echo esc_html__( 'You can create as many custom layouts you wish. Simply create a new Template, just like you have created this one.', 'botiga-pro' ); ?></p>
					<hr>
					<h4><?php echo esc_html__( 'Resources', 'botiga-pro' ); ?></h4>
					<ul class="tips-list">
						<li><a href="<?php echo esc_url( 'https://docs.athemes.com/article/pro-how-to-build-a-custom-shop-catalog-template/' ); ?>" target="_blank"><?php echo esc_html__( 'Learn how to build a custom shop catalog template', 'botiga-pro' ); ?></a></li>
						<li><a href="<?php echo esc_url( 'https://docs.athemes.com/article/pro-how-to-build-a-custom-single-product-template/' ); ?>" target="_blank"><?php echo esc_html__( 'Learn how to build a custom single product template', 'botiga-pro' ); ?></a></li>
						<li><a href="<?php echo esc_url( 'https://docs.athemes.com/article/pro-how-to-build-a-content-block-template/' ); ?>" target="_blank"><?php echo esc_html__( 'Learn how to build a content block template', 'botiga-pro' ); ?></a></li>
						<li><a href="<?php echo esc_url( 'https://docs.athemes.com/article/pro-how-to-build-a-custom-404-page-template/' ); ?>" target="_blank"><?php echo esc_html__( 'Learn how to build a custom 404 page template', 'botiga-pro' ); ?></a></li>
						<li><a href="<?php echo esc_url( 'https://docs.athemes.com/article/pro-how-to-use-custom-template-inside-a-mega-menu/' ); ?>" target="_blank"><?php echo esc_html__( 'Learn how to build custom template to be used inside a \'Mega Menu\'', 'botiga-pro' ); ?></a></li>
						<li><a href="<?php echo esc_url( 'https://docs.athemes.com/article/how-to-use-custom-template-within-modal-popup/' ); ?>" target="_blank"><?php echo esc_html__( 'Learn how to build custom template to be used within the \'Modal Popup\'', 'botiga-pro' ); ?></a></li>
					</ul>
				</div>
			</div>			
			<?php endif; ?>
		</div>

		<?php
	}

	/**
	 * Sanitize selects
	 */
	public function sanitize_selects( $input, $choices ) {

		$input = sanitize_key( $input );

		return ( in_array( $input, $choices ) ? $input : '' );
	}

	/**
	 * Display locations
	 */
	public function display_locations() {

		$general = array(
			'website' 		=> esc_html__( 'Everywhere', 'botiga-pro' ),
			'homepage' 		=> esc_html__( 'Homepage', 'botiga-pro' ),
			'blog' 			=> esc_html__( 'Blog', 'botiga-pro' ),
			'search' 		=> esc_html__( 'Search', 'botiga-pro' )
		);

		if ( class_exists( 'Woocommerce' ) ) {
			$general['shop'] = esc_html__( 'Shop page', 'botiga-pro' );
		}

		$options = array(
			'general' 		=> array(
				'label' => esc_html__( 'General', 'botiga-pro' ), 
				'group' => $general,
			),
		);

		$post_types = $this->get_all_post_types();

		$options = array_merge( $options, $post_types );

		return $options;
	}

	/**
	 * Return taxonomies
	 */
	protected function get_all_post_types() {

		$args       = array(
			'public' => true,
		);
		$post_types = get_post_types( $args, 'objects' );

		$results = array();

		foreach ( $post_types as $post_type ) {
			$results[$post_type->name] = array(
				'label' => $post_type->label,
				'group' => array(
					$post_type->name 				=> sprintf( 'Single %s', $post_type->label ),
					$post_type->name . '-archives' 	=> sprintf( '%s archives', $post_type->label )
				),
			);
		}

		unset( $results['page']['group']['page-archives'] );
		unset( $results[ 'attachment' ] ); 
		unset( $results[ 'e-landing-page' ] );
		unset( $results[ 'elementor_library' ] );
		unset( $results[ 'athemes_hf' ] );

		return $results;
	}

	/**
	 * Return taxonomies
	 */
	protected function get_products_posts() {
		$results = array();

		//Build posts array
		$args = array(
			'numberposts' => -1,
			'post_type'   => 'product'
		);
			
		$posts = get_posts( $args );

		$all_posts = array(
			'all' => esc_html__( 'All Products', 'botiga-pro' )
		);

		foreach ( $posts as $single_post ) {
			$all_posts[$single_post->ID] = $single_post->post_title;
		}

		$results[ 'product' ] = array(
			'label' => esc_html__( 'Products', 'botiga-pro' ),
			'group' => $all_posts,
		);

		return $results;
	}

	/**
	 * Hooks locations
	 */
	public function hooks() {

		//Theme hooks
		$locations = array(
			'theme' 		=> array(
				'label' => esc_html__( 'Botiga-pro', 'botiga-pro' ), 
				'group' => array(
					'none'                         => esc_html__( 'None', 'botiga-pro' ),
					'botiga_before_site'				=> esc_html__( 'Before site (botiga_before_site)', 'botiga-pro' ),
					'botiga_after_site'				=> esc_html__( 'After site (botiga_after_site)', 'botiga-pro' ),
					'botiga_before_header'          => esc_html__( 'Before header (botiga_before_header)', 'botiga-pro' ),
					'botiga_header'							=> esc_html__( 'Header (botiga_header)', 'botiga-pro' ),
					'botiga_after_header'          => esc_html__( 'Before header (botiga_after_header)', 'botiga-pro' ),
					'botiga_before_page_header'					=> esc_html__( 'Before page header (botiga_before_page_header)', 'botiga-pro' ),
					'botiga_after_page_header'						=> esc_html__( 'After page header (botiga_after_page_header)', 'botiga-pro' ),
					'botiga_before_main_wrapper' 					=> esc_html__( 'Before main wrapper (botiga_before_main_wrapper)', 'botiga-pro' ),
					'botiga_after_main_wrapper'			=> esc_html__( 'After main wrapper (botiga_after_main_wrapper)', 'botiga-pro' ),
					'botiga_main_wrapper_start'							=> esc_html__( 'Main wrapper start (botiga_main_wrapper_start)', 'botiga-pro' ),
					'botiga_main_wrapper_end'					=> esc_html__( 'Main wrapper end (botiga_main_wrapper_end)', 'botiga-pro' ),
					'botiga_footer_before'				=> esc_html__( 'Before footer (botiga_footer_before)', 'botiga-pro' ),
					'botiga_footer'					=> esc_html__( 'Footer (botiga_footer)', 'botiga-pro' ),
					'botiga_footer_after'					=> esc_html__( 'After footer (botiga_footer_after)', 'botiga-pro' ),
					'botiga_before_sidebar'				=> esc_html__( 'Before sidebar (botiga_before_sidebar)', 'botiga-pro' ),
					'botiga_after_sidebar'			=> esc_html__( 'After sidebar (botiga_after_sidebar)', 'botiga-pro' ),
					'botiga_before_single_post_content'				=> esc_html__( 'Before single post content (botiga_before_single_post_content)', 'botiga-pro' ),
					'botiga_after_single_post_content'					=> esc_html__( 'After single post content (botiga_after_single_post_content)', 'botiga-pro' ),
					'botiga_before_ajax_search_item'					=> esc_html__( 'Before ajax search item (botiga_before_ajax_search_item)', 'botiga-pro' ),
					'botiga_after_ajax_search_item'					=> esc_html__( 'After ajax search item (botiga_after_ajax_search_item)', 'botiga-pro' ),
					'botiga_before_page_entry_content'							=> esc_html__( 'Before page entry content (botiga_before_page_entry_content)', 'botiga-pro' ),
					'botiga_after_page_entry_content'							=> esc_html__( 'After page entry content (botiga_after_page_entry_content)', 'botiga-pro' ),
					'botiga_before_page_the_content'					=> esc_html__( 'Before the page content (botiga_before_page_the_content)', 'botiga-pro' ),
					'botiga_after_page_the_content'					=> esc_html__( 'After the page content (botiga_after_page_the_content)', 'botiga-pro' ),
					'botiga_before_quick_view_popup_content'						=> esc_html__( 'Before quick view popup content (botiga_before_quick_view_popup_content)', 'botiga-pro' ),
					'botiga_after_quick_view_popup_content'						=> esc_html__( 'After quick view popup content (botiga_after_quick_view_popup_content)', 'botiga-pro' ),
					'botiga_quick_view_share'						=> esc_html__( 'Quick view popup share (botiga_quick_view_share)', 'botiga-pro' ),
				)
			),
		);

		//Woocommerce hooks
		if ( class_exists( 'Woocommerce' ) ) {
			$locations['woocommerce'] = array(
				'label' => esc_html__( 'WooCommerce', 'botiga-pro' ), 
				'group' => array(
					'woocommerce_before_main_content'			=> esc_html__( 'Before content (woocommerce_before_main_content)', 'botiga-pro' ),
					'woocommerce_after_main_content'			=> esc_html__( 'After content (woocommerce_after_main_content)', 'botiga-pro' ),
					'woocommerce_before_shop_loop'				=> esc_html__( 'Before shop loop (woocommerce_before_shop_loop)', 'botiga-pro' ),
					'woocommerce_after_shop_loop'				=> esc_html__( 'After shop loop (woocommerce_after_shop_loop)', 'botiga-pro' ),
					'woocommerce_before_shop_loop_item'			=> esc_html__( 'Before shop loop item (woocommerce_before_shop_loop_item)', 'botiga-pro' ),
					'woocommerce_after_shop_loop_item'			=> esc_html__( 'After shop loop item (woocommerce_after_shop_loop_item)', 'botiga-pro' ),
					'woocommerce_before_single_product'			=> esc_html__( 'Before single product (woocommerce_before_single_product)', 'botiga-pro' ),
					'woocommerce_before_single_product_summary'	=> esc_html__( 'Before single product summary (woocommerce_before_single_product_summary)', 'botiga-pro' ),
					'woocommerce_single_product_summary'		=> esc_html__( 'Single product summary (woocommerce_single_product_summary)', 'botiga-pro' ),
					'woocommerce_after_single_product_summary'	=> esc_html__( 'After single product summary (woocommerce_after_single_product_summary)', 'botiga-pro' ),
					'woocommerce_after_single_product' 			=> esc_html__( 'After single product (woocommerce_after_single_product)', 'botiga-pro' ),
				)
			);
		}

		return $locations;
	}

	/**
	 * Scripts
	 */
	public function scripts( $hook ) {
		$type = 'athemes_hf';

		if ( in_array( $hook, array('post.php', 'post-new.php') ) ) {
			$current_screen = get_current_screen();
	
			if ( is_object( $current_screen ) && $type == $current_screen->post_type ) {
				wp_enqueue_script( 'botiga-select2', get_template_directory_uri() . '/js/select2.min.js', array('jquery'), '20220128', true );
				wp_enqueue_style( 'botiga-select2-styles', get_template_directory_uri() . '/css/select2.min.css' );
			}
		}
	}
}